/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.util;

import com.huskycode.jpaquery.util.Randomizer;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.RandomStringUtils;

public class RandomizerImpl
implements Randomizer {
    private static final Random any = new Random();
    public static Integer DEFAULT_LENGTH = 10;

    @Override
    public <T> T getRandomOfType(Class<T> type, int length) {
        if (type.equals(String.class)) {
            return (T)(length > 0 ? RandomizerImpl.getAsciiString(length) : RandomizerImpl.getAsciiString());
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (T)RandomizerImpl.getInt();
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (T)RandomizerImpl.getDouble();
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return (T)RandomizerImpl.getFloat();
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (T)RandomizerImpl.getLong();
        }
        if (type.equals(Character.class) || type.equals(Character.TYPE)) {
            return (T)RandomizerImpl.getCharacter();
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)RandomizerImpl.getBoolean();
        }
        if (type.equals(Date.class)) {
            return (T)RandomizerImpl.getDate();
        }
        System.out.println("Not primitive: " + type);
        throw new UnsupportedOperationException("Not a primitive class: " + type);
    }

    @Override
    public <T> T getRandomOfType(Class<T> type) {
        return this.getRandomOfType(type, 0);
    }

    public static String getString(int length) {
        return length == 0 ? "" : RandomStringUtils.random((int)Math.abs(length));
    }

    public static String getString() {
        return RandomizerImpl.getString(any.nextInt(DEFAULT_LENGTH));
    }

    public static String getAsciiString(int length) {
        return length == 0 ? "" : RandomStringUtils.randomAscii((int)Math.abs(length));
    }

    public static Character getCharacter() {
        return Character.valueOf(RandomStringUtils.randomAscii((int)1).charAt(0));
    }

    public static String getAsciiString() {
        return RandomizerImpl.getAsciiString(any.nextInt(DEFAULT_LENGTH));
    }

    public static Integer getInt() {
        return any.nextInt();
    }

    public static Integer getNonNegativeInt() {
        return Math.abs(any.nextInt());
    }

    public static Long getLong() {
        return any.nextLong();
    }

    public static Long getNonNegativeLong() {
        return Math.abs(any.nextLong());
    }

    public static Double getDouble() {
        return any.nextDouble();
    }

    public static Float getFloat() {
        return Float.valueOf(any.nextFloat());
    }

    public static Boolean getBoolean() {
        return any.nextDouble() > 0.5;
    }

    public static Date getDate() {
        return new Date(RandomizerImpl.getLong());
    }

    public static <T> T getRandomFromArray(T[] array) {
        int length = array.length;
        return array[any.nextInt(length)];
    }

    public static <T> T getRandomFromList(List<T> list) {
        int length = list.size();
        return list.get(any.nextInt(length));
    }
}

