package com.huskycode.jpaquery.persister.store;

import java.util.Map;

import com.huskycode.jpaquery.util.MapUtil;
/**
 * Store a value to propagate into each entity node. For performance 
 * reason, we are going to use equality by each entity node instance. 
 * If the EntityNode are generated by the solver, that should be the
 * case anyway.
 * 
 *  @author Varokas Panusuwan
 */
public class PropogatedValueStore<T, K, V> {
	
	private final InstanceValueStore<T, Map<K, V>> dataStore 
	 	= InstanceValueStore.newInstance();

	private PropogatedValueStore() {}
	
	public static <T, K, V> PropogatedValueStore<T, K, V> newInstance() {
		return new PropogatedValueStore<T, K, V>();
	}

	public Object putValue(T t, K k, V value) {
		Map<K, V> map = getValueOrCreateIfNotExist(t);
		
		return map.put(k, value);
	}
	
	public void putValue(T t, Map<K, V> values) {
		Map<K, V> map = getValueOrCreateIfNotExist(t);
		map.putAll(values);
	}
	
	public Map<K, V> get(T t) {
		return getValueOrCreateIfNotExist(t);
	}
	
	private Map<K, V> getValueOrCreateIfNotExist(T key) {
		return MapUtil.getOrCreateMap(this.dataStore, key);
	}
}
