/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery;

import com.huskycode.jpaquery.link.Link;
import com.huskycode.jpaquery.util.Factory;
import com.huskycode.jpaquery.util.ListFactory;
import com.huskycode.jpaquery.util.MapUtil;
import com.huskycode.jpaquery.util.SetFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependenciesDefinition {
    private final Link<?, ?, ?>[] links;
    private final Map<Class<?>, List<Link<?, ?, ?>>> entityDirectLinkDependencyMap = new HashMap();
    private final Map<Class<?>, Set<Class<?>>> entityDirectParentEntityDependencyMap = new HashMap();
    private final Map<Class<?>, Set<Class<?>>> entityDirectChildEntityDependencyMap = new HashMap();
    private final Map<Class<?>, Set<Class<?>>> entityAllParentEntityDependencyMap = new HashMap();
    private final Map<Class<?>, Set<Class<?>>> entityAllChildEntityDependencyMap = new HashMap();
    private final Map<Class<?>, Map<Class<?>, List<Link<?, ?, ?>>>> childFieldToParentMap = new HashMap();
    private final Set<Class<?>> enumTables;
    private final Set<Class<?>> triggeredTables;
    private static final Factory<List<Link<?, ?, ?>>> LIST_OF_LINK_FACTORY = ListFactory.getInstance();
    private static final Factory<Set<Class<?>>> SET_OF_CLASS_FACTORY = SetFactory.getInstance();

    DependenciesDefinition(Link<?, ?, ?>[] links, List<Class<?>> enumTables, List<Class<?>> triggeredTables) {
        for (Link<?, ?, ?> link : links) {
            Class<?> eFrom = link.getFrom().getEntityClass();
            Class<?> eTo = link.getTo().getEntityClass();
            MapUtil.getOrCreateList(this.entityDirectLinkDependencyMap, eFrom).add(link);
            MapUtil.getOrCreateSet(this.entityDirectParentEntityDependencyMap, eFrom).add(eTo);
            MapUtil.getOrCreateSet(this.entityDirectChildEntityDependencyMap, eTo).add(eFrom);
            MapUtil.getOrCreateList(MapUtil.getOrCreateMap(this.childFieldToParentMap, eFrom), eTo).add(link);
        }
        this.links = links;
        this.enumTables = new HashSet(enumTables);
        this.triggeredTables = new HashSet(triggeredTables);
        this.buildAllDependentEntitiesMap();
    }

    private void buildAllDependentEntitiesMap() {
        for (Class<?> clazz : this.entityDirectParentEntityDependencyMap.keySet()) {
            Set<Class<?>> value = this.getAllParentDependentEntities(clazz);
            this.entityAllParentEntityDependencyMap.put(clazz, value);
        }
        for (Map.Entry entry : this.entityAllParentEntityDependencyMap.entrySet()) {
            Class child = (Class)entry.getKey();
            for (Class parent : (Set)entry.getValue()) {
                MapUtil.getOrCreateSet(this.entityAllChildEntityDependencyMap, parent).add(child);
            }
        }
    }

    private Set<Class<?>> getAllParentDependentEntities(Class<?> entityClass) {
        HashSet visited = new HashSet();
        LinkedList queue = new LinkedList();
        queue.add(entityClass);
        while (queue.size() > 0) {
            Class e = (Class)queue.removeFirst();
            if (visited.contains(e)) continue;
            visited.add(e);
            queue.addAll(this.getDirectParentDependencyEntity(e));
        }
        visited.remove(entityClass);
        return visited;
    }

    public Link<?, ?, ?>[] getLinks() {
        return this.links;
    }

    public <E> List<Link<?, ?, ?>> getDirectDependency(Class<E> entityClass) {
        if (this.entityDirectLinkDependencyMap.containsKey(entityClass)) {
            return this.entityDirectLinkDependencyMap.get(entityClass);
        }
        return LIST_OF_LINK_FACTORY.newInstace();
    }

    public Set<Class<?>> getDirectParentDependencyEntity(Class<?> entityClass) {
        if (this.entityDirectParentEntityDependencyMap.containsKey(entityClass)) {
            return this.entityDirectParentEntityDependencyMap.get(entityClass);
        }
        return SET_OF_CLASS_FACTORY.newInstace();
    }

    public Set<Class<?>> getDirectChildDependencyEntity(Class<?> entityClass) {
        if (this.entityDirectChildEntityDependencyMap.containsKey(entityClass)) {
            return this.entityDirectChildEntityDependencyMap.get(entityClass);
        }
        return SET_OF_CLASS_FACTORY.newInstace();
    }

    public Set<Class<?>> getAllParentDependencyEntity(Class<?> entityClass) {
        if (this.entityAllParentEntityDependencyMap.containsKey(entityClass)) {
            return this.entityAllParentEntityDependencyMap.get(entityClass);
        }
        return SET_OF_CLASS_FACTORY.newInstace();
    }

    public Set<Class<?>> getAllChildDependencyEntity(Class<?> entityClass) {
        if (this.entityAllChildEntityDependencyMap.containsKey(entityClass)) {
            return this.entityAllChildEntityDependencyMap.get(entityClass);
        }
        return SET_OF_CLASS_FACTORY.newInstace();
    }

    public List<Link<?, ?, ?>> getDependencyLinks(Class<?> from, Class<?> to) {
        Map<Class<?>, List<Link<?, ?, ?>>> parentLinkMap = this.childFieldToParentMap.get(from);
        if (parentLinkMap != null && parentLinkMap.containsKey(to)) {
            return parentLinkMap.get(to);
        }
        return LIST_OF_LINK_FACTORY.newInstace();
    }

    public Set<Class<?>> getEnumTables() {
        return this.enumTables;
    }

    public Set<Class<?>> getTriggeredTables() {
        return this.triggeredTables;
    }
}

