/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery;

import com.huskycode.jpaquery.DependenciesDefinition;
import com.huskycode.jpaquery.command.CommandNodes;
import com.huskycode.jpaquery.crud.CreationPlanFromDefinition;
import com.huskycode.jpaquery.persister.Persister;
import com.huskycode.jpaquery.persister.PersisterImpl;
import com.huskycode.jpaquery.populator.RandomValuePopulator;
import com.huskycode.jpaquery.populator.RandomValuePopulatorImpl;
import com.huskycode.jpaquery.solver.CommandNodesIndexBuilder;
import com.huskycode.jpaquery.solver.CommandNodesIndexBuilderImpl;
import com.huskycode.jpaquery.solver.CommandNodesIndexResult;
import com.huskycode.jpaquery.solver.SolverImpl;
import com.huskycode.jpaquery.types.tree.CreationPlan;
import com.huskycode.jpaquery.types.tree.PersistedResult;
import javax.persistence.EntityManager;

public class JPAQueryContext {
    private EntityManager entityManager;
    private RandomValuePopulator randomValuePopulator;
    private DependenciesDefinition dependenciesDefinition;
    private CommandNodesIndexBuilder indexBuilder;

    private JPAQueryContext() {
    }

    static JPAQueryContext newInstance(EntityManager entityManager, DependenciesDefinition deps, RandomValuePopulator randomValuePopulator, CommandNodesIndexBuilder indexBuilder) {
        JPAQueryContext jpaContext = new JPAQueryContext();
        if (entityManager == null) {
            throw new IllegalArgumentException("Entity manager supplied cannot be null");
        }
        if (deps == null) {
            throw new IllegalArgumentException("Dependencies definition supplied cannot be null");
        }
        jpaContext.randomValuePopulator = randomValuePopulator;
        jpaContext.entityManager = entityManager;
        jpaContext.dependenciesDefinition = deps;
        jpaContext.indexBuilder = indexBuilder;
        return jpaContext;
    }

    public static JPAQueryContext newInstance(EntityManager entityManager, DependenciesDefinition deps) {
        return JPAQueryContext.newInstance(entityManager, deps, new RandomValuePopulatorImpl());
    }

    public static JPAQueryContext newInstance(EntityManager entityManager, DependenciesDefinition deps, RandomValuePopulator randomValuePopulator) {
        return JPAQueryContext.newInstance(entityManager, deps, randomValuePopulator, new CommandNodesIndexBuilderImpl());
    }

    public <E> PersistedResult create(Class<E> entityClass) {
        SolverImpl solver = SolverImpl.newInstance(this.dependenciesDefinition);
        CreationPlan creationPlan = solver.solveFor(entityClass);
        Persister persister = this.createPersister();
        return persister.persistValues(creationPlan);
    }

    public <E> PersistedResult create(CommandNodes commands) {
        SolverImpl solver = SolverImpl.newInstance(this.dependenciesDefinition);
        CreationPlan creationPlan = solver.solveFor(commands);
        CommandNodesIndexResult indexes = this.indexBuilder.build(commands);
        Persister persister = this.createPersister();
        return persister.persistValues(creationPlan, indexes);
    }

    public <E> PersistedResult createFromDependencyDefinition() {
        CreationPlanFromDefinition creator = CreationPlanFromDefinition.getInstance();
        Persister persister = this.createPersister();
        return persister.persistValues(creator.from(this.dependenciesDefinition));
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    private Persister createPersister() {
        return PersisterImpl.newInstance(this.entityManager, this.dependenciesDefinition, this.randomValuePopulator);
    }

    public RandomValuePopulator getRandomValuePopulator() {
        return this.randomValuePopulator;
    }

    public DependenciesDefinition getDependenciesDefinition() {
        return this.dependenciesDefinition;
    }
}

