/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.crud;

import com.huskycode.jpaquery.DependenciesDefinition;
import com.huskycode.jpaquery.link.Link;
import com.huskycode.jpaquery.types.tree.ActionGraph;
import com.huskycode.jpaquery.types.tree.CreationPlan;
import com.huskycode.jpaquery.types.tree.EntityNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CreationPlanFromDefinition {
    private static final CreationPlanFromDefinition INSTANCE = new CreationPlanFromDefinition();

    private CreationPlanFromDefinition() {
    }

    public static CreationPlanFromDefinition getInstance() {
        return INSTANCE;
    }

    public CreationPlan from(DependenciesDefinition deps) {
        ActionGraph actionGraph = ActionGraph.newInstance();
        Set<Class<?>> allEntities = this.getAllEntities(deps);
        HashMap container = new HashMap();
        for (Class<?> e : allEntities) {
            EntityNode thisNode = this.getOrCreate(e, container);
            this.linkChildren(thisNode, deps.getDirectChildDependencyEntity(e), container);
            this.linkParents(thisNode, deps.getDirectParentDependencyEntity(e), container);
            actionGraph.addEntityNode(thisNode);
        }
        return CreationPlan.newInstance(actionGraph);
    }

    private void linkChildren(EntityNode thisNode, Set<Class<?>> childSet, Map<Class<?>, EntityNode> container) {
        for (Class<?> childC : childSet) {
            EntityNode child = this.getOrCreate(childC, container);
            thisNode.addChild(child);
        }
    }

    private void linkParents(EntityNode thisNode, Set<Class<?>> parents, Map<Class<?>, EntityNode> container) {
        for (Class<?> parentC : parents) {
            EntityNode parent = this.getOrCreate(parentC, container);
            thisNode.addParent(parent);
        }
    }

    private EntityNode getOrCreate(Class<?> entityClass, Map<Class<?>, EntityNode> container) {
        EntityNode result = container.get(entityClass);
        if (result == null) {
            result = EntityNode.newInstance(entityClass);
            container.put(entityClass, result);
        }
        return result;
    }

    private Set<Class<?>> getAllEntities(DependenciesDefinition deps) {
        HashSet result = new HashSet();
        for (Link<?, ?, ?> link : deps.getLinks()) {
            result.add(link.getFrom().getEntityClass());
            result.add(link.getTo().getEntityClass());
        }
        return result;
    }
}

