/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.persister;

import com.huskycode.jpaquery.DependenciesDefinition;
import com.huskycode.jpaquery.annotation.VisibleForTesting;
import com.huskycode.jpaquery.command.CommandNode;
import com.huskycode.jpaquery.link.Link;
import com.huskycode.jpaquery.persister.Persister;
import com.huskycode.jpaquery.persister.entitycreator.EntityPersisterFactory;
import com.huskycode.jpaquery.persister.entitycreator.EntityPersisterFactoryImpl;
import com.huskycode.jpaquery.persister.store.PropogatedValueStore;
import com.huskycode.jpaquery.persister.util.BeanUtil;
import com.huskycode.jpaquery.populator.CreationPlanTraverser;
import com.huskycode.jpaquery.populator.RandomValuePopulator;
import com.huskycode.jpaquery.populator.RandomValuePopulatorImpl;
import com.huskycode.jpaquery.solver.CommandNodesIndexResult;
import com.huskycode.jpaquery.types.tree.CreationPlan;
import com.huskycode.jpaquery.types.tree.EntityNode;
import com.huskycode.jpaquery.types.tree.PersistedResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;

public class PersisterImpl
implements Persister {
    private final EntityManager em;
    private final DependenciesDefinition deps;
    private final CreationPlanTraverser creationPlanTraverser = new CreationPlanTraverser();
    private final EntityPersisterFactory entityPersisterFactory;

    @VisibleForTesting
    PersisterImpl(EntityManager em, DependenciesDefinition deps) {
        this(em, deps, new RandomValuePopulatorImpl());
    }

    PersisterImpl(EntityManager em, DependenciesDefinition deps, RandomValuePopulator randomValuePopulator) {
        this.em = em;
        this.deps = deps;
        this.entityPersisterFactory = new EntityPersisterFactoryImpl(randomValuePopulator);
    }

    public static PersisterImpl newInstance(EntityManager em, DependenciesDefinition deps) {
        PersisterImpl persisterImpl = new PersisterImpl(em, deps);
        return persisterImpl;
    }

    public static PersisterImpl newInstance(EntityManager em, DependenciesDefinition deps, RandomValuePopulator randomValuePopulator) {
        PersisterImpl persisterImpl = new PersisterImpl(em, deps, randomValuePopulator);
        return persisterImpl;
    }

    @Override
    public PersistedResult persistValues(CreationPlan plan) {
        return this.persistValues(plan, null);
    }

    @Override
    public PersistedResult persistValues(CreationPlan plan, CommandNodesIndexResult commandIndexes) {
        ArrayList<Object> objects = new ArrayList<Object>();
        PropogatedValueStore<EntityNode, Field, Object> valueStore = PropogatedValueStore.newInstance();
        HashMap<CommandNode, Object> commandObjectMap = new HashMap<CommandNode, Object>();
        for (EntityNode node : this.creationPlanTraverser.getEntityNodes(plan)) {
            Map<Field, Object> overrideFields = this.getOverrideFields(node, valueStore);
            Object obj = this.entityPersisterFactory.createEntityPersister(node, this.deps, this.em).persistNode(node, overrideFields);
            objects.add(obj);
            this.storeFieldValueToPopulate(obj, node, valueStore);
            if (node.getCommand() == null) continue;
            commandObjectMap.put(node.getCommand(), obj);
        }
        if (commandIndexes != null) {
            return PersistedResult.newInstance(objects, commandIndexes, commandObjectMap);
        }
        return PersistedResult.newInstance(objects);
    }

    private Map<Field, Object> getOverrideFields(EntityNode node, PropogatedValueStore<EntityNode, Field, Object> valueStore) {
        HashMap<Field, Object> overrideFields = new HashMap<Field, Object>();
        overrideFields.putAll(valueStore.get(node));
        if (node.getCommand() != null) {
            overrideFields.putAll(node.getCommand().getFieldValues());
        }
        return overrideFields;
    }

    private void storeFieldValueToPopulate(Object obj, EntityNode parent, PropogatedValueStore<EntityNode, Field, Object> valueStore) {
        for (EntityNode child : parent.getChilds()) {
            List<Link<?, ?, ?>> links = this.deps.getDependencyLinks(child.getEntityClass(), parent.getEntityClass());
            for (Link<?, ?, ?> link : links) {
                Field parentField = link.getTo().getField();
                valueStore.putValue(child, link.getFrom().getField(), BeanUtil.getValue(obj, parentField));
            }
        }
    }
}

