/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.persister.entitycreator;

import com.huskycode.jpaquery.DependenciesDefinition;
import com.huskycode.jpaquery.link.Link;
import com.huskycode.jpaquery.persister.entitycreator.EntityPersister;
import com.huskycode.jpaquery.persister.entitycreator.EntityPersisterFactory;
import com.huskycode.jpaquery.persister.entitycreator.EnumClassEntityPersister;
import com.huskycode.jpaquery.persister.entitycreator.EnumTableEntityPersister;
import com.huskycode.jpaquery.persister.entitycreator.NewRowEntityPersister;
import com.huskycode.jpaquery.persister.entitycreator.TriggeredTableEntityPersister;
import com.huskycode.jpaquery.populator.RandomValuePopulator;
import com.huskycode.jpaquery.populator.RandomValuePopulatorImpl;
import com.huskycode.jpaquery.types.tree.EntityNode;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;

public class EntityPersisterFactoryImpl
implements EntityPersisterFactory {
    private final RandomValuePopulator randomValuePopulator;

    public EntityPersisterFactoryImpl(RandomValuePopulator randomValuePopulator) {
        this.randomValuePopulator = randomValuePopulator;
    }

    public EntityPersisterFactoryImpl() {
        this(new RandomValuePopulatorImpl());
    }

    @Override
    public EntityPersister createEntityPersister(EntityNode entityNode, DependenciesDefinition deps, EntityManager em) {
        Class<?> entityClass = entityNode.getEntityClass();
        if (entityClass.isEnum()) {
            return new EnumClassEntityPersister();
        }
        if (deps.getEnumTables().contains(entityClass)) {
            return new EnumTableEntityPersister(em);
        }
        if (deps.getTriggeredTables().contains(entityClass)) {
            List<Link<?, ?, ?>> allDirectLinks = this.getAllDirectLinksFrom(entityClass, deps);
            return new TriggeredTableEntityPersister(em, allDirectLinks);
        }
        return new NewRowEntityPersister(em, this.randomValuePopulator);
    }

    private List<Link<?, ?, ?>> getAllDirectLinksFrom(Class<?> from, DependenciesDefinition deps) {
        ArrayList allLinks = new ArrayList();
        for (Class<?> parent : deps.getDirectParentDependencyEntity(from)) {
            allLinks.addAll(deps.getDependencyLinks(from, parent));
        }
        return allLinks;
    }
}

