/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.persister.entitycreator;

import com.huskycode.jpaquery.persister.entitycreator.EntityPersister;
import com.huskycode.jpaquery.persister.util.BeanUtil;
import com.huskycode.jpaquery.populator.RandomValuePopulator;
import com.huskycode.jpaquery.populator.ValuesPopulator;
import com.huskycode.jpaquery.populator.ValuesPopulatorImpl;
import com.huskycode.jpaquery.types.tree.EntityNode;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;

public class NewRowEntityPersister
implements EntityPersister {
    private final RandomValuePopulator randomValuePopulator;
    private final ValuesPopulator valuesPopulator = ValuesPopulatorImpl.getInstance();
    private final EntityManager em;

    NewRowEntityPersister(EntityManager em, RandomValuePopulator randomValuePopulator) {
        this.em = em;
        this.randomValuePopulator = randomValuePopulator;
    }

    @Override
    public Object persistNode(EntityNode node, Map<Field, Object> overrideFields) {
        return this.createNodeInDatabase(overrideFields, node);
    }

    private Object createNodeInDatabase(Map<Field, Object> overrideFields, EntityNode node) {
        Class<?> c = node.getEntityClass();
        Object obj = BeanUtil.newInstance(c);
        Map<Field, Object> valuesToPopulate = this.getValuesToOverride(overrideFields, node, c);
        this.randomValuePopulator.populateValue(obj);
        this.valuesPopulator.populateValue(obj, valuesToPopulate);
        this.em.persist(obj);
        return obj;
    }

    private Map<Field, Object> getValuesToOverride(Map<Field, Object> valuesToPopulate, EntityNode node, Class<?> c) {
        Field idField = BeanUtil.findIdField(c);
        if (idField != null) {
            if (BeanUtil.isAnnotatedWithGenerated(idField)) {
                valuesToPopulate.put(idField, null);
            } else if (valuesToPopulate.get(idField) == null) {
                Object maxRecordId = this.getMaxRecordId(c, idField);
                idField.setAccessible(true);
                if (maxRecordId != null) {
                    try {
                        if (idField.getType().equals(Integer.class)) {
                            valuesToPopulate.put(idField, Integer.valueOf(maxRecordId.toString()) + 1);
                        } else if (idField.getType().equals(Long.class)) {
                            valuesToPopulate.put(idField, Long.valueOf(maxRecordId.toString()) + 1L);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return valuesToPopulate;
    }

    private <T> Object getMaxRecordId(Class<T> c, Field idField) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cb.createTupleQuery();
        Root root = criteriaQuery.from(c);
        EntityType model = root.getModel();
        SingularAttribute attr = model.getId(idField.getType());
        CriteriaQuery cq = criteriaQuery.multiselect(new Selection[]{cb.max((Expression)root.get(attr))});
        TypedQuery query = this.em.createQuery(cq);
        List result = query.getResultList();
        return result.size() > 0 ? ((Tuple)result.get(0)).get(0) : null;
    }
}

