/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.persister.entitycreator;

import com.huskycode.jpaquery.link.Link;
import com.huskycode.jpaquery.persister.entitycreator.EntityPersister;
import com.huskycode.jpaquery.populator.ValuesPopulator;
import com.huskycode.jpaquery.populator.ValuesPopulatorImpl;
import com.huskycode.jpaquery.types.tree.EntityNode;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;

public class TriggeredTableEntityPersister
implements EntityPersister {
    private final ValuesPopulator valuesPopulator = ValuesPopulatorImpl.getInstance();
    private final EntityManager em;
    private final List<Link<?, ?, ?>> allDirectLinks;

    TriggeredTableEntityPersister(EntityManager em, List<Link<?, ?, ?>> allDirectLinks) {
        this.em = em;
        this.allDirectLinks = allDirectLinks;
    }

    @Override
    public Object persistNode(EntityNode node, Map<Field, Object> overrideFields) {
        Object obj = this.getRecord(node.getEntityClass(), overrideFields);
        if (obj != null) {
            this.valuesPopulator.populateValue(obj, overrideFields);
            this.em.merge(obj);
            return obj;
        }
        throw new RuntimeException(node.getEntityClass() + " cannot be found in database. It should be created via trigger by parent tables given the link definition");
    }

    private <T> T getRecord(Class<T> c, Map<Field, Object> overrideFields) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cb.createQuery(c);
        Root root = criteriaQuery.from(c);
        EntityType model = root.getModel();
        CriteriaQuery cq = criteriaQuery.select((Selection)root);
        for (Link<?, ?, ?> link : this.allDirectLinks) {
            Field field = link.getFrom().getField();
            SingularAttribute attr = model.getSingularAttribute(link.getFrom().getField().getName());
            cq.where((Expression)cb.equal((Expression)root.get(attr), overrideFields.get(field)));
        }
        TypedQuery query = this.em.createQuery(cq);
        List result = query.getResultList();
        return result.size() > 0 ? (T)result.get(0) : null;
    }
}

