/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.persister.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InstanceWrapper<T> {
    private final T t;

    public InstanceWrapper(T t) {
        this.t = t;
    }

    public static <T> InstanceWrapper<T> newInstance(T t) {
        return new InstanceWrapper<T>(t);
    }

    public T get() {
        return this.t;
    }

    public int hashCode() {
        return this.t.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceWrapper other = (InstanceWrapper)obj;
        return this.t == other.t;
    }

    public static <T> List<T> toInstanceList(Collection<InstanceWrapper<T>> col) {
        ArrayList<T> result = new ArrayList<T>(col.size());
        for (InstanceWrapper<T> w : col) {
            result.add(w.get());
        }
        return result;
    }
}

