/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.persister.store;

import com.huskycode.jpaquery.persister.store.InstanceValueStore;
import com.huskycode.jpaquery.util.MapUtil;
import java.util.Map;

public class PropogatedValueStore<T, K, V> {
    private final InstanceValueStore<T, Map<K, V>> dataStore = InstanceValueStore.newInstance();

    private PropogatedValueStore() {
    }

    public static <T, K, V> PropogatedValueStore<T, K, V> newInstance() {
        return new PropogatedValueStore<T, K, V>();
    }

    public Object putValue(T t, K k, V value) {
        Map<K, V> map = this.getValueOrCreateIfNotExist(t);
        return map.put(k, value);
    }

    public void putValue(T t, Map<K, V> values) {
        Map<K, V> map = this.getValueOrCreateIfNotExist(t);
        map.putAll(values);
    }

    public Map<K, V> get(T t) {
        return this.getValueOrCreateIfNotExist(t);
    }

    private Map<K, V> getValueOrCreateIfNotExist(T key) {
        return MapUtil.getOrCreateMap(this.dataStore, key);
    }
}

