/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.persister.util;

import com.huskycode.jpaquery.persister.exception.EntityInstantiationException;
import com.huskycode.jpaquery.populator.CannotSetValueException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.metamodel.SingularAttribute;

public class BeanUtil {
    public static <E> E newInstance(Class<E> beanClass) {
        try {
            Constructor<E> c = BeanUtil.searchForDefaultConstructor(beanClass);
            if (c != null) {
                c.setAccessible(true);
                return c.newInstance(new Object[0]);
            }
            return beanClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new EntityInstantiationException("Cannot create class: " + beanClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new EntityInstantiationException("Cannot create class: " + beanClass.getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new EntityInstantiationException("Cannot create class: " + beanClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new EntityInstantiationException("Cannot create class: " + beanClass.getName(), e);
        }
    }

    private static <E> Constructor<E> searchForDefaultConstructor(Class<E> beanClass) {
        Constructor<?>[] constructors = beanClass.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != 0) continue;
            return constructors[i];
        }
        return null;
    }

    public static Field getFieldByName(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getValue(Object obj, Field field) {
        field.setAccessible(true);
        try {
            return field.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new CannotSetValueException(e);
        }
        catch (IllegalAccessException e) {
            throw new CannotSetValueException(e);
        }
    }

    public static Field findIdField(Class<?> entityClass) {
        Field[] fields;
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (field.getAnnotation(Id.class) == null) continue;
            return field;
        }
        return null;
    }

    public static boolean isAnnotatedWithGenerated(Field field) {
        return field.getAnnotation(GeneratedValue.class) != null;
    }

    public static <T> Field getField(SingularAttribute<?, T> attr) {
        Class declaredJavaType = attr.getDeclaringType().getJavaType();
        Field originalField = (Field)attr.getJavaMember();
        if (originalField.getDeclaringClass().equals(declaredJavaType)) {
            return originalField;
        }
        try {
            return declaredJavaType.getDeclaredField(originalField.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

