/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.solver;

import com.huskycode.jpaquery.command.CommandNode;
import com.huskycode.jpaquery.command.CommandNodes;
import com.huskycode.jpaquery.solver.CommandNodesIndexBuilder;
import com.huskycode.jpaquery.solver.CommandNodesIndexResult;
import java.util.HashMap;
import java.util.Map;

public class CommandNodesIndexBuilderImpl
implements CommandNodesIndexBuilder {
    @Override
    public CommandNodesIndexResult build(CommandNodes commands) {
        HashMap sizeMap = new HashMap();
        CommandNodesIndexResult result = new CommandNodesIndexResult();
        for (CommandNode command : commands.get()) {
            this.deepFirstSearchIndexing(command, sizeMap, result);
        }
        return result;
    }

    private void deepFirstSearchIndexing(CommandNode command, Map<Class<?>, Integer> sizeMap, CommandNodesIndexResult result) {
        if (result.getIndexOf(command) == null) {
            Class<?> c = command.getEntity();
            int size = this.getSize(c, sizeMap);
            sizeMap.put(c, size + 1);
            result.put(command, size);
            for (CommandNode child : command.getChildren()) {
                this.deepFirstSearchIndexing(child, sizeMap, result);
            }
        }
    }

    private Integer getSize(Class<?> clazz, Map<Class<?>, Integer> sizeMap) {
        Integer size = 0;
        if (sizeMap.containsKey(clazz)) {
            size = sizeMap.get(clazz);
        }
        return size;
    }
}

