/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.solver;

import com.huskycode.jpaquery.DependenciesDefinition;
import com.huskycode.jpaquery.command.CommandNode;
import com.huskycode.jpaquery.command.CommandNodeFactory;
import com.huskycode.jpaquery.command.CommandNodes;
import com.huskycode.jpaquery.command.CommandNodesFactory;
import com.huskycode.jpaquery.persister.store.InstanceWrapper;
import com.huskycode.jpaquery.persister.store.PropogatedValueStore;
import com.huskycode.jpaquery.solver.CommandInterpretor;
import com.huskycode.jpaquery.solver.CommandPlan;
import com.huskycode.jpaquery.solver.InOrderEntityData;
import com.huskycode.jpaquery.solver.InvalidCommandHierarchy;
import com.huskycode.jpaquery.solver.Solver;
import com.huskycode.jpaquery.types.tree.ActionGraph;
import com.huskycode.jpaquery.types.tree.CreationPlan;
import com.huskycode.jpaquery.types.tree.EntityNode;
import com.huskycode.jpaquery.util.CollectionUtil;
import com.huskycode.jpaquery.util.Factory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SolverImpl
implements Solver {
    private final CommandInterpretor commandInterpretor = CommandInterpretor.getInstance();
    private final DependenciesDefinition deps;
    private static final boolean isDebug = false;

    private SolverImpl(DependenciesDefinition deps) {
        this.deps = deps;
    }

    public static SolverImpl newInstance(DependenciesDefinition deps) {
        return new SolverImpl(deps);
    }

    @Override
    @Deprecated
    public <E> CreationPlan solveFor(Class<E> entityClass) {
        CommandNodeFactory.CommandNodeImpl command = CommandNodeFactory.n(entityClass, new CommandNode[0]);
        return this.solveFor(CommandNodesFactory.ns(command));
    }

    @Override
    public <E> CreationPlan solveFor(CommandNodes commands) {
        ActionGraph actionGraph = this.createActionGraph(commands);
        return CreationPlan.newInstance(actionGraph);
    }

    protected ActionGraph createActionGraph(CommandNodes commands) {
        ActionGraph actionGraph = ActionGraph.newInstance();
        CommandPlan plan = this.commandInterpretor.createPlan(commands, this.deps);
        this.printPlan(plan);
        this.createActionGraph2(plan, actionGraph);
        return actionGraph;
    }

    private void printPlan(CommandPlan plan) {
        SolverImpl.printIfDebug("Graph Order:");
        for (Class<?> c : plan.getInOrderEntityData().getInOrderEntityList()) {
            SolverImpl.printIfDebug(c.toString());
        }
        SolverImpl.printIfDebug("Command Order:");
        for (CommandNode currentCommand : plan.getPlan()) {
            SolverImpl.printIfDebug(currentCommand);
        }
    }

    private void createActionGraph2(CommandPlan plan, ActionGraph actionGraph) {
        PropogatedValueStore<CommandNode, Class<?>, EntityNode> context = PropogatedValueStore.newInstance();
        DummyEntityContainer globallySharedContextContainer = DummyEntityContainer.newInstance(this.deps);
        HashMap<ContextKey, EntityNode> contextSpecificContainer = new HashMap<ContextKey, EntityNode>();
        InOrderEntityData inOrderEntityData = plan.getInOrderEntityData();
        EntityListIteratorFactory entityListIteratorFactory = EntityListIteratorFactory.newInstance(inOrderEntityData.getInOrderEntityList());
        for (CommandNode currentCommand : plan.getPlan()) {
            SolverImpl.printIfDebug("Command: " + currentCommand);
            Object entityClassIterator = entityListIteratorFactory.newInstace();
            Map<Class<?>, EntityNode> currentContext = context.get(currentCommand);
            this.createAllRequiredParentDependencyIfNeeded((ListIterator<Class<?>>)entityClassIterator, currentCommand, currentContext, globallySharedContextContainer, (Map<ContextKey, EntityNode>)contextSpecificContainer, actionGraph);
            this.createEntityNodeOfThisCommand(currentCommand, currentContext, globallySharedContextContainer, contextSpecificContainer, actionGraph);
            this.updateChildrenContext(currentCommand.getChildren(), currentContext, context);
            SolverImpl.printIfDebug("");
        }
    }

    private void createEntityNodeOfThisCommand(CommandNode currentCommand, Map<Class<?>, EntityNode> currentContext, DummyEntityContainer dummyContainer, Map<ContextKey, EntityNode> contextSpecificContainer, ActionGraph actionGraph) {
        Set<Class<?>> parents = this.getDirectParentDependency(currentCommand.getEntity());
        EntityNode thisNode = this.createEntityNodeAndUpdateContext(currentCommand, currentContext, dummyContainer, parents, contextSpecificContainer);
        actionGraph.addEntityNode(thisNode);
        ContextKey key = this.createContextKey(currentCommand.getEntity(), currentContext, dummyContainer, contextSpecificContainer);
        contextSpecificContainer.put(key, thisNode);
    }

    private void createAllRequiredParentDependencyIfNeeded(ListIterator<Class<?>> entityClassIterator, CommandNode currentCommand, Map<Class<?>, EntityNode> currentContext, DummyEntityContainer globallySharedContextContainer, Map<ContextKey, EntityNode> contextSpecificContainer, ActionGraph actionGraph) {
        Class currentEntityClass = entityClassIterator.getCurrent();
        Set<Class<?>> allParentDependency = this.deps.getAllParentDependencyEntity(currentCommand.getEntity());
        SolverImpl.printIfDebug(" Current Command Context: " + currentContext.keySet());
        while (!currentCommand.getEntity().equals(currentEntityClass)) {
            SolverImpl.printIfDebug("  Current Entity: " + currentEntityClass);
            if (allParentDependency.contains(currentEntityClass) && !currentContext.containsKey(currentEntityClass)) {
                SolverImpl.printIfDebug("     Current Entity is required and not in context");
                Set<Class<?>> parents = this.getDirectParentDependency(currentEntityClass);
                if (parents.size() == 0 || !CollectionUtil.containAny(parents, currentContext.keySet())) {
                    SolverImpl.printIfDebug("      Not context specific and can be shared");
                    if (!globallySharedContextContainer.contain(currentEntityClass)) {
                        SolverImpl.printIfDebug("        No Dummpy and should create it");
                        EntityNode thisNode = globallySharedContextContainer.create(currentEntityClass);
                        actionGraph.addEntityNode(thisNode);
                    }
                } else {
                    SolverImpl.printIfDebug("      Context Specific Entity");
                    ContextKey key = this.createContextKey(currentEntityClass, currentContext, globallySharedContextContainer, contextSpecificContainer);
                    EntityNode thisNode = contextSpecificContainer.get(key);
                    if (thisNode == null) {
                        SolverImpl.printIfDebug("        Create new Context Entity");
                        thisNode = this.createEntityNodeAndUpdateContext(currentEntityClass, currentContext, globallySharedContextContainer, contextSpecificContainer);
                        actionGraph.addEntityNode(thisNode);
                        contextSpecificContainer.put(key, thisNode);
                    }
                    currentContext.put(currentEntityClass, thisNode);
                }
            }
            if (entityClassIterator.hasNext()) {
                currentEntityClass = (Class)((ListIterator)entityClassIterator).next().getCurrent();
                continue;
            }
            throw new InvalidCommandHierarchy(currentCommand.toString());
        }
        SolverImpl.printIfDebug(" Current Command Context: " + currentContext.keySet());
        SolverImpl.printIfDebug("End While: " + currentEntityClass);
    }

    private Set<Class<?>> getDirectParentDependency(Class<?> currentEntityClass) {
        return this.deps.getDirectParentDependencyEntity(currentEntityClass);
    }

    private ContextKey createContextKey(Class<?> currentEntityClass, Map<Class<?>, EntityNode> context, DummyEntityContainer globallySharedContextContainer, Map<ContextKey, EntityNode> contextSpecificContainer) {
        ContextKey key = ContextKey.newInstance(currentEntityClass);
        for (Class<?> parent : this.getDirectParentDependency(currentEntityClass)) {
            EntityNode parentNode = context.get(parent);
            if (parentNode == null) {
                ContextKey parentKey = this.createContextKey(parent, context, globallySharedContextContainer, contextSpecificContainer);
                parentNode = contextSpecificContainer.get(parentKey);
            }
            if (parentNode == null) {
                parentNode = globallySharedContextContainer.getDummyEntity(parent);
            }
            if (parentNode == null) {
                throw new RuntimeException("Cannot find parent entity " + parent + " in all contexts and global context for " + currentEntityClass);
            }
            key.addEntityNode(parentNode);
        }
        return key;
    }

    private void updateChildrenContext(List<CommandNode> children, Map<Class<?>, EntityNode> parentContext, PropogatedValueStore<CommandNode, Class<?>, EntityNode> context) {
        for (CommandNode child : children) {
            for (Map.Entry<Class<?>, EntityNode> entry : parentContext.entrySet()) {
                Map<Class<?>, EntityNode> childContext = context.get(child);
                if (childContext.containsKey(entry.getKey())) continue;
                childContext.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private EntityNode createEntityNodeAndUpdateContext(Class<?> entityClass, Map<Class<?>, EntityNode> context, DummyEntityContainer globallySharedContextContainer, Map<ContextKey, EntityNode> contextSpecificContainer) {
        EntityNode thisNode = EntityNode.newInstance(entityClass);
        this.linkDependency(thisNode, context, globallySharedContextContainer, contextSpecificContainer);
        context.put(entityClass, thisNode);
        return thisNode;
    }

    private EntityNode createEntityNodeAndUpdateContext(CommandNode command, Map<Class<?>, EntityNode> context, DummyEntityContainer globallySharedContextContainer, Set<Class<?>> parents, Map<ContextKey, EntityNode> instanceContainer) {
        EntityNode thisNode = this.createEntityNodeAndUpdateContext(command.getEntity(), context, globallySharedContextContainer, instanceContainer);
        thisNode.setCommand(command);
        return thisNode;
    }

    private void linkDependency(EntityNode thisNode, Map<Class<?>, EntityNode> context, DummyEntityContainer globallySharedContextContainer, Map<ContextKey, EntityNode> contextSpecificContainer) {
        for (Class<?> entityClass : this.getDirectParentDependency(thisNode.getEntityClass())) {
            EntityNode parentNode = context.get(entityClass);
            if (parentNode == null) {
                ContextKey parentKey = this.createContextKey(entityClass, context, globallySharedContextContainer, contextSpecificContainer);
                parentNode = contextSpecificContainer.get(parentKey);
            }
            if (parentNode == null) {
                parentNode = globallySharedContextContainer.getDummyEntity(entityClass);
            }
            if (parentNode == null) {
                throw new RuntimeException("Cannot find parent entity " + entityClass + " in all contexts and global context for " + thisNode.getEntityClass());
            }
            thisNode.addParent(parentNode);
            parentNode.addChild(thisNode);
        }
    }

    private static void printIfDebug(Object msg) {
    }

    private static class ContextKey {
        private final Class<?> entityClass;
        private final List<InstanceWrapper<EntityNode>> entityNodes;

        private ContextKey(Class<?> entityClass) {
            this.entityClass = entityClass;
            this.entityNodes = new ArrayList<InstanceWrapper<EntityNode>>();
        }

        public static ContextKey newInstance(Class<?> entityClass) {
            return new ContextKey(entityClass);
        }

        public void addEntityNode(EntityNode node) {
            this.entityNodes.add(new InstanceWrapper<EntityNode>(node));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.entityClass == null ? 0 : this.entityClass.hashCode());
            result = 31 * result + (this.entityNodes == null ? 0 : ((Object)this.entityNodes).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContextKey other = (ContextKey)obj;
            if (this.entityClass == null ? other.entityClass != null : !this.entityClass.equals(other.entityClass)) {
                return false;
            }
            return !(this.entityNodes == null ? other.entityNodes != null : !((Object)this.entityNodes).equals(other.entityNodes));
        }
    }

    private static class ListIterator<T> {
        private java.util.ListIterator<T> itr;
        private List<T> list;
        private T current;
        private int currentIndex;

        private ListIterator(List<T> list, int index) {
            this.initialize(list, index);
        }

        private void initialize(List<T> list, int index) {
            this.list = list;
            this.itr = list.listIterator(index);
            this.next();
        }

        public static <T> ListIterator<T> of(List<T> list) {
            return new ListIterator<T>(list, 0);
        }

        public static <T> ListIterator<T> copy(ListIterator<T> other) {
            return new ListIterator<T>(other.list, other.currentIndex);
        }

        public void updateLatest(ListIterator<T> other) {
            if (this.currentIndex < other.currentIndex) {
                this.initialize(this.list, other.currentIndex);
            }
        }

        public boolean hasNext() {
            return this.itr.hasNext();
        }

        private ListIterator<T> next() {
            try {
                this.currentIndex = this.itr.nextIndex();
                this.current = this.itr.next();
                return this;
            }
            catch (NoSuchElementException e) {
                this.current = null;
                return this;
            }
        }

        public T getCurrent() {
            return this.current;
        }
    }

    private static class DummyEntityContainer {
        private final Map<Class<?>, EntityNode> dummyContainer = new HashMap();
        private final DependenciesDefinition deps;

        private DummyEntityContainer(DependenciesDefinition deps) {
            this.deps = deps;
        }

        public static DummyEntityContainer newInstance(DependenciesDefinition deps) {
            return new DummyEntityContainer(deps);
        }

        public EntityNode create(Class<?> entityClass) {
            EntityNode result = this.dummyContainer.get(entityClass);
            if (result == null) {
                result = EntityNode.newInstance(entityClass);
                this.linkDependency(result);
                this.dummyContainer.put(entityClass, result);
            }
            return result;
        }

        public boolean contain(Class<?> entityClass) {
            return this.dummyContainer.containsKey(entityClass);
        }

        public EntityNode getDummyEntity(Class<?> entityClass) {
            return this.dummyContainer.get(entityClass);
        }

        private void linkDependency(EntityNode thisNode) {
            for (Class<?> parent : this.deps.getDirectParentDependencyEntity(thisNode.getEntityClass())) {
                EntityNode parentNode = this.dummyContainer.get(parent);
                SolverImpl.printIfDebug("Get Dummy Parent " + parent + " for " + thisNode.getEntityClass());
                if (parentNode == null) {
                    throw new RuntimeException("Cannot find parent entity " + parent + " for entity " + thisNode.getEntityClass() + " in globally shared context.");
                }
                thisNode.addParent(parentNode);
                parentNode.addChild(thisNode);
            }
        }
    }

    private static class EntityListIteratorFactory
    implements Factory<ListIterator<Class<?>>> {
        private final List<Class<?>> plan;

        private EntityListIteratorFactory(List<Class<?>> plan) {
            this.plan = plan;
        }

        public static EntityListIteratorFactory newInstance(List<Class<?>> plan) {
            return new EntityListIteratorFactory(plan);
        }

        @Override
        public ListIterator<Class<?>> newInstace() {
            return ListIterator.of(this.plan);
        }
    }
}

