/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.types.tree;

import com.huskycode.jpaquery.command.CommandNode;
import com.huskycode.jpaquery.solver.CommandNodesIndexResult;
import com.huskycode.jpaquery.util.MapUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersistedResult {
    private final List<Object> persistedObjects;
    private final Map<Class<?>, List<Object>> classInstanceMap;
    private final Map<Class<?>, Map<Integer, Object>> commandNodeObjectIndexMap;

    private PersistedResult(List<Object> persistedObjects) {
        this.persistedObjects = persistedObjects;
        this.classInstanceMap = new HashMap();
        this.commandNodeObjectIndexMap = new HashMap();
    }

    private static void initialize(PersistedResult result) {
        for (Object obj : result.persistedObjects) {
            MapUtil.getOrCreateList(result.classInstanceMap, obj.getClass()).add(obj);
        }
    }

    public static PersistedResult newInstance(List<Object> persistedObjects) {
        PersistedResult tree = new PersistedResult(persistedObjects);
        PersistedResult.initialize(tree);
        return tree;
    }

    public List<Object> getPersistedObjects() {
        return this.persistedObjects;
    }

    public <E> List<E> getForClass(Class<E> clazz) {
        return this.classInstanceMap.get(clazz);
    }

    public <E> E getForClassByCommandIndex(Class<E> clazz, int index) {
        Map<Integer, Object> indexObjectMap = this.commandNodeObjectIndexMap.get(clazz);
        if (indexObjectMap == null) {
            throw new RuntimeException("Class " + clazz + " does not get created with the given commands");
        }
        Object obj = indexObjectMap.get(index);
        if (obj == null) {
            throw new ArrayIndexOutOfBoundsException("Index " + index + " of class " + clazz);
        }
        return (E)obj;
    }

    public static PersistedResult newInstance(List<Object> persistedObjects, CommandNodesIndexResult commandIndexes, Map<CommandNode, Object> commandObjectMap) {
        PersistedResult tree = new PersistedResult(persistedObjects);
        PersistedResult.initialize(tree);
        PersistedResult.initializeIndexMap(tree, commandIndexes, commandObjectMap);
        return tree;
    }

    private static void initializeIndexMap(PersistedResult tree, CommandNodesIndexResult commandIndexes, Map<CommandNode, Object> commandObjectMap) {
        for (Map.Entry<CommandNode, Object> commandObject : commandObjectMap.entrySet()) {
            CommandNode command = commandObject.getKey();
            int index = commandIndexes.getIndexOf(command);
            MapUtil.getOrCreateMap(tree.commandNodeObjectIndexMap, command.getEntity()).put(index, commandObject.getValue());
        }
    }
}

