/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.util;

import com.huskycode.jpaquery.util.Randomizer;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.RandomStringUtils;

public class RandomizerImpl
implements Randomizer {
    private static final Random any = new Random();
    public static Integer DEFAULT_LENGTH = 2;

    @Override
    public <T> T getRandomOfType(Class<T> type, int length) {
        if (type.equals(String.class)) {
            return (T)(length > 0 ? RandomizerImpl.getAlphanumericString(DEFAULT_LENGTH) : RandomizerImpl.getAlphanumericString(DEFAULT_LENGTH));
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (T)RandomizerImpl.getInt();
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (T)RandomizerImpl.getDouble();
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return (T)RandomizerImpl.getFloat();
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (T)RandomizerImpl.getLong();
        }
        if (type.equals(Character.class) || type.equals(Character.TYPE)) {
            return (T)RandomizerImpl.getCharacter();
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)RandomizerImpl.getBoolean();
        }
        if (type.equals(Date.class)) {
            return (T)RandomizerImpl.getDate();
        }
        if (type.equals(BigDecimal.class)) {
            return (T)RandomizerImpl.getBigDecimal();
        }
        if (type.equals(Timestamp.class)) {
            return (T)this.getTimestamp();
        }
        if (type.isEnum()) {
            return RandomizerImpl.getRandomEnum(type);
        }
        System.out.println("Not primitive: " + type);
        throw new UnsupportedOperationException("Not a primitive class: " + type);
    }

    private Timestamp getTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static <T> T getRandomEnum(Class<T> enumType) {
        return enumType.getEnumConstants()[0];
    }

    public static BigDecimal getBigDecimal() {
        return new BigDecimal(any.nextDouble());
    }

    @Override
    public <T> T getRandomOfType(Class<T> type) {
        return this.getRandomOfType(type, 0);
    }

    public static String getString(int length) {
        return length == 0 ? "" : RandomStringUtils.randomAlphanumeric((int)Math.abs(length));
    }

    public static String getString() {
        return RandomizerImpl.getString(any.nextInt(DEFAULT_LENGTH));
    }

    public static String getAlphanumericString(int length) {
        return length == 0 ? "" : RandomStringUtils.randomAlphanumeric((int)Math.abs(length));
    }

    public static Character getCharacter() {
        return Character.valueOf(RandomStringUtils.randomAlphanumeric((int)1).charAt(0));
    }

    public static String getAlphanumericString() {
        return RandomizerImpl.getAlphanumericString(any.nextInt(DEFAULT_LENGTH));
    }

    public static Integer getInt() {
        return any.nextInt();
    }

    public static Integer getNonNegativeInt() {
        return Math.abs(any.nextInt());
    }

    public static Long getLong() {
        return new Long(any.nextInt());
    }

    public static Long getNonNegativeLong() {
        return Math.abs(any.nextLong());
    }

    public static Double getDouble() {
        return any.nextDouble();
    }

    public static Float getFloat() {
        return Float.valueOf(any.nextFloat());
    }

    public static Boolean getBoolean() {
        return any.nextDouble() > 0.5;
    }

    public static Date getDate() {
        return new Date();
    }

    public static <T> T getRandomFromArray(T[] array) {
        int length = array.length;
        return array[any.nextInt(length)];
    }

    public static <T> T getRandomFromList(List<T> list) {
        int length = list.size();
        return list.get(any.nextInt(length));
    }
}

