/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import com.ibm.etcd.api.AuthGrpc;
import com.ibm.etcd.api.AuthenticateRequest;
import com.ibm.etcd.api.AuthenticateResponse;
import com.ibm.etcd.client.GrpcClient;
import com.ibm.etcd.client.KvStoreClient;
import com.ibm.etcd.client.StaticEtcdNameResolverFactory;
import com.ibm.etcd.client.kv.EtcdKvClient;
import com.ibm.etcd.client.kv.KvClient;
import com.ibm.etcd.client.lease.EtcdLeaseClient;
import com.ibm.etcd.client.lease.LeaseClient;
import com.ibm.etcd.client.lease.PersistentLease;
import com.ibm.etcd.client.lock.EtcdLockClient;
import com.ibm.etcd.client.lock.LockClient;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

public class EtcdClient
implements KvStoreClient {
    private static final Metadata.Key<String> TOKEN_KEY = Metadata.Key.of((String)"token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final MethodDescriptor<AuthenticateRequest, AuthenticateResponse> METHOD_AUTHENTICATE = AuthGrpc.getAuthenticateMethod();
    public static final int DEFAULT_PORT = 2379;
    private static final LeaseClient CLOSED = GrpcClient.sentinel(LeaseClient.class);
    public static final long DEFAULT_TIMEOUT_MS = 10000L;
    public static final int DEFAULT_SESSION_TIMEOUT_SECS = 20;
    private final int sessionTimeoutSecs;
    private final ByteString name;
    private final ByteString password;
    private final MultithreadEventLoopGroup internalExecutor;
    private final GrpcClient grpc;
    private final ManagedChannel channel;
    private final EtcdKvClient kvClient;
    private volatile LeaseClient leaseClient;
    private volatile LockClient lockClient;
    private volatile PersistentLease sessionLease;

    private static int defaultThreadCount() {
        return Math.min(6, Runtime.getRuntime().availableProcessors());
    }

    public static Builder forEndpoint(String host, int port) {
        String target = GrpcUtil.authorityFromHostAndPort((String)host, (int)port);
        return new Builder(NettyChannelBuilder.forTarget((String)target));
    }

    public static Builder forEndpoints(List<String> endpoints) {
        NettyChannelBuilder ncb = (NettyChannelBuilder)NettyChannelBuilder.forTarget((String)"etcd").nameResolverFactory((NameResolver.Factory)new StaticEtcdNameResolverFactory(endpoints));
        return new Builder(ncb);
    }

    public static Builder forEndpoints(String endpoints) {
        return EtcdClient.forEndpoints(Arrays.asList(endpoints.split(",")));
    }

    EtcdClient(NettyChannelBuilder chanBuilder, long defaultTimeoutMs, ByteString name, ByteString password, boolean initialAuth, int threads, Executor userExecutor, boolean sendViaEventLoop, int sessTimeoutSecs) {
        Class<EpollSocketChannel> channelType;
        if (name == null && password != null) {
            throw new IllegalArgumentException("password without name");
        }
        this.name = name;
        this.password = password;
        this.sessionTimeoutSecs = sessTimeoutSecs;
        chanBuilder.keepAliveTime(10L, TimeUnit.SECONDS);
        chanBuilder.keepAliveTimeout(8L, TimeUnit.SECONDS);
        int connTimeout = Math.min((int)defaultTimeoutMs, 6000);
        chanBuilder.withOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connTimeout);
        ThreadFactory tfac = new ThreadFactoryBuilder().setDaemon(true).setThreadFactory(EtcdEventThread::new).setNameFormat("etcd-event-pool-%d").build();
        if (Epoll.isAvailable()) {
            this.internalExecutor = new EpollEventLoopGroup(threads, tfac);
            channelType = EpollSocketChannel.class;
        } else {
            this.internalExecutor = new NioEventLoopGroup(threads, tfac);
            channelType = NioSocketChannel.class;
        }
        chanBuilder.eventLoopGroup((EventLoopGroup)this.internalExecutor).channelType(channelType);
        if (userExecutor == null) {
            userExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("etcd-callback-thread-%d").build());
        }
        chanBuilder.executor(userExecutor);
        this.channel = chanBuilder.build();
        Predicate rr = name != null ? EtcdClient::reauthRequired : null;
        Supplier<CallCredentials> rc = name != null ? this::refreshCredentials : null;
        this.grpc = new GrpcClient(this.channel, (Predicate<Throwable>)rr, rc, (ScheduledExecutorService)this.internalExecutor, () -> Thread.currentThread() instanceof EtcdEventThread, userExecutor, sendViaEventLoop, defaultTimeoutMs);
        if (initialAuth) {
            this.grpc.authenticateNow();
        }
        this.kvClient = new EtcdKvClient(this.grpc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.leaseClient == CLOSED) {
            return;
        }
        this.kvClient.close();
        EtcdClient etcdClient = this;
        synchronized (etcdClient) {
            if (this.leaseClient instanceof EtcdLeaseClient) {
                ((EtcdLeaseClient)this.leaseClient).close();
            }
            this.leaseClient = CLOSED;
        }
        this.executeWhenIdle(() -> {
            try {
                this.channel.shutdown().awaitTermination(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executeWhenIdle(() -> this.internalExecutor.shutdownGracefully(0L, 1L, TimeUnit.SECONDS));
        });
    }

    private void executeWhenIdle(Runnable task) {
        AtomicInteger remainingTasks = new AtomicInteger(-1);
        CyclicBarrier cb = new CyclicBarrier(this.internalExecutor.executorCount(), () -> {
            int rt = remainingTasks.get();
            if (rt == -1) {
                remainingTasks.incrementAndGet();
            } else if (rt > 0) {
                this.executeWhenIdle(task);
            } else {
                this.internalExecutor.execute(task);
            }
        });
        this.internalExecutor.forEach(ex -> ex.execute(new Runnable((EventExecutor)ex, cb, remainingTasks){
            final /* synthetic */ EventExecutor val$ex;
            final /* synthetic */ CyclicBarrier val$cb;
            final /* synthetic */ AtomicInteger val$remainingTasks;
            {
                this.val$ex = eventExecutor;
                this.val$cb = cyclicBarrier;
                this.val$remainingTasks = atomicInteger;
            }

            @Override
            public void run() {
                SingleThreadEventLoop stel = (SingleThreadEventLoop)this.val$ex;
                try {
                    if (stel.pendingTasks() > 0) {
                        this.val$ex.execute((Runnable)this);
                    } else {
                        this.val$cb.await();
                        if (stel.pendingTasks() > 0) {
                            this.val$remainingTasks.incrementAndGet();
                        }
                        this.val$cb.await();
                    }
                }
                catch (InterruptedException | BrokenBarrierException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }));
    }

    public boolean isClosed() {
        return this.leaseClient == CLOSED;
    }

    protected static boolean reauthRequired(Throwable error) {
        Status.Code statusCode = GrpcClient.codeFromThrowable(error);
        return statusCode == Status.Code.UNAUTHENTICATED || statusCode == Status.Code.INVALID_ARGUMENT && EtcdClient.contains(error.getMessage(), "user name is empty") || statusCode == Status.Code.CANCELLED && EtcdClient.reauthRequired(error.getCause());
    }

    private CallCredentials refreshCredentials() {
        return new CallCredentials(){
            private Metadata tokenHeader;
            private final long authTime = System.currentTimeMillis();
            private final ListenableFuture<Metadata> futureTokenHeader = Futures.transform((ListenableFuture)EtcdClient.access$100(EtcdClient.this), ar -> {
                this.tokenHeader = EtcdClient.tokenHeader(ar);
                return this.tokenHeader;
            }, (Executor)MoreExecutors.directExecutor());

            public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
                Metadata tokHeader = this.tokenHeader;
                if (tokHeader != null) {
                    applier.apply(tokHeader);
                } else {
                    this.futureTokenHeader.addListener(() -> {
                        try {
                            applier.apply((Metadata)this.futureTokenHeader.get());
                        }
                        catch (InterruptedException | ExecutionException ee) {
                            Status.Code code;
                            Status failStatus = Status.fromThrowable((Throwable)ee.getCause());
                            Status.Code code2 = code = failStatus != null ? failStatus.getCode() : null;
                            if (code != Status.Code.INVALID_ARGUMENT && System.currentTimeMillis() - this.authTime > 15000L) {
                                failStatus = Status.UNAUTHENTICATED.withDescription("re-attempt re-auth");
                            }
                            applier.fail(failStatus);
                        }
                    }, MoreExecutors.directExecutor());
                }
            }

            public void thisUsesUnstableApi() {
            }
        };
    }

    private static Metadata tokenHeader(AuthenticateResponse authResponse) {
        Metadata header = new Metadata();
        header.put(TOKEN_KEY, (Object)authResponse.getToken());
        return header;
    }

    private ListenableFuture<AuthenticateResponse> authenticate() {
        AuthenticateRequest request = AuthenticateRequest.newBuilder().setNameBytes(this.name).setPasswordBytes(this.password).build();
        CallOptions callOpts = CallOptions.DEFAULT;
        return Futures.catchingAsync(this.grpc.fuCall(METHOD_AUTHENTICATE, request, callOpts, 0L), Exception.class, ex -> !EtcdClient.retryAuthRequest(ex) ? Futures.immediateFailedFuture((Throwable)ex) : this.grpc.fuCall(METHOD_AUTHENTICATE, request, callOpts, 0L), (Executor)MoreExecutors.directExecutor());
    }

    protected static boolean retryAuthRequest(Throwable error) {
        Status status = Status.fromThrowable((Throwable)error);
        Status.Code statusCode = status != null ? status.getCode() : null;
        return statusCode == Status.Code.UNAVAILABLE && GrpcClient.isConnectException(error);
    }

    @Override
    public KvClient getKvClient() {
        return this.kvClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaseClient getLeaseClient() {
        LeaseClient lc = this.leaseClient;
        if (lc == null) {
            EtcdClient etcdClient = this;
            synchronized (etcdClient) {
                lc = this.leaseClient;
                if (lc == null) {
                    this.leaseClient = lc = new EtcdLeaseClient(this.grpc);
                }
            }
        }
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockClient getLockClient() {
        LockClient lc = this.lockClient;
        if (lc == null) {
            EtcdClient etcdClient = this;
            synchronized (etcdClient) {
                lc = this.lockClient;
                if (lc == null) {
                    this.lockClient = lc = new EtcdLockClient(this.grpc, this);
                }
            }
        }
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistentLease getSessionLease() {
        PersistentLease sl = this.sessionLease;
        if (sl == null) {
            EtcdClient etcdClient = this;
            synchronized (etcdClient) {
                sl = this.sessionLease;
                if (sl == null) {
                    this.sessionLease = sl = this.getLeaseClient().maintain().minTtl(this.sessionTimeoutSecs).permanent().start();
                }
            }
        }
        if (this.leaseClient == CLOSED) {
            throw new IllegalStateException("client closed");
        }
        return sl;
    }

    public Executor getExecutor() {
        return this.grpc.getResponseExecutor();
    }

    protected static <T> Predicate<T> constantPredicate(boolean val) {
        return val ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    protected static boolean contains(String str, String subStr) {
        return str != null && str.contains(subStr);
    }

    @VisibleForTesting
    MultithreadEventLoopGroup getInternalExecutor() {
        return this.internalExecutor;
    }

    static /* synthetic */ int access$000() {
        return EtcdClient.defaultThreadCount();
    }

    static /* synthetic */ ListenableFuture access$100(EtcdClient x0) {
        return x0.authenticate();
    }

    protected static final class EtcdEventThread
    extends FastThreadLocalThread {
        public EtcdEventThread(Runnable r) {
            super(r);
        }
    }

    public static class Builder {
        private final NettyChannelBuilder chanBuilder;
        private ByteString name;
        private ByteString password;
        private long defaultTimeoutMs = 10000L;
        private boolean preemptAuth;
        private int threads = EtcdClient.access$000();
        private Executor executor;
        private boolean sendViaEventLoop = true;
        private int sessTimeoutSecs = 20;

        Builder(NettyChannelBuilder chanBuilder) {
            this.chanBuilder = chanBuilder;
        }

        public Builder withCredentials(ByteString name, ByteString password) {
            this.name = name;
            this.password = password;
            return this;
        }

        public Builder withCredentials(String name, String password) {
            this.name = ByteString.copyFromUtf8((String)name);
            this.password = ByteString.copyFromUtf8((String)password);
            return this;
        }

        public Builder withImmediateAuth() {
            this.preemptAuth = true;
            return this;
        }

        public Builder withThreadCount(int threads) {
            this.threads = threads;
            return this;
        }

        public Builder sendViaEventLoop(boolean sendViaEventLoop) {
            this.sendViaEventLoop = sendViaEventLoop;
            return this;
        }

        public Builder withUserExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder withDefaultTimeout(long value, TimeUnit unit) {
            this.defaultTimeoutMs = TimeUnit.MILLISECONDS.convert(value, unit);
            return this;
        }

        public Builder withPlainText() {
            this.chanBuilder.usePlaintext();
            return this;
        }

        public Builder withCaCert(ByteSource certSource) throws IOException, SSLException {
            try (InputStream cert = certSource.openStream();){
                this.chanBuilder.sslContext(GrpcSslContexts.forClient().trustManager(cert).build());
            }
            return this;
        }

        public Builder withTrustManager(TrustManagerFactory tmf) throws SSLException {
            this.chanBuilder.sslContext(GrpcSslContexts.forClient().trustManager(tmf).build());
            return this;
        }

        public Builder withSessionTimeoutSecs(int timeoutSecs) {
            if (timeoutSecs < 1) {
                throw new IllegalArgumentException("invalid session timeout: " + timeoutSecs);
            }
            this.sessTimeoutSecs = timeoutSecs;
            return this;
        }

        public Builder withMaxInboundMessageSize(int sizeInBytes) {
            this.chanBuilder.maxInboundMessageSize(sizeInBytes);
            return this;
        }

        public EtcdClient build() {
            return new EtcdClient(this.chanBuilder, this.defaultTimeoutMs, this.name, this.password, this.preemptAuth, this.threads, this.executor, this.sendViaEventLoop, this.sessTimeoutSecs);
        }
    }
}

