/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;

public class KeyUtils {
    public static final ByteString ZERO_BYTE = KeyUtils.singleByte(0);

    private KeyUtils() {
    }

    public static ByteString plusOne(ByteString key) {
        int max = key.size() - 1;
        if (max < 0) {
            return KeyUtils.singleByte(1);
        }
        int lastPlusOne = key.byteAt(max) + 1;
        ByteString excludeLast = key.substring(0, max);
        return lastPlusOne == 0 ? KeyUtils.plusOne(excludeLast) : excludeLast.concat(KeyUtils.singleByte(lastPlusOne));
    }

    public static ByteString singleByte(int b) {
        return UnsafeByteOperations.unsafeWrap((byte[])new byte[]{(byte)b});
    }

    public static int compareByteStrings(ByteString bs1, ByteString bs2) {
        int s1 = bs1.size();
        int s2 = bs2.size();
        int n = Math.min(s1, s2);
        for (int i = 0; i < n; ++i) {
            int cmp = Byte.compare(bs1.byteAt(i), bs2.byteAt(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return s1 - s2;
    }

    public static ByteString bs(String str) {
        return str != null ? ByteString.copyFromUtf8((String)str) : null;
    }
}

