/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client.lease;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.ibm.etcd.api.LeaseGrantRequest;
import com.ibm.etcd.api.LeaseGrantResponse;
import com.ibm.etcd.api.LeaseGrpc;
import com.ibm.etcd.api.LeaseKeepAliveRequest;
import com.ibm.etcd.api.LeaseKeepAliveResponse;
import com.ibm.etcd.api.LeaseLeasesRequest;
import com.ibm.etcd.api.LeaseLeasesResponse;
import com.ibm.etcd.api.LeaseRevokeRequest;
import com.ibm.etcd.api.LeaseRevokeResponse;
import com.ibm.etcd.api.LeaseTimeToLiveRequest;
import com.ibm.etcd.api.LeaseTimeToLiveResponse;
import com.ibm.etcd.client.FluentRequest;
import com.ibm.etcd.client.GrpcClient;
import com.ibm.etcd.client.lease.LeaseClient;
import com.ibm.etcd.client.lease.PersistentLease;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EtcdLeaseClient
implements LeaseClient,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(EtcdLeaseClient.class);
    private static final Exception CANCEL_EXCEPTION = new CancellationException();
    private static final MethodDescriptor<LeaseGrantRequest, LeaseGrantResponse> METHOD_LEASE_GRANT = LeaseGrpc.getLeaseGrantMethod();
    private static final MethodDescriptor<LeaseRevokeRequest, LeaseRevokeResponse> METHOD_LEASE_REVOKE = LeaseGrpc.getLeaseRevokeMethod();
    private static final MethodDescriptor<LeaseTimeToLiveRequest, LeaseTimeToLiveResponse> METHOD_LEASE_TIME_TO_LIVE = LeaseGrpc.getLeaseTimeToLiveMethod();
    private static final MethodDescriptor<LeaseKeepAliveRequest, LeaseKeepAliveResponse> METHOD_LEASE_KEEP_ALIVE = LeaseGrpc.getLeaseKeepAliveMethod();
    private static final MethodDescriptor<LeaseLeasesRequest, LeaseLeasesResponse> METHOD_LEASE_LEASES = LeaseGrpc.getLeaseLeasesMethod();
    private final GrpcClient client;
    private final ScheduledExecutorService ses;
    private volatile boolean closed;
    protected static final int MIN_MIN_EXPIRY_SECS = 2;
    protected static final int MIN_INTERVAL_SECS = 4;
    protected static final int DEFAULT_MIN_EXPIRY_SECS = 10;
    protected static final int DEFAULT_INTERVAL_SECS = 5;
    protected final LeaseKeepAliveRequest.Builder KAR_BUILDER = LeaseKeepAliveRequest.newBuilder();
    protected StreamObserver<LeaseKeepAliveRequest> kaReqStream;
    protected int leaseCount;
    protected final Executor kaReqExecutor;
    protected final Executor respExecutor;
    protected final Set<LeaseRecord> allLeases = ConcurrentHashMap.newKeySet();
    protected final ConcurrentMap<Long, LeaseRecord> leaseMap = new ConcurrentHashMap<Long, LeaseRecord>();
    protected final ConcurrentMap<Long, List<KeepAliveFuture>> oneTimeMap = new ConcurrentHashMap<Long, List<KeepAliveFuture>>(4);
    boolean streamEstablished;
    protected final GrpcClient.ResilientResponseObserver<LeaseKeepAliveRequest, LeaseKeepAliveResponse> responseObserver = new GrpcClient.ResilientResponseObserver<LeaseKeepAliveRequest, LeaseKeepAliveResponse>(){

        @Override
        public void onEstablished() {
            EtcdLeaseClient.this.streamEstablished = true;
            EtcdLeaseClient.this.oneTimeMap.keySet().forEach(EtcdLeaseClient.this::sendKeepAlive);
            EtcdLeaseClient.this.allLeases.forEach(LeaseRecord::reconnected);
        }

        @Override
        public void onReplaced(StreamObserver<LeaseKeepAliveRequest> newReqStream) {
            if (!EtcdLeaseClient.this.closed) {
                logger.info("onReplaced called for lease request stream" + (newReqStream == null ? " with newReqStream == null" : ""));
            }
            EtcdLeaseClient.this.streamEstablished = false;
            EtcdLeaseClient.this.kaReqExecutor.execute(() -> {
                EtcdLeaseClient.this.kaReqStream = newReqStream;
            });
            EtcdLeaseClient.this.allLeases.forEach(LeaseRecord::connectionLost);
        }

        public void onNext(LeaseKeepAliveResponse lkar) {
            LeaseRecord rec;
            Long lid = lkar.getID();
            List oneTimeFuts = (List)EtcdLeaseClient.this.oneTimeMap.remove(lid);
            if (oneTimeFuts != null) {
                EtcdLeaseClient.this.leaseRemoved();
                for (KeepAliveFuture fut : oneTimeFuts) {
                    fut.set(lkar);
                }
            }
            if ((rec = (LeaseRecord)EtcdLeaseClient.this.leaseMap.get(lid)) != null) {
                rec.processKeepAliveResponse(lkar);
            }
        }

        public void onError(Throwable t) {
            if (EtcdLeaseClient.this.closed || GrpcClient.causedBy(t, CancellationException.class)) {
                return;
            }
            EtcdLeaseClient.this.streamEstablished = false;
            EtcdLeaseClient.this.kaReqExecutor.execute(() -> {
                StreamObserver<LeaseKeepAliveRequest> stream = EtcdLeaseClient.this.kaReqStream;
                if (stream != null) {
                    stream.onError(t);
                }
            });
        }

        public void onCompleted() {
            EtcdLeaseClient.this.streamEstablished = false;
        }
    };

    public EtcdLeaseClient(GrpcClient client) {
        this.client = client;
        this.ses = client.getInternalExecutor();
        this.kaReqExecutor = GrpcClient.serialized(this.ses);
        this.respExecutor = GrpcClient.serialized(this.ses);
    }

    @Override
    @Deprecated
    public ListenableFuture<LeaseGrantResponse> create(long leaseId, long ttlSecs) {
        return this.client.call(METHOD_LEASE_GRANT, LeaseGrantRequest.newBuilder().setID(leaseId).setTTL(ttlSecs).build(), false);
    }

    @Override
    public LeaseClient.FluentGrantRequest grant(long ttlSecs) {
        return new EtcdGrantRequest(ttlSecs);
    }

    @Override
    public ListenableFuture<LeaseRevokeResponse> revoke(long leaseId) {
        return this.client.call(METHOD_LEASE_REVOKE, LeaseRevokeRequest.newBuilder().setID(leaseId).build(), false);
    }

    @Override
    public ListenableFuture<LeaseRevokeResponse> revoke(long leaseId, boolean ensureWithRetries) {
        if (!ensureWithRetries) {
            return this.revoke(leaseId);
        }
        return Futures.catching(this.client.call(METHOD_LEASE_REVOKE, null, LeaseRevokeRequest.newBuilder().setID(leaseId).build(), null, (t, r) -> !EtcdLeaseClient.isNotFound(t) && !this.closed, true, null, 0L), StatusRuntimeException.class, sre -> {
            if (sre.getStatus().getCode() != Status.Code.NOT_FOUND) {
                throw sre;
            }
            return LeaseRevokeResponse.getDefaultInstance();
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ListenableFuture<LeaseTimeToLiveResponse> ttl(long leaseId, boolean includeKeys) {
        return this.client.call(METHOD_LEASE_TIME_TO_LIVE, LeaseTimeToLiveRequest.newBuilder().setID(leaseId).setKeys(includeKeys).build(), true);
    }

    @Override
    public ListenableFuture<LeaseKeepAliveResponse> keepAliveOnce(long leaseId) {
        Long lid = leaseId;
        KeepAliveFuture ourFut = new KeepAliveFuture(lid);
        List futs = (List)this.oneTimeMap.get(lid);
        while (true) {
            List<KeepAliveFuture> newFuts;
            if (futs == null) {
                newFuts = Collections.singletonList(ourFut);
                futs = this.oneTimeMap.putIfAbsent(lid, newFuts);
                if (futs != null) continue;
                this.leaseAdded();
                this.sendKeepAlive(leaseId);
                return ourFut;
            }
            newFuts = new ArrayList<KeepAliveFuture>(futs.size() + 1);
            newFuts.addAll(futs);
            newFuts.add(ourFut);
            if (this.oneTimeMap.replace(lid, futs, newFuts)) {
                return ourFut;
            }
            futs = (List)this.oneTimeMap.get(lid);
        }
    }

    @Override
    public ListenableFuture<LeaseLeasesResponse> list() {
        return this.client.call(METHOD_LEASE_LEASES, LeaseLeasesRequest.getDefaultInstance(), true);
    }

    @Override
    public LeaseClient.FluentMaintainRequest maintain() {
        return new LeaseClient.FluentMaintainRequest(){
            private long id;
            private int intervalSecs = 5;
            private int minTtlSecs = 10;
            private boolean permanent;
            private Executor executor;

            @Override
            public LeaseClient.FluentMaintainRequest leaseId(long leaseId) {
                if (leaseId < 0L) {
                    throw new IllegalArgumentException("invalid leaseId " + leaseId);
                }
                this.id = leaseId;
                return this;
            }

            @Override
            public LeaseClient.FluentMaintainRequest keepAliveFreq(int frequencySecs) {
                if (frequencySecs < 4) {
                    throw new IllegalArgumentException("invalid keep-alive freq " + frequencySecs);
                }
                this.intervalSecs = frequencySecs;
                return this;
            }

            @Override
            public LeaseClient.FluentMaintainRequest minTtl(int minTtlSecs) {
                if (minTtlSecs < 2) {
                    throw new IllegalArgumentException("invalid min expiry " + minTtlSecs);
                }
                this.minTtlSecs = minTtlSecs;
                return this;
            }

            @Override
            public LeaseClient.FluentMaintainRequest executor(Executor executor) {
                this.executor = executor;
                return this;
            }

            @Override
            public LeaseClient.FluentMaintainRequest permanent() {
                this.permanent = true;
                return this;
            }

            @Override
            public PersistentLease start(StreamObserver<PersistentLease.LeaseState> observer) {
                return EtcdLeaseClient.this.newPersisentLease(this.id, this.minTtlSecs, this.intervalSecs, observer, this.executor, this.permanent);
            }

            @Override
            public PersistentLease start() {
                return this.start(null);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PersistentLease newPersisentLease(long leaseId, int minExpirySecs, int keepAliveFreqSecs, StreamObserver<PersistentLease.LeaseState> observer, Executor executor, boolean protect) {
        LeaseRecord rec;
        if (this.closed) {
            throw new IllegalStateException("client closed");
        }
        LeaseRecord leaseRecord = rec = !protect ? new LeaseRecord(leaseId, minExpirySecs, keepAliveFreqSecs, observer, executor) : new ProtectedLeaseRecord(leaseId, minExpirySecs, keepAliveFreqSecs, observer, executor);
        if (leaseId != 0L && this.leaseMap.putIfAbsent(leaseId, rec) != null) {
            throw new IllegalStateException("duplicate lease id");
        }
        boolean ok = false;
        try {
            this.leaseAdded();
            this.respExecutor.execute(() -> rec.start(this.streamEstablished));
            ok = true;
        }
        finally {
            if (!ok) {
                this.leaseMap.remove(leaseId, rec);
            }
        }
        return rec;
    }

    private void leaseAdded() {
        this.kaReqExecutor.execute(() -> {
            if (this.leaseCount++ == 0) {
                this.kaReqStream = this.client.callStream(METHOD_LEASE_KEEP_ALIVE, this.responseObserver, this.respExecutor);
            }
        });
    }

    private void leaseRemoved() {
        this.kaReqExecutor.execute(() -> {
            if (--this.leaseCount == 0) {
                this.kaReqStream.onError((Throwable)CANCEL_EXCEPTION);
                this.kaReqStream = null;
            }
        });
    }

    protected void leaseClosed(LeaseRecord rec) {
        this.allLeases.remove(rec);
        if (rec.leaseId != 0L) {
            this.leaseMap.remove(rec.leaseId, rec);
        }
        this.leaseRemoved();
    }

    protected void sendKeepAlive(long leaseId) {
        this.kaReqExecutor.execute(() -> {
            StreamObserver<LeaseKeepAliveRequest> stream = this.kaReqStream;
            if (stream != null) {
                stream.onNext((Object)this.KAR_BUILDER.setID(leaseId).build());
            }
        });
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (LeaseRecord rec : this.allLeases) {
            rec.doClose();
        }
        Iterator it = this.oneTimeMap.values().iterator();
        while (it.hasNext()) {
            for (KeepAliveFuture fut : (List)it.next()) {
                fut.cancel(true);
            }
            it.remove();
            this.leaseRemoved();
        }
    }

    private static boolean isNotFound(Throwable t) {
        return GrpcClient.codeFromThrowable(t) == Status.Code.NOT_FOUND;
    }

    final class ProtectedLeaseRecord
    extends LeaseRecord {
        public ProtectedLeaseRecord(long leaseId, int minExpirySecs, int intervalSecs, StreamObserver<PersistentLease.LeaseState> observer, Executor executor) {
            super(leaseId, minExpirySecs, intervalSecs, observer, executor);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public void close() {
        }

        @Override
        public String toString() {
            return "SessionLease[id=" + this.leaseId + "]";
        }
    }

    class LeaseRecord
    extends AbstractFuture<Long>
    implements PersistentLease {
        final CopyOnWriteArrayList<StreamObserver<PersistentLease.LeaseState>> observers;
        final Executor eventLoop;
        final Executor observerExecutor;
        final int intervalSecs;
        final int minExpirySecs;
        ListenableFuture<LeaseGrantResponse> createFuture;
        boolean connected;
        long leaseId;
        volatile int keepAliveTtlSecs = -1;
        volatile long expiryTimeMs = -1L;
        volatile PersistentLease.LeaseState state = PersistentLease.LeaseState.PENDING;
        ScheduledFuture<?> nextKeepAlive;

        public LeaseRecord(long leaseId, int minExpirySecs, int intervalSecs, StreamObserver<PersistentLease.LeaseState> observer, Executor executor) {
            this.minExpirySecs = minExpirySecs;
            this.intervalSecs = intervalSecs;
            this.leaseId = leaseId;
            this.observers = observer == null ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<StreamObserver<PersistentLease.LeaseState>>(Collections.singletonList(observer));
            this.eventLoop = GrpcClient.serialized(EtcdLeaseClient.this.ses);
            this.observerExecutor = GrpcClient.serialized(executor != null ? executor : EtcdLeaseClient.this.client.getResponseExecutor());
        }

        @Override
        public void addStateObserver(StreamObserver<PersistentLease.LeaseState> observer, boolean publishInit) {
            if (publishInit) {
                this.eventLoop.execute(() -> {
                    PersistentLease.LeaseState stateNow = this.state;
                    this.observers.add(observer);
                    this.observerExecutor.execute(() -> this.callObserverOnNext(observer, stateNow));
                });
            } else {
                this.observers.add(observer);
            }
        }

        @Override
        public void removeStateObserver(StreamObserver<PersistentLease.LeaseState> observer) {
            this.observers.remove(observer);
        }

        private boolean callObserverOnNext(StreamObserver<PersistentLease.LeaseState> observer, PersistentLease.LeaseState state) {
            try {
                observer.onNext((Object)state);
            }
            catch (RuntimeException e) {
                logger.warn("State observer onNext(" + (Object)((Object)state) + ") method threw", (Throwable)e);
                this.observers.remove(observer);
                try {
                    observer.onError((Throwable)e);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return false;
            }
            if (state == PersistentLease.LeaseState.CLOSED) {
                try {
                    observer.onCompleted();
                }
                catch (RuntimeException e) {
                    logger.warn("State observer onComplete method threw", (Throwable)e);
                }
            }
            return true;
        }

        void start(boolean connected) {
            this.connected = connected;
            if (EtcdLeaseClient.this.closed) {
                this.close();
            } else {
                EtcdLeaseClient.this.allLeases.add(this);
                this.create();
            }
        }

        void reconnected() {
            this.eventLoop.execute(() -> {
                if (this.state == PersistentLease.LeaseState.CLOSED) {
                    return;
                }
                this.connected = true;
                if (this.createFuture != null) {
                    return;
                }
                if (this.leaseId == 0L || this.state == PersistentLease.LeaseState.PENDING || this.state == PersistentLease.LeaseState.EXPIRED) {
                    this.create();
                } else {
                    this.sendKeepAliveIfNeeded();
                    this.changeState(PersistentLease.LeaseState.ACTIVE);
                }
            });
        }

        private void processGrantResponse(LeaseGrantResponse lgr) {
            if (this.leaseId == 0L) {
                this.leaseId = lgr.getID();
                EtcdLeaseClient.this.leaseMap.put(this.leaseId, this);
            }
            this.processTtlFromServer(lgr.getTTL());
        }

        void processKeepAliveResponse(LeaseKeepAliveResponse lkar) {
            this.eventLoop.execute(() -> this.processTtlFromServer(lkar.getTTL()));
        }

        private void processTtlFromServer(long newTtl) {
            if (this.state == PersistentLease.LeaseState.CLOSED) {
                return;
            }
            if (newTtl <= 0L) {
                this.expiryTimeMs = 0L;
                this.keepAliveTtlSecs = 0;
                this.changeState(PersistentLease.LeaseState.EXPIRED);
                this.create();
            } else {
                this.updateKeepAlive((int)Math.min(newTtl, Integer.MAX_VALUE));
                this.changeState(PersistentLease.LeaseState.ACTIVE);
            }
        }

        void connectionLost() {
            this.eventLoop.execute(() -> {
                this.connected = false;
                long ttlSecs = this.getCurrentTtlSecs();
                if (ttlSecs > 0L) {
                    this.changeState(PersistentLease.LeaseState.ACTIVE_NO_CONN);
                    EtcdLeaseClient.this.ses.schedule(this::checkExpired, ttlSecs, TimeUnit.SECONDS);
                } else {
                    this.changeState(PersistentLease.LeaseState.EXPIRED);
                }
            });
        }

        void checkExpired() {
            this.eventLoop.execute(() -> {
                if (this.state != PersistentLease.LeaseState.EXPIRED && this.getCurrentTtlSecs() <= 0L) {
                    this.changeState(PersistentLease.LeaseState.EXPIRED);
                }
            });
        }

        private void changeState(PersistentLease.LeaseState targetState) {
            Iterator snapshot;
            PersistentLease.LeaseState stateBefore = this.state;
            if (stateBefore == targetState) {
                return;
            }
            if (stateBefore == PersistentLease.LeaseState.PENDING && targetState != PersistentLease.LeaseState.ACTIVE && targetState != PersistentLease.LeaseState.CLOSED) {
                return;
            }
            if (stateBefore == PersistentLease.LeaseState.CLOSED) {
                return;
            }
            this.state = targetState;
            this.logStateChange(stateBefore, targetState);
            long leaseToSet = stateBefore == PersistentLease.LeaseState.PENDING && targetState == PersistentLease.LeaseState.ACTIVE ? this.leaseId : -1L;
            Iterator<Object> iterator = snapshot = !this.observers.isEmpty() ? this.observers.iterator() : Collections.emptyIterator();
            if (snapshot.hasNext() || leaseToSet != -1L) {
                this.observerExecutor.execute(() -> {
                    if (leaseToSet != -1L) {
                        this.set(leaseToSet);
                    }
                    while (snapshot.hasNext()) {
                        this.callObserverOnNext((StreamObserver<PersistentLease.LeaseState>)((StreamObserver)snapshot.next()), targetState);
                    }
                });
            }
        }

        private void logStateChange(PersistentLease.LeaseState from, PersistentLease.LeaseState to) {
            if (from == PersistentLease.LeaseState.ACTIVE_NO_CONN || from == PersistentLease.LeaseState.EXPIRED || to == PersistentLease.LeaseState.ACTIVE_NO_CONN || to == PersistentLease.LeaseState.EXPIRED) {
                logger.info(this + " state changed from " + (Object)((Object)from) + " to " + (Object)((Object)to));
            } else if (logger.isDebugEnabled()) {
                logger.debug(this + " state changed from " + (Object)((Object)from) + " to " + (Object)((Object)to));
            }
        }

        void create() {
            if (this.createFuture != null || this.state == PersistentLease.LeaseState.CLOSED) {
                return;
            }
            long ttlSecs = this.minExpirySecs + this.intervalSecs;
            this.createFuture = EtcdLeaseClient.this.client.call(METHOD_LEASE_GRANT, () -> this.state != PersistentLease.LeaseState.CLOSED, LeaseGrantRequest.newBuilder().setID(this.leaseId).setTTL(ttlSecs).build(), this.eventLoop, (t, r) -> {
                Status.Code code = GrpcClient.codeFromThrowable(t);
                return this.connected && code != Status.Code.ALREADY_EXISTS && code != Status.Code.FAILED_PRECONDITION;
            }, true, null, 0L);
            Futures.addCallback(this.createFuture, (result, t) -> {
                this.createFuture = null;
                if (this.state == PersistentLease.LeaseState.CLOSED) {
                    if (t == null || !GrpcClient.isConnectException(t)) {
                        this.revoke();
                    }
                } else if (t != null) {
                    Status.Code code = GrpcClient.codeFromThrowable(t);
                    if (code == Status.Code.ALREADY_EXISTS || code == Status.Code.FAILED_PRECONDITION) {
                        this.sendKeepAliveIfNeeded();
                    }
                } else {
                    this.processGrantResponse((LeaseGrantResponse)result);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private void updateKeepAlive(int newTtlSecs) {
            this.keepAliveTtlSecs = newTtlSecs;
            this.expiryTimeMs = System.currentTimeMillis() + 1000L * (long)newTtlSecs;
            if (newTtlSecs <= this.intervalSecs) {
                logger.warn("Keepalive ttl too short to meet target interval of " + this.intervalSecs + " for lease " + this.leaseId);
            }
            if (!this.connected) {
                return;
            }
            int ttNextKaSecs = Math.max(this.intervalSecs, newTtlSecs - this.minExpirySecs);
            if (ttNextKaSecs <= 0) {
                EtcdLeaseClient.this.sendKeepAlive(this.leaseId);
            } else {
                this.nextKeepAlive = EtcdLeaseClient.this.ses.schedule(() -> this.eventLoop.execute(this::sendKeepAliveIfNeeded), (long)ttNextKaSecs, TimeUnit.SECONDS);
            }
        }

        private void sendKeepAliveIfNeeded() {
            if (!this.connected || this.state == PersistentLease.LeaseState.CLOSED || this.leaseId == 0L) {
                return;
            }
            int ttNextKaSecs = (int)this.getCurrentTtlSecs() - this.minExpirySecs;
            if (ttNextKaSecs <= 0) {
                EtcdLeaseClient.this.sendKeepAlive(this.leaseId);
            } else if (this.nextKeepAlive == null || this.nextKeepAlive.getDelay(TimeUnit.NANOSECONDS) <= 0L) {
                this.nextKeepAlive = EtcdLeaseClient.this.ses.schedule(() -> this.eventLoop.execute(this::sendKeepAliveIfNeeded), (long)ttNextKaSecs, TimeUnit.SECONDS);
            }
        }

        protected void interruptTask() {
            this.doClose();
        }

        @Override
        public void close() {
            this.doClose();
        }

        void doClose() {
            if (this.state != PersistentLease.LeaseState.CLOSED) {
                this.eventLoop.execute(() -> {
                    if (this.state == PersistentLease.LeaseState.CLOSED) {
                        return;
                    }
                    this.changeState(PersistentLease.LeaseState.CLOSED);
                    if (this.createFuture == null) {
                        this.revoke();
                    } else {
                        this.createFuture.cancel(false);
                    }
                    EtcdLeaseClient.this.leaseClosed(this);
                    if (!this.isDone()) {
                        this.observerExecutor.execute(() -> this.setException(new IllegalStateException("closed")));
                    }
                });
            }
        }

        private void revoke() {
            ListenableFuture fut = EtcdLeaseClient.this.client.call(METHOD_LEASE_REVOKE, () -> this.leaseId != 0L && this.getCurrentTtlSecs() > 0L, LeaseRevokeRequest.newBuilder().setID(this.leaseId).build(), this.eventLoop, (t, r) -> !EtcdLeaseClient.isNotFound(t) && !EtcdLeaseClient.this.closed, true, null, 5000L);
            Futures.addCallback(fut, (v, t) -> {
                if (t == null || EtcdLeaseClient.isNotFound(t)) {
                    this.expiryTimeMs = 0L;
                    this.keepAliveTtlSecs = 0;
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public String toString() {
            return "PersistentLease[id=" + this.leaseId + "]";
        }

        @Override
        public long getCurrentTtlSecs() {
            long expires = this.expiryTimeMs;
            if (expires <= 0L) {
                return expires;
            }
            return (expires -= System.currentTimeMillis()) < 0L ? 0L : expires / 1000L;
        }

        @Override
        public long getLeaseId() {
            return this.isDone() ? this.leaseId : 0L;
        }

        @Override
        public PersistentLease.LeaseState getState() {
            return this.state;
        }

        @Override
        public long getPreferredTtlSecs() {
            return this.minExpirySecs + this.intervalSecs;
        }

        @Override
        public long getKeepAliveTtlSecs() {
            return this.keepAliveTtlSecs;
        }
    }

    final class KeepAliveFuture
    extends AbstractFuture<LeaseKeepAliveResponse> {
        final long leaseId;

        public KeepAliveFuture(long leaseId) {
            this.leaseId = leaseId;
        }

        protected boolean set(LeaseKeepAliveResponse value) {
            return super.set((Object)value);
        }

        protected void interruptTask() {
            Long lid = this.leaseId;
            while (true) {
                List futs;
                if ((futs = (List)EtcdLeaseClient.this.oneTimeMap.get(lid)) == null || !futs.contains((Object)this)) {
                    return;
                }
                if (futs.size() == 1) {
                    if (!EtcdLeaseClient.this.oneTimeMap.remove(lid, futs)) continue;
                    EtcdLeaseClient.this.leaseRemoved();
                    return;
                }
                if (EtcdLeaseClient.this.oneTimeMap.replace(lid, futs, futs.stream().filter(arg_0 -> this.equals(arg_0)).collect(Collectors.toList()))) break;
            }
        }
    }

    final class EtcdGrantRequest
    extends FluentRequest.AbstractFluentRequest<LeaseClient.FluentGrantRequest, LeaseGrantRequest, LeaseGrantResponse, LeaseGrantRequest.Builder>
    implements LeaseClient.FluentGrantRequest {
        EtcdGrantRequest(long ttl) {
            super(EtcdLeaseClient.this.client, LeaseGrantRequest.newBuilder().setTTL(ttl));
        }

        @Override
        protected MethodDescriptor<LeaseGrantRequest, LeaseGrantResponse> getMethod() {
            return METHOD_LEASE_GRANT;
        }

        @Override
        protected boolean idempotent() {
            return false;
        }

        @Override
        public LeaseClient.FluentGrantRequest leaseId(long leaseId) {
            ((LeaseGrantRequest.Builder)this.builder).setID(leaseId);
            return this;
        }
    }
}

