/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.GeneratedMessageV3;
import com.ibm.etcd.client.Condition;
import com.ibm.etcd.client.GrpcClient;
import com.ibm.etcd.client.kv.KvClient;
import io.grpc.Deadline;
import io.grpc.MethodDescriptor;
import java.util.concurrent.Executor;

public interface FluentRequest<FR extends FluentRequest<FR, ReqT, RespT>, ReqT, RespT> {
    public ListenableFuture<RespT> async();

    public ListenableFuture<RespT> async(Executor var1);

    public RespT sync();

    public FR timeout(long var1);

    public FR deadline(Deadline var1);

    public FR backoffRetry();

    public FR backoffRetry(Condition var1);

    public ReqT asRequest();

    public static abstract class AbstractFluentRequest<FR extends FluentRequest<FR, ReqT, RespT>, ReqT, RespT, BldT extends GeneratedMessageV3.Builder<BldT>>
    implements FluentRequest<FR, ReqT, RespT> {
        protected final GrpcClient client;
        protected final BldT builder;
        protected KvClient.RetryStrategy retryStrategy = KvClient.RetryStrategy.BASIC;
        protected Condition precondition;
        protected long timeoutMs;
        protected Deadline deadline;

        protected AbstractFluentRequest(GrpcClient client, BldT builder) {
            this.client = client;
            this.builder = builder;
        }

        protected abstract MethodDescriptor<ReqT, RespT> getMethod();

        protected abstract boolean idempotent();

        @Override
        public FR timeout(long millisecs) {
            this.timeoutMs = millisecs;
            return (FR)this;
        }

        @Override
        public FR deadline(Deadline deadline) {
            this.deadline = deadline;
            return (FR)this;
        }

        @Override
        public final FR backoffRetry() {
            this.retryStrategy = KvClient.RetryStrategy.BACKOFF;
            return (FR)this;
        }

        @Override
        public final FR backoffRetry(Condition precondition) {
            this.retryStrategy = KvClient.RetryStrategy.BACKOFF;
            this.precondition = precondition;
            return (FR)this;
        }

        @Override
        public final ReqT asRequest() {
            return (ReqT)this.builder.build();
        }

        @Override
        public ListenableFuture<RespT> async(Executor executor) {
            return this.client.call(this.getMethod(), this.precondition, this.builder.build(), executor, GrpcClient.retryDecision(this.idempotent()), this.retryStrategy == KvClient.RetryStrategy.BACKOFF, this.deadline, this.timeoutMs);
        }

        @Override
        public final ListenableFuture<RespT> async() {
            return this.async(null);
        }

        @Override
        public final RespT sync() {
            return (RespT)GrpcClient.waitFor(this::async);
        }
    }
}

