/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client.kv;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import com.ibm.etcd.api.CompactionRequest;
import com.ibm.etcd.api.CompactionResponse;
import com.ibm.etcd.api.Compare;
import com.ibm.etcd.api.DeleteRangeRequest;
import com.ibm.etcd.api.DeleteRangeRequestOrBuilder;
import com.ibm.etcd.api.DeleteRangeResponse;
import com.ibm.etcd.api.KVGrpc;
import com.ibm.etcd.api.PutRequest;
import com.ibm.etcd.api.PutRequestOrBuilder;
import com.ibm.etcd.api.PutResponse;
import com.ibm.etcd.api.RangeRequest;
import com.ibm.etcd.api.RangeRequestOrBuilder;
import com.ibm.etcd.api.RangeResponse;
import com.ibm.etcd.api.RequestOp;
import com.ibm.etcd.api.TxnRequest;
import com.ibm.etcd.api.TxnRequestOrBuilder;
import com.ibm.etcd.api.TxnResponse;
import com.ibm.etcd.api.WatchCreateRequest;
import com.ibm.etcd.client.Condition;
import com.ibm.etcd.client.FluentRequest;
import com.ibm.etcd.client.GrpcClient;
import com.ibm.etcd.client.KeyUtils;
import com.ibm.etcd.client.kv.KvClient;
import com.ibm.etcd.client.kv.WatchUpdate;
import com.ibm.etcd.client.watch.EtcdWatchClient;
import io.grpc.Deadline;
import io.grpc.MethodDescriptor;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.concurrent.Executor;

public final class EtcdKvClient
implements KvClient {
    private static final MethodDescriptor<RangeRequest, RangeResponse> METHOD_RANGE = KVGrpc.getRangeMethod();
    private static final MethodDescriptor<TxnRequest, TxnResponse> METHOD_TXN = KVGrpc.getTxnMethod();
    private static final MethodDescriptor<PutRequest, PutResponse> METHOD_PUT = KVGrpc.getPutMethod();
    private static final MethodDescriptor<DeleteRangeRequest, DeleteRangeResponse> METHOD_DELETE_RANGE = KVGrpc.getDeleteRangeMethod();
    protected final GrpcClient client;
    private static Predicate<TxnRequest> IDEMPOTENT_TXN = txn -> Iterables.all((Iterable)Iterables.concat(txn.getSuccessList(), txn.getFailureList()), op -> op.getRequestCase() == RequestOp.RequestCase.REQUEST_RANGE);
    private volatile EtcdWatchClient watchClient;
    private boolean closed;

    public EtcdKvClient(GrpcClient client) {
        this.client = client;
    }

    @Override
    public ListenableFuture<RangeResponse> get(RangeRequest request) {
        return this.client.call(METHOD_RANGE, request, true);
    }

    @Override
    public KvClient.FluentRangeRequest get(ByteString key) {
        return new EtcdRangeRequest(key);
    }

    @Override
    public ListenableFuture<TxnResponse> txn(TxnRequest txn) {
        return this.client.call(METHOD_TXN, txn, false);
    }

    @Override
    public KvClient.FluentTxnRequest txnIf() {
        return new EtcdTxnRequest();
    }

    @Override
    public KvClient.FluentTxnOps<?> batch() {
        return this.txnIf().then();
    }

    @Override
    public TxnResponse txnSync(TxnRequest txn, long timeoutMillis) {
        return (TxnResponse)this.client.waitForCall(ex -> this.client.call(METHOD_TXN, txn, false, timeoutMillis, (Executor)ex));
    }

    @Override
    public ListenableFuture<PutResponse> put(PutRequest request) {
        return this.client.call(METHOD_PUT, request, false);
    }

    @Override
    public KvClient.FluentPutRequest put(ByteString key, ByteString value) {
        return new EtcdPutRequest(key, value, false);
    }

    @Override
    public KvClient.FluentPutRequest put(ByteString key, ByteString value, long leaseId) {
        return new EtcdPutRequest(key, value, leaseId);
    }

    @Override
    public KvClient.FluentPutRequest setLease(ByteString key, long leaseId) {
        return new EtcdPutRequest(key, leaseId);
    }

    @Override
    public KvClient.FluentPutRequest setValue(ByteString key, ByteString value) {
        return new EtcdPutRequest(key, value, true);
    }

    @Override
    public ListenableFuture<DeleteRangeResponse> delete(DeleteRangeRequest request) {
        return this.client.call(METHOD_DELETE_RANGE, request, false);
    }

    @Override
    public KvClient.FluentDeleteRequest delete(ByteString key) {
        return new EtcdDeleteRequest(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EtcdWatchClient watchClient() {
        EtcdWatchClient wc = this.watchClient;
        if (wc == null) {
            EtcdKvClient etcdKvClient = this;
            synchronized (etcdKvClient) {
                if (this.closed) {
                    throw new IllegalStateException("client closed");
                }
                wc = this.watchClient;
                if (wc == null) {
                    this.watchClient = wc = new EtcdWatchClient(this.client);
                }
            }
        }
        return wc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        EtcdKvClient etcdKvClient = this;
        synchronized (etcdKvClient) {
            if (!this.closed) {
                this.closed = true;
                if (this.watchClient != null) {
                    this.watchClient.close();
                }
            }
        }
    }

    @Override
    public KvClient.Watch watch(WatchCreateRequest request, StreamObserver<WatchUpdate> updates) {
        return this.watchClient().watch(request, updates);
    }

    @Override
    public KvClient.FluentWatchRequest watch(ByteString key) {
        return new EtcdWatchRequest(key);
    }

    @Override
    public ListenableFuture<CompactionResponse> compact(long minRevision, boolean physical) {
        return this.client.call(KVGrpc.getCompactMethod(), CompactionRequest.newBuilder().setRevision(minRevision).setPhysical(physical).build(), true, 600000L, null);
    }

    final class EtcdWatchRequest
    implements KvClient.FluentWatchRequest {
        private final WatchCreateRequest.Builder builder = WatchCreateRequest.newBuilder();
        private Executor executor;

        EtcdWatchRequest(ByteString key) {
            if (key != KvClient.ALL_KEYS) {
                this.builder.setKey(key);
            } else {
                this.builder.setKey(KeyUtils.ZERO_BYTE).setRangeEnd(KeyUtils.ZERO_BYTE);
            }
        }

        @Override
        public KvClient.FluentWatchRequest filters(List<WatchCreateRequest.FilterType> filters) {
            this.builder.addAllFilters(filters);
            return this;
        }

        @Override
        public KvClient.FluentWatchRequest filters(WatchCreateRequest.FilterType ... filters) {
            for (WatchCreateRequest.FilterType ft : filters) {
                this.builder.addFilters(ft);
            }
            return this;
        }

        @Override
        public KvClient.FluentWatchRequest prevKv() {
            this.builder.setPrevKv(true);
            return this;
        }

        @Override
        public KvClient.FluentWatchRequest rangeEnd(ByteString key) {
            this.builder.setRangeEnd(key);
            return this;
        }

        @Override
        public KvClient.FluentWatchRequest asPrefix() {
            this.builder.setRangeEnd(KeyUtils.plusOne(this.builder.getKey()));
            return this;
        }

        @Override
        public KvClient.FluentWatchRequest andHigher() {
            this.builder.setRangeEnd(KeyUtils.ZERO_BYTE);
            return this;
        }

        @Override
        public KvClient.FluentWatchRequest progressNotify() {
            this.builder.setProgressNotify(true);
            return this;
        }

        @Override
        public KvClient.FluentWatchRequest startRevision(long rev) {
            this.builder.setStartRevision(rev);
            return this;
        }

        @Override
        public KvClient.FluentWatchRequest executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public KvClient.Watch start(StreamObserver<WatchUpdate> updateObserver) {
            return EtcdKvClient.this.watchClient().watch(this.builder.build(), updateObserver, this.executor);
        }

        @Override
        public KvClient.WatchIterator start() {
            if (this.executor != null) {
                throw new IllegalArgumentException("executor provided for iterator-based watch");
            }
            return EtcdKvClient.this.watchClient().watch(this.builder.build());
        }
    }

    final class EtcdTxnRequest
    extends FluentRequest.AbstractFluentRequest<KvClient.FluentTxnRequest, TxnRequest, TxnResponse, TxnRequest.Builder>
    implements KvClient.FluentTxnRequest {
        final Compare.Builder cmpBld;
        final KvClient.FluentCmpTarget CMP_TARGET;
        KvClient.FluentTxnSuccOps TXN_OPS;
        boolean idempotent;

        public EtcdTxnRequest() {
            super(EtcdKvClient.this.client, TxnRequest.newBuilder());
            this.cmpBld = Compare.newBuilder();
            this.CMP_TARGET = new EtcdCmpTarget();
            this.TXN_OPS = null;
            this.idempotent = true;
        }

        @Override
        protected MethodDescriptor<TxnRequest, TxnResponse> getMethod() {
            return METHOD_TXN;
        }

        @Override
        protected boolean idempotent() {
            return this.idempotent;
        }

        @Override
        public KvClient.FluentCmpTarget cmpEqual(ByteString key) {
            return this.cmp(key, Compare.CompareResult.EQUAL);
        }

        @Override
        public KvClient.FluentCmpTarget cmpNotEqual(ByteString key) {
            return this.cmp(key, Compare.CompareResult.NOT_EQUAL);
        }

        @Override
        public KvClient.FluentCmpTarget cmpLess(ByteString key) {
            return this.cmp(key, Compare.CompareResult.LESS);
        }

        @Override
        public KvClient.FluentCmpTarget cmpGreater(ByteString key) {
            return this.cmp(key, Compare.CompareResult.GREATER);
        }

        @Override
        public KvClient.FluentTxnRequest exists(ByteString key) {
            return this.cmpNotEqual(key).version(0L);
        }

        @Override
        public KvClient.FluentTxnRequest notExists(ByteString key) {
            return this.cmpEqual(key).version(0L);
        }

        private KvClient.FluentCmpTarget cmp(ByteString key, Compare.CompareResult cr) {
            this.cmpBld.setKey(key).setResult(cr);
            return this.CMP_TARGET;
        }

        @Override
        public KvClient.FluentTxnSuccOps then() {
            return this.TXN_OPS != null ? this.TXN_OPS : (this.TXN_OPS = new EtcdTxnOps());
        }

        final class EtcdTxnOps
        implements KvClient.FluentTxnSuccOps {
            private final RequestOp.Builder opBld = RequestOp.newBuilder();
            private boolean succ = true;

            EtcdTxnOps() {
            }

            private KvClient.FluentTxnSuccOps add(RequestOp.Builder op) {
                if (this.succ) {
                    ((TxnRequest.Builder)EtcdTxnRequest.this.builder).addSuccess(op);
                } else {
                    ((TxnRequest.Builder)EtcdTxnRequest.this.builder).addFailure(op);
                }
                return this;
            }

            @Override
            public KvClient.FluentTxnOps<?> elseDo() {
                this.succ = false;
                return this;
            }

            @Override
            public KvClient.FluentTxnSuccOps put(PutRequestOrBuilder putReq) {
                EtcdTxnRequest.this.idempotent = false;
                return this.add(putReq instanceof PutRequest ? this.opBld.setRequestPut((PutRequest)putReq) : this.opBld.setRequestPut((PutRequest.Builder)putReq));
            }

            @Override
            public KvClient.FluentTxnSuccOps get(RangeRequestOrBuilder getReq) {
                return this.add(getReq instanceof RangeRequest ? this.opBld.setRequestRange((RangeRequest)getReq) : this.opBld.setRequestRange((RangeRequest.Builder)getReq));
            }

            @Override
            public KvClient.FluentTxnSuccOps delete(DeleteRangeRequestOrBuilder delReq) {
                EtcdTxnRequest.this.idempotent = false;
                return this.add(delReq instanceof DeleteRangeRequest ? this.opBld.setRequestDeleteRange((DeleteRangeRequest)delReq) : this.opBld.setRequestDeleteRange((DeleteRangeRequest.Builder)delReq));
            }

            @Override
            public KvClient.FluentTxnSuccOps subTxn(TxnRequestOrBuilder txnReq) {
                EtcdTxnRequest.this.idempotent = false;
                return this.add(txnReq instanceof TxnRequest ? this.opBld.setRequestTxn((TxnRequest)txnReq) : this.opBld.setRequestTxn((TxnRequest.Builder)txnReq));
            }

            @Override
            public KvClient.FluentTxnOps<KvClient.FluentTxnSuccOps> backoffRetry() {
                EtcdTxnRequest.this.backoffRetry();
                return this;
            }

            @Override
            public KvClient.FluentTxnOps<KvClient.FluentTxnSuccOps> backoffRetry(Condition precondition) {
                EtcdTxnRequest.this.backoffRetry(precondition);
                return this;
            }

            @Override
            public KvClient.FluentTxnOps<KvClient.FluentTxnSuccOps> timeout(long millisecs) {
                EtcdTxnRequest.this.timeout(millisecs);
                return this;
            }

            @Override
            public KvClient.FluentTxnOps<KvClient.FluentTxnSuccOps> deadline(Deadline deadline) {
                EtcdTxnRequest.this.deadline(deadline);
                return this;
            }

            @Override
            public ListenableFuture<TxnResponse> async() {
                return EtcdTxnRequest.this.async();
            }

            @Override
            public ListenableFuture<TxnResponse> async(Executor executor) {
                return EtcdTxnRequest.this.async(executor);
            }

            @Override
            public TxnRequest asRequest() {
                return (TxnRequest)EtcdTxnRequest.this.asRequest();
            }

            @Override
            public TxnResponse sync() {
                return (TxnResponse)EtcdTxnRequest.this.sync();
            }
        }

        final class EtcdCmpTarget
        implements KvClient.FluentCmpTarget {
            EtcdCmpTarget() {
            }

            @Override
            public KvClient.FluentCmpTarget allInRange(ByteString rangeEnd) {
                EtcdTxnRequest.this.cmpBld.setRangeEnd(rangeEnd);
                return this;
            }

            @Override
            public KvClient.FluentCmpTarget allWithPrefix() {
                EtcdTxnRequest.this.cmpBld.setRangeEnd(KeyUtils.plusOne(EtcdTxnRequest.this.cmpBld.getKey()));
                return this;
            }

            @Override
            public KvClient.FluentCmpTarget andAllHigher() {
                EtcdTxnRequest.this.cmpBld.setRangeEnd(KeyUtils.ZERO_BYTE);
                return this;
            }

            @Override
            public KvClient.FluentTxnRequest version(long version) {
                EtcdTxnRequest.this.cmpBld.setVersion(version);
                return this.add(Compare.CompareTarget.VERSION);
            }

            @Override
            public KvClient.FluentTxnRequest mod(long rev) {
                EtcdTxnRequest.this.cmpBld.setModRevision(rev);
                return this.add(Compare.CompareTarget.MOD);
            }

            @Override
            public KvClient.FluentTxnRequest create(long rev) {
                EtcdTxnRequest.this.cmpBld.setCreateRevision(rev);
                return this.add(Compare.CompareTarget.CREATE);
            }

            @Override
            public KvClient.FluentTxnRequest value(ByteString value) {
                EtcdTxnRequest.this.cmpBld.setValue(value);
                return this.add(Compare.CompareTarget.VALUE);
            }

            @Override
            public KvClient.FluentTxnRequest lease(long leaseId) {
                EtcdTxnRequest.this.cmpBld.setLease(leaseId);
                return this.add(Compare.CompareTarget.LEASE);
            }

            private KvClient.FluentTxnRequest add(Compare.CompareTarget ct) {
                ((TxnRequest.Builder)EtcdTxnRequest.this.builder).addCompare(EtcdTxnRequest.this.cmpBld.setTarget(ct));
                return EtcdTxnRequest.this;
            }
        }
    }

    final class EtcdPutRequest
    extends FluentRequest.AbstractFluentRequest<KvClient.FluentPutRequest, PutRequest, PutResponse, PutRequest.Builder>
    implements KvClient.FluentPutRequest {
        EtcdPutRequest() {
            super(EtcdKvClient.this.client, PutRequest.newBuilder());
        }

        EtcdPutRequest(ByteString key, ByteString value, boolean ignoreLease) {
            this();
            ((PutRequest.Builder)this.builder).setKey(key).setValue(value).setIgnoreLease(ignoreLease);
        }

        EtcdPutRequest(ByteString key, ByteString value, long leaseId) {
            this();
            ((PutRequest.Builder)this.builder).setKey(key).setValue(value).setLease(leaseId);
        }

        EtcdPutRequest(ByteString key, long lease) {
            this();
            ((PutRequest.Builder)this.builder).setKey(key).setLease(lease).setIgnoreValue(true);
        }

        @Override
        protected MethodDescriptor<PutRequest, PutResponse> getMethod() {
            return METHOD_PUT;
        }

        @Override
        protected boolean idempotent() {
            return false;
        }

        @Override
        public KvClient.FluentPutRequest prevKv() {
            ((PutRequest.Builder)this.builder).setPrevKv(true);
            return this;
        }
    }

    final class EtcdDeleteRequest
    extends FluentRequest.AbstractFluentRequest<KvClient.FluentDeleteRequest, DeleteRangeRequest, DeleteRangeResponse, DeleteRangeRequest.Builder>
    implements KvClient.FluentDeleteRequest {
        EtcdDeleteRequest(ByteString key) {
            super(EtcdKvClient.this.client, DeleteRangeRequest.newBuilder());
            if (key != KvClient.ALL_KEYS) {
                ((DeleteRangeRequest.Builder)this.builder).setKey(key);
            } else {
                ((DeleteRangeRequest.Builder)this.builder).setKey(KeyUtils.ZERO_BYTE).setRangeEnd(KeyUtils.ZERO_BYTE);
            }
        }

        @Override
        protected MethodDescriptor<DeleteRangeRequest, DeleteRangeResponse> getMethod() {
            return METHOD_DELETE_RANGE;
        }

        @Override
        protected boolean idempotent() {
            return false;
        }

        @Override
        public KvClient.FluentDeleteRequest rangeEnd(ByteString key) {
            ((DeleteRangeRequest.Builder)this.builder).setRangeEnd(key);
            return this;
        }

        @Override
        public KvClient.FluentDeleteRequest asPrefix() {
            ((DeleteRangeRequest.Builder)this.builder).setRangeEnd(KeyUtils.plusOne(((DeleteRangeRequest.Builder)this.builder).getKey()));
            return this;
        }

        @Override
        public KvClient.FluentDeleteRequest andHigher() {
            ((DeleteRangeRequest.Builder)this.builder).setRangeEnd(KeyUtils.ZERO_BYTE);
            return this;
        }

        @Override
        public KvClient.FluentDeleteRequest prevKv() {
            ((DeleteRangeRequest.Builder)this.builder).setPrevKv(true);
            return this;
        }
    }

    final class EtcdRangeRequest
    extends FluentRequest.AbstractFluentRequest<KvClient.FluentRangeRequest, RangeRequest, RangeResponse, RangeRequest.Builder>
    implements KvClient.FluentRangeRequest {
        EtcdRangeRequest(ByteString key) {
            super(EtcdKvClient.this.client, RangeRequest.newBuilder());
            if (key != KvClient.ALL_KEYS) {
                ((RangeRequest.Builder)this.builder).setKey(key);
            } else {
                ((RangeRequest.Builder)this.builder).setKey(KeyUtils.ZERO_BYTE).setRangeEnd(KeyUtils.ZERO_BYTE);
            }
        }

        @Override
        protected MethodDescriptor<RangeRequest, RangeResponse> getMethod() {
            return METHOD_RANGE;
        }

        @Override
        protected boolean idempotent() {
            return true;
        }

        @Override
        public KvClient.FluentRangeRequest rangeEnd(ByteString key) {
            ((RangeRequest.Builder)this.builder).setRangeEnd(key);
            return this;
        }

        @Override
        public KvClient.FluentRangeRequest asPrefix() {
            ((RangeRequest.Builder)this.builder).setRangeEnd(KeyUtils.plusOne(((RangeRequest.Builder)this.builder).getKey()));
            return this;
        }

        @Override
        public KvClient.FluentRangeRequest andHigher() {
            ((RangeRequest.Builder)this.builder).setRangeEnd(KeyUtils.ZERO_BYTE);
            return this;
        }

        @Override
        public KvClient.FluentRangeRequest limit(long limit) {
            ((RangeRequest.Builder)this.builder).setLimit(limit);
            return this;
        }

        @Override
        public KvClient.FluentRangeRequest revision(long rev) {
            ((RangeRequest.Builder)this.builder).setRevision(rev);
            return this;
        }

        @Override
        public KvClient.FluentRangeRequest sorted(RangeRequest.SortTarget target, RangeRequest.SortOrder order) {
            ((RangeRequest.Builder)this.builder).setSortTarget(target).setSortOrder(order);
            return this;
        }

        @Override
        public KvClient.FluentRangeRequest serializable(boolean serializable) {
            ((RangeRequest.Builder)this.builder).setSerializable(serializable);
            return this;
        }

        @Override
        public KvClient.FluentRangeRequest serializable() {
            ((RangeRequest.Builder)this.builder).setSerializable(true);
            return this;
        }

        @Override
        public KvClient.FluentRangeRequest keysOnly() {
            ((RangeRequest.Builder)this.builder).setKeysOnly(true);
            return this;
        }

        @Override
        public KvClient.FluentRangeRequest countOnly() {
            ((RangeRequest.Builder)this.builder).setCountOnly(true);
            return this;
        }

        @Override
        public KvClient.FluentRangeRequest minModRevision(long rev) {
            ((RangeRequest.Builder)this.builder).setMinModRevision(rev);
            return this;
        }

        @Override
        public KvClient.FluentRangeRequest maxModRevision(long rev) {
            ((RangeRequest.Builder)this.builder).setMaxModRevision(rev);
            return this;
        }

        @Override
        public KvClient.FluentRangeRequest minCreateRevision(long rev) {
            ((RangeRequest.Builder)this.builder).setMinCreateRevision(rev);
            return this;
        }

        @Override
        public KvClient.FluentRangeRequest maxCreateRevision(long rev) {
            ((RangeRequest.Builder)this.builder).setMaxCreateRevision(rev);
            return this;
        }
    }
}

