/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.protobuf.ByteString;
import com.ibm.etcd.client.EtcdClient;
import com.ibm.etcd.client.KeyUtils;
import com.ibm.etcd.client.config.ComposeTrustManagerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdClusterConfig {
    private static final Logger logger = LoggerFactory.getLogger(EtcdClusterConfig.class);
    public static final int DEFAULT_MAX_MSG_SIZE = 0x10000000;
    protected final int maxMessageSize = Integer.getInteger("etcd-java.maxMessageSize", 0x10000000);
    Set<String> endpoints;
    TlsMode tlsMode;
    ByteString user;
    ByteString password;
    ByteString rootPrefix;
    @Deprecated
    String composeDeployment;
    ByteSource certificate;
    String overrideAuthority;
    ByteSource clientKey;
    ByteSource clientCertificate;
    protected static final String ADDR_STR = "(?:https?://)?(?:[a-zA-Z0-9\\-.]+)(?::\\d+)?";
    protected static final Pattern SIMPLE_PATT = Pattern.compile(String.format("((?:%s)(?:,%s)*)(?:;rootPrefix=(.+))?", "(?:https?://)?(?:[a-zA-Z0-9\\-.]+)(?::\\d+)?", "(?:https?://)?(?:[a-zA-Z0-9\\-.]+)(?::\\d+)?"));
    private static final Cache<CacheKey, EtcdClient> clientCache = CacheBuilder.newBuilder().weakValues().removalListener(rn -> EtcdClient.Internal.cleanup((EtcdClient)rn.getValue())).build();
    private static volatile boolean isShutdown = false;
    private static final Gson gson = new Gson();

    protected EtcdClusterConfig() {
    }

    public ByteString getRootPrefix() {
        return this.rootPrefix;
    }

    public Set<String> getEndpoints() {
        return this.endpoints;
    }

    public EtcdClient getClient() throws IOException, CertificateException {
        return EtcdClusterConfig.getClient(this);
    }

    private EtcdClient newClient() throws IOException, CertificateException {
        TlsMode ssl;
        ArrayList<String> endpointList = new ArrayList<String>(this.endpoints);
        EtcdClient.Builder builder = EtcdClient.forEndpoints(endpointList).withCredentials(this.user, this.password).withImmediateAuth().withMaxInboundMessageSize(this.maxMessageSize);
        EtcdClient.Internal.makeRefCounted(builder);
        if (this.overrideAuthority != null) {
            builder.overrideAuthority(this.overrideAuthority);
        }
        if ((ssl = this.tlsMode) == TlsMode.AUTO || ssl == null) {
            String ep = (String)endpointList.get(0);
            TlsMode tlsMode = ssl = ep.startsWith("https://") || !ep.startsWith("http://") && (this.certificate != null || this.clientCertificate != null) ? TlsMode.TLS : TlsMode.PLAINTEXT;
        }
        if (ssl == TlsMode.PLAINTEXT) {
            builder.withPlainText();
        } else {
            if (this.composeDeployment != null) {
                builder.withTrustManager((TrustManagerFactory)((Object)new ComposeTrustManagerFactory(this.composeDeployment, this.composeDeployment, this.certificate)));
            } else if (this.certificate != null) {
                builder.withCaCert(this.certificate);
            }
            if (this.clientCertificate != null && this.clientKey != null) {
                try (InputStream keyStream = this.clientKey.openStream();
                     InputStream certStream = this.clientCertificate.openStream();){
                    builder.withTlsConfig(b -> b.keyManager(certStream, keyStream));
                }
            }
        }
        if (isShutdown) {
            throw new IllegalStateException("shutdown");
        }
        return builder.build();
    }

    public static EtcdClusterConfig newSimpleConfig(String endpoints, String rootPrefix) {
        EtcdClusterConfig config = new EtcdClusterConfig();
        config.endpoints = Sets.newHashSet((Object[])endpoints.split(","));
        config.rootPrefix = KeyUtils.bs(rootPrefix);
        return config;
    }

    public static EtcdClusterConfig fromProperties(ByteSource source) throws IOException {
        Properties props = new Properties();
        try (InputStream in = source.openStream();){
            props.load(in);
        }
        String epString = props.getProperty("endpoints");
        if (epString == null) {
            throw new IOException("etcd config must contain endpoints property");
        }
        EtcdClusterConfig config = new EtcdClusterConfig();
        config.endpoints = Sets.newHashSet((Object[])epString.split(","));
        config.user = KeyUtils.bs(props.getProperty("username"));
        config.password = KeyUtils.bs(props.getProperty("password"));
        config.composeDeployment = props.getProperty("compose_deployment");
        config.rootPrefix = KeyUtils.bs(props.getProperty("root_prefix"));
        String tlsMode = props.getProperty("tls_mode");
        if (tlsMode != null) {
            try {
                config.tlsMode = TlsMode.valueOf(tlsMode);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException("Invalid value " + tlsMode + " for etcd tls_mode config property");
            }
        }
        config.clientKey = EtcdClusterConfig.certFromProperties("client_key", props);
        config.clientCertificate = EtcdClusterConfig.certFromProperties("client_certificate", props);
        config.certificate = EtcdClusterConfig.certFromProperties("certificate_file", props);
        config.overrideAuthority = props.getProperty("override_authority");
        return EtcdClusterConfig.validateConfig(config);
    }

    private static ByteSource certFromProperties(String certFilePropName, Properties props) throws IOException {
        String certPath = props.getProperty(certFilePropName);
        if (certPath == null) {
            return null;
        }
        File certFile = new File(certPath);
        if (certFile.exists()) {
            return Files.asByteSource((File)certFile);
        }
        throw new IOException("cant find certificate file: " + certPath);
    }

    public static EtcdClusterConfig fromJson(ByteSource source, File dir) throws IOException {
        JsonConfig jsonConfig;
        try (InputStream in = source.openStream();){
            jsonConfig = EtcdClusterConfig.deserializeJson(in);
        }
        if (jsonConfig.endpoints == null || jsonConfig.endpoints.trim().isEmpty()) {
            throw new IOException("etcd config must contain endpoints property");
        }
        EtcdClusterConfig config = new EtcdClusterConfig();
        config.endpoints = Sets.newHashSet((Object[])jsonConfig.endpoints.split(","));
        config.user = KeyUtils.bs(jsonConfig.user);
        config.password = KeyUtils.bs(jsonConfig.password);
        config.composeDeployment = jsonConfig.composeDeployment;
        config.rootPrefix = KeyUtils.bs(jsonConfig.rootPrefix);
        if (jsonConfig.tlsMode != null) {
            try {
                config.tlsMode = TlsMode.valueOf(jsonConfig.tlsMode);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException("Invalid value " + jsonConfig.tlsMode + " for etcd tls_mode config field");
            }
        }
        config.clientKey = EtcdClusterConfig.certFromJson(jsonConfig.clientKeyFile, jsonConfig.clientKey, dir);
        config.clientCertificate = EtcdClusterConfig.certFromJson(jsonConfig.clientCertificateFile, jsonConfig.clientCertificate, dir);
        config.certificate = EtcdClusterConfig.certFromJson(jsonConfig.certificateFile, jsonConfig.certificate, dir);
        config.overrideAuthority = jsonConfig.overrideAuthority;
        return EtcdClusterConfig.validateConfig(config);
    }

    private static ByteSource certFromJson(String certFileName, String literalCert, File dir) throws IOException {
        if (certFileName != null) {
            File certFile = new File(certFileName);
            if (dir != null && !certFile.exists()) {
                certFile = new File(dir, certFileName);
            }
            if (certFile.exists()) {
                if (literalCert != null) {
                    logger.warn("Ignoring json-embedded cert because file " + certFileName + " was also provided");
                }
                return Files.asByteSource((File)certFile);
            }
            if (literalCert != null) {
                logger.warn("Can't find certificate file: " + certFileName);
            } else {
                throw new IOException("Can't find certificate file: " + certFileName);
            }
        }
        return literalCert != null ? ByteSource.wrap((byte[])literalCert.getBytes(StandardCharsets.UTF_8)) : null;
    }

    private static EtcdClusterConfig validateConfig(EtcdClusterConfig config) throws IOException {
        if (config.composeDeployment != null) {
            logger.warn("compose_deployment config param is deprecated, use override_authority to set a specific name for TLS SNI");
        }
        if (config.clientKey == null != (config.clientCertificate == null)) {
            throw new IOException("Must specify either both or neither of TLS client_key and client_certificate attributes");
        }
        return config;
    }

    public static EtcdClusterConfig fromJson(ByteSource source) throws IOException {
        return EtcdClusterConfig.fromJson(source, null);
    }

    public static EtcdClusterConfig fromJsonFile(String file) throws IOException {
        File f = new File(file);
        return EtcdClusterConfig.fromJson(Files.asByteSource((File)f), f.getParentFile());
    }

    public static EtcdClusterConfig fromJsonFileOrSimple(String fileOrSimpleString) throws IOException {
        File f = new File(fileOrSimpleString);
        if (f.exists()) {
            return EtcdClusterConfig.fromJson(Files.asByteSource((File)f), f.getParentFile());
        }
        Matcher m = SIMPLE_PATT.matcher(fileOrSimpleString);
        if (m.matches()) {
            return EtcdClusterConfig.newSimpleConfig(m.group(1), m.group(2));
        }
        throw new FileNotFoundException("etcd config json file not found: " + f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EtcdClient getClient(EtcdClusterConfig config) throws IOException, CertificateException {
        try {
            CacheKey key = new CacheKey(config);
            while (true) {
                EtcdClient client;
                if ((client = (EtcdClient)clientCache.getIfPresent((Object)key)) == null) {
                    ArrayDeque maybeNew = new ArrayDeque(1);
                    try {
                        client = (EtcdClient)clientCache.get((Object)key, () -> {
                            EtcdClient newClient = config.newClient();
                            maybeNew.add(newClient);
                            return newClient;
                        });
                        if (client == maybeNew.peekLast()) {
                            EtcdClient etcdClient = (EtcdClient)maybeNew.pollLast();
                            return etcdClient;
                        }
                    }
                    finally {
                        maybeNew.stream().forEach(EtcdClient::close);
                    }
                }
                if (EtcdClient.Internal.retain(client)) {
                    return client;
                }
                clientCache.invalidate((Object)key);
            }
        }
        catch (ExecutionException ee) {
            Throwables.throwIfInstanceOf((Throwable)ee.getCause(), IOException.class);
            Throwables.throwIfInstanceOf((Throwable)ee.getCause(), CertificateException.class);
            Throwables.throwIfUnchecked((Throwable)ee.getCause());
            throw new RuntimeException(ee.getCause());
        }
    }

    public static void shutdownAll() {
        isShutdown = true;
        clientCache.invalidateAll();
    }

    private static JsonConfig deserializeJson(InputStream in) {
        return (JsonConfig)gson.fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), JsonConfig.class);
    }

    static class JsonConfig {
        @SerializedName(value="endpoints")
        String endpoints;
        @SerializedName(value="userid")
        String user;
        @SerializedName(value="password")
        String password;
        @SerializedName(value="root_prefix")
        String rootPrefix;
        @Deprecated
        @SerializedName(value="compose_deployment")
        String composeDeployment;
        @SerializedName(value="tls_mode")
        String tlsMode;
        @SerializedName(value="certificate")
        String certificate;
        @SerializedName(value="certificate_file")
        String certificateFile;
        @SerializedName(value="override_authority")
        String overrideAuthority;
        @SerializedName(value="client_key")
        String clientKey;
        @SerializedName(value="client_key_file")
        String clientKeyFile;
        @SerializedName(value="client_certificate")
        String clientCertificate;
        @SerializedName(value="client_certificate_file")
        String clientCertificateFile;

        JsonConfig() {
        }
    }

    static class CacheKey {
        private final EtcdClusterConfig config;

        CacheKey(EtcdClusterConfig config) {
            this.config = (EtcdClusterConfig)Preconditions.checkNotNull((Object)config);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            EtcdClusterConfig other = ((CacheKey)obj).config;
            return Objects.equals(this.config.endpoints, other.endpoints) && Objects.equals(this.config.composeDeployment, other.composeDeployment) && Objects.equals(this.config.user, other.user) && Objects.equals((Object)this.config.tlsMode, (Object)other.tlsMode) && this.config.certificate == null == (other.certificate == null) && this.config.clientKey == null == (other.clientKey == null) && this.config.clientCertificate == null == (other.clientCertificate == null);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.config.endpoints, this.config.user, this.config.composeDeployment, this.config.tlsMode, this.config.certificate == null, this.config.clientKey == null, this.config.clientCertificate == null});
        }
    }

    public static enum TlsMode {
        TLS,
        PLAINTEXT,
        AUTO;

    }
}

