/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client.watch;

import com.ibm.etcd.api.Event;
import com.ibm.etcd.api.ResponseHeader;
import com.ibm.etcd.client.kv.KvClient;
import com.ibm.etcd.client.kv.WatchUpdate;
import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

final class EtcdWatchIterator
implements KvClient.WatchIterator,
StreamObserver<WatchUpdate> {
    final BlockingQueue<WatchUpdate> updateQueue = new LinkedBlockingQueue<WatchUpdate>();
    KvClient.Watch watch;
    CompletedUpdate complete;

    EtcdWatchIterator() {
    }

    EtcdWatchIterator setWatch(KvClient.Watch watch) {
        this.watch = watch;
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.complete == null) {
            WatchUpdate wu = (WatchUpdate)this.updateQueue.peek();
            if (!(wu instanceof CompletedUpdate) || ((CompletedUpdate)wu).error != null) {
                return true;
            }
            this.updateQueue.remove();
            this.complete = (CompletedUpdate)wu;
        }
        return false;
    }

    @Override
    public WatchUpdate next() {
        if (this.complete == null) {
            try {
                WatchUpdate wu = this.updateQueue.take();
                if (!(wu instanceof CompletedUpdate)) {
                    return wu;
                }
                this.complete = (CompletedUpdate)wu;
                if (this.complete.error == null) {
                    return this.complete;
                }
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        throw this.complete.error != null ? this.complete.error : new NoSuchElementException();
    }

    @Override
    public void close() {
        if (this.watch == null) {
            throw new IllegalStateException();
        }
        this.watch.close();
    }

    public void onNext(WatchUpdate value) {
        this.updateQueue.add(value);
    }

    public void onError(Throwable t) {
        RuntimeException err = t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
        this.updateQueue.add(new CompletedUpdate(err));
    }

    public void onCompleted() {
        this.updateQueue.add(new CompletedUpdate(null));
    }

    static class CompletedUpdate
    implements WatchUpdate {
        final RuntimeException error;

        @Override
        public ResponseHeader getHeader() {
            return null;
        }

        @Override
        public List<Event> getEvents() {
            return Collections.emptyList();
        }

        public String toString() {
            return "watch complete";
        }

        CompletedUpdate(RuntimeException error) {
            this.error = error;
        }
    }
}

