package com.ibm.etcd.api;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.11.0)",
    comments = "Source: rpc.proto")
public final class KVGrpc {

  private KVGrpc() {}

  public static final String SERVICE_NAME = "etcdserverpb.KV";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getRangeMethod()} instead. 
  public static final io.grpc.MethodDescriptor<com.ibm.etcd.api.RangeRequest,
      com.ibm.etcd.api.RangeResponse> METHOD_RANGE = getRangeMethodHelper();

  private static volatile io.grpc.MethodDescriptor<com.ibm.etcd.api.RangeRequest,
      com.ibm.etcd.api.RangeResponse> getRangeMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<com.ibm.etcd.api.RangeRequest,
      com.ibm.etcd.api.RangeResponse> getRangeMethod() {
    return getRangeMethodHelper();
  }

  private static io.grpc.MethodDescriptor<com.ibm.etcd.api.RangeRequest,
      com.ibm.etcd.api.RangeResponse> getRangeMethodHelper() {
    io.grpc.MethodDescriptor<com.ibm.etcd.api.RangeRequest, com.ibm.etcd.api.RangeResponse> getRangeMethod;
    if ((getRangeMethod = KVGrpc.getRangeMethod) == null) {
      synchronized (KVGrpc.class) {
        if ((getRangeMethod = KVGrpc.getRangeMethod) == null) {
          KVGrpc.getRangeMethod = getRangeMethod = 
              io.grpc.MethodDescriptor.<com.ibm.etcd.api.RangeRequest, com.ibm.etcd.api.RangeResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.KV", "Range"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.RangeRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.RangeResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new KVMethodDescriptorSupplier("Range"))
                  .build();
          }
        }
     }
     return getRangeMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getPutMethod()} instead. 
  public static final io.grpc.MethodDescriptor<com.ibm.etcd.api.PutRequest,
      com.ibm.etcd.api.PutResponse> METHOD_PUT = getPutMethodHelper();

  private static volatile io.grpc.MethodDescriptor<com.ibm.etcd.api.PutRequest,
      com.ibm.etcd.api.PutResponse> getPutMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<com.ibm.etcd.api.PutRequest,
      com.ibm.etcd.api.PutResponse> getPutMethod() {
    return getPutMethodHelper();
  }

  private static io.grpc.MethodDescriptor<com.ibm.etcd.api.PutRequest,
      com.ibm.etcd.api.PutResponse> getPutMethodHelper() {
    io.grpc.MethodDescriptor<com.ibm.etcd.api.PutRequest, com.ibm.etcd.api.PutResponse> getPutMethod;
    if ((getPutMethod = KVGrpc.getPutMethod) == null) {
      synchronized (KVGrpc.class) {
        if ((getPutMethod = KVGrpc.getPutMethod) == null) {
          KVGrpc.getPutMethod = getPutMethod = 
              io.grpc.MethodDescriptor.<com.ibm.etcd.api.PutRequest, com.ibm.etcd.api.PutResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.KV", "Put"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.PutRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.PutResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new KVMethodDescriptorSupplier("Put"))
                  .build();
          }
        }
     }
     return getPutMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getDeleteRangeMethod()} instead. 
  public static final io.grpc.MethodDescriptor<com.ibm.etcd.api.DeleteRangeRequest,
      com.ibm.etcd.api.DeleteRangeResponse> METHOD_DELETE_RANGE = getDeleteRangeMethodHelper();

  private static volatile io.grpc.MethodDescriptor<com.ibm.etcd.api.DeleteRangeRequest,
      com.ibm.etcd.api.DeleteRangeResponse> getDeleteRangeMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<com.ibm.etcd.api.DeleteRangeRequest,
      com.ibm.etcd.api.DeleteRangeResponse> getDeleteRangeMethod() {
    return getDeleteRangeMethodHelper();
  }

  private static io.grpc.MethodDescriptor<com.ibm.etcd.api.DeleteRangeRequest,
      com.ibm.etcd.api.DeleteRangeResponse> getDeleteRangeMethodHelper() {
    io.grpc.MethodDescriptor<com.ibm.etcd.api.DeleteRangeRequest, com.ibm.etcd.api.DeleteRangeResponse> getDeleteRangeMethod;
    if ((getDeleteRangeMethod = KVGrpc.getDeleteRangeMethod) == null) {
      synchronized (KVGrpc.class) {
        if ((getDeleteRangeMethod = KVGrpc.getDeleteRangeMethod) == null) {
          KVGrpc.getDeleteRangeMethod = getDeleteRangeMethod = 
              io.grpc.MethodDescriptor.<com.ibm.etcd.api.DeleteRangeRequest, com.ibm.etcd.api.DeleteRangeResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.KV", "DeleteRange"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.DeleteRangeRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.DeleteRangeResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new KVMethodDescriptorSupplier("DeleteRange"))
                  .build();
          }
        }
     }
     return getDeleteRangeMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getTxnMethod()} instead. 
  public static final io.grpc.MethodDescriptor<com.ibm.etcd.api.TxnRequest,
      com.ibm.etcd.api.TxnResponse> METHOD_TXN = getTxnMethodHelper();

  private static volatile io.grpc.MethodDescriptor<com.ibm.etcd.api.TxnRequest,
      com.ibm.etcd.api.TxnResponse> getTxnMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<com.ibm.etcd.api.TxnRequest,
      com.ibm.etcd.api.TxnResponse> getTxnMethod() {
    return getTxnMethodHelper();
  }

  private static io.grpc.MethodDescriptor<com.ibm.etcd.api.TxnRequest,
      com.ibm.etcd.api.TxnResponse> getTxnMethodHelper() {
    io.grpc.MethodDescriptor<com.ibm.etcd.api.TxnRequest, com.ibm.etcd.api.TxnResponse> getTxnMethod;
    if ((getTxnMethod = KVGrpc.getTxnMethod) == null) {
      synchronized (KVGrpc.class) {
        if ((getTxnMethod = KVGrpc.getTxnMethod) == null) {
          KVGrpc.getTxnMethod = getTxnMethod = 
              io.grpc.MethodDescriptor.<com.ibm.etcd.api.TxnRequest, com.ibm.etcd.api.TxnResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.KV", "Txn"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.TxnRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.TxnResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new KVMethodDescriptorSupplier("Txn"))
                  .build();
          }
        }
     }
     return getTxnMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getCompactMethod()} instead. 
  public static final io.grpc.MethodDescriptor<com.ibm.etcd.api.CompactionRequest,
      com.ibm.etcd.api.CompactionResponse> METHOD_COMPACT = getCompactMethodHelper();

  private static volatile io.grpc.MethodDescriptor<com.ibm.etcd.api.CompactionRequest,
      com.ibm.etcd.api.CompactionResponse> getCompactMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<com.ibm.etcd.api.CompactionRequest,
      com.ibm.etcd.api.CompactionResponse> getCompactMethod() {
    return getCompactMethodHelper();
  }

  private static io.grpc.MethodDescriptor<com.ibm.etcd.api.CompactionRequest,
      com.ibm.etcd.api.CompactionResponse> getCompactMethodHelper() {
    io.grpc.MethodDescriptor<com.ibm.etcd.api.CompactionRequest, com.ibm.etcd.api.CompactionResponse> getCompactMethod;
    if ((getCompactMethod = KVGrpc.getCompactMethod) == null) {
      synchronized (KVGrpc.class) {
        if ((getCompactMethod = KVGrpc.getCompactMethod) == null) {
          KVGrpc.getCompactMethod = getCompactMethod = 
              io.grpc.MethodDescriptor.<com.ibm.etcd.api.CompactionRequest, com.ibm.etcd.api.CompactionResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.KV", "Compact"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.CompactionRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.CompactionResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new KVMethodDescriptorSupplier("Compact"))
                  .build();
          }
        }
     }
     return getCompactMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static KVStub newStub(io.grpc.Channel channel) {
    return new KVStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static KVBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new KVBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static KVFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new KVFutureStub(channel);
  }

  /**
   */
  public static abstract class KVImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Range gets the keys in the range from the key-value store.
     * </pre>
     */
    public void range(com.ibm.etcd.api.RangeRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.RangeResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getRangeMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * Put puts the given key into the key-value store.
     * A put request increments the revision of the key-value store
     * and generates one event in the event history.
     * </pre>
     */
    public void put(com.ibm.etcd.api.PutRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.PutResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getPutMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * DeleteRange deletes the given range from the key-value store.
     * A delete request increments the revision of the key-value store
     * and generates a delete event in the event history for every deleted key.
     * </pre>
     */
    public void deleteRange(com.ibm.etcd.api.DeleteRangeRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.DeleteRangeResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getDeleteRangeMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * Txn processes multiple requests in a single transaction.
     * A txn request increments the revision of the key-value store
     * and generates events with the same revision for every completed request.
     * It is not allowed to modify the same key several times within one txn.
     * </pre>
     */
    public void txn(com.ibm.etcd.api.TxnRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.TxnResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getTxnMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * Compact compacts the event history in the etcd key-value store. The key-value
     * store should be periodically compacted or the event history will continue to grow
     * indefinitely.
     * </pre>
     */
    public void compact(com.ibm.etcd.api.CompactionRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.CompactionResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getCompactMethodHelper(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getRangeMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                com.ibm.etcd.api.RangeRequest,
                com.ibm.etcd.api.RangeResponse>(
                  this, METHODID_RANGE)))
          .addMethod(
            getPutMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                com.ibm.etcd.api.PutRequest,
                com.ibm.etcd.api.PutResponse>(
                  this, METHODID_PUT)))
          .addMethod(
            getDeleteRangeMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                com.ibm.etcd.api.DeleteRangeRequest,
                com.ibm.etcd.api.DeleteRangeResponse>(
                  this, METHODID_DELETE_RANGE)))
          .addMethod(
            getTxnMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                com.ibm.etcd.api.TxnRequest,
                com.ibm.etcd.api.TxnResponse>(
                  this, METHODID_TXN)))
          .addMethod(
            getCompactMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                com.ibm.etcd.api.CompactionRequest,
                com.ibm.etcd.api.CompactionResponse>(
                  this, METHODID_COMPACT)))
          .build();
    }
  }

  /**
   */
  public static final class KVStub extends io.grpc.stub.AbstractStub<KVStub> {
    private KVStub(io.grpc.Channel channel) {
      super(channel);
    }

    private KVStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected KVStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new KVStub(channel, callOptions);
    }

    /**
     * <pre>
     * Range gets the keys in the range from the key-value store.
     * </pre>
     */
    public void range(com.ibm.etcd.api.RangeRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.RangeResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRangeMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Put puts the given key into the key-value store.
     * A put request increments the revision of the key-value store
     * and generates one event in the event history.
     * </pre>
     */
    public void put(com.ibm.etcd.api.PutRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.PutResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getPutMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * DeleteRange deletes the given range from the key-value store.
     * A delete request increments the revision of the key-value store
     * and generates a delete event in the event history for every deleted key.
     * </pre>
     */
    public void deleteRange(com.ibm.etcd.api.DeleteRangeRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.DeleteRangeResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDeleteRangeMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Txn processes multiple requests in a single transaction.
     * A txn request increments the revision of the key-value store
     * and generates events with the same revision for every completed request.
     * It is not allowed to modify the same key several times within one txn.
     * </pre>
     */
    public void txn(com.ibm.etcd.api.TxnRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.TxnResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getTxnMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Compact compacts the event history in the etcd key-value store. The key-value
     * store should be periodically compacted or the event history will continue to grow
     * indefinitely.
     * </pre>
     */
    public void compact(com.ibm.etcd.api.CompactionRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.CompactionResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCompactMethodHelper(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class KVBlockingStub extends io.grpc.stub.AbstractStub<KVBlockingStub> {
    private KVBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private KVBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected KVBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new KVBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Range gets the keys in the range from the key-value store.
     * </pre>
     */
    public com.ibm.etcd.api.RangeResponse range(com.ibm.etcd.api.RangeRequest request) {
      return blockingUnaryCall(
          getChannel(), getRangeMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Put puts the given key into the key-value store.
     * A put request increments the revision of the key-value store
     * and generates one event in the event history.
     * </pre>
     */
    public com.ibm.etcd.api.PutResponse put(com.ibm.etcd.api.PutRequest request) {
      return blockingUnaryCall(
          getChannel(), getPutMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * DeleteRange deletes the given range from the key-value store.
     * A delete request increments the revision of the key-value store
     * and generates a delete event in the event history for every deleted key.
     * </pre>
     */
    public com.ibm.etcd.api.DeleteRangeResponse deleteRange(com.ibm.etcd.api.DeleteRangeRequest request) {
      return blockingUnaryCall(
          getChannel(), getDeleteRangeMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Txn processes multiple requests in a single transaction.
     * A txn request increments the revision of the key-value store
     * and generates events with the same revision for every completed request.
     * It is not allowed to modify the same key several times within one txn.
     * </pre>
     */
    public com.ibm.etcd.api.TxnResponse txn(com.ibm.etcd.api.TxnRequest request) {
      return blockingUnaryCall(
          getChannel(), getTxnMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Compact compacts the event history in the etcd key-value store. The key-value
     * store should be periodically compacted or the event history will continue to grow
     * indefinitely.
     * </pre>
     */
    public com.ibm.etcd.api.CompactionResponse compact(com.ibm.etcd.api.CompactionRequest request) {
      return blockingUnaryCall(
          getChannel(), getCompactMethodHelper(), getCallOptions(), request);
    }
  }

  /**
   */
  public static final class KVFutureStub extends io.grpc.stub.AbstractStub<KVFutureStub> {
    private KVFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private KVFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected KVFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new KVFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Range gets the keys in the range from the key-value store.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.ibm.etcd.api.RangeResponse> range(
        com.ibm.etcd.api.RangeRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRangeMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Put puts the given key into the key-value store.
     * A put request increments the revision of the key-value store
     * and generates one event in the event history.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.ibm.etcd.api.PutResponse> put(
        com.ibm.etcd.api.PutRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getPutMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * DeleteRange deletes the given range from the key-value store.
     * A delete request increments the revision of the key-value store
     * and generates a delete event in the event history for every deleted key.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.ibm.etcd.api.DeleteRangeResponse> deleteRange(
        com.ibm.etcd.api.DeleteRangeRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getDeleteRangeMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Txn processes multiple requests in a single transaction.
     * A txn request increments the revision of the key-value store
     * and generates events with the same revision for every completed request.
     * It is not allowed to modify the same key several times within one txn.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.ibm.etcd.api.TxnResponse> txn(
        com.ibm.etcd.api.TxnRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getTxnMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Compact compacts the event history in the etcd key-value store. The key-value
     * store should be periodically compacted or the event history will continue to grow
     * indefinitely.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.ibm.etcd.api.CompactionResponse> compact(
        com.ibm.etcd.api.CompactionRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getCompactMethodHelper(), getCallOptions()), request);
    }
  }

  private static final int METHODID_RANGE = 0;
  private static final int METHODID_PUT = 1;
  private static final int METHODID_DELETE_RANGE = 2;
  private static final int METHODID_TXN = 3;
  private static final int METHODID_COMPACT = 4;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final KVImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(KVImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_RANGE:
          serviceImpl.range((com.ibm.etcd.api.RangeRequest) request,
              (io.grpc.stub.StreamObserver<com.ibm.etcd.api.RangeResponse>) responseObserver);
          break;
        case METHODID_PUT:
          serviceImpl.put((com.ibm.etcd.api.PutRequest) request,
              (io.grpc.stub.StreamObserver<com.ibm.etcd.api.PutResponse>) responseObserver);
          break;
        case METHODID_DELETE_RANGE:
          serviceImpl.deleteRange((com.ibm.etcd.api.DeleteRangeRequest) request,
              (io.grpc.stub.StreamObserver<com.ibm.etcd.api.DeleteRangeResponse>) responseObserver);
          break;
        case METHODID_TXN:
          serviceImpl.txn((com.ibm.etcd.api.TxnRequest) request,
              (io.grpc.stub.StreamObserver<com.ibm.etcd.api.TxnResponse>) responseObserver);
          break;
        case METHODID_COMPACT:
          serviceImpl.compact((com.ibm.etcd.api.CompactionRequest) request,
              (io.grpc.stub.StreamObserver<com.ibm.etcd.api.CompactionResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class KVBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    KVBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.ibm.etcd.api.Rpc.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("KV");
    }
  }

  private static final class KVFileDescriptorSupplier
      extends KVBaseDescriptorSupplier {
    KVFileDescriptorSupplier() {}
  }

  private static final class KVMethodDescriptorSupplier
      extends KVBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    KVMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (KVGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new KVFileDescriptorSupplier())
              .addMethod(getRangeMethodHelper())
              .addMethod(getPutMethodHelper())
              .addMethod(getDeleteRangeMethodHelper())
              .addMethod(getTxnMethodHelper())
              .addMethod(getCompactMethodHelper())
              .build();
        }
      }
    }
    return result;
  }
}
