/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import com.ibm.etcd.api.AuthGrpc;
import com.ibm.etcd.api.AuthenticateRequest;
import com.ibm.etcd.api.AuthenticateResponse;
import com.ibm.etcd.client.GrpcClient;
import com.ibm.etcd.client.KvStoreClient;
import com.ibm.etcd.client.kv.EtcdKvClient;
import com.ibm.etcd.client.kv.KvClient;
import com.ibm.etcd.client.lease.EtcdLeaseClient;
import com.ibm.etcd.client.lease.LeaseClient;
import com.ibm.etcd.client.lease.PersistentLease;
import io.grpc.Attributes;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.ChannelOption;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

public class EtcdClient
implements KvStoreClient {
    private static final Metadata.Key<String> TOKEN_KEY = Metadata.Key.of((String)"token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final MethodDescriptor<AuthenticateRequest, AuthenticateResponse> METHOD_AUTHENTICATE = AuthGrpc.getAuthenticateMethod();
    protected static final String ETCD = "etcd";
    public static final int DEFAULT_PORT = 2379;
    protected static final Pattern ADDR_PATT = Pattern.compile("(?:https?://)?([a-zA-Z0-9\\-.]+)(?::(\\d+))?");
    private static final LeaseClient CLOSED = GrpcClient.sentinel(LeaseClient.class);
    public static final long DEFAULT_TIMEOUT_MS = 10000L;
    public static final int DEFAULT_SESSION_TIMEOUT_SECS = 20;
    private final int sessionTimeoutSecs;
    private final ByteString name;
    private final ByteString password;
    private final ScheduledThreadPoolExecutor executor;
    private final GrpcClient grpc;
    private final ManagedChannel channel;
    private final EtcdKvClient kvClient;
    private volatile LeaseClient leaseClient;
    private volatile PersistentLease sessionLease;

    public static Builder forEndpoint(String host, int port) {
        String target = GrpcUtil.authorityFromHostAndPort((String)host, (int)port);
        return new Builder(NettyChannelBuilder.forTarget((String)target));
    }

    public static Builder forEndpoints(final List<String> endpoints) {
        NettyChannelBuilder ncb = (NettyChannelBuilder)NettyChannelBuilder.forTarget((String)ETCD).nameResolverFactory(new NameResolver.Factory(){

            public NameResolver newNameResolver(URI targetUri, Attributes params) {
                if (!EtcdClient.ETCD.equals(targetUri.getScheme())) {
                    return null;
                }
                return new NameResolver(){

                    public void start(NameResolver.Listener listener) {
                        ArrayList<InetSocketAddress> addrList = new ArrayList<InetSocketAddress>(endpoints.size());
                        try {
                            for (String endpoint : endpoints) {
                                Matcher m = ADDR_PATT.matcher(endpoint.trim());
                                if (!m.matches()) {
                                    throw new Exception("invalid endpoint: " + endpoint);
                                }
                                String hostname = m.group(1);
                                String portStr = m.group(2);
                                int port = portStr != null ? Integer.parseInt(portStr) : 2379;
                                addrList.add(new InetSocketAddress(hostname, port));
                            }
                            Collections.shuffle(addrList);
                            listener.onAddresses(Collections.singletonList(new EquivalentAddressGroup(addrList)), Attributes.EMPTY);
                        }
                        catch (Exception e) {
                            listener.onError(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(e.getMessage()));
                        }
                    }

                    public String getServiceAuthority() {
                        return EtcdClient.ETCD;
                    }

                    public void shutdown() {
                    }
                };
            }

            public String getDefaultScheme() {
                return EtcdClient.ETCD;
            }
        });
        return new Builder(ncb);
    }

    public static Builder forEndpoints(String endpoints) {
        return EtcdClient.forEndpoints(Arrays.asList(endpoints.split(",")));
    }

    EtcdClient(NettyChannelBuilder chanBuilder, long defaultTimeoutMs, ByteString name, ByteString password, boolean initialAuth, int threads, int sessTimeoutSecs) {
        if (name == null && password != null) {
            throw new IllegalArgumentException("password without name");
        }
        this.name = name;
        this.password = password;
        this.sessionTimeoutSecs = sessTimeoutSecs;
        chanBuilder.keepAliveTime(10L, TimeUnit.SECONDS);
        chanBuilder.keepAliveTimeout(8L, TimeUnit.SECONDS);
        int connTimeout = Math.min((int)defaultTimeoutMs, 6000);
        chanBuilder.withOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connTimeout);
        this.executor = new ScheduledThreadPoolExecutor(threads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("etcd-sched-pool-%d").build());
        chanBuilder.executor((Executor)ForkJoinPool.commonPool());
        this.channel = chanBuilder.build();
        Predicate rr = name != null ? EtcdClient::reauthRequired : null;
        Supplier<CallCredentials> rc = name != null ? this::refreshCredentials : null;
        this.grpc = new GrpcClient(this.channel, (Predicate<Throwable>)rr, rc, this.executor, defaultTimeoutMs);
        if (initialAuth) {
            this.grpc.authenticateNow();
        }
        this.kvClient = new EtcdKvClient(this.grpc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.leaseClient == CLOSED) {
            return;
        }
        this.kvClient.close();
        EtcdClient etcdClient = this;
        synchronized (etcdClient) {
            if (this.leaseClient instanceof EtcdLeaseClient) {
                ((EtcdLeaseClient)this.leaseClient).close();
            }
            this.leaseClient = CLOSED;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                BlockingQueue<Runnable> queue = EtcdClient.this.executor.getQueue();
                if (queue.isEmpty() || queue.stream().allMatch(r -> ((Delayed)((Object)r)).getDelay(TimeUnit.NANOSECONDS) > 0L)) {
                    if (EtcdClient.this.executor.getActiveCount() > 1) {
                        EtcdClient.this.executor.schedule(this, 10L, TimeUnit.MILLISECONDS);
                    } else if (EtcdClient.this.channel.isShutdown()) {
                        EtcdClient.this.executor.shutdown();
                    } else {
                        try {
                            EtcdClient.this.channel.shutdown().awaitTermination(3L, TimeUnit.SECONDS);
                            this.run();
                        }
                        catch (InterruptedException ie) {
                            EtcdClient.this.executor.shutdown();
                            Thread.currentThread().interrupt();
                        }
                    }
                } else {
                    EtcdClient.this.executor.purge();
                    EtcdClient.this.executor.execute(this);
                }
            }
        });
    }

    public boolean isClosed() {
        return this.leaseClient == CLOSED;
    }

    protected static boolean reauthRequired(Throwable error) {
        Status.Code statusCode = GrpcClient.codeFromThrowable(error);
        return statusCode == Status.Code.UNAUTHENTICATED || statusCode == Status.Code.INVALID_ARGUMENT && EtcdClient.contains(error.getMessage(), "user name is empty") || statusCode == Status.Code.CANCELLED && EtcdClient.reauthRequired(error.getCause());
    }

    private CallCredentials refreshCredentials() {
        return new CallCredentials(){
            private Metadata tokenHeader;
            private final long authTime = System.currentTimeMillis();
            private final ListenableFuture<Metadata> futureTokenHeader = Futures.transform((ListenableFuture)EtcdClient.access$200(EtcdClient.this), ar -> {
                this.tokenHeader = EtcdClient.tokenHeader(ar);
                return this.tokenHeader;
            });

            public void applyRequestMetadata(MethodDescriptor<?, ?> method, Attributes attrs, Executor appExecutor, CallCredentials.MetadataApplier applier) {
                Metadata tokHeader = this.tokenHeader;
                if (tokHeader != null) {
                    applier.apply(tokHeader);
                } else {
                    this.futureTokenHeader.addListener(() -> {
                        try {
                            applier.apply((Metadata)this.futureTokenHeader.get());
                        }
                        catch (InterruptedException | ExecutionException ee) {
                            Status.Code code;
                            Status failStatus = Status.fromThrowable((Throwable)ee.getCause());
                            Status.Code code2 = code = failStatus != null ? failStatus.getCode() : null;
                            if (code != Status.Code.INVALID_ARGUMENT && System.currentTimeMillis() - this.authTime > 15000L) {
                                failStatus = Status.UNAUTHENTICATED.withDescription("re-attempt re-auth");
                            }
                            applier.fail(failStatus);
                        }
                    }, MoreExecutors.directExecutor());
                }
            }

            public void thisUsesUnstableApi() {
            }
        };
    }

    private static Metadata tokenHeader(AuthenticateResponse authResponse) {
        Metadata header = new Metadata();
        header.put(TOKEN_KEY, (Object)authResponse.getToken());
        return header;
    }

    private ListenableFuture<AuthenticateResponse> authenticate() {
        AuthenticateRequest request = AuthenticateRequest.newBuilder().setNameBytes(this.name).setPasswordBytes(this.password).build();
        CallOptions callOpts = CallOptions.DEFAULT;
        return Futures.catchingAsync(this.grpc.fuCall(METHOD_AUTHENTICATE, request, callOpts, 0L), Exception.class, ex -> !EtcdClient.retryAuthRequest(ex) ? Futures.immediateFailedFuture((Throwable)ex) : this.grpc.fuCall(METHOD_AUTHENTICATE, request, callOpts, 0L));
    }

    protected static boolean retryAuthRequest(Throwable error) {
        Status status = Status.fromThrowable((Throwable)error);
        Status.Code statusCode = status != null ? status.getCode() : null;
        return statusCode == Status.Code.UNAVAILABLE && GrpcClient.isConnectException(error);
    }

    @Override
    public KvClient getKvClient() {
        return this.kvClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaseClient getLeaseClient() {
        LeaseClient lc = this.leaseClient;
        if (lc == null) {
            EtcdClient etcdClient = this;
            synchronized (etcdClient) {
                lc = this.leaseClient;
                if (lc == null) {
                    this.leaseClient = lc = new EtcdLeaseClient(this.grpc);
                }
            }
        }
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistentLease getSessionLease() {
        PersistentLease sl = this.sessionLease;
        if (sl == null) {
            EtcdClient etcdClient = this;
            synchronized (etcdClient) {
                sl = this.sessionLease;
                if (sl == null) {
                    this.sessionLease = sl = this.getLeaseClient().maintain().minTtl(this.sessionTimeoutSecs).permanent().start();
                }
            }
        }
        if (sl == CLOSED) {
            throw new IllegalStateException("client closed");
        }
        return sl;
    }

    public Executor getExecutor() {
        return this.grpc.getExecutor();
    }

    protected static <T> Predicate<T> constantPredicate(boolean val) {
        return val ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    protected static boolean contains(String str, String subStr) {
        return str != null && str.contains(subStr);
    }

    static /* synthetic */ ListenableFuture access$200(EtcdClient x0) {
        return x0.authenticate();
    }

    public static class Builder {
        private ByteString name;
        private ByteString password;
        private long defaultTimeoutMs = 10000L;
        private NettyChannelBuilder chanBuilder;
        private boolean preemptAuth;
        private int threads = 8;
        private int sessTimeoutSecs = 20;

        Builder(NettyChannelBuilder chanBuilder) {
            this.chanBuilder = chanBuilder;
        }

        public Builder withCredentials(ByteString name, ByteString password) {
            this.name = name;
            this.password = password;
            return this;
        }

        public Builder withCredentials(String name, String password) {
            this.name = ByteString.copyFromUtf8((String)name);
            this.password = ByteString.copyFromUtf8((String)password);
            return this;
        }

        public Builder withImmediateAuth() {
            this.preemptAuth = true;
            return this;
        }

        public Builder withThreadCount(int threads) {
            this.threads = threads;
            return this;
        }

        public Builder withDefaultTimeout(long value, TimeUnit unit) {
            this.defaultTimeoutMs = TimeUnit.MILLISECONDS.convert(value, unit);
            return this;
        }

        public Builder withPlainText() {
            this.chanBuilder.usePlaintext(true);
            return this;
        }

        public Builder withCaCert(ByteSource certSource) throws IOException, SSLException {
            try (InputStream cert = certSource.openStream();){
                this.chanBuilder.sslContext(GrpcSslContexts.forClient().trustManager(cert).build());
            }
            return this;
        }

        public Builder withTrustManager(TrustManagerFactory tmf) throws SSLException {
            this.chanBuilder.sslContext(GrpcSslContexts.forClient().trustManager(tmf).build());
            return this;
        }

        public Builder withSessionTimeoutSecs(int timeoutSecs) {
            if (timeoutSecs < 1) {
                throw new IllegalArgumentException("invalid session timeout: " + timeoutSecs);
            }
            this.sessTimeoutSecs = timeoutSecs;
            return this;
        }

        public Builder withMaxInboundMessageSize(int sizeInBytes) {
            this.chanBuilder.maxInboundMessageSize(sizeInBytes);
            return this;
        }

        public EtcdClient build() {
            return new EtcdClient(this.chanBuilder, this.defaultTimeoutMs, this.name, this.password, this.preemptAuth, this.threads, this.sessTimeoutSecs);
        }
    }
}

