/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializingExecutor
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger(SerializingExecutor.class);
    private final Executor sharedPool;
    private final Queue<Runnable> workQueue;
    private final boolean bounded;
    private volatile boolean scheduled = false;
    private final TaskRun runner = new TaskRun();

    public SerializingExecutor(Executor parentPool) {
        this(parentPool, 0);
    }

    public SerializingExecutor(Executor parentPool, int capacity) {
        if (parentPool == null) {
            throw new NullPointerException();
        }
        this.sharedPool = parentPool;
        this.bounded = capacity > 0;
        this.workQueue = this.bounded ? new ArrayBlockingQueue(capacity) : new ConcurrentLinkedQueue();
    }

    protected void logTaskUncheckedException(Throwable t) {
        logger.error("Uncaught task exception: " + t, t);
    }

    @Override
    public void execute(Runnable command) {
        if (this.bounded) {
            try {
                ((ArrayBlockingQueue)this.workQueue).put(command);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.workQueue.offer(command);
        }
        if (!this.scheduled) {
            boolean doit = false;
            this.runner.lock();
            try {
                if (!this.scheduled) {
                    this.scheduled = true;
                    doit = true;
                }
            }
            finally {
                this.runner.unlock();
            }
            if (doit) {
                this.dispatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch() {
        boolean ok = false;
        try {
            this.sharedPool.execute(this.runner);
            ok = true;
        }
        finally {
            if (!ok) {
                this.runner.lock();
                try {
                    this.scheduled = false;
                }
                finally {
                    this.runner.unlock();
                }
            }
        }
    }

    class TaskRun
    extends ReentrantLock
    implements Runnable {
        TaskRun() {
        }

        @Override
        public void run() {
            block8: while (true) {
                try {
                    while (true) {
                        Queue wq;
                        Runnable next;
                        if ((next = (Runnable)(wq = SerializingExecutor.this.workQueue).poll()) == null) {
                            this.lock();
                            try {
                                SerializingExecutor.this.scheduled = false;
                                next = (Runnable)wq.poll();
                                if (next == null) {
                                    return;
                                }
                                SerializingExecutor.this.scheduled = true;
                            }
                            finally {
                                this.unlock();
                            }
                        }
                        try {
                            next.run();
                            continue block8;
                        }
                        catch (RuntimeException e) {
                            SerializingExecutor.this.logTaskUncheckedException(e);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    SerializingExecutor.this.dispatch();
                    SerializingExecutor.this.logTaskUncheckedException(t);
                    throw t;
                }
            }
        }
    }
}

