/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client.config;

import com.google.common.io.ByteSource;
import io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import io.netty.util.internal.EmptyArrays;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposeTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final Logger logger = LoggerFactory.getLogger(ComposeTrustManagerFactory.class);
    private final TrustManager tm;

    public ComposeTrustManagerFactory(String name, final String deployment, ByteSource certSource) throws CertificateException, IOException {
        super(name);
        X509Certificate cert;
        if (certSource == null) {
            cert = null;
        } else {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            try (InputStream in = certSource.openStream();){
                cert = (X509Certificate)certFactory.generateCertificate(in);
            }
        }
        this.tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String str) {
                logger.info("Accepting a client certificate: " + chain[0].getSubjectDN());
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String str) throws CertificateException {
                X509Certificate serverCert = chain[0];
                if (!serverCert.getSubjectDN().getName().equalsIgnoreCase(deployment) && !serverCert.getSubjectDN().getName().equalsIgnoreCase("CN=" + deployment)) {
                    throw new CertificateException("Certificate with unknown deployment: " + serverCert.getSubjectDN().getName());
                }
                if (cert != null) {
                    if (!serverCert.getIssuerDN().equals(cert.getIssuerDN())) {
                        throw new CertificateException("Certificate Issuers do not match: " + serverCert.getIssuerDN());
                    }
                    if (!serverCert.equals(cert)) {
                        try {
                            serverCert.verify(cert.getPublicKey());
                        }
                        catch (Exception exc) {
                            throw new CertificateException("Certificate not trusted", exc);
                        }
                    }
                }
                serverCert.checkValidity();
                if (logger.isDebugEnabled()) {
                    logger.debug("Accepting a server certificate: " + serverCert.getSubjectDN().getName());
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                X509Certificate[] x509CertificateArray;
                if (cert != null) {
                    X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
                    x509CertificateArray = x509CertificateArray2;
                    x509CertificateArray2[0] = cert;
                } else {
                    x509CertificateArray = EmptyArrays.EMPTY_X509_CERTIFICATES;
                }
                return x509CertificateArray;
            }
        };
    }

    protected TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.tm};
    }

    protected void engineInit(KeyStore keyStore) throws Exception {
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
    }
}

