/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client.kv;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import com.ibm.etcd.api.DeleteRangeRequest;
import com.ibm.etcd.api.DeleteRangeRequestOrBuilder;
import com.ibm.etcd.api.DeleteRangeResponse;
import com.ibm.etcd.api.PutRequest;
import com.ibm.etcd.api.PutRequestOrBuilder;
import com.ibm.etcd.api.PutResponse;
import com.ibm.etcd.api.RangeRequest;
import com.ibm.etcd.api.RangeRequestOrBuilder;
import com.ibm.etcd.api.RangeResponse;
import com.ibm.etcd.api.TxnRequest;
import com.ibm.etcd.api.TxnRequestOrBuilder;
import com.ibm.etcd.api.TxnResponse;
import com.ibm.etcd.api.WatchCreateRequest;
import com.ibm.etcd.client.Condition;
import com.ibm.etcd.client.kv.WatchUpdate;
import io.grpc.Deadline;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public interface KvClient {
    public static final ByteString ALL_KEYS = ByteString.copyFromUtf8((String)"ALL_KEYS");

    public ListenableFuture<RangeResponse> get(RangeRequest var1);

    public FluentRangeRequest get(ByteString var1);

    public ListenableFuture<TxnResponse> txn(TxnRequest var1);

    public FluentTxnRequest txnIf();

    public FluentTxnOps<?> batch();

    public ListenableFuture<PutResponse> put(PutRequest var1);

    public FluentPutRequest put(ByteString var1, ByteString var2);

    public FluentPutRequest put(ByteString var1, ByteString var2, long var3);

    public FluentPutRequest setLease(ByteString var1, long var2);

    public FluentPutRequest setValue(ByteString var1, ByteString var2);

    public ListenableFuture<DeleteRangeResponse> delete(DeleteRangeRequest var1);

    public FluentDeleteRequest delete(ByteString var1);

    public Watch watch(WatchCreateRequest var1, StreamObserver<WatchUpdate> var2);

    public FluentWatchRequest watch(ByteString var1);

    public static interface WatchIterator
    extends Closeable,
    Iterator<WatchUpdate> {
        @Override
        public void close();
    }

    public static interface Watch
    extends Closeable,
    ListenableFuture<Boolean> {
        @Override
        public void close();
    }

    public static interface FluentWatchRequest {
        public FluentWatchRequest filters(List<WatchCreateRequest.FilterType> var1);

        public FluentWatchRequest filters(WatchCreateRequest.FilterType ... var1);

        public FluentWatchRequest prevKv();

        public FluentWatchRequest rangeEnd(ByteString var1);

        public FluentWatchRequest asPrefix();

        public FluentWatchRequest andHigher();

        public FluentWatchRequest progressNotify();

        public FluentWatchRequest startRevision(long var1);

        public FluentWatchRequest executor(Executor var1);

        public Watch start(StreamObserver<WatchUpdate> var1);

        public WatchIterator start();
    }

    public static enum RetryStrategy {
        BASIC,
        BACKOFF;

    }

    public static interface FluentTxnSuccOps
    extends FluentTxnOps<FluentTxnSuccOps> {
        public FluentTxnOps<?> elseDo();
    }

    public static interface FluentTxnOps<FTO extends FluentTxnOps<FTO>>
    extends FluentRequest<FluentTxnOps<FTO>, TxnRequest, TxnResponse> {
        public FTO put(PutRequestOrBuilder var1);

        public FTO get(RangeRequestOrBuilder var1);

        public FTO delete(DeleteRangeRequestOrBuilder var1);

        public FTO subTxn(TxnRequestOrBuilder var1);

        default public FTO and() {
            return (FTO)this;
        }

        default public FTO noop() {
            return (FTO)this;
        }
    }

    public static interface FluentCmpTarget {
        public FluentTxnRequest version(long var1);

        public FluentTxnRequest mod(long var1);

        public FluentTxnRequest create(long var1);

        public FluentTxnRequest value(ByteString var1);

        public FluentTxnRequest lease(long var1);

        public FluentCmpTarget allInRange(ByteString var1);

        public FluentCmpTarget allWithPrefix();

        public FluentCmpTarget andAllHigher();
    }

    public static interface FluentTxnRequest
    extends FluentRequest<FluentTxnRequest, TxnRequest, TxnResponse> {
        public FluentCmpTarget cmpEqual(ByteString var1);

        public FluentCmpTarget cmpNotEqual(ByteString var1);

        public FluentCmpTarget cmpLess(ByteString var1);

        public FluentCmpTarget cmpGreater(ByteString var1);

        public FluentTxnRequest exists(ByteString var1);

        public FluentTxnRequest notExists(ByteString var1);

        default public FluentTxnRequest and() {
            return this;
        }

        public FluentTxnSuccOps then();
    }

    public static interface FluentPutRequest
    extends FluentRequest<FluentPutRequest, PutRequest, PutResponse> {
        public FluentPutRequest prevKv();
    }

    public static interface FluentDeleteRequest
    extends FluentRequest<FluentDeleteRequest, DeleteRangeRequest, DeleteRangeResponse> {
        public FluentDeleteRequest rangeEnd(ByteString var1);

        public FluentDeleteRequest asPrefix();

        public FluentDeleteRequest andHigher();

        public FluentDeleteRequest prevKv();
    }

    public static interface FluentRangeRequest
    extends FluentRequest<FluentRangeRequest, RangeRequest, RangeResponse> {
        public FluentRangeRequest rangeEnd(ByteString var1);

        public FluentRangeRequest asPrefix();

        public FluentRangeRequest andHigher();

        public FluentRangeRequest limit(long var1);

        public FluentRangeRequest revision(long var1);

        public FluentRangeRequest sorted(RangeRequest.SortTarget var1, RangeRequest.SortOrder var2);

        public FluentRangeRequest serializable();

        public FluentRangeRequest serializable(boolean var1);

        public FluentRangeRequest keysOnly();

        public FluentRangeRequest countOnly();

        public FluentRangeRequest minModRevision(long var1);

        public FluentRangeRequest maxModRevision(long var1);

        public FluentRangeRequest minCreateRevision(long var1);

        public FluentRangeRequest maxCreateRevision(long var1);
    }

    public static interface FluentRequest<FR extends FluentRequest<FR, ReqT, RespT>, ReqT, RespT> {
        public ListenableFuture<RespT> async();

        public RespT sync();

        public FR timeout(long var1);

        public FR deadline(Deadline var1);

        public FR backoffRetry();

        public FR backoffRetry(Condition var1);

        public ReqT asRequest();
    }
}

