/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.ForwardingExecutorService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import com.ibm.etcd.api.AuthGrpc;
import com.ibm.etcd.api.AuthenticateRequest;
import com.ibm.etcd.api.AuthenticateResponse;
import com.ibm.etcd.client.GrpcClient;
import com.ibm.etcd.client.KvStoreClient;
import com.ibm.etcd.client.StaticEtcdNameResolverFactory;
import com.ibm.etcd.client.kv.EtcdKvClient;
import com.ibm.etcd.client.kv.KvClient;
import com.ibm.etcd.client.lease.EtcdLeaseClient;
import com.ibm.etcd.client.lease.LeaseClient;
import com.ibm.etcd.client.lease.PersistentLease;
import com.ibm.etcd.client.lock.EtcdLockClient;
import com.ibm.etcd.client.lock.LockClient;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

public class EtcdClient
implements KvStoreClient {
    private static final Metadata.Key<String> TOKEN_KEY = Metadata.Key.of((String)"token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final MethodDescriptor<AuthenticateRequest, AuthenticateResponse> METHOD_AUTHENTICATE = AuthGrpc.getAuthenticateMethod();
    public static final int DEFAULT_PORT = 2379;
    private static final LeaseClient CLOSED = GrpcClient.sentinel(LeaseClient.class);
    public static final long DEFAULT_TIMEOUT_MS = 10000L;
    public static final int DEFAULT_SESSION_TIMEOUT_SECS = 20;
    protected static final Pattern ADDR_PATT = Pattern.compile("(?:https?://|dns:///)?([a-zA-Z0-9\\-.]+)(?::(\\d+))?");
    private final ReferenceCounted refCount;
    private final int sessionTimeoutSecs;
    private final ByteString name;
    private final ByteString password;
    private final MultithreadEventLoopGroup internalExecutor;
    private final ScheduledExecutorService sharedInternalExecutor;
    private final GrpcClient grpc;
    private final ManagedChannel channel;
    private final EtcdKvClient kvClient;
    private volatile LeaseClient leaseClient;
    private volatile LockClient lockClient;
    private volatile PersistentLease sessionLease;
    private static final Set<Status.Code> OTHER_AUTH_FAILURE_CODES = ImmutableSet.of((Object)Status.Code.INVALID_ARGUMENT, (Object)Status.Code.FAILED_PRECONDITION, (Object)Status.Code.PERMISSION_DENIED, (Object)Status.Code.UNKNOWN);
    private static final String[] AUTH_FAILURE_MESSAGES = new String[]{"root user does not exist", "root user does not have root role", "user name already exists", "user name is empty", "user name not found", "role name already exists", "role name not found", "role name is empty", "authentication failed, invalid user ID or password", "permission denied", "role is not granted to the user", "permission is not granted to the role", "authentication is not enabled", "invalid auth token", "invalid auth management"};
    private Status lastAuthFailStatus;
    private long authFailRetryTime;

    static String endpointToUriString(String endpoint) {
        Preconditions.checkNotNull((Object)endpoint, (Object)"null endpoint");
        Matcher m = ADDR_PATT.matcher(endpoint.trim());
        if (!m.matches()) {
            throw new IllegalArgumentException("invalid endpoint: " + endpoint);
        }
        String portStr = m.group(2);
        if (portStr == null) {
            portStr = String.valueOf(2379);
        }
        return "dns:///" + m.group(1) + ":" + portStr;
    }

    private static int defaultThreadCount() {
        return Math.min(6, Runtime.getRuntime().availableProcessors());
    }

    public static Builder forEndpoint(String host, int port) {
        String target = GrpcUtil.authorityFromHostAndPort((String)host, (int)port);
        return new Builder(Collections.singletonList(target));
    }

    public static Builder forEndpoints(List<String> endpoints) {
        return new Builder(endpoints);
    }

    public static Builder forEndpoints(String endpoints) {
        return EtcdClient.forEndpoints(Arrays.asList(endpoints.split(",")));
    }

    EtcdClient(NettyChannelBuilder chanBuilder, long defaultTimeoutMs, ByteString name, ByteString password, boolean initialAuth, int threads, Executor userExecutor, boolean sendViaEventLoop, int sessTimeoutSecs, boolean refCounted) {
        Class<EpollSocketChannel> channelType;
        if (name == null && password != null) {
            throw new IllegalArgumentException("password without name");
        }
        this.name = name;
        this.password = password;
        this.sessionTimeoutSecs = sessTimeoutSecs;
        this.refCount = !refCounted ? null : new AbstractReferenceCounted(){

            public ReferenceCounted touch(Object hint) {
                return null;
            }

            protected void deallocate() {
                EtcdClient.this.doClose();
            }
        };
        chanBuilder.keepAliveTime(10L, TimeUnit.SECONDS);
        chanBuilder.keepAliveTimeout(8L, TimeUnit.SECONDS);
        int connTimeout = Math.min((int)defaultTimeoutMs, 6000);
        chanBuilder.withOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connTimeout);
        ThreadFactory tfac = new ThreadFactoryBuilder().setDaemon(true).setThreadFactory(EtcdEventThread::new).setNameFormat("etcd-event-pool-%d").build();
        if (Epoll.isAvailable()) {
            this.internalExecutor = new EpollEventLoopGroup(threads, tfac);
            channelType = EpollSocketChannel.class;
        } else {
            this.internalExecutor = new NioEventLoopGroup(threads, tfac);
            channelType = NioSocketChannel.class;
        }
        chanBuilder.eventLoopGroup((EventLoopGroup)this.internalExecutor).channelType(channelType);
        if (userExecutor == null) {
            userExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("etcd-callback-thread-%d").build());
        }
        chanBuilder.executor(userExecutor);
        this.channel = chanBuilder.build();
        GrpcClient.AuthProvider authProvider = name == null ? null : new GrpcClient.AuthProvider(){

            @Override
            public boolean requiresReauth(Throwable t) {
                return EtcdClient.reauthRequired(t);
            }

            @Override
            public CallCredentials refreshCredentials(Throwable trigger) {
                return EtcdClient.this.refreshCredentials(trigger);
            }

            @Override
            public CallCredentials refreshCredentials() {
                return this.refreshCredentials(null);
            }
        };
        this.sharedInternalExecutor = new SharedScheduledExecutorService((ScheduledExecutorService)this.internalExecutor);
        this.grpc = new GrpcClient(this.channel, authProvider, this.sharedInternalExecutor, () -> Thread.currentThread() instanceof EtcdEventThread, userExecutor, sendViaEventLoop, defaultTimeoutMs);
        if (authProvider != null && initialAuth) {
            this.grpc.authenticateNow();
        }
        this.kvClient = new EtcdKvClient(this.grpc);
    }

    @Override
    public void close() {
        if (this.refCount != null) {
            this.refCount.release();
        } else {
            this.doClose();
        }
    }

    boolean retain() {
        if (this.refCount != null) {
            try {
                this.refCount.retain();
                return true;
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClose() {
        if (this.leaseClient == CLOSED) {
            return;
        }
        EtcdClient etcdClient = this;
        synchronized (etcdClient) {
            LeaseClient toClose = this.leaseClient;
            if (toClose == CLOSED) {
                return;
            }
            this.leaseClient = CLOSED;
            this.kvClient.close();
            if (toClose instanceof EtcdLeaseClient) {
                ((EtcdLeaseClient)toClose).close();
            }
        }
        this.executeWhenIdle(() -> {
            try {
                this.channel.shutdown().awaitTermination(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executeWhenIdle(() -> this.internalExecutor.shutdownGracefully(0L, 1L, TimeUnit.SECONDS));
        });
    }

    private void executeWhenIdle(Runnable task) {
        AtomicInteger remainingTasks = new AtomicInteger(-1);
        CyclicBarrier cb = new CyclicBarrier(this.internalExecutor.executorCount(), () -> {
            int rt = remainingTasks.get();
            if (rt == -1) {
                remainingTasks.incrementAndGet();
            } else if (rt > 0) {
                this.executeWhenIdle(task);
            } else {
                this.internalExecutor.execute(task);
            }
        });
        this.internalExecutor.forEach(ex -> ex.execute(new Runnable((EventExecutor)ex, cb, remainingTasks){
            final /* synthetic */ EventExecutor val$ex;
            final /* synthetic */ CyclicBarrier val$cb;
            final /* synthetic */ AtomicInteger val$remainingTasks;
            {
                this.val$ex = eventExecutor;
                this.val$cb = cyclicBarrier;
                this.val$remainingTasks = atomicInteger;
            }

            @Override
            public void run() {
                SingleThreadEventLoop stel = (SingleThreadEventLoop)this.val$ex;
                try {
                    if (stel.pendingTasks() > 0) {
                        this.val$ex.execute((Runnable)this);
                    } else {
                        this.val$cb.await();
                        if (stel.pendingTasks() > 0) {
                            this.val$remainingTasks.incrementAndGet();
                        }
                        this.val$cb.await();
                    }
                }
                catch (InterruptedException | BrokenBarrierException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }));
    }

    public boolean isClosed() {
        return this.leaseClient == CLOSED;
    }

    protected static boolean reauthRequired(Throwable error) {
        if (error == null) {
            return false;
        }
        Status status = Status.fromThrowable((Throwable)error);
        Status.Code code = status.getCode();
        return code == Status.Code.UNAUTHENTICATED || OTHER_AUTH_FAILURE_CODES.contains(code) && (EtcdClient.startsWith(status.getDescription(), "auth: ") || EtcdClient.endsWith(status.getDescription(), AUTH_FAILURE_MESSAGES)) || code == Status.Code.CANCELLED && EtcdClient.reauthRequired(error.getCause());
    }

    private CallCredentials refreshCredentials(final Throwable trigger) {
        if (System.currentTimeMillis() < this.authFailRetryTime) {
            return new CallCredentials(){

                public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
                    applier.fail(EtcdClient.this.lastAuthFailStatus);
                }

                public void thisUsesUnstableApi() {
                }
            };
        }
        return new CallCredentials(){
            private volatile Metadata tokenHeader;
            private final ListenableFuture<Metadata> futureTokenHeader;
            {
                this.futureTokenHeader = Futures.transform((ListenableFuture)EtcdClient.this.authenticate(), ar -> {
                    this.tokenHeader = EtcdClient.tokenHeader(ar);
                    return this.tokenHeader;
                }, (Executor)MoreExecutors.directExecutor());
            }

            public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
                Metadata tokHeader = this.tokenHeader;
                if (tokHeader != null) {
                    applier.apply(tokHeader);
                } else {
                    this.futureTokenHeader.addListener(() -> {
                        try {
                            applier.apply((Metadata)this.futureTokenHeader.get());
                        }
                        catch (InterruptedException | ExecutionException ee) {
                            Status failStatus;
                            Throwable failure = ee.getCause();
                            if (!EtcdClient.reauthRequired(failure)) {
                                failStatus = Status.UNAUTHENTICATED.withDescription("(Re)authentication RPC failed").withCause(failure);
                                EtcdClient.this.authFailRetryTime = System.currentTimeMillis() + 5000L;
                            } else {
                                failStatus = Status.fromThrowable((Throwable)failure);
                                EtcdClient.this.authFailRetryTime = System.currentTimeMillis() + 15000L;
                            }
                            EtcdClient.this.lastAuthFailStatus = failStatus;
                            if (trigger != null) {
                                if (failStatus.getCause() != null) {
                                    failStatus.getCause().addSuppressed(trigger);
                                } else {
                                    failStatus = failStatus.withCause(trigger);
                                }
                            }
                            applier.fail(failStatus);
                        }
                    }, MoreExecutors.directExecutor());
                }
            }

            public void thisUsesUnstableApi() {
            }
        };
    }

    private static Metadata tokenHeader(AuthenticateResponse authResponse) {
        Metadata header = new Metadata();
        header.put(TOKEN_KEY, (Object)authResponse.getToken());
        return header;
    }

    private ListenableFuture<AuthenticateResponse> authenticate() {
        AuthenticateRequest request = AuthenticateRequest.newBuilder().setNameBytes(this.name).setPasswordBytes(this.password).build();
        CallOptions callOpts = CallOptions.DEFAULT;
        return Futures.catchingAsync(this.grpc.fuCall(METHOD_AUTHENTICATE, request, callOpts, 0L), Exception.class, ex -> !EtcdClient.retryAuthRequest(ex) ? Futures.immediateFailedFuture((Throwable)ex) : this.grpc.fuCall(METHOD_AUTHENTICATE, request, callOpts, 0L), (Executor)MoreExecutors.directExecutor());
    }

    protected static boolean retryAuthRequest(Throwable error) {
        return GrpcClient.codeFromThrowable(error) == Status.Code.UNAVAILABLE && GrpcClient.isConnectException(error);
    }

    @Override
    public KvClient getKvClient() {
        return this.kvClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaseClient getLeaseClient() {
        LeaseClient lc = this.leaseClient;
        if (lc == null) {
            EtcdClient etcdClient = this;
            synchronized (etcdClient) {
                lc = this.leaseClient;
                if (lc == null) {
                    this.leaseClient = lc = new EtcdLeaseClient(this.grpc);
                }
            }
        }
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockClient getLockClient() {
        LockClient lc = this.lockClient;
        if (lc == null) {
            EtcdClient etcdClient = this;
            synchronized (etcdClient) {
                lc = this.lockClient;
                if (lc == null) {
                    this.lockClient = lc = new EtcdLockClient(this.grpc, this);
                }
            }
        }
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistentLease getSessionLease() {
        PersistentLease sl = this.sessionLease;
        if (sl == null) {
            EtcdClient etcdClient = this;
            synchronized (etcdClient) {
                sl = this.sessionLease;
                if (sl == null) {
                    this.sessionLease = sl = this.getLeaseClient().maintain().minTtl(this.sessionTimeoutSecs).permanent().start();
                }
            }
        }
        if (this.leaseClient == CLOSED) {
            throw new IllegalStateException("client closed");
        }
        return sl;
    }

    public Executor getExecutor() {
        return this.grpc.getResponseExecutor();
    }

    public ScheduledExecutorService internalScheduledExecutor() {
        return this.sharedInternalExecutor;
    }

    protected static <T> Predicate<T> constantPredicate(boolean val) {
        return val ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    protected static boolean contains(String str, String subStr) {
        return str != null && str.contains(subStr);
    }

    protected static boolean startsWith(String str, String prefix) {
        return str != null && str.startsWith(prefix);
    }

    protected static boolean endsWith(String str, String ... suffixes) {
        if (str != null) {
            for (String suffix : suffixes) {
                if (!str.endsWith(suffix)) continue;
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    MultithreadEventLoopGroup getInternalExecutor() {
        return this.internalExecutor;
    }

    static /* synthetic */ int access$000() {
        return EtcdClient.defaultThreadCount();
    }

    public static final class Internal {
        private Internal() {
        }

        public static boolean retain(EtcdClient client) {
            return client != null && client.retain();
        }

        public static void cleanup(EtcdClient client) {
            if (client != null) {
                client.doClose();
            }
        }

        public static void makeRefCounted(Builder builder) {
            builder.refCounted = true;
        }
    }

    static final class SharedScheduledExecutorService
    extends ForwardingExecutorService
    implements ScheduledExecutorService {
        private final ScheduledExecutorService delegate;

        SharedScheduledExecutorService(ScheduledExecutorService delegate) {
            this.delegate = delegate;
        }

        protected ExecutorService delegate() {
            return this.delegate;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.delegate.schedule(command, delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this.delegate.schedule(callable, delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.delegate.scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.delegate.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException("Cannot be shut down directly, close EtcdClient instead");
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException("Cannot be shut down directly, close EtcdClient instead");
        }
    }

    protected static final class EtcdEventThread
    extends FastThreadLocalThread {
        public EtcdEventThread(Runnable r) {
            super(r);
        }
    }

    public static class Builder {
        private final List<String> endpoints;
        private boolean plainText;
        private int maxInboundMessageSize;
        private SslContextBuilder sslContextBuilder;
        private SslContext sslContext;
        private String overrideAuthority;
        private ByteString name;
        private ByteString password;
        private long defaultTimeoutMs = 10000L;
        private boolean preemptAuth;
        private int threads = EtcdClient.access$000();
        private Executor executor;
        private boolean sendViaEventLoop = true;
        private int sessTimeoutSecs = 20;
        private boolean refCounted;

        Builder(List<String> endpoints) {
            this.endpoints = (List)Preconditions.checkNotNull(endpoints);
            Preconditions.checkArgument((!endpoints.isEmpty() ? 1 : 0) != 0, (Object)"empty endpoints");
        }

        public Builder withCredentials(ByteString name, ByteString password) {
            Preconditions.checkArgument((name == null == (password == null) ? 1 : 0) != 0, (Object)"name and password must both be null or both be non-null");
            this.name = name;
            this.password = password;
            return this;
        }

        public Builder withCredentials(String name, String password) {
            this.name = ByteString.copyFromUtf8((String)name);
            this.password = ByteString.copyFromUtf8((String)password);
            return this;
        }

        public Builder withImmediateAuth() {
            this.preemptAuth = true;
            return this;
        }

        public Builder withThreadCount(int threads) {
            Preconditions.checkArgument((threads > 0 ? 1 : 0) != 0, (String)"invalid thread count: %s", (int)threads);
            this.threads = threads;
            return this;
        }

        public Builder sendViaEventLoop(boolean sendViaEventLoop) {
            this.sendViaEventLoop = sendViaEventLoop;
            return this;
        }

        public Builder withUserExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder withDefaultTimeout(long value, TimeUnit unit) {
            this.defaultTimeoutMs = TimeUnit.MILLISECONDS.convert(value, unit);
            return this;
        }

        private SslContextBuilder sslBuilder() {
            return this.sslContextBuilder != null ? this.sslContextBuilder : (this.sslContextBuilder = GrpcSslContexts.forClient());
        }

        public Builder withPlainText() {
            this.plainText = true;
            return this;
        }

        public Builder overrideAuthority(String authority) {
            this.overrideAuthority = (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
            return this;
        }

        public Builder withCaCert(ByteSource certSource) throws IOException, SSLException {
            try (InputStream cert = certSource.openStream();){
                this.sslContext = this.sslBuilder().trustManager(cert).build();
            }
            return this;
        }

        public Builder withTrustManager(TrustManagerFactory tmf) throws SSLException {
            this.sslContext = this.sslBuilder().trustManager(tmf).build();
            return this;
        }

        public Builder withTlsConfig(Consumer<SslContextBuilder> contextBuilder) throws SSLException {
            SslContextBuilder sslBuilder = this.sslBuilder();
            contextBuilder.accept(sslBuilder);
            this.sslContext = sslBuilder.build();
            return this;
        }

        public Builder withSessionTimeoutSecs(int timeoutSecs) {
            Preconditions.checkArgument((timeoutSecs > 0 ? 1 : 0) != 0, (String)"invalid session timeout: %s", (int)timeoutSecs);
            this.sessTimeoutSecs = timeoutSecs;
            return this;
        }

        public Builder withMaxInboundMessageSize(int sizeInBytes) {
            this.maxInboundMessageSize = sizeInBytes;
            return this;
        }

        public EtcdClient build() {
            NettyChannelBuilder ncb;
            if (this.endpoints.size() == 1) {
                ncb = NettyChannelBuilder.forTarget((String)EtcdClient.endpointToUriString(this.endpoints.get(0)));
                if (this.overrideAuthority != null) {
                    ncb.overrideAuthority(this.overrideAuthority);
                }
            } else {
                ncb = (NettyChannelBuilder)NettyChannelBuilder.forTarget((String)"etcd").nameResolverFactory((NameResolver.Factory)new StaticEtcdNameResolverFactory(this.endpoints, this.overrideAuthority));
            }
            if (this.plainText) {
                ncb.usePlaintext();
            }
            if (this.sslContext != null) {
                ncb.sslContext(this.sslContext);
            }
            if (this.maxInboundMessageSize != 0) {
                ncb.maxInboundMessageSize(this.maxInboundMessageSize);
            }
            return new EtcdClient(ncb, this.defaultTimeoutMs, this.name, this.password, this.preemptAuth, this.threads, this.executor, this.sendViaEventLoop, this.sessTimeoutSecs, this.refCounted);
        }
    }
}

