package com.ibm.etcd.api;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.12.0)",
    comments = "Source: rpc.proto")
public final class LeaseGrpc {

  private LeaseGrpc() {}

  public static final String SERVICE_NAME = "etcdserverpb.Lease";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getLeaseGrantMethod()} instead. 
  public static final io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseGrantRequest,
      com.ibm.etcd.api.LeaseGrantResponse> METHOD_LEASE_GRANT = getLeaseGrantMethodHelper();

  private static volatile io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseGrantRequest,
      com.ibm.etcd.api.LeaseGrantResponse> getLeaseGrantMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseGrantRequest,
      com.ibm.etcd.api.LeaseGrantResponse> getLeaseGrantMethod() {
    return getLeaseGrantMethodHelper();
  }

  private static io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseGrantRequest,
      com.ibm.etcd.api.LeaseGrantResponse> getLeaseGrantMethodHelper() {
    io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseGrantRequest, com.ibm.etcd.api.LeaseGrantResponse> getLeaseGrantMethod;
    if ((getLeaseGrantMethod = LeaseGrpc.getLeaseGrantMethod) == null) {
      synchronized (LeaseGrpc.class) {
        if ((getLeaseGrantMethod = LeaseGrpc.getLeaseGrantMethod) == null) {
          LeaseGrpc.getLeaseGrantMethod = getLeaseGrantMethod = 
              io.grpc.MethodDescriptor.<com.ibm.etcd.api.LeaseGrantRequest, com.ibm.etcd.api.LeaseGrantResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Lease", "LeaseGrant"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.LeaseGrantRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.LeaseGrantResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new LeaseMethodDescriptorSupplier("LeaseGrant"))
                  .build();
          }
        }
     }
     return getLeaseGrantMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getLeaseRevokeMethod()} instead. 
  public static final io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseRevokeRequest,
      com.ibm.etcd.api.LeaseRevokeResponse> METHOD_LEASE_REVOKE = getLeaseRevokeMethodHelper();

  private static volatile io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseRevokeRequest,
      com.ibm.etcd.api.LeaseRevokeResponse> getLeaseRevokeMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseRevokeRequest,
      com.ibm.etcd.api.LeaseRevokeResponse> getLeaseRevokeMethod() {
    return getLeaseRevokeMethodHelper();
  }

  private static io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseRevokeRequest,
      com.ibm.etcd.api.LeaseRevokeResponse> getLeaseRevokeMethodHelper() {
    io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseRevokeRequest, com.ibm.etcd.api.LeaseRevokeResponse> getLeaseRevokeMethod;
    if ((getLeaseRevokeMethod = LeaseGrpc.getLeaseRevokeMethod) == null) {
      synchronized (LeaseGrpc.class) {
        if ((getLeaseRevokeMethod = LeaseGrpc.getLeaseRevokeMethod) == null) {
          LeaseGrpc.getLeaseRevokeMethod = getLeaseRevokeMethod = 
              io.grpc.MethodDescriptor.<com.ibm.etcd.api.LeaseRevokeRequest, com.ibm.etcd.api.LeaseRevokeResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Lease", "LeaseRevoke"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.LeaseRevokeRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.LeaseRevokeResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new LeaseMethodDescriptorSupplier("LeaseRevoke"))
                  .build();
          }
        }
     }
     return getLeaseRevokeMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getLeaseKeepAliveMethod()} instead. 
  public static final io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseKeepAliveRequest,
      com.ibm.etcd.api.LeaseKeepAliveResponse> METHOD_LEASE_KEEP_ALIVE = getLeaseKeepAliveMethodHelper();

  private static volatile io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseKeepAliveRequest,
      com.ibm.etcd.api.LeaseKeepAliveResponse> getLeaseKeepAliveMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseKeepAliveRequest,
      com.ibm.etcd.api.LeaseKeepAliveResponse> getLeaseKeepAliveMethod() {
    return getLeaseKeepAliveMethodHelper();
  }

  private static io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseKeepAliveRequest,
      com.ibm.etcd.api.LeaseKeepAliveResponse> getLeaseKeepAliveMethodHelper() {
    io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseKeepAliveRequest, com.ibm.etcd.api.LeaseKeepAliveResponse> getLeaseKeepAliveMethod;
    if ((getLeaseKeepAliveMethod = LeaseGrpc.getLeaseKeepAliveMethod) == null) {
      synchronized (LeaseGrpc.class) {
        if ((getLeaseKeepAliveMethod = LeaseGrpc.getLeaseKeepAliveMethod) == null) {
          LeaseGrpc.getLeaseKeepAliveMethod = getLeaseKeepAliveMethod = 
              io.grpc.MethodDescriptor.<com.ibm.etcd.api.LeaseKeepAliveRequest, com.ibm.etcd.api.LeaseKeepAliveResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Lease", "LeaseKeepAlive"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.LeaseKeepAliveRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.LeaseKeepAliveResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new LeaseMethodDescriptorSupplier("LeaseKeepAlive"))
                  .build();
          }
        }
     }
     return getLeaseKeepAliveMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getLeaseTimeToLiveMethod()} instead. 
  public static final io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseTimeToLiveRequest,
      com.ibm.etcd.api.LeaseTimeToLiveResponse> METHOD_LEASE_TIME_TO_LIVE = getLeaseTimeToLiveMethodHelper();

  private static volatile io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseTimeToLiveRequest,
      com.ibm.etcd.api.LeaseTimeToLiveResponse> getLeaseTimeToLiveMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseTimeToLiveRequest,
      com.ibm.etcd.api.LeaseTimeToLiveResponse> getLeaseTimeToLiveMethod() {
    return getLeaseTimeToLiveMethodHelper();
  }

  private static io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseTimeToLiveRequest,
      com.ibm.etcd.api.LeaseTimeToLiveResponse> getLeaseTimeToLiveMethodHelper() {
    io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseTimeToLiveRequest, com.ibm.etcd.api.LeaseTimeToLiveResponse> getLeaseTimeToLiveMethod;
    if ((getLeaseTimeToLiveMethod = LeaseGrpc.getLeaseTimeToLiveMethod) == null) {
      synchronized (LeaseGrpc.class) {
        if ((getLeaseTimeToLiveMethod = LeaseGrpc.getLeaseTimeToLiveMethod) == null) {
          LeaseGrpc.getLeaseTimeToLiveMethod = getLeaseTimeToLiveMethod = 
              io.grpc.MethodDescriptor.<com.ibm.etcd.api.LeaseTimeToLiveRequest, com.ibm.etcd.api.LeaseTimeToLiveResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Lease", "LeaseTimeToLive"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.LeaseTimeToLiveRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.LeaseTimeToLiveResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new LeaseMethodDescriptorSupplier("LeaseTimeToLive"))
                  .build();
          }
        }
     }
     return getLeaseTimeToLiveMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getLeaseLeasesMethod()} instead. 
  public static final io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseLeasesRequest,
      com.ibm.etcd.api.LeaseLeasesResponse> METHOD_LEASE_LEASES = getLeaseLeasesMethodHelper();

  private static volatile io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseLeasesRequest,
      com.ibm.etcd.api.LeaseLeasesResponse> getLeaseLeasesMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseLeasesRequest,
      com.ibm.etcd.api.LeaseLeasesResponse> getLeaseLeasesMethod() {
    return getLeaseLeasesMethodHelper();
  }

  private static io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseLeasesRequest,
      com.ibm.etcd.api.LeaseLeasesResponse> getLeaseLeasesMethodHelper() {
    io.grpc.MethodDescriptor<com.ibm.etcd.api.LeaseLeasesRequest, com.ibm.etcd.api.LeaseLeasesResponse> getLeaseLeasesMethod;
    if ((getLeaseLeasesMethod = LeaseGrpc.getLeaseLeasesMethod) == null) {
      synchronized (LeaseGrpc.class) {
        if ((getLeaseLeasesMethod = LeaseGrpc.getLeaseLeasesMethod) == null) {
          LeaseGrpc.getLeaseLeasesMethod = getLeaseLeasesMethod = 
              io.grpc.MethodDescriptor.<com.ibm.etcd.api.LeaseLeasesRequest, com.ibm.etcd.api.LeaseLeasesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "etcdserverpb.Lease", "LeaseLeases"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.LeaseLeasesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.ibm.etcd.api.LeaseLeasesResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new LeaseMethodDescriptorSupplier("LeaseLeases"))
                  .build();
          }
        }
     }
     return getLeaseLeasesMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static LeaseStub newStub(io.grpc.Channel channel) {
    return new LeaseStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static LeaseBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new LeaseBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static LeaseFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new LeaseFutureStub(channel);
  }

  /**
   */
  public static abstract class LeaseImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * LeaseGrant creates a lease which expires if the server does not receive a keepAlive
     * within a given time to live period. All keys attached to the lease will be expired and
     * deleted if the lease expires. Each expired key generates a delete event in the event history.
     * </pre>
     */
    public void leaseGrant(com.ibm.etcd.api.LeaseGrantRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseGrantResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getLeaseGrantMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * LeaseRevoke revokes a lease. All keys attached to the lease will expire and be deleted.
     * </pre>
     */
    public void leaseRevoke(com.ibm.etcd.api.LeaseRevokeRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseRevokeResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getLeaseRevokeMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * LeaseKeepAlive keeps the lease alive by streaming keep alive requests from the client
     * to the server and streaming keep alive responses from the server to the client.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseKeepAliveRequest> leaseKeepAlive(
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseKeepAliveResponse> responseObserver) {
      return asyncUnimplementedStreamingCall(getLeaseKeepAliveMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * LeaseTimeToLive retrieves lease information.
     * </pre>
     */
    public void leaseTimeToLive(com.ibm.etcd.api.LeaseTimeToLiveRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseTimeToLiveResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getLeaseTimeToLiveMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * LeaseLeases lists all existing leases.
     * </pre>
     */
    public void leaseLeases(com.ibm.etcd.api.LeaseLeasesRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseLeasesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getLeaseLeasesMethodHelper(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getLeaseGrantMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                com.ibm.etcd.api.LeaseGrantRequest,
                com.ibm.etcd.api.LeaseGrantResponse>(
                  this, METHODID_LEASE_GRANT)))
          .addMethod(
            getLeaseRevokeMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                com.ibm.etcd.api.LeaseRevokeRequest,
                com.ibm.etcd.api.LeaseRevokeResponse>(
                  this, METHODID_LEASE_REVOKE)))
          .addMethod(
            getLeaseKeepAliveMethodHelper(),
            asyncBidiStreamingCall(
              new MethodHandlers<
                com.ibm.etcd.api.LeaseKeepAliveRequest,
                com.ibm.etcd.api.LeaseKeepAliveResponse>(
                  this, METHODID_LEASE_KEEP_ALIVE)))
          .addMethod(
            getLeaseTimeToLiveMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                com.ibm.etcd.api.LeaseTimeToLiveRequest,
                com.ibm.etcd.api.LeaseTimeToLiveResponse>(
                  this, METHODID_LEASE_TIME_TO_LIVE)))
          .addMethod(
            getLeaseLeasesMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                com.ibm.etcd.api.LeaseLeasesRequest,
                com.ibm.etcd.api.LeaseLeasesResponse>(
                  this, METHODID_LEASE_LEASES)))
          .build();
    }
  }

  /**
   */
  public static final class LeaseStub extends io.grpc.stub.AbstractStub<LeaseStub> {
    private LeaseStub(io.grpc.Channel channel) {
      super(channel);
    }

    private LeaseStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LeaseStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new LeaseStub(channel, callOptions);
    }

    /**
     * <pre>
     * LeaseGrant creates a lease which expires if the server does not receive a keepAlive
     * within a given time to live period. All keys attached to the lease will be expired and
     * deleted if the lease expires. Each expired key generates a delete event in the event history.
     * </pre>
     */
    public void leaseGrant(com.ibm.etcd.api.LeaseGrantRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseGrantResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getLeaseGrantMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * LeaseRevoke revokes a lease. All keys attached to the lease will expire and be deleted.
     * </pre>
     */
    public void leaseRevoke(com.ibm.etcd.api.LeaseRevokeRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseRevokeResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getLeaseRevokeMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * LeaseKeepAlive keeps the lease alive by streaming keep alive requests from the client
     * to the server and streaming keep alive responses from the server to the client.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseKeepAliveRequest> leaseKeepAlive(
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseKeepAliveResponse> responseObserver) {
      return asyncBidiStreamingCall(
          getChannel().newCall(getLeaseKeepAliveMethodHelper(), getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     * LeaseTimeToLive retrieves lease information.
     * </pre>
     */
    public void leaseTimeToLive(com.ibm.etcd.api.LeaseTimeToLiveRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseTimeToLiveResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getLeaseTimeToLiveMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * LeaseLeases lists all existing leases.
     * </pre>
     */
    public void leaseLeases(com.ibm.etcd.api.LeaseLeasesRequest request,
        io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseLeasesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getLeaseLeasesMethodHelper(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class LeaseBlockingStub extends io.grpc.stub.AbstractStub<LeaseBlockingStub> {
    private LeaseBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private LeaseBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LeaseBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new LeaseBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * LeaseGrant creates a lease which expires if the server does not receive a keepAlive
     * within a given time to live period. All keys attached to the lease will be expired and
     * deleted if the lease expires. Each expired key generates a delete event in the event history.
     * </pre>
     */
    public com.ibm.etcd.api.LeaseGrantResponse leaseGrant(com.ibm.etcd.api.LeaseGrantRequest request) {
      return blockingUnaryCall(
          getChannel(), getLeaseGrantMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * LeaseRevoke revokes a lease. All keys attached to the lease will expire and be deleted.
     * </pre>
     */
    public com.ibm.etcd.api.LeaseRevokeResponse leaseRevoke(com.ibm.etcd.api.LeaseRevokeRequest request) {
      return blockingUnaryCall(
          getChannel(), getLeaseRevokeMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * LeaseTimeToLive retrieves lease information.
     * </pre>
     */
    public com.ibm.etcd.api.LeaseTimeToLiveResponse leaseTimeToLive(com.ibm.etcd.api.LeaseTimeToLiveRequest request) {
      return blockingUnaryCall(
          getChannel(), getLeaseTimeToLiveMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * LeaseLeases lists all existing leases.
     * </pre>
     */
    public com.ibm.etcd.api.LeaseLeasesResponse leaseLeases(com.ibm.etcd.api.LeaseLeasesRequest request) {
      return blockingUnaryCall(
          getChannel(), getLeaseLeasesMethodHelper(), getCallOptions(), request);
    }
  }

  /**
   */
  public static final class LeaseFutureStub extends io.grpc.stub.AbstractStub<LeaseFutureStub> {
    private LeaseFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private LeaseFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LeaseFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new LeaseFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * LeaseGrant creates a lease which expires if the server does not receive a keepAlive
     * within a given time to live period. All keys attached to the lease will be expired and
     * deleted if the lease expires. Each expired key generates a delete event in the event history.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.ibm.etcd.api.LeaseGrantResponse> leaseGrant(
        com.ibm.etcd.api.LeaseGrantRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getLeaseGrantMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * LeaseRevoke revokes a lease. All keys attached to the lease will expire and be deleted.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.ibm.etcd.api.LeaseRevokeResponse> leaseRevoke(
        com.ibm.etcd.api.LeaseRevokeRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getLeaseRevokeMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * LeaseTimeToLive retrieves lease information.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.ibm.etcd.api.LeaseTimeToLiveResponse> leaseTimeToLive(
        com.ibm.etcd.api.LeaseTimeToLiveRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getLeaseTimeToLiveMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * LeaseLeases lists all existing leases.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.ibm.etcd.api.LeaseLeasesResponse> leaseLeases(
        com.ibm.etcd.api.LeaseLeasesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getLeaseLeasesMethodHelper(), getCallOptions()), request);
    }
  }

  private static final int METHODID_LEASE_GRANT = 0;
  private static final int METHODID_LEASE_REVOKE = 1;
  private static final int METHODID_LEASE_TIME_TO_LIVE = 2;
  private static final int METHODID_LEASE_LEASES = 3;
  private static final int METHODID_LEASE_KEEP_ALIVE = 4;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final LeaseImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(LeaseImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LEASE_GRANT:
          serviceImpl.leaseGrant((com.ibm.etcd.api.LeaseGrantRequest) request,
              (io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseGrantResponse>) responseObserver);
          break;
        case METHODID_LEASE_REVOKE:
          serviceImpl.leaseRevoke((com.ibm.etcd.api.LeaseRevokeRequest) request,
              (io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseRevokeResponse>) responseObserver);
          break;
        case METHODID_LEASE_TIME_TO_LIVE:
          serviceImpl.leaseTimeToLive((com.ibm.etcd.api.LeaseTimeToLiveRequest) request,
              (io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseTimeToLiveResponse>) responseObserver);
          break;
        case METHODID_LEASE_LEASES:
          serviceImpl.leaseLeases((com.ibm.etcd.api.LeaseLeasesRequest) request,
              (io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseLeasesResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LEASE_KEEP_ALIVE:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.leaseKeepAlive(
              (io.grpc.stub.StreamObserver<com.ibm.etcd.api.LeaseKeepAliveResponse>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class LeaseBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    LeaseBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.ibm.etcd.api.Rpc.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Lease");
    }
  }

  private static final class LeaseFileDescriptorSupplier
      extends LeaseBaseDescriptorSupplier {
    LeaseFileDescriptorSupplier() {}
  }

  private static final class LeaseMethodDescriptorSupplier
      extends LeaseBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    LeaseMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (LeaseGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new LeaseFileDescriptorSupplier())
              .addMethod(getLeaseGrantMethodHelper())
              .addMethod(getLeaseRevokeMethodHelper())
              .addMethod(getLeaseKeepAliveMethodHelper())
              .addMethod(getLeaseTimeToLiveMethodHelper())
              .addMethod(getLeaseLeasesMethodHelper())
              .build();
        }
      }
    }
    return result;
  }
}
