/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client.lease;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.ibm.etcd.api.LeaseGrantRequest;
import com.ibm.etcd.api.LeaseGrantResponse;
import com.ibm.etcd.api.LeaseGrpc;
import com.ibm.etcd.api.LeaseKeepAliveRequest;
import com.ibm.etcd.api.LeaseKeepAliveResponse;
import com.ibm.etcd.api.LeaseLeasesRequest;
import com.ibm.etcd.api.LeaseLeasesResponse;
import com.ibm.etcd.api.LeaseRevokeRequest;
import com.ibm.etcd.api.LeaseRevokeResponse;
import com.ibm.etcd.api.LeaseTimeToLiveRequest;
import com.ibm.etcd.api.LeaseTimeToLiveResponse;
import com.ibm.etcd.client.GrpcClient;
import com.ibm.etcd.client.lease.LeaseClient;
import com.ibm.etcd.client.lease.PersistentLease;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdLeaseClient
implements LeaseClient,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(EtcdLeaseClient.class);
    private static final MethodDescriptor<LeaseGrantRequest, LeaseGrantResponse> METHOD_LEASE_GRANT = LeaseGrpc.getLeaseGrantMethod();
    private static final MethodDescriptor<LeaseRevokeRequest, LeaseRevokeResponse> METHOD_LEASE_REVOKE = LeaseGrpc.getLeaseRevokeMethod();
    private static final MethodDescriptor<LeaseTimeToLiveRequest, LeaseTimeToLiveResponse> METHOD_LEASE_TIME_TO_LIVE = LeaseGrpc.getLeaseTimeToLiveMethod();
    private static final MethodDescriptor<LeaseKeepAliveRequest, LeaseKeepAliveResponse> METHOD_LEASE_KEEP_ALIVE = LeaseGrpc.getLeaseKeepAliveMethod();
    private static final MethodDescriptor<LeaseLeasesRequest, LeaseLeasesResponse> METHOD_LEASE_LEASES = LeaseGrpc.getLeaseLeasesMethod();
    private final GrpcClient client;
    private final ScheduledExecutorService ses;
    private volatile boolean closed;
    protected static final int MIN_MIN_EXPIRY_SECS = 2;
    protected static final int MIN_INTERVAL_SECS = 4;
    protected static final int DEFAULT_MIN_EXPIRY_SECS = 10;
    protected static final int DEFAULT_INTERVAL_SECS = 5;
    protected final LeaseKeepAliveRequest.Builder KAR_BUILDER = LeaseKeepAliveRequest.newBuilder();
    protected StreamObserver<LeaseKeepAliveRequest> kaReqStream;
    protected final Executor kaReqExecutor;
    protected final Executor respExecutor;
    protected final Set<LeaseRecord> allLeases = ConcurrentHashMap.newKeySet();
    protected final ConcurrentMap<Long, LeaseRecord> leaseMap = new ConcurrentHashMap<Long, LeaseRecord>();
    protected final AtomicInteger leaseCount = new AtomicInteger();
    boolean streamEstablished = false;
    protected final GrpcClient.ResilientResponseObserver<LeaseKeepAliveRequest, LeaseKeepAliveResponse> responseObserver = new GrpcClient.ResilientResponseObserver<LeaseKeepAliveRequest, LeaseKeepAliveResponse>(){

        @Override
        public void onEstablished() {
            EtcdLeaseClient.this.streamEstablished = true;
            for (LeaseRecord rec : EtcdLeaseClient.this.allLeases) {
                rec.reconnected();
            }
        }

        @Override
        public void onReplaced(StreamObserver<LeaseKeepAliveRequest> newStream) {
            EtcdLeaseClient.this.streamEstablished = false;
            EtcdLeaseClient.this.kaReqExecutor.execute(() -> {
                EtcdLeaseClient.this.kaReqStream = newStream;
            });
            for (LeaseRecord rec : EtcdLeaseClient.this.allLeases) {
                rec.connectionLost();
            }
        }

        public void onNext(LeaseKeepAliveResponse lkar) {
            LeaseRecord rec = (LeaseRecord)EtcdLeaseClient.this.leaseMap.get(lkar.getID());
            if (rec != null) {
                rec.processKeepAliveResponse(lkar);
            }
        }

        public void onError(Throwable t) {
            EtcdLeaseClient.this.streamEstablished = false;
            EtcdLeaseClient.this.kaReqExecutor.execute(() -> {
                StreamObserver<LeaseKeepAliveRequest> stream = EtcdLeaseClient.this.kaReqStream;
                if (stream != null) {
                    EtcdLeaseClient.this.kaReqStream.onError(t);
                }
            });
        }

        public void onCompleted() {
            EtcdLeaseClient.this.streamEstablished = false;
        }
    };

    public EtcdLeaseClient(GrpcClient client) {
        this.client = client;
        this.ses = client.getInternalExecutor();
        this.kaReqExecutor = GrpcClient.serialized(this.ses, 0);
        this.respExecutor = GrpcClient.serialized(this.ses, 0);
    }

    @Override
    public ListenableFuture<LeaseGrantResponse> create(long leaseId, long ttlSecs) {
        return this.client.call(METHOD_LEASE_GRANT, LeaseGrantRequest.newBuilder().setID(leaseId).setTTL(ttlSecs).build(), false);
    }

    @Override
    public ListenableFuture<LeaseRevokeResponse> revoke(long leaseId) {
        return this.client.call(METHOD_LEASE_REVOKE, LeaseRevokeRequest.newBuilder().setID(leaseId).build(), false);
    }

    @Override
    public ListenableFuture<LeaseTimeToLiveResponse> ttl(long leaseId, boolean includeKeys) {
        return this.client.call(METHOD_LEASE_TIME_TO_LIVE, LeaseTimeToLiveRequest.newBuilder().setID(leaseId).setKeys(includeKeys).build(), true);
    }

    @Override
    public ListenableFuture<LeaseKeepAliveResponse> keepAliveOnce(long leaseId) {
        throw new UnsupportedOperationException("coming soon");
    }

    @Override
    public ListenableFuture<LeaseLeasesResponse> list() {
        return this.client.call(METHOD_LEASE_LEASES, LeaseLeasesRequest.getDefaultInstance(), true);
    }

    @Override
    public LeaseClient.FluentMaintainRequest maintain() {
        return new LeaseClient.FluentMaintainRequest(){
            private long id;
            private int intervalSecs = 5;
            private int minTtlSecs = 10;
            private boolean permanent;
            private Executor executor;

            @Override
            public LeaseClient.FluentMaintainRequest leaseId(long leaseId) {
                if (leaseId < 0L) {
                    throw new IllegalArgumentException("invalid leaseId " + leaseId);
                }
                this.id = leaseId;
                return this;
            }

            @Override
            public LeaseClient.FluentMaintainRequest keepAliveFreq(int frequencySecs) {
                if (frequencySecs < 4) {
                    throw new IllegalArgumentException("invalid keep-alive freq " + frequencySecs);
                }
                this.intervalSecs = frequencySecs;
                return this;
            }

            @Override
            public LeaseClient.FluentMaintainRequest minTtl(int minTtlSecs) {
                if (minTtlSecs < 2) {
                    throw new IllegalArgumentException("invalid min expiry " + minTtlSecs);
                }
                this.minTtlSecs = minTtlSecs;
                return this;
            }

            @Override
            public LeaseClient.FluentMaintainRequest executor(Executor executor) {
                this.executor = executor;
                return this;
            }

            @Override
            public LeaseClient.FluentMaintainRequest permanent() {
                this.permanent = true;
                return this;
            }

            @Override
            public PersistentLease start(StreamObserver<PersistentLease.LeaseState> observer) {
                return EtcdLeaseClient.this.newPersisentLease(this.id, this.minTtlSecs, this.intervalSecs, observer, this.executor, this.permanent);
            }

            @Override
            public PersistentLease start() {
                return this.start(null);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PersistentLease newPersisentLease(long leaseId, int minExpirySecs, int keepAliveFreqSecs, StreamObserver<PersistentLease.LeaseState> observer, Executor executor, boolean protect) {
        LeaseRecord rec;
        if (this.closed) {
            throw new IllegalStateException("client closed");
        }
        LeaseRecord leaseRecord = rec = !protect ? new LeaseRecord(leaseId, minExpirySecs, keepAliveFreqSecs, observer, executor) : new ProtectedLeaseRecord(leaseId, minExpirySecs, keepAliveFreqSecs, observer, executor);
        if (leaseId != 0L && this.leaseMap.putIfAbsent(leaseId, rec) != null) {
            throw new IllegalStateException("duplicate lease id");
        }
        boolean ok = false;
        try {
            if (this.leaseCount.getAndIncrement() == 0) {
                this.kaReqExecutor.execute(() -> {
                    this.kaReqStream = this.client.callStream(METHOD_LEASE_KEEP_ALIVE, this.responseObserver, this.respExecutor);
                });
            }
            this.respExecutor.execute(() -> rec.start(this.streamEstablished));
            ok = true;
        }
        finally {
            if (!ok) {
                this.leaseMap.remove(leaseId, rec);
            }
        }
        return rec;
    }

    protected void leaseClosed(LeaseRecord rec) {
        this.allLeases.remove(rec);
        if (rec.leaseId != 0L) {
            this.leaseMap.remove(rec.leaseId, rec);
        }
        if (this.leaseCount.decrementAndGet() == 0) {
            this.kaReqExecutor.execute(() -> {
                this.kaReqStream.onCompleted();
                this.kaReqStream = null;
            });
        }
    }

    protected void sendKeepAlive(long leaseId) {
        this.kaReqExecutor.execute(() -> {
            StreamObserver<LeaseKeepAliveRequest> stream = this.kaReqStream;
            if (stream != null) {
                stream.onNext((Object)this.KAR_BUILDER.setID(leaseId).build());
            }
        });
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (LeaseRecord rec : this.allLeases) {
            rec.doClose();
        }
    }

    class ProtectedLeaseRecord
    extends LeaseRecord {
        public ProtectedLeaseRecord(long leaseId, int minExpirySecs, int intervalSecs, StreamObserver<PersistentLease.LeaseState> observer, Executor executor) {
            super(leaseId, minExpirySecs, intervalSecs, observer, executor);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public void close() {
        }
    }

    class LeaseRecord
    extends AbstractFuture<Long>
    implements PersistentLease {
        final CopyOnWriteArrayList<StreamObserver<PersistentLease.LeaseState>> observers;
        final Executor eventLoop;
        ListenableFuture<LeaseGrantResponse> createFuture;
        final int intervalSecs;
        final int minExpirySecs;
        long leaseId;
        long keepAliveTtlSecs = -1L;
        long expiryTimeMs = -1L;
        boolean connected;
        PersistentLease.LeaseState state = PersistentLease.LeaseState.PENDING;

        public LeaseRecord(long leaseId, int minExpirySecs, int intervalSecs, StreamObserver<PersistentLease.LeaseState> observer, Executor executor) {
            this.minExpirySecs = minExpirySecs;
            this.intervalSecs = intervalSecs;
            this.leaseId = leaseId;
            this.observers = observer == null ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<StreamObserver<PersistentLease.LeaseState>>(Collections.singletonList(observer));
            this.eventLoop = GrpcClient.serialized(executor != null ? executor : EtcdLeaseClient.this.client.getResponseExecutor(), 0);
        }

        @Override
        public void addStateObserver(StreamObserver<PersistentLease.LeaseState> observer, boolean publishInit) {
            if (publishInit) {
                this.eventLoop.execute(() -> {
                    this.observers.add(observer);
                    this.callObserverOnNext(observer, this.state);
                });
            } else {
                this.observers.add(observer);
            }
        }

        @Override
        public void removeStateObserver(StreamObserver<PersistentLease.LeaseState> observer) {
            this.observers.remove(observer);
        }

        private boolean callObserverOnNext(StreamObserver<PersistentLease.LeaseState> observer, PersistentLease.LeaseState state) {
            try {
                observer.onNext((Object)state);
            }
            catch (RuntimeException e) {
                logger.warn("state observer onNext(" + (Object)((Object)state) + ") method threw", (Throwable)e);
                this.observers.remove(observer);
                try {
                    observer.onError((Throwable)e);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return false;
            }
            if (state == PersistentLease.LeaseState.CLOSED) {
                try {
                    observer.onCompleted();
                }
                catch (RuntimeException e) {
                    logger.warn("state observer onComplete method threw", (Throwable)e);
                }
            }
            return true;
        }

        void start(boolean connected) {
            this.connected = connected;
            if (EtcdLeaseClient.this.closed) {
                this.close();
            } else {
                EtcdLeaseClient.this.allLeases.add(this);
                this.create();
            }
        }

        void reconnected() {
            this.eventLoop.execute(() -> {
                if (this.state == PersistentLease.LeaseState.CLOSED) {
                    return;
                }
                this.connected = true;
                if (this.createFuture != null) {
                    return;
                }
                if (this.leaseId == 0L || this.state == PersistentLease.LeaseState.PENDING || this.state == PersistentLease.LeaseState.EXPIRED) {
                    this.create();
                } else {
                    this.sendKeepAliveIfNeeded();
                    this.changeState(PersistentLease.LeaseState.ACTIVE);
                }
            });
        }

        private void processGrantResponse(LeaseGrantResponse lgr) {
            if (this.leaseId == 0L) {
                this.leaseId = lgr.getID();
                EtcdLeaseClient.this.leaseMap.put(this.leaseId, this);
            }
            this.processTtlFromServer(lgr.getTTL());
        }

        void processKeepAliveResponse(LeaseKeepAliveResponse lkar) {
            this.eventLoop.execute(() -> this.processTtlFromServer(lkar.getTTL()));
        }

        private void processTtlFromServer(long newTtl) {
            if (this.state == PersistentLease.LeaseState.CLOSED) {
                return;
            }
            if (newTtl <= 0L) {
                this.expiryTimeMs = 0L;
                this.keepAliveTtlSecs = 0L;
                this.changeState(PersistentLease.LeaseState.EXPIRED);
                this.create();
            } else {
                this.updateKeepAlive(newTtl);
                this.changeState(PersistentLease.LeaseState.ACTIVE);
            }
        }

        void connectionLost() {
            this.eventLoop.execute(() -> {
                this.connected = false;
                EtcdLeaseClient.this.ses.schedule(() -> this.eventLoop.execute(() -> {
                    if (this.connected) {
                        return;
                    }
                    long ttlSecs = this.getCurrentTtlSecs();
                    PersistentLease.LeaseState newState = ttlSecs > 0L ? PersistentLease.LeaseState.ACTIVE_NO_CONN : PersistentLease.LeaseState.EXPIRED;
                    this.changeState(newState);
                    if (ttlSecs > 0L) {
                        EtcdLeaseClient.this.ses.schedule(this::checkExpired, ttlSecs, TimeUnit.SECONDS);
                    }
                }), 1500L, TimeUnit.MILLISECONDS);
            });
        }

        void checkExpired() {
            this.eventLoop.execute(() -> {
                if (this.state != PersistentLease.LeaseState.EXPIRED && this.getCurrentTtlSecs() <= 0L) {
                    this.changeState(PersistentLease.LeaseState.EXPIRED);
                }
            });
        }

        private void changeState(PersistentLease.LeaseState targetState) {
            PersistentLease.LeaseState stateBefore = this.state;
            if (stateBefore == targetState) {
                return;
            }
            if (stateBefore == PersistentLease.LeaseState.PENDING && targetState != PersistentLease.LeaseState.ACTIVE && targetState != PersistentLease.LeaseState.CLOSED) {
                return;
            }
            if (stateBefore == PersistentLease.LeaseState.CLOSED) {
                return;
            }
            this.state = targetState;
            if (stateBefore == PersistentLease.LeaseState.PENDING && targetState == PersistentLease.LeaseState.ACTIVE) {
                this.set(this.leaseId);
            }
            if (!this.observers.isEmpty()) {
                for (StreamObserver<PersistentLease.LeaseState> observer : this.observers) {
                    this.callObserverOnNext(observer, this.state);
                }
            }
        }

        void create() {
            if (this.createFuture != null || this.state == PersistentLease.LeaseState.CLOSED) {
                return;
            }
            this.createFuture = EtcdLeaseClient.this.create(this.leaseId, this.minExpirySecs + this.intervalSecs);
            Futures.addCallback(this.createFuture, (FutureCallback)new FutureCallback<LeaseGrantResponse>(){

                public void onSuccess(LeaseGrantResponse result) {
                    LeaseRecord.this.createFuture = null;
                    if (LeaseRecord.this.state == PersistentLease.LeaseState.CLOSED) {
                        LeaseRecord.this.revoke();
                    } else {
                        LeaseRecord.this.processGrantResponse(result);
                    }
                }

                public void onFailure(Throwable t) {
                    LeaseRecord.this.createFuture = null;
                    Status.Code code = GrpcClient.codeFromThrowable(t);
                    if (LeaseRecord.this.state == PersistentLease.LeaseState.CLOSED) {
                        if (!GrpcClient.isConnectException(t)) {
                            LeaseRecord.this.revoke();
                        }
                    } else if (code == Status.Code.ALREADY_EXISTS || code == Status.Code.FAILED_PRECONDITION) {
                        LeaseRecord.this.sendKeepAliveIfNeeded();
                    } else if (LeaseRecord.this.connected) {
                        LeaseRecord.this.create();
                    }
                }
            }, (Executor)this.eventLoop);
        }

        private void updateKeepAlive(long newTtlSecs) {
            this.keepAliveTtlSecs = newTtlSecs;
            this.expiryTimeMs = System.currentTimeMillis() + 1000L * newTtlSecs;
            if (newTtlSecs <= (long)this.intervalSecs) {
                logger.warn("Keepalive ttl too short to meet target interval of " + this.intervalSecs + " for lease " + this.leaseId);
            }
            long ttNextKaSecs = Math.max((long)this.intervalSecs, newTtlSecs - (long)this.minExpirySecs);
            EtcdLeaseClient.this.ses.schedule(() -> this.eventLoop.execute(this::sendKeepAliveIfNeeded), ttNextKaSecs, TimeUnit.SECONDS);
        }

        private void sendKeepAliveIfNeeded() {
            if (this.connected && this.state != PersistentLease.LeaseState.CLOSED && this.leaseId > 0L && this.getCurrentTtlSecs() <= (long)this.minExpirySecs) {
                EtcdLeaseClient.this.sendKeepAlive(this.leaseId);
            }
        }

        protected void interruptTask() {
            this.doClose();
        }

        @Override
        public void close() {
            this.doClose();
        }

        void doClose() {
            if (this.state != PersistentLease.LeaseState.CLOSED) {
                this.eventLoop.execute(() -> {
                    if (this.state == PersistentLease.LeaseState.CLOSED) {
                        return;
                    }
                    this.changeState(PersistentLease.LeaseState.CLOSED);
                    if (this.createFuture == null) {
                        this.revoke();
                    } else {
                        this.createFuture.cancel(false);
                    }
                    EtcdLeaseClient.this.leaseClosed(this);
                    this.setException(new IllegalStateException("closed"));
                });
            }
        }

        private void revoke() {
            if (this.leaseId == 0L || this.getCurrentTtlSecs() <= 0L) {
                return;
            }
            ListenableFuture<LeaseRevokeResponse> fut = EtcdLeaseClient.this.revoke(this.leaseId);
            Futures.addCallback(fut, (v, t) -> {
                if (t == null || GrpcClient.codeFromThrowable(t) == Status.Code.NOT_FOUND) {
                    this.expiryTimeMs = 0L;
                    this.keepAliveTtlSecs = 0L;
                } else {
                    if (this.leaseId == 0L || this.getCurrentTtlSecs() <= 0L) {
                        return;
                    }
                    EtcdLeaseClient.this.ses.schedule(this::revoke, 2L, TimeUnit.SECONDS);
                }
            });
        }

        @Override
        public long getCurrentTtlSecs() {
            long expires = this.expiryTimeMs;
            if (expires <= 0L) {
                return expires;
            }
            return (expires -= System.currentTimeMillis()) < 0L ? 0L : expires / 1000L;
        }

        @Override
        public long getLeaseId() {
            return this.leaseId;
        }

        @Override
        public PersistentLease.LeaseState getState() {
            return this.state;
        }

        @Override
        public long getPreferredTtlSecs() {
            return this.minExpirySecs + this.intervalSecs;
        }

        @Override
        public long getKeepAliveTtlSecs() {
            return this.keepAliveTtlSecs;
        }
    }
}

