/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client.watch;

import com.google.protobuf.ByteString;
import com.ibm.etcd.api.Event;
import com.ibm.etcd.api.KeyValue;
import com.ibm.etcd.api.ResponseHeader;
import com.ibm.etcd.api.WatchResponse;
import com.ibm.etcd.client.kv.WatchUpdate;
import java.util.List;
import java.util.stream.Collectors;

public class EtcdWatchUpdate
implements WatchUpdate {
    private final WatchResponse response;

    EtcdWatchUpdate(WatchResponse response) {
        this.response = response;
    }

    @Override
    public ResponseHeader getHeader() {
        return this.response.getHeader();
    }

    @Override
    public List<Event> getEvents() {
        return this.response.getEventsList();
    }

    public String toString() {
        return "WatchUpdate[rev=" + this.response.getHeader().getRevision() + ",events=[" + this.getEvents().stream().map(e -> "Event[type=" + (Object)((Object)e.getType()) + ",key=" + EtcdWatchUpdate.kvToString(e.getKv()) + ",modRev=" + (e.getKv() != null ? Long.valueOf(e.getKv().getModRevision()) : "n/a") + ",prevKey=" + EtcdWatchUpdate.kvToString(e.getPrevKv()) + "]").collect(Collectors.joining(",")) + "]]";
    }

    private static String kvToString(KeyValue kv) {
        if (kv == null) {
            return null;
        }
        ByteString key = kv.getKey();
        return key != null ? key.toStringUtf8() : "null";
    }
}

