/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.Uninterruptibles;
import com.ibm.etcd.client.Condition;
import com.ibm.etcd.client.SerializingExecutor;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.Deadline;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import io.netty.util.concurrent.OrderedEventExecutor;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcClient {
    private static final Logger logger = LoggerFactory.getLogger(GrpcClient.class);
    private final long defaultTimeoutMs;
    private final Supplier<CallCredentials> refreshCreds;
    private final Predicate<Throwable> reauthRequired;
    private final ManagedChannel channel;
    protected final ListeningScheduledExecutorService ses;
    protected final Executor userExecutor;
    protected final Condition isEventThread;
    protected final boolean sendViaEventLoop;
    protected final RateLimiter immediateRetryLimiter = RateLimiter.create((double)1.0);
    private CallOptions callOptions = CallOptions.DEFAULT;
    static final RetryDecision<?> IDEMP = (t, r) -> {
        Status status = Status.fromThrowable((Throwable)t);
        Status.Code code = status != null ? status.getCode() : null;
        return code == Status.Code.UNAVAILABLE || code == Status.Code.DEADLINE_EXCEEDED || code == Status.Code.UNKNOWN && status.getDescription() != null && status.getDescription().startsWith("Channel closed");
    };
    static final RetryDecision<?> NON_IDEMP = (t, r) -> GrpcClient.codeFromThrowable(t) == Status.Code.UNAVAILABLE && GrpcClient.isConnectException(t);
    private static final StreamObserver<?> EMPTY_STREAM = new StreamObserver(){

        public void onCompleted() {
        }

        public void onError(Throwable t) {
        }

        public void onNext(Object value) {
        }
    };
    private static final Class<? extends Executor> GSE_CLASS = MoreExecutors.newSequentialExecutor((Executor)MoreExecutors.directExecutor()).getClass();

    public GrpcClient(ManagedChannel channel, Predicate<Throwable> reauthRequired, Supplier<CallCredentials> credsSupplier, ScheduledExecutorService executor, Condition isEventThread, Executor userExecutor, boolean sendViaEventLoop, long defaultTimeoutMs) {
        Preconditions.checkArgument((reauthRequired == null == (credsSupplier == null) ? 1 : 0) != 0, (Object)"must supply both or neither reauth and creds");
        this.channel = channel;
        this.refreshCreds = credsSupplier;
        this.reauthRequired = reauthRequired;
        this.ses = MoreExecutors.listeningDecorator((ScheduledExecutorService)executor);
        this.isEventThread = isEventThread;
        this.userExecutor = userExecutor;
        this.sendViaEventLoop = sendViaEventLoop;
        this.defaultTimeoutMs = defaultTimeoutMs;
    }

    @Deprecated
    public ScheduledExecutorService getExecutor() {
        return this.ses;
    }

    public ScheduledExecutorService getInternalExecutor() {
        return this.ses;
    }

    public Executor getResponseExecutor() {
        return this.userExecutor;
    }

    public void authenticateNow() {
        if (this.refreshCreds != null) {
            this.reauthenticate(this.getCallOptions());
        }
    }

    protected CallOptions getCallOptions() {
        return this.callOptions;
    }

    public static final <R> RetryDecision<R> retryDecision(boolean idempotent) {
        return idempotent ? IDEMP : NON_IDEMP;
    }

    public <ReqT, R> ListenableFuture<R> call(MethodDescriptor<ReqT, R> method, ReqT request, boolean idempotent) {
        return this.call(method, null, request, null, GrpcClient.retryDecision(idempotent), 0, false, null, 0L);
    }

    public <ReqT, R> ListenableFuture<R> call(MethodDescriptor<ReqT, R> method, ReqT request, boolean idempotent, long timeoutMillis, Executor executor) {
        return this.call(method, null, request, executor, GrpcClient.retryDecision(idempotent), 0, false, null, timeoutMillis);
    }

    public <ReqT, R> ListenableFuture<R> call(MethodDescriptor<ReqT, R> method, Condition precondition, ReqT request, Executor executor, RetryDecision<ReqT> retry, boolean backoff, Deadline deadline, long timeoutMs) {
        return this.call(method, precondition, request, executor, retry, 0, backoff, null, timeoutMs);
    }

    private <ReqT, R> ListenableFuture<R> call(MethodDescriptor<ReqT, R> method, Condition precondition, ReqT request, Executor executor, RetryDecision<ReqT> retry, int attempt, boolean backoff, Deadline deadline, long timeoutMs) {
        CallOptions callOpts;
        if (precondition != null && !precondition.satisfied()) {
            return Futures.immediateFailedFuture((Throwable)new CancellationException("precondition false"));
        }
        CallOptions baseCallOpts = this.getCallOptions();
        CallOptions callOptions = callOpts = deadline != null ? baseCallOpts.withDeadline(deadline) : baseCallOpts;
        if (executor != null) {
            callOpts = callOpts.withExecutor(executor);
        }
        return Futures.catchingAsync(this.fuCall(method, request, callOpts, timeoutMs), Exception.class, t -> {
            boolean reauth;
            if (!backoff && attempt > 0 || deadline != null && deadline.isExpired() || !(reauth = this.reauthIfRequired((Throwable)t, baseCallOpts)) && !retry.retry((Throwable)t, request)) {
                return Futures.immediateFailedFuture((Throwable)t);
            }
            if (reauth || attempt == 0 && this.immediateRetryLimiter.tryAcquire()) {
                return this.call(method, precondition, request, executor, retry, reauth ? attempt : 1, backoff, deadline, timeoutMs);
            }
            int nextAttempt = attempt > 0 ? attempt + 1 : 2;
            long delayMs = 500L * (1L << Math.min(nextAttempt - 2, 4));
            if (deadline != null && deadline.timeRemaining(TimeUnit.MILLISECONDS) < delayMs) {
                return Futures.immediateFailedFuture((Throwable)t);
            }
            return Futures.scheduleAsync(() -> this.call(method, precondition, request, executor, retry, nextAttempt, backoff, deadline, timeoutMs), (long)delayMs, (TimeUnit)TimeUnit.MILLISECONDS, (ScheduledExecutorService)this.ses);
        }, (Executor)MoreExecutors.directExecutor());
    }

    protected <ReqT, R> ListenableFuture<R> fuCall(MethodDescriptor<ReqT, R> method, ReqT request, CallOptions callOptions, long timeoutMs) {
        if (timeoutMs <= 0L) {
            timeoutMs = this.defaultTimeoutMs;
        }
        if (timeoutMs > 0L) {
            Deadline deadline = callOptions.getDeadline();
            Deadline timeoutDeadline = Deadline.after((long)timeoutMs, (TimeUnit)TimeUnit.MILLISECONDS);
            if (deadline == null || timeoutDeadline.isBefore(deadline)) {
                callOptions = callOptions.withDeadline(timeoutDeadline);
            } else if (deadline.isExpired()) {
                return Futures.immediateFailedFuture((Throwable)Status.DEADLINE_EXCEEDED.asRuntimeException());
            }
        }
        CallOptions callOpts = callOptions;
        return this.sendViaEventLoop && !this.isEventThread.satisfied() ? Futures.submitAsync(() -> this.fuCall(method, request, callOpts), (Executor)this.ses) : this.fuCall(method, request, callOpts);
    }

    protected <ReqT, R> ListenableFuture<R> fuCall(MethodDescriptor<ReqT, R> method, ReqT request, CallOptions callOptions) {
        return ClientCalls.futureUnaryCall((ClientCall)this.channel.newCall(method, callOptions), request);
    }

    protected boolean retryableStreamError(Throwable error) {
        return Status.fromThrowable((Throwable)error).getCode() != Status.Code.INVALID_ARGUMENT && !GrpcClient.causedByJavaError(error);
    }

    protected static boolean causedByJavaError(Throwable t) {
        return GrpcClient.causedBy(t, Error.class);
    }

    protected boolean reauthIfRequired(Throwable error, CallOptions callOpts) {
        if (this.reauthRequired == null || !this.reauthRequired.apply((Object)error)) {
            return false;
        }
        this.reauthenticate(callOpts);
        return true;
    }

    public static boolean isConnectException(Throwable t) {
        return GrpcClient.causedBy(t, ConnectException.class) || GrpcClient.causedBy(t, NoRouteToHostException.class);
    }

    public static Status.Code codeFromThrowable(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        return status != null ? status.getCode() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reauthenticate(CallOptions failedOpts) {
        if (this.getCallOptions() != failedOpts) {
            return;
        }
        GrpcClient grpcClient = this;
        synchronized (grpcClient) {
            CallOptions callOpts = this.getCallOptions();
            if (callOpts != failedOpts) {
                return;
            }
            this.callOptions = callOpts.withCallCredentials(this.refreshCreds.get());
        }
    }

    public <ReqT, RespT> StreamObserver<ReqT> callStream(MethodDescriptor<ReqT, RespT> method, ResilientResponseObserver<ReqT, RespT> respStream) {
        return this.callStream(method, respStream, null);
    }

    public <ReqT, RespT> StreamObserver<ReqT> callStream(MethodDescriptor<ReqT, RespT> method, ResilientResponseObserver<ReqT, RespT> respStream, Executor responseExecutor) {
        if (this.refreshCreds != null && this.getCallOptions() == CallOptions.DEFAULT) {
            this.authenticateNow();
        }
        return new ResilientBiDiStream<ReqT, RespT>(method, respStream, responseExecutor).start();
    }

    public static <T> T waitFor(Future<T> fut) {
        return GrpcClient.waitFor(fut, -1L);
    }

    public static <T> T waitFor(Future<T> fut, long timeoutMillis) {
        try {
            return timeoutMillis < 0L ? fut.get() : fut.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException e) {
            fut.cancel(true);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Status.CANCELLED.withCause((Throwable)e).asRuntimeException();
        }
        catch (ExecutionException ee) {
            throw Status.fromThrowable((Throwable)ee.getCause()).asRuntimeException();
        }
        catch (TimeoutException te) {
            fut.cancel(true);
            throw Status.DEADLINE_EXCEEDED.withCause((Throwable)te).withDescription("local timeout of " + timeoutMillis + "ms exceeded").asRuntimeException();
        }
        catch (RuntimeException rte) {
            fut.cancel(true);
            throw Status.fromThrowable((Throwable)rte).asRuntimeException();
        }
    }

    public static <T> T waitFor(Function<Executor, Future<T>> asyncCall) {
        ThreadlessExecutor exec = new ThreadlessExecutor();
        Future<T> fut = asyncCall.apply(exec);
        while (!fut.isDone()) {
            try {
                exec.waitAndDrain();
            }
            catch (InterruptedException ie) {
                fut.cancel(true);
                Thread.currentThread().interrupt();
                throw Status.CANCELLED.withCause((Throwable)ie).asRuntimeException();
            }
        }
        try {
            return (T)Uninterruptibles.getUninterruptibly(fut);
        }
        catch (CancellationException e) {
            fut.cancel(true);
            throw Status.CANCELLED.withCause((Throwable)e).asRuntimeException();
        }
        catch (ExecutionException ee) {
            throw Status.fromThrowable((Throwable)ee.getCause()).asRuntimeException();
        }
        catch (RuntimeException rte) {
            fut.cancel(true);
            throw Status.fromThrowable((Throwable)rte).asRuntimeException();
        }
    }

    protected static void closeStream(StreamObserver<?> stream, Throwable err) {
        if (err == null) {
            stream.onCompleted();
        } else {
            stream.onError(err);
        }
    }

    protected static <ReqT> StreamObserver<ReqT> emptyStream() {
        return EMPTY_STREAM;
    }

    protected static <T> Predicate<T> constantPredicate(boolean val) {
        return val ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    protected static boolean contains(String str, String subStr) {
        return str != null && str.contains(subStr);
    }

    public static boolean causedBy(Throwable t, Class<? extends Throwable> exClass) {
        return t != null && (exClass.isAssignableFrom(t.getClass()) || GrpcClient.causedBy(t.getCause(), exClass));
    }

    public static <I> I sentinel(Class<I> intface) {
        return (I)Proxy.newProxyInstance(intface.getClassLoader(), new Class[]{intface}, (p, m, a) -> {
            if ("toString".equals(m.getName())) {
                return "SENTINEL";
            }
            if ("hashCode".equals(m.getName())) {
                return System.identityHashCode(p);
            }
            if ("equals".equals(m.getName())) {
                return a[0] == p;
            }
            throw new IllegalStateException("attempt to invoke sentinel");
        });
    }

    public static Executor serialized(Executor parent) {
        return GrpcClient.serialized(parent, 0);
    }

    public static Executor serialized(Executor parent, int bufferSize) {
        return parent instanceof SerializingExecutor || parent instanceof io.grpc.internal.SerializingExecutor || parent instanceof OrderedEventExecutor || GSE_CLASS.isAssignableFrom(parent.getClass()) ? parent : new SerializingExecutor(parent, bufferSize);
    }

    private static final class ThreadlessExecutor
    extends LinkedBlockingQueue<Runnable>
    implements Executor {
        private static final Logger logger = LoggerFactory.getLogger(ThreadlessExecutor.class);

        ThreadlessExecutor() {
        }

        public void waitAndDrain() throws InterruptedException {
            Runnable runnable = (Runnable)this.take();
            while (runnable != null) {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                    logger.warn("Runnable threw exception", t);
                }
                runnable = (Runnable)this.poll();
            }
        }

        @Override
        public void execute(Runnable runnable) {
            this.add(runnable);
        }
    }

    class ResilientBiDiStream<ReqT, RespT> {
        private final MethodDescriptor<ReqT, RespT> method;
        private final ResilientResponseObserver<ReqT, RespT> respStream;
        private final Executor responseExecutor;
        private final Executor requestExecutor;
        private CallOptions sentCallOptions;
        private int errCounter = 0;
        private RequestSubStream userReqStream;
        private boolean finished;
        private Throwable error;
        private final StreamObserver<RespT> respWrapper = new ClientResponseObserver<ReqT, RespT>(){

            public void beforeStart(ClientCallStreamObserver<ReqT> rs) {
                rs.setOnReadyHandler(() -> {
                    if (rs.isReady()) {
                        ResilientBiDiStream.this.errCounter = 0;
                        boolean notify = ResilientBiDiStream.this.userReqStream.established(rs);
                        if (notify) {
                            ResilientBiDiStream.this.respStream.onEstablished();
                        }
                    }
                });
            }

            public void onNext(RespT value) {
                ResilientBiDiStream.this.respStream.onNext(value);
            }

            public void onError(Throwable t) {
                boolean finalError;
                boolean reauthed = false;
                if (ResilientBiDiStream.this.finished) {
                    finalError = true;
                } else {
                    reauthed = GrpcClient.this.reauthIfRequired(t, ResilientBiDiStream.this.sentCallOptions);
                    boolean bl = finalError = !reauthed && !GrpcClient.this.retryableStreamError(t);
                }
                if (!finalError) {
                    int errCount = ++ResilientBiDiStream.this.errCounter;
                    String msg = "retryable onError #" + errCount + " on underlying stream of method " + ResilientBiDiStream.this.method.getFullMethodName();
                    if (logger.isDebugEnabled()) {
                        logger.info(msg, t);
                    } else {
                        logger.info(msg + ": " + t.getClass().getName() + ": " + t.getMessage());
                    }
                    RequestSubStream userStreamBefore = ResilientBiDiStream.this.userReqStream;
                    if (userStreamBefore.isEstablished()) {
                        ResilientBiDiStream.this.userReqStream = new RequestSubStream();
                        userStreamBefore.discard(null);
                        ResilientBiDiStream.this.respStream.onReplaced(ResilientBiDiStream.this.userReqStream);
                    } else if (ResilientBiDiStream.this.initialReqStream != null) {
                        ResilientBiDiStream.this.initialReqStream.onError(t);
                        ResilientBiDiStream.this.initialReqStream = null;
                    }
                    if (reauthed || errCount <= 1 && GrpcClient.this.immediateRetryLimiter.tryAcquire()) {
                        ResilientBiDiStream.this.refreshBackingStream();
                    } else {
                        if (errCount == 1) {
                            ++errCount;
                        }
                        long delay = 500L + (errCount == 2 ? ThreadLocalRandom.current().nextLong(500L) : 2000L * (long)(1 << Math.min(errCount - 3, 2)));
                        GrpcClient.this.ses.schedule(() -> ResilientBiDiStream.this.refreshBackingStream(), delay, TimeUnit.MILLISECONDS);
                    }
                } else {
                    ResilientBiDiStream.this.sentCallOptions = null;
                    ResilientBiDiStream.this.userReqStream.discard(t);
                    ResilientBiDiStream.this.respStream.onError(t);
                }
            }

            public void onCompleted() {
                if (!ResilientBiDiStream.this.finished) {
                    logger.warn("Unexpected onCompleted received for stream of method " + ResilientBiDiStream.this.method.getFullMethodName());
                }
                ResilientBiDiStream.this.sentCallOptions = null;
                ResilientBiDiStream.this.userReqStream.discard(null);
                ResilientBiDiStream.this.respStream.onCompleted();
            }
        };
        private StreamObserver<ReqT> initialReqStream;

        public ResilientBiDiStream(MethodDescriptor<ReqT, RespT> method, ResilientResponseObserver<ReqT, RespT> respStream, Executor responseExecutor) {
            this.method = method;
            this.respStream = respStream;
            this.responseExecutor = GrpcClient.serialized(responseExecutor != null ? responseExecutor : GrpcClient.this.userExecutor);
            this.requestExecutor = !GrpcClient.this.sendViaEventLoop ? null : GrpcClient.serialized((Executor)GrpcClient.this.ses);
        }

        StreamObserver<ReqT> start() {
            RequestSubStream firstStream;
            this.userReqStream = firstStream = new RequestSubStream();
            this.responseExecutor.execute(this::refreshBackingStream);
            return firstStream;
        }

        private void onFinish(Throwable err) {
            if (this.finished) {
                return;
            }
            this.responseExecutor.execute(() -> {
                if (this.finished) {
                    return;
                }
                if (err == null || GrpcClient.this.reauthRequired == null || !GrpcClient.this.reauthRequired.apply((Object)err)) {
                    this.error = err;
                    this.finished = true;
                }
                this.userReqStream.close(err, true);
            });
        }

        private void refreshBackingStream() {
            CallOptions callOpts;
            if (this.finished) {
                return;
            }
            this.sentCallOptions = callOpts = GrpcClient.this.getCallOptions();
            callOpts = callOpts.withExecutor(this.responseExecutor);
            this.initialReqStream = ClientCalls.asyncBidiStreamingCall((ClientCall)GrpcClient.this.channel.newCall(this.method, callOpts), this.respWrapper);
        }

        class RequestSubStream
        implements StreamObserver<ReqT> {
            private volatile StreamObserver<ReqT> grpcReqStream;
            private Queue<ReqT> preConnectBuffer;

            RequestSubStream() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(ReqT value) {
                if (ResilientBiDiStream.this.finished) {
                    return;
                }
                StreamObserver rs = this.grpcReqStream;
                if (rs == null) {
                    RequestSubStream requestSubStream = this;
                    synchronized (requestSubStream) {
                        rs = this.grpcReqStream;
                        if (rs == null) {
                            if (this.preConnectBuffer == null) {
                                this.preConnectBuffer = new ArrayDeque(8);
                            }
                            this.preConnectBuffer.add(value);
                            return;
                        }
                    }
                }
                if (ResilientBiDiStream.this.requestExecutor == null) {
                    this.sendOnNext(rs, value);
                } else {
                    StreamObserver rsFinal = rs;
                    ResilientBiDiStream.this.requestExecutor.execute(() -> this.sendOnNext(rsFinal, value));
                }
            }

            private void sendOnNext(StreamObserver<ReqT> reqStream, ReqT value) {
                block2: {
                    try {
                        reqStream.onNext(value);
                    }
                    catch (IllegalStateException ise) {
                        if (this.grpcReqStream == GrpcClient.emptyStream()) break block2;
                        throw ise;
                    }
                }
            }

            public void onError(Throwable t) {
                ResilientBiDiStream.this.onFinish(t);
            }

            public void onCompleted() {
                ResilientBiDiStream.this.onFinish(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean established(StreamObserver<ReqT> stream) {
                StreamObserver curStream = this.grpcReqStream;
                if (curStream == null) {
                    RequestSubStream requestSubStream = this;
                    synchronized (requestSubStream) {
                        Queue pcb = this.preConnectBuffer;
                        if (pcb != null) {
                            Object req;
                            while ((req = pcb.poll()) != null) {
                                stream.onNext(req);
                            }
                            this.preConnectBuffer = null;
                        }
                        ResilientBiDiStream.this.initialReqStream = null;
                        if (!ResilientBiDiStream.this.finished) {
                            this.grpcReqStream = stream;
                            return true;
                        }
                        this.grpcReqStream = GrpcClient.emptyStream();
                    }
                } else if (stream == curStream) {
                    return false;
                }
                if (!ResilientBiDiStream.this.finished) {
                    logger.info("Closing unexpected new stream of method " + ResilientBiDiStream.this.method.getFullMethodName());
                }
                GrpcClient.closeStream(stream, ResilientBiDiStream.this.error);
                return false;
            }

            boolean isEstablished() {
                return this.grpcReqStream != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void discard(Throwable err) {
                StreamObserver curStream = this.grpcReqStream;
                StreamObserver empty = GrpcClient.emptyStream();
                if (curStream == empty) {
                    return;
                }
                if (curStream == null) {
                    RequestSubStream requestSubStream = this;
                    synchronized (requestSubStream) {
                        this.grpcReqStream = empty;
                        this.preConnectBuffer = null;
                    }
                } else {
                    this.close(err, false);
                }
            }

            void close(Throwable err, boolean fromUser) {
                StreamObserver curStream = this.grpcReqStream;
                StreamObserver empty = GrpcClient.emptyStream();
                if (curStream == null || curStream == empty) {
                    return;
                }
                this.grpcReqStream = empty;
                if (fromUser) {
                    GrpcClient.closeStream(curStream, err);
                } else {
                    Runnable closeTask = () -> GrpcClient.closeStream(curStream, err);
                    if (ResilientBiDiStream.this.requestExecutor != null) {
                        ResilientBiDiStream.this.requestExecutor.execute(closeTask);
                    } else {
                        GrpcClient.this.ses.schedule(closeTask, 400L, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }
    }

    public static interface ResilientResponseObserver<ReqT, RespT>
    extends StreamObserver<RespT> {
        public void onEstablished();

        public void onReplaced(StreamObserver<ReqT> var1);
    }

    public static interface RetryDecision<ReqT> {
        public boolean retry(Throwable var1, ReqT var2);
    }
}

