/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.connect;

import com.ibm.ims.connect.ApiProperties;
import com.ibm.ims.connect.ImsConnectApiException;
import com.ibm.ims.connect.ImsConnectErrorMessage;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class ApiLoggingConfiguration {
    private static final String copyright = "Licensed Material - Property of IBM 5655-TDA(C) Copyright IBM Corp. 2009,2015  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  ";
    private Logger logger;
    private Handler loggerFileHandler;
    private Level loggerLevel;
    private String loggerTraceFileName;
    private SimpleFormatter mySimpleFormatter;
    private boolean loggerAppendMode = false;
    private int loggerFileLimit = 0;
    private int loggerFileCount = 1;
    private static final String sdf = "EEE, MMM dd yyyy, HH.mm.ss.SSS z";
    private static final DateFormat df = new SimpleDateFormat("EEE, MMM dd yyyy, HH.mm.ss.SSS z");
    private static final String lBracket = "[";
    private static final String rBracket = "] ";
    private static final String blank = " ";
    private static final String newLine = System.getProperty("line.separator");
    private static final String version = "3.1.0.8";
    private static final String build = "2015_03_31_2029 ";
    private int i;

    public Logger configureApiLogging(String aTraceFileName, Level aLevel) throws ImsConnectApiException {
        this.loggerTraceFileName = aTraceFileName;
        this.loggerLevel = aLevel;
        this.mySimpleFormatter = new SimpleFormatter(){

            @Override
            public String format(LogRecord record) {
                long threadId = Thread.currentThread().getId();
                StringBuffer sb = new StringBuffer();
                sb.append(df.format(new Date(record.getMillis()))).append(ApiLoggingConfiguration.blank);
                sb.append(ApiLoggingConfiguration.lBracket).append("Thread # : " + threadId).append(ApiLoggingConfiguration.rBracket);
                sb.append(ApiLoggingConfiguration.lBracket).append(record.getLevel().getName()).append(ApiLoggingConfiguration.rBracket);
                sb.append(this.formatMessage(record)).append(newLine);
                return sb.toString();
            }
        };
        this.setLoggerFileHandler();
        this.logger.setLevel(aLevel);
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            this.logger.finest("   configureApiLogging() - Trace log now open for IMS Connect API version [3.1.0.8], build [2015_03_31_2029 ]");
        }
        return this.logger;
    }

    private void setLoggerFileHandler() throws ImsConnectApiException {
        try {
            this.logger = Logger.getLogger("com.ibm.ims.connect");
            Handler[] handlers = this.logger.getHandlers();
            this.i = 0;
            while (this.i < handlers.length) {
                if (handlers[this.i].getClass() == FileHandler.class) break;
                ++this.i;
            }
            if (this.i < handlers.length) {
                this.logger.removeHandler(handlers[this.i]);
            }
            this.loggerFileHandler = new FileHandler(this.loggerTraceFileName, this.getLoggerFileLimit(), this.getLoggerFileCount(), this.isLoggerAppendModeEnabled());
            this.loggerFileHandler.setFormatter(this.mySimpleFormatter);
            this.loggerFileHandler.setLevel(this.loggerLevel);
            this.loggerFileHandler.setEncoding("UTF-8");
            this.logger.addHandler(this.loggerFileHandler);
        }
        catch (IOException e) {
            String fileTypeString = ImsConnectErrorMessage.getString("TRACE_FILE");
            String errMsg = ImsConnectErrorMessage.getString("HWS0002E", new Object[]{fileTypeString, this.loggerTraceFileName, e});
            ImsConnectApiException newExc = new ImsConnectApiException("HWS0002E", errMsg);
            throw newExc;
        }
    }

    public static String getBuild() {
        return build;
    }

    public static String getVersion() {
        return version;
    }

    public Level getLoggerLevel() {
        return this.loggerLevel;
    }

    public String getLoggerTraceFileName() {
        return this.loggerTraceFileName;
    }

    public void setLoggerLevel(Level aLevel) throws ImsConnectApiException {
        this.loggerLevel = aLevel;
        this.setLoggerFileHandler();
        this.logger.setLevel(aLevel);
    }

    public void setLoggerTraceFileName(String aTraceFileName) throws ImsConnectApiException {
        this.loggerTraceFileName = aTraceFileName;
        this.setLoggerFileHandler();
    }

    public void setLoggerToAppendMode(boolean aBooleanAppendValue) {
        this.loggerAppendMode = aBooleanAppendValue;
    }

    public boolean isLoggerAppendModeEnabled() {
        return this.loggerAppendMode;
    }

    public void setLoggerFileLimit(int aLimitValue) {
        this.loggerFileLimit = aLimitValue;
    }

    public int getLoggerFileLimit() {
        return this.loggerFileLimit;
    }

    public void setLoggerFileCount(int aCountValue) {
        this.loggerFileCount = aCountValue;
    }

    public int getLoggerFileCount() {
        return this.loggerFileCount;
    }

    public Handler getLoggerFileHandler() {
        return this.loggerFileHandler;
    }
}

