/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.connect;

import com.ibm.ims.connect.ApiProperties;
import com.ibm.ims.connect.Connection;
import com.ibm.ims.connect.ImsConnectApiException;
import com.ibm.ims.connect.ImsConnectErrorMessage;
import com.ibm.ims.connect.PropertiesFileLoader;
import com.ibm.ims.connect.impl.ConnectionImpl;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;

public final class ConnectionFactory
implements ApiProperties {
    private static final String copyright = "Licensed Material - Property of IBM 5655-TDA(C) Copyright IBM Corp. 2009, 2013  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private Logger logger;
    private static String traceFileName;
    private String hostName = "HOSTNAME";
    private int portNumber = 9999;
    private byte socketType = (byte)16;
    private String clientId = "        ";
    private byte sslEncryptionType = 1;
    private InputStream sslKeystoreInputStream = ApiProperties.DEFAULT_SSL_KEYSTORE_INPUT_STREAM;
    private URL sslKeystoreUrl = ApiProperties.DEFAULT_SSL_KEYSTORE_URL;
    private String sslKeystoreName = ApiProperties.DEFAULT_SSL_KEYSTORE_NAME;
    private String sslKeystorePassword = "keystrPw";
    private InputStream sslTruststoreInputStream = ApiProperties.DEFAULT_SSL_TRUSTSTORE_INPUT_STREAM;
    private URL sslTruststoreUrl = ApiProperties.DEFAULT_SSL_TRUSTSTORE_URL;
    private String sslTruststoreName = ApiProperties.DEFAULT_SSL_TRUSTSTORE_NAME;
    private String sslTruststorePassword = "trststPw";
    private boolean useSslConnection = false;
    private int interactionTimeout = -1;
    private int socketConnectTimeout = -1;
    String validChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-";
    String validLetters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    static {
        String os = System.getProperty("os.name").toUpperCase();
        if (os.indexOf("WINDOWS") >= 0) {
            traceFileName = ".\\trace.log";
        } else if (os.indexOf("Z/OS") >= 0 || os.indexOf("OS/390") >= 0) {
            traceFileName = "/usr/lpp/ims/iconapi/trace.log";
        }
    }

    public ConnectionFactory() throws ImsConnectApiException {
        this.logger = Logger.getLogger("com.ibm.ims.connect");
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-> ConnectionImpl()...");
        }
    }

    public Connection getConnection() throws ImsConnectApiException {
        try {
            ConnectionImpl conn = null;
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
                this.logger.finer("--> ConnectionFactory.getConnection()...");
            }
            ConnectionImpl connectionImpl = conn = new ConnectionImpl(this);
            return connectionImpl;
        }
        finally {
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
                this.logger.finer("<-- ConnectionFactory.getConnection()...");
            }
        }
    }

    public void loadConnectionFactoryAttributesFromFile(String aConnectionAttributesFileName) throws Exception {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> ConnectionFactory.loadConnectionFactoryAttributesFromFile(String)...");
        }
        PropertiesFileLoader myPropertiesFileLoader = new PropertiesFileLoader();
        myPropertiesFileLoader.loadPropertiesFile(this, aConnectionAttributesFileName);
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- ConnectionFactory.loadConnectionFactoryAttributesFromFile(String)...");
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public final void setClientId(String aClientId) throws ImsConnectApiException {
        if (PropertiesFileLoader.isValidHostStyleName(aClientId)) {
            this.clientId = aClientId.toUpperCase();
        } else if (aClientId.trim().equals("")) {
            this.clientId = "        ";
        } else {
            if (aClientId.length() > 8) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0026E", new Object[]{aClientId, "clientId", "8"});
                ImsConnectApiException e = new ImsConnectApiException("HWS0026E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in ConnectionFactory.setClientId(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"clientID", aClientId});
            ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setClientId(String). Exception thrown was: " + e.toString());
            }
            throw e;
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String aHostName) throws ImsConnectApiException {
        boolean valid = true;
        boolean ipAddress = true;
        if (this.hostName.equalsIgnoreCase(aHostName)) {
            return;
        }
        String[] result = aHostName.split("\\.");
        int numberOfNodes = result.length;
        int i = 0;
        while (i < numberOfNodes) {
            block18: {
                try {
                    int octet = Integer.parseInt(result[i]);
                    if (octet < 0 || octet > 255) {
                        valid = false;
                    }
                    break block18;
                }
                catch (Exception e) {
                    valid = false;
                    ipAddress = false;
                }
                break;
            }
            ++i;
        }
        if (valid && ipAddress && numberOfNodes != 4 && numberOfNodes != 6) {
            valid = false;
        }
        if (!ipAddress) {
            if (aHostName.length() <= 255 && this.validLetters.indexOf(aHostName.charAt(0)) != -1) {
                result = aHostName.split("\\.");
                if (numberOfNodes <= 127) {
                    valid = true;
                    i = 0;
                    while (i < numberOfNodes) {
                        int strLen = result[i].length();
                        if (strLen > 63) {
                            i = numberOfNodes;
                            int n = strLen;
                        }
                        char[] charBuf = new char[strLen];
                        result[i].getChars(0, strLen, charBuf, 0);
                        int j = 0;
                        while (j < strLen) {
                            if (this.validChars.indexOf(charBuf[j]) == -1) {
                                valid = false;
                                i = numberOfNodes;
                                j = strLen;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            } else {
                valid = false;
            }
        }
        if (!valid) {
            String validHostnameString = "";
            try {
                validHostnameString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_HOSTNAME");
            }
            catch (Exception strLen) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"hostName", aHostName, validHostnameString});
            ImsConnectApiException e1 = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in Connection.setHostName(String). Exception caught was: " + e1.toString());
            }
            throw e1;
        }
        this.hostName = aHostName;
    }

    public int getInteractionTimeout() {
        return this.interactionTimeout;
    }

    public void setInteractionTimeout(int anInteractionTimeout) throws ImsConnectApiException {
        if (anInteractionTimeout <= 0 && anInteractionTimeout != -1) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0007E", new Object[]{"ConnectionFactory.setInteractionTimeout(int)", String.valueOf(anInteractionTimeout)});
            ImsConnectApiException e = new ImsConnectApiException("HWS0007E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setInteractionTimeout(int). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.interactionTimeout = anInteractionTimeout;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int aPortNumber) throws ImsConnectApiException {
        if (aPortNumber > 0 && aPortNumber <= 65535) {
            if (this.getPortNumber() == aPortNumber) {
                return;
            }
        } else {
            String validPortNumberString = "";
            try {
                validPortNumberString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_PORTNUMBER");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"portNumber", String.valueOf(aPortNumber), validPortNumberString});
            ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setPortNumber(int).  Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.portNumber = aPortNumber;
    }

    public int getSocketConnectTimeout() {
        return this.socketConnectTimeout;
    }

    public void setSocketConnectTimeout(int aSocketConnectTimeout) throws ImsConnectApiException {
        if (aSocketConnectTimeout <= 0 && aSocketConnectTimeout != -1) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0007E", new Object[]{"ConnectionFactory.setSocketConnectTimeout(int)", aSocketConnectTimeout});
            ImsConnectApiException e = new ImsConnectApiException("HWS0007E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setSocketConnectTimeout(). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.socketConnectTimeout = aSocketConnectTimeout;
    }

    public byte getSocketType() {
        return this.socketType;
    }

    public void setSocketType(byte aSocketType) throws ImsConnectApiException {
        if (this.getSocketType() == aSocketType) {
            return;
        }
        this.socketType = aSocketType;
    }

    public byte getSslEncryptionType() {
        return this.sslEncryptionType;
    }

    public void setSslEncryptionType(byte anSslEncryptionType) throws ImsConnectApiException {
        if (this.getSslEncryptionType() == anSslEncryptionType) {
            return;
        }
        this.sslEncryptionType = anSslEncryptionType;
    }

    public InputStream getSslKeystoreInputStream() {
        return this.sslKeystoreInputStream;
    }

    public void setSslKeystoreInputStream(InputStream anSslKeystoreInputStream) {
        this.sslKeystoreInputStream = anSslKeystoreInputStream;
    }

    public URL getSslKeystoreUrl() {
        return this.sslKeystoreUrl;
    }

    public void setSslKeystoreUrl(URL anSslKeystoreUrl) {
        this.sslKeystoreUrl = anSslKeystoreUrl;
    }

    public String getSslKeystoreName() {
        return this.sslKeystoreName;
    }

    public void setSslKeystoreName(String anSslKeystoreName) throws ImsConnectApiException {
        if (this.getSslKeystoreName() == anSslKeystoreName) {
            return;
        }
        this.sslKeystoreName = anSslKeystoreName;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public void setSslKeystorePassword(String anSslKeystorePassword) throws ImsConnectApiException {
        if (this.getSslKeystoreName() == anSslKeystorePassword) {
            return;
        }
        this.sslKeystorePassword = anSslKeystorePassword;
    }

    public InputStream getSslTruststoreInputStream() {
        return this.sslTruststoreInputStream;
    }

    public void setSslTruststoreInputStream(InputStream anSslTruststoreInputStream) {
        this.sslTruststoreInputStream = anSslTruststoreInputStream;
    }

    public URL getSslTruststoreUrl() {
        return this.sslTruststoreUrl;
    }

    public void setSslTruststoreUrl(URL anSslTruststoreUrl) {
        this.sslTruststoreUrl = anSslTruststoreUrl;
    }

    public String getSslTruststoreName() {
        return this.sslTruststoreName;
    }

    public void setSslTruststoreName(String anSslTruststoreName) throws ImsConnectApiException {
        if (this.getSslTruststoreName() == anSslTruststoreName) {
            return;
        }
        this.sslTruststoreName = anSslTruststoreName;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public void setSslTruststorePassword(String anSslTruststorePassword) throws ImsConnectApiException {
        if (this.getSslKeystoreName() == anSslTruststorePassword) {
            return;
        }
        this.sslTruststorePassword = anSslTruststorePassword;
    }

    public boolean isUseSslConnection() {
        return this.useSslConnection;
    }

    public void setUseSslConnection(boolean aUseSslConnection) throws ImsConnectApiException {
        if (this.isUseSslConnection() == aUseSslConnection) {
            return;
        }
        this.useSslConnection = aUseSslConnection;
    }

    public boolean hasValue(String inStr) {
        return inStr != null & inStr.trim().length() > 0;
    }
}

