/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.connect;

public class NumberConversion {
    private static final String copyright = "Licensed Material - Property of IBM 5655-TDA(C) Copyright IBM Corp. 2010, 2013  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";

    public static int parseByteArrayToInt(byte[] byteVal, int startOffset) {
        int result = 0;
        int i = startOffset;
        while (i < startOffset + 4) {
            result = (result << 8) + (byteVal[i] & 0xFF);
            ++i;
        }
        return result;
    }

    public static short parseByteArrayToShort(byte[] byteVal, int startOffset) {
        int result = 0;
        int i = startOffset;
        while (i < startOffset + 2) {
            if (i >= byteVal.length) {
                return -1;
            }
            result = (result << 8) + (byteVal[i] & 0xFF);
            ++i;
        }
        return (short)result;
    }

    public static byte[] parseIntToByteArray(int val) {
        byte[] result = new byte[4];
        int i = 0;
        while (i < 4) {
            result[3 - i] = (byte)val;
            ++i;
            val >>= 8;
        }
        return result;
    }

    public static byte[] parseShortToByteArray(short val) {
        byte[] result = new byte[2];
        int i = 0;
        while (i < 2) {
            result[1 - i] = (byte)val;
            ++i;
            val = (short)(val >> 8);
        }
        return result;
    }
}

