/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.connect;

import com.ibm.ims.connect.ApiProperties;
import com.ibm.ims.connect.ConnectionAttributes;
import com.ibm.ims.connect.ConnectionFactory;
import com.ibm.ims.connect.ImsConnectApiException;
import com.ibm.ims.connect.ImsConnectCommunicationException;
import com.ibm.ims.connect.ImsConnectErrorMessage;
import com.ibm.ims.connect.TmInteractionAttributes;
import com.ibm.ims.connect.impl.ConnectionImpl;
import com.ibm.ims.connect.impl.TmInteractionImpl;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Logger;

public class PropertiesFileLoader {
    private static final String copyright = "Licensed Material - Property of IBM 5655-TDA(C) Copyright IBM Corp. 2009, 2013  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private int equalsPosition = -1;
    private String key = null;
    private String value = null;
    private String strVal = "";
    private String lowerValue = "";
    private String upperValue = "";
    private Boolean booleanVal;
    private byte bytVal;
    private Byte byteVal;
    private int intVal;
    private Integer integerVal;
    private String apiPropVal;
    private Class type;
    private String setMethodName;
    private Method setMethod;
    private Object callingObject;
    private Class callingObjectClass;
    private static String validSpecialCharacters = "@#$";
    private int numPropertiesSet = 0;
    private Logger logger;
    private FileInputStream fileInStream;
    private BufferedReader bufFileReader;
    private int maxLinesforReader;
    private int maxLineLen;
    private int line = 1;
    private static final int DEFAULT_API_READER__LINES_MAX = 4096;
    private static final int DEFAULT_API_READER_LINE_LENGTH_MAX = 4096;
    private static final int CARRIAGE_RETURN = 13;
    private static final int LINE_FEED = 10;

    /*
     * Unable to fully structure code
     */
    public void loadPropertiesFile(Object theCallingObject, String anAttributesFileName) throws Exception {
        this.logger = Logger.getLogger("com.ibm.ims.connect");
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> PropertiesFileLoader.loadPropertiesFile(Object, String)...");
        }
        this.callingObject = theCallingObject;
        this.callingObjectClass = theCallingObject.getClass();
        this.numPropertiesSet = 0;
        try {
            this.fileInStream = new FileInputStream(anAttributesFileName);
            this.bufFileReader = new BufferedReader(new InputStreamReader(this.fileInStream));
        }
        catch (Exception e) {
            fileTypeString = ImsConnectErrorMessage.getString("UNKNOWN_TYPE_FILE");
            try {
                if (this.callingObjectClass.equals(ConnectionImpl.class) || this.callingObjectClass.equals(ConnectionFactory.class) || this.callingObjectClass.equals(ConnectionAttributes.class)) {
                    fileTypeString = ImsConnectErrorMessage.getString("CONNECTION_PROPERTIES_FILE");
                } else if (this.callingObjectClass.equals(TmInteractionImpl.class) || this.callingObjectClass.equals(TmInteractionAttributes.class)) {
                    fileTypeString = ImsConnectErrorMessage.getString("TMINTERACTION_PROPERTIES_FILE");
                }
            }
            catch (Exception var5_9) {
                // empty catch block
            }
            errMsg = ImsConnectErrorMessage.getString("HWS0002E", new Object[]{fileTypeString, anAttributesFileName, ImsConnectErrorMessage.getExceptionMessage(e)});
            e1 = new ImsConnectCommunicationException("HWS0002E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in PropertiesFileLoader.loadPropertiesFile(Object, String). Exception thrown was: " + e1.toString());
            }
            throw e;
        }
        try {
            i = 0;
            line = this.readLine(this.bufFileReader);
            ++i;
            while (line != null) {
                block91: {
                    slash_star_pos = line.indexOf("/*");
                    star_slash_pos = line.indexOf("*/");
                    ** GOTO lbl50
                    {
                        nextLine = this.readLine(this.bufFileReader);
                        ++i;
                        if (nextLine == null) {
                            errMsg = ImsConnectErrorMessage.getString("HWS0032E", new Object[]{anAttributesFileName, i, slash_star_pos});
                            e = new ImsConnectApiException("HWS0032E", errMsg);
                            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                this.logger.severe("    Exception caught in PropertiesFileLoader.loadPropertiesFile(Object, String).  Exception caught was: " + e.toString());
                            }
                            throw e;
                        }
                        line = String.valueOf(line) + nextLine;
                        star_slash_pos = line.indexOf("*/");
                        do {
                            if (slash_star_pos > -1 && star_slash_pos == -1) continue block39;
                            line = String.valueOf(line.substring(0, slash_star_pos)) + line.substring(star_slash_pos + 2);
                            slash_star_pos = line.indexOf("/*");
                            star_slash_pos = line.indexOf("*/");
lbl50:
                            // 2 sources

                        } while (slash_star_pos > -1);
                    }
                    slash_slash_pos = line.indexOf("//");
                    if (slash_slash_pos > -1) {
                        line = line.substring(0, slash_slash_pos);
                    }
                    this.equalsPosition = line.indexOf("=");
                    if (this.equalsPosition <= -1) break block91;
                    this.key = line.substring(0, this.equalsPosition);
                    this.key = this.key.trim();
                    if (this.key.charAt(0) == '\"' || this.key.charAt(0) == '\'') {
                        this.key = this.key.substring(1);
                    }
                    if (this.key.charAt((keyLen = this.key.length()) - 1) == '\"' || this.key.charAt(keyLen - 1) == '\'') {
                        this.key = this.key.substring(0, keyLen - 2);
                    }
                    if ((keyLen = this.key.length()) != 0) {
                        try {
                            if (this.callingObjectClass.equals(ConnectionImpl.class) || theCallingObject.getClass().equals(ConnectionFactory.class)) {
                                this.type = ConnectionImpl.class.getDeclaredField(String.valueOf(this.key)).getType();
                            } else if (this.callingObjectClass.equals(TmInteractionImpl.class)) {
                                this.type = TmInteractionImpl.class.getDeclaredField(String.valueOf(this.key)).getType();
                            }
                        }
                        catch (Exception e) {
                            errMsg = ImsConnectErrorMessage.getString("HWS0028E", new Object[]{this.key});
                            e1 = new ImsConnectApiException("HWS0028E", errMsg);
                            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                this.logger.severe("    Exception caught in PropertiesFileLoader.loadPropertiesFile(Object, String).  Exception caught was: " + e.toString());
                            }
                            throw e1;
                        }
                    }
                    this.value = line.substring(this.equalsPosition + 1);
                    this.value = this.value.replaceAll("\t", "   ");
                    tmpVal = this.value.trim();
                    if (tmpVal.length() > 0) {
                        this.value = tmpVal;
                    }
                    if ((valueLen = this.value.length()) == 0 && this.type == String.class) {
                        this.value = "        ";
                        valueLen = 8;
                    }
                    if (valueLen <= 0) break block91;
                    if (this.value.charAt(0) == '\"' || this.value.charAt(0) == '\'') {
                        this.value = this.value.substring(1);
                    }
                    if (this.value.charAt((valueLen = this.value.length()) - 1) == '\"' || this.value.charAt(valueLen - 1) == '\'') {
                        this.value = this.value.substring(0, valueLen - 1);
                        valueLen = this.value.length();
                    }
                    if (this.type == String.class) {
                        this.lowerValue = this.value.toLowerCase();
                        this.upperValue = this.value.toUpperCase();
                        if (this.lowerValue.equals("true") || this.lowerValue.equals("false")) {
                            validStringString = "";
                            try {
                                validStringString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_STRING");
                            }
                            catch (Exception var12_28) {
                                // empty catch block
                            }
                            errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{this.key, this.value, validStringString});
                            e = new ImsConnectApiException("HWS0030E", errMsg);
                            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                this.logger.severe("    Exception caught in PropertiesFileLoader.loadPropertiesFile(Object, String).  Exception caught was: " + e.toString());
                            }
                            throw e;
                        }
                        try {
                            targetField = ApiProperties.class.getDeclaredField(String.valueOf(this.upperValue));
                            classType = targetField.getType();
                            if (classType == String.class) {
                                this.apiPropVal = (String)targetField.get(targetField);
                                this.setStringVal(this.key, this.apiPropVal);
                                break block91;
                            }
                            validStringString = "";
                            try {
                                validStringString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_STRING");
                            }
                            catch (Exception var14_41) {
                                // empty catch block
                            }
                            errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{this.key, this.value, validStringString});
                            e = new ImsConnectApiException("HWS0030E", errMsg);
                            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                this.logger.severe("    Exception caught in PropertiesFileLoader.loadPropertiesFile(Object, String).  Exception caught was: " + e.toString());
                            }
                            throw e;
                        }
                        catch (Exception e1) {
                            try {
                                this.setStringVal(this.key, this.value);
                                break block91;
                            }
                            catch (Exception e) {
                                if (e instanceof InvocationTargetException) {
                                    if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                        this.logger.severe("    Exception caught in PropertiesFileLoader.loadPropertiesFile(Object, String).  Exception caught was: " + e.getCause().toString());
                                    }
                                    throw (ImsConnectApiException)e.getCause();
                                }
                                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                    this.logger.severe("    Exception caught in PropertiesFileLoader.loadPropertiesFile(Object, String).  Exception caught was: " + e.toString());
                                }
                                throw e;
                            }
                        }
                    }
                    if (this.type != Boolean.TYPE) ** GOTO lbl173
                    this.lowerValue = this.value.toLowerCase();
                    this.upperValue = this.value.toUpperCase();
                    if (this.lowerValue.equals("true") || this.lowerValue.equals("false")) {
                        this.booleanVal = new Boolean(this.lowerValue);
                        this.setBoolVal(this.key, this.booleanVal);
                    } else {
                        try {
                            targetField = ApiProperties.class.getDeclaredField(String.valueOf(this.upperValue));
                            classType = targetField.getType();
                            if (classType == Boolean.TYPE) {
                                this.apiPropVal = targetField.get(targetField).toString();
                                this.booleanVal = new Boolean(this.apiPropVal);
                                this.setBoolVal(this.key, this.booleanVal);
                                break block91;
                            }
                            validBooleanString = "";
                            try {
                                validBooleanString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_BOOLEAN");
                            }
                            catch (Exception errMsg) {
                                // empty catch block
                            }
                            errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{this.key, this.value, validBooleanString});
                            e = new ImsConnectApiException("HWS0030E", errMsg);
                            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                this.logger.severe("    Exception caught in PropertiesFileLoader.loadPropertiesFile(Object, String).  Exception caught was: " + e.toString());
                            }
                            throw e;
                        }
                        catch (Exception e1) {
                            validBooleanString = "";
                            try {
                                validBooleanString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_BOOLEAN");
                            }
                            catch (Exception validBooleanString) {
                                // empty catch block
                            }
                            errMsg = ImsConnectErrorMessage.getString("HWS0031E", new Object[]{this.key, this.value, validBooleanString, e1});
                            e2 = new ImsConnectApiException("HWS0031E", errMsg);
                            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                this.logger.severe("    Exception caught in PropertiesFileLoader.loadPropertiesFile(Object, String).  Exception caught was: " + e2.toString());
                            }
                            throw e2;
                        }
lbl173:
                        // 1 sources

                        if (this.type == Integer.TYPE) {
                            block92: {
                                try {
                                    this.integerVal = (int)new Integer(this.value);
                                    this.setIntVal(this.key, this.integerVal);
                                    break block91;
                                }
                                catch (Exception e) {
                                    if (!(e instanceof NoSuchMethodException) && !(e instanceof NumberFormatException)) break block92;
                                    try {
                                        multiplier = 1;
                                        multiplierString = "";
                                        multiplierChar = this.value.charAt(0);
                                        d = 0;
                                        while (Character.isDigit(multiplierChar)) {
                                            multiplierString = String.valueOf(multiplierString) + multiplierChar;
                                            this.value = this.value.substring(d++);
                                            multiplier = Integer.valueOf(multiplierString);
                                        }
                                        numTargetField = ApiProperties.class.getDeclaredField(String.valueOf(this.value));
                                        numClassType = numTargetField.getType();
                                        if (numClassType == Integer.TYPE) {
                                            this.intVal = numTargetField.getInt(numTargetField);
                                            this.intVal *= multiplier;
                                            this.integerVal = new Integer(this.intVal);
                                            this.setIntVal(this.key, this.integerVal);
                                            break block91;
                                        }
                                        validIntegerString = "";
                                        try {
                                            validIntegerString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_INTEGER");
                                        }
                                        catch (Exception var19_59) {
                                            // empty catch block
                                        }
                                        errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{this.key, this.value, validIntegerString});
                                        e2 = new ImsConnectApiException("HWS0030E", errMsg);
                                        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                            this.logger.severe("    Exception caught in PropertiesFileLoader.loadPropertiesFile(Object, String).  Exception caught was: " + e2.toString());
                                        }
                                        throw e2;
                                    }
                                    catch (Exception e2) {
                                        validIntegerString = "";
                                        try {
                                            validIntegerString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_INTEGER");
                                        }
                                        catch (Exception multiplierChar) {
                                            // empty catch block
                                        }
                                        errMsg = ImsConnectErrorMessage.getString("HWS0031E", new Object[]{this.key, this.strVal, validIntegerString, e2});
                                        e3 = new ImsConnectApiException("HWS0031E", errMsg);
                                        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                            this.logger.severe("    Exception caught in PropertiesFileLoader.loadPropertiesFile(Object, String).  Exception caught was: " + e3.toString());
                                        }
                                        throw e3;
                                    }
                                }
                            }
                            if (e instanceof InvocationTargetException) {
                                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                    this.logger.severe("    Exception caught in PropertiesFileLoader.loadPropertiesFile(Object, String).  Exception caught was: " + e.getCause().toString());
                                }
                                throw (ImsConnectApiException)e.getCause();
                            }
                            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                this.logger.severe("    Exception caught in PropertiesFileLoader.loadPropertiesFile(Object, String).  Exception caught was: " + e.toString());
                            }
                            throw e;
                        }
                        if (this.type == Byte.TYPE) {
                            block93: {
                                try {
                                    this.byteVal = (byte)new Byte(this.value);
                                    this.setByteVal(this.key, this.byteVal);
                                    break block91;
                                }
                                catch (Exception e) {
                                    if (!(e instanceof NoSuchMethodException) && !(e instanceof NumberFormatException)) break block93;
                                    try {
                                        multiplier = 1;
                                        multiplierString = "";
                                        multiplierChar = this.value.charAt(0);
                                        d = 0;
                                        while (Character.isDigit(multiplierChar)) {
                                            multiplierString = String.valueOf(multiplierString) + multiplierChar;
                                            this.value = this.value.substring(d++);
                                            multiplier = Byte.valueOf(multiplierString);
                                        }
                                        numTargetField = ApiProperties.class.getDeclaredField(String.valueOf(this.value));
                                        numClassType = numTargetField.getType();
                                        if (numClassType == Byte.TYPE) {
                                            this.bytVal = numTargetField.getByte(numTargetField);
                                            this.bytVal = (byte)(this.bytVal * multiplier);
                                            this.byteVal = new Byte(this.bytVal);
                                            this.setByteVal(this.key, this.byteVal);
                                            break block91;
                                        }
                                        validByteString = "";
                                        try {
                                            validByteString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_BYTE");
                                        }
                                        catch (Exception errMsg) {
                                            // empty catch block
                                        }
                                        errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{this.key, this.value, validByteString});
                                        e1 = new ImsConnectApiException("HWS0030E", errMsg);
                                        throw e1;
                                    }
                                    catch (Exception e2) {
                                        validByteString = "";
                                        try {
                                            validByteString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_BYTE");
                                        }
                                        catch (Exception multiplierChar) {
                                            // empty catch block
                                        }
                                        errMsg = ImsConnectErrorMessage.getString("HWS0031E", new Object[]{this.key, this.value, validByteString, e2});
                                        e3 = new ImsConnectApiException("HWS0031E", errMsg);
                                        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                            this.logger.severe("    Exception caught in PropertiesFileLoader.loadPropertiesFile(Object, String).  Exception caught was: " + e3.toString());
                                        }
                                        throw e3;
                                    }
                                }
                            }
                            if (e instanceof InvocationTargetException) {
                                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                    this.logger.severe("    Exception caught in PropertiesFileLoader.loadPropertiesFile(Object, String).  Exception caught was: " + e.getCause().toString());
                                }
                                throw (ImsConnectApiException)e.getCause();
                            }
                            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                this.logger.severe("    Exception caught in PropertiesFileLoader.loadPropertiesFile(Object, String).  Exception caught was: " + e.toString());
                            }
                            throw e;
                        }
                    }
                }
                line = this.readLine(this.bufFileReader);
                ++i;
            }
        }
        catch (IOException e) {
            errMsg = ImsConnectErrorMessage.getString("HWS0001E", new Object[]{ImsConnectErrorMessage.getExceptionMessage(e)});
            e1 = new ImsConnectApiException("HWS0001E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in PropertiesFileLoader.loadPropertiesFile(Object, String). Exception thrown was: " + e1.toString());
            }
            throw e;
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            this.logger.finest("    " + this.numPropertiesSet + " properties set in " + theCallingObject.getClass().getSimpleName() + "...");
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- PropertiesFileLoader.loadPropertiesFile(Object, String)...");
        }
    }

    private void setBoolVal(String aKey, Boolean aBooleanVal) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] argTypes = new Class[]{Boolean.TYPE};
        Object[] valueToBeSet = new Object[]{aBooleanVal};
        this.invokeSetMethod(aKey, argTypes, valueToBeSet);
    }

    private void setByteVal(String aKey, Byte aByteVal) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] argTypes = new Class[]{Byte.TYPE};
        Object[] valueToBeSet = new Object[]{aByteVal};
        this.invokeSetMethod(aKey, argTypes, valueToBeSet);
    }

    private void setIntVal(String aKey, Integer anIntegerVal) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] argTypes = new Class[]{Integer.TYPE};
        Object[] valueToBeSet = new Object[]{anIntegerVal};
        this.invokeSetMethod(aKey, argTypes, valueToBeSet);
    }

    private void setStringVal(String aPropertyName, String aStringVal) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] argTypes = new Class[]{String.class};
        Object[] valueToBeSet = new Object[]{aStringVal};
        this.invokeSetMethod(aPropertyName, argTypes, valueToBeSet);
    }

    private void invokeSetMethod(String aKey, Class[] argTypes, Object[] valueToBeSet) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.callingObjectClass.equals(ConnectionImpl.class)) {
            this.callConnectionImplSetMethod(aKey, valueToBeSet[0], this.callingObject);
        } else if (this.callingObjectClass.equals(ConnectionFactory.class)) {
            this.callConnectionFactorySetMethod(aKey, valueToBeSet[0], this.callingObject);
        } else if (this.callingObjectClass.equals(ConnectionAttributes.class)) {
            this.callConnectionAttributesSetMethod(aKey, valueToBeSet[0], this.callingObject);
        } else if (this.callingObjectClass.equals(TmInteractionImpl.class)) {
            this.callTmInteractionImplSetMethod(aKey, valueToBeSet[0], this.callingObject);
        } else if (this.callingObjectClass.equals(TmInteractionAttributes.class)) {
            this.callTmInteractionAttributesSetMethod(aKey, valueToBeSet[0], this.callingObject);
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            this.logger.finest("    " + aKey + " set to [" + valueToBeSet[0].toString() + "]");
        }
        ++this.numPropertiesSet;
    }

    private String extractValueMultiplier(String aValue) {
        boolean multiplier = true;
        String multiplierString = "";
        char multiplierChar = aValue.charAt(0);
        int d = 0;
        while (Character.isDigit(multiplierChar)) {
            multiplierString = String.valueOf(multiplierString) + multiplierChar;
            aValue = aValue.substring(d++);
        }
        return multiplierString;
    }

    public static boolean isValidHostStyleName(String aName) {
        if (aName != null && aName.length() > 0) {
            int i = 0;
            while (i < aName.length()) {
                char c = aName.charAt(i);
                if (!Character.isLetterOrDigit(c) && validSpecialCharacters.indexOf(c) == -1) {
                    i = 9;
                }
                ++i;
            }
            if (i < 9) {
                return true;
            }
        }
        return false;
    }

    protected String readLine(BufferedReader bufferedReader) throws ImsConnectApiException {
        char[] lineBreak = System.getProperty("line.separator").toCharArray();
        int bufferMax = 4096;
        char[] buffer = new char[bufferMax];
        int pos = 0;
        try {
            if (this.line <= 4096) {
                int charRead;
                while ((charRead = bufferedReader.read()) != -1 && charRead != lineBreak[0]) {
                    if (pos >= bufferMax) break;
                    buffer[pos] = (char)charRead;
                    ++pos;
                }
                ++this.line;
                return new String(buffer, 0, pos);
            }
            return null;
        }
        catch (IOException e) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0001E", new Object[]{ImsConnectErrorMessage.getExceptionMessage(e)});
            ImsConnectApiException e1 = new ImsConnectApiException("HWS0001E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in PropertiesFileLoader.apiBufferReadLine(). Exception thrown was: " + e1.toString());
            }
            throw e1;
        }
    }

    private void callConnectionImplSetMethod(String key, Object value, Object conImpl) {
        try {
            ConnectionImpl cImpl = (ConnectionImpl)conImpl;
            if (key.equals("hostName")) {
                cImpl.setHostName((String)value);
            } else if (key.equals("portNumber")) {
                int portNum = (Integer)value;
                cImpl.setPortNumber(portNum);
            } else if (key.equals("socketType")) {
                Byte sockType = (Byte)value;
                cImpl.setSocketType(sockType);
            } else if (key.equals("clientId")) {
                cImpl.setClientId((String)value);
            } else if (key.equals("sslEncryptionType")) {
                Byte encryptType = (Byte)value;
                cImpl.setSslEncryptionType(encryptType);
            } else if (key.equals("sslKeystoreInputStream")) {
                InputStream keyStoreIS = (InputStream)value;
                cImpl.setSslKeystoreInputStream(keyStoreIS);
            } else if (key.equals("sslKeystoreUrl")) {
                URL keystoreURL = (URL)value;
                cImpl.setSslKeystoreUrl(keystoreURL);
            } else if (key.equals("sslKeystoreName")) {
                cImpl.setSslKeystoreName((String)value);
            } else if (key.equals("sslKeystorePassword")) {
                cImpl.setSslKeystorePassword((String)value);
            } else if (key.equals("sslTruststoreInputStream")) {
                InputStream trustStoreIS = (InputStream)value;
                cImpl.setSslTruststoreInputStream(trustStoreIS);
            } else if (key.equals("sslTruststoreUrl")) {
                URL storeURL = (URL)value;
                cImpl.setSslTruststoreUrl(storeURL);
            } else if (key.equals("sslTruststoreName")) {
                cImpl.setSslTruststoreName((String)value);
            } else if (key.equals("sslTruststorePassword")) {
                cImpl.setSslTruststorePassword((String)value);
            } else if (key.equals("useSslConnection")) {
                Boolean sslConnect = (Boolean)value;
                cImpl.setUseSslConnection(sslConnect);
            } else if (key.equals("interactionTimeout")) {
                int timeOut = (Integer)value;
                cImpl.setInteractionTimeout(timeOut);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void callConnectionFactorySetMethod(String key, Object value, Object conFactory) {
        try {
            ConnectionFactory cF = (ConnectionFactory)conFactory;
            if (key.equals("hostName")) {
                String hostName = (String)value;
                cF.setHostName(hostName);
            } else if (key.equals("portNumber")) {
                int portNum = (Integer)value;
                cF.setPortNumber(portNum);
            } else if (key.equals("socketType")) {
                Byte sockType = (Byte)value;
                cF.setSocketType(sockType);
            } else if (key.equals("clientId")) {
                cF.setClientId((String)value);
            } else if (key.equals("sslEncryptionType")) {
                Byte encryptType = (Byte)value;
                cF.setSslEncryptionType(encryptType);
            } else if (key.equals("sslKeystoreInputStream")) {
                InputStream keyStoreIS = (InputStream)value;
                cF.setSslKeystoreInputStream(keyStoreIS);
            } else if (key.equals("sslKeystoreUrl")) {
                URL keystoreURL = (URL)value;
                cF.setSslKeystoreUrl(keystoreURL);
            } else if (key.equals("sslKeystoreName")) {
                cF.setSslKeystoreName((String)value);
            } else if (key.equals("sslKeystorePassword")) {
                cF.setSslKeystorePassword((String)value);
            } else if (key.equals("sslTruststoreInputStream")) {
                InputStream trustStoreIS = (InputStream)value;
                cF.setSslTruststoreInputStream(trustStoreIS);
            } else if (key.equals("sslTruststoreUrl")) {
                URL storeURL = (URL)value;
                cF.setSslTruststoreUrl(storeURL);
            } else if (key.equals("sslTruststoreName")) {
                cF.setSslTruststoreName((String)value);
            } else if (key.equals("sslTruststorePassword")) {
                cF.setSslTruststorePassword((String)value);
            } else if (key.equals("useSslConnection")) {
                Boolean sslConnect = (Boolean)value;
                cF.setUseSslConnection(sslConnect);
            } else if (key.equals("interactionTimeout")) {
                int timeOut = (Integer)value;
                cF.setInteractionTimeout(timeOut);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    private void callConnectionAttributesSetMethod(String key, Object value, Object conAttributes) {
        try {
            ConnectionAttributes cAttr = (ConnectionAttributes)conAttributes;
            if (key.equals("hostName")) {
                cAttr.setHostName((String)value);
            } else if (key.equals("portNumber")) {
                int portNum = (Integer)value;
                cAttr.setPortNumber(portNum);
            } else if (key.equals("socketType")) {
                Byte sockType = (Byte)value;
                cAttr.setSocketType(sockType);
            } else if (key.equals("clientId")) {
                cAttr.setClientId((String)value);
            } else if (key.equals("sslEncryptionType")) {
                Byte encryptType = (Byte)value;
                cAttr.setSslEncryptionType(encryptType);
            } else if (key.equals("sslKeystoreInputStream")) {
                InputStream keyStoreIS = (InputStream)value;
                cAttr.setSslKeystoreInputStream(keyStoreIS);
            } else if (key.equals("sslKeystoreUrl")) {
                URL keystoreURL = (URL)value;
                cAttr.setSslKeystoreUrl(keystoreURL);
            } else if (key.equals("sslKeystoreName")) {
                cAttr.setSslKeystoreName((String)value);
            } else if (key.equals("sslKeystorePassword")) {
                cAttr.setSslKeystorePassword((String)value);
            } else if (key.equals("sslTruststoreInputStream")) {
                InputStream trustStoreIS = (InputStream)value;
                cAttr.setSslTruststoreInputStream(trustStoreIS);
            } else if (key.equals("sslTruststoreUrl")) {
                URL storeURL = (URL)value;
                cAttr.setSslTruststoreUrl(storeURL);
            } else if (key.equals("sslTruststoreName")) {
                cAttr.setSslTruststoreName((String)value);
            } else if (key.equals("sslTruststorePassword")) {
                cAttr.setSslTruststorePassword((String)value);
            } else if (key.equals("useSslConnection")) {
                Boolean sslConnect = (Boolean)value;
                cAttr.setUseSslConnection(sslConnect);
            } else if (key.equals("interactionTimeout")) {
                int timeOut = (Integer)value;
                cAttr.setInteractionTimeout(timeOut);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void callTmInteractionImplSetMethod(String key, Object value, Object tmInterImpl) {
        try {
            TmInteractionImpl interImpl = (TmInteractionImpl)tmInterImpl;
            if (key.equals("ackNakProvider")) {
                Byte ackProvider = (Byte)value;
                interImpl.setAckNakProvider(ackProvider);
            } else if (key.equals("commitMode")) {
                Byte cMode = (Byte)value;
                interImpl.setCommitMode(cMode);
            } else if (key.equals("cm0IgnorePurge")) {
                Boolean cm0IgrPurge = (Boolean)value;
                interImpl.setCm0IgnorePurge(cm0IgrPurge);
            } else if (key.equals("inputMessageDataSegmentsIncludeLlzzAndTrancode")) {
                Boolean includeLlzzTrancode = (Boolean)value;
                interImpl.setInputMessageDataSegmentsIncludeLlzzAndTrancode(includeLlzzTrancode);
            } else if (key.equals("imsConnectUserMessageExitIdentifier")) {
                interImpl.setImsConnectUserMessageExitIdentifier((String)value);
            } else if (key.equals("inputMessageOptions")) {
                int iMesOptions = (Integer)value;
                interImpl.setInputMessageOptions(iMesOptions);
            } else if (key.equals("interactionTypeDescription")) {
                interImpl.setInteractionTypeDescription((String)value);
            } else if (key.equals("ltermOverrideName")) {
                interImpl.setLtermOverrideName((String)value);
            } else if (key.equals("returnMfsModname")) {
                Boolean rMfsModName = (Boolean)value;
                interImpl.setReturnMfsModname(rMfsModName);
            } else if (key.equals("syncLevel")) {
                Byte sLevel = (Byte)value;
                interImpl.setSyncLevel(sLevel);
            } else if (key.equals("imsConnectCodepage")) {
                interImpl.setImsConnectCodepage((String)value);
            } else if (key.equals("purgeUndeliverableOutput")) {
                Boolean pOutput = (Boolean)value;
                interImpl.setPurgeUndeliverableOutput(pOutput);
            } else if (key.equals("rerouteUndeliverableOutput")) {
                Boolean pOutput = (Boolean)value;
                interImpl.setRerouteUndeliverableOutput(pOutput);
            } else if (key.equals("rerouteName")) {
                interImpl.setRerouteName((String)value);
            } else if (key.equals("resumeTpipeAlternateClientId")) {
                interImpl.setResumeTpipeAlternateClientId((String)value);
            } else if (key.equals("resumeTpipeProcessing")) {
                int rtpProc = (Integer)value;
                interImpl.setResumeTpipeProcessing(rtpProc);
            } else if (key.equals("calloutRequestNakProcessing")) {
                interImpl.setCalloutRequestNakProcessing((String)value);
            } else if (key.equals("calloutResponseMessageType")) {
                interImpl.setCalloutResponseMessageType((String)value);
            } else if (key.equals("resumeTPipeRetrievalType")) {
                Byte retType = (Byte)value;
                interImpl.setResumeTpipeRetrievalType(retType);
            } else if (key.equals("nakReasonCode")) {
                short nakRC = (Short)value;
                interImpl.setResumeTpipeProcessing(nakRC);
            } else if (key.equals("inputModName")) {
                interImpl.setInputModName((String)value);
            } else if (key.equals("correlatorTkn")) {
                byte[] cTkn = (byte[])value;
                interImpl.setCorrelatorToken(cTkn);
            } else if (key.equals("racfApplName")) {
                interImpl.setRacfApplName((String)value);
            } else if (key.equals("racfGroupName")) {
                interImpl.setRacfGroupName((String)value);
            } else if (key.equals("racfPassword")) {
                interImpl.setRacfPassword((String)value);
            } else if (key.equals("racfUserId")) {
                interImpl.setRacfUserId((String)value);
            } else if (key.equals("imsDatastoreName")) {
                interImpl.setImsDatastoreName((String)value);
            } else if (key.equals("trancode")) {
                interImpl.setTrancode((String)value);
            } else if (key.equals("interactionTimeout")) {
                int iTimeout = (Integer)value;
                interImpl.setInteractionTimeout(iTimeout);
            } else if (key.equals("imsConnectTimeout")) {
                int cTimeout = (Integer)value;
                interImpl.setImsConnectTimeout(cTimeout);
            } else if (key.equals("otmaTransactionExpiration")) {
                Boolean tExp = (Boolean)value;
                interImpl.setOtmaTransactionExpiration(tExp);
            } else if (key.equals("useCM0AckNoWait")) {
                Boolean noWait = (Boolean)value;
                interImpl.setUseCM0AckNoWait(noWait);
            } else if (key.equals("responseIncludesLlll")) {
                Boolean iLlll = (Boolean)value;
                interImpl.setResponseIncludesLlll(iLlll);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void callTmInteractionAttributesSetMethod(String key, Object value, Object tmInterAttr) {
        try {
            TmInteractionAttributes interAttr = (TmInteractionAttributes)tmInterAttr;
            if (key.equals("ackNakProvider")) {
                Byte ackProvider = (Byte)value;
                interAttr.setAckNakProvider(ackProvider);
            } else if (key.equals("commitMode")) {
                Byte cMode = (Byte)value;
                interAttr.setCommitMode(cMode);
            } else if (key.equals("cm0IgnorePurge")) {
                Boolean cm0IgrPurge = (Boolean)value;
                interAttr.setCm0IgnorePurge(cm0IgrPurge);
            } else if (key.equals("inputMessageDataSegmentsIncludeLlzzAndTrancode")) {
                Boolean includeLlzzTrancode = (Boolean)value;
                interAttr.setInputMessageDataSegmentsIncludeLlzzAndTrancode(includeLlzzTrancode);
            } else if (key.equals("imsConnectUserMessageExitIdentifier")) {
                interAttr.setImsConnectUserMessageExitIdentifier((String)value);
            } else if (key.equals("inputMessageOptions")) {
                int iMesOptions = (Integer)value;
                interAttr.setInputMessageOptions(iMesOptions);
            } else if (key.equals("interactionTypeDescription")) {
                interAttr.setInteractionTypeDescription((String)value);
            } else if (key.equals("ltermOverrideName")) {
                interAttr.setLtermOverrideName((String)value);
            } else if (key.equals("returnMfsModname")) {
                Boolean rMfsModName = (Boolean)value;
                interAttr.setReturnMfsModname(rMfsModName);
            } else if (key.equals("syncLevel")) {
                Byte sLevel = (Byte)value;
                interAttr.setSyncLevel(sLevel);
            } else if (key.equals("imsConnectCodepage")) {
                interAttr.setImsConnectCodepage((String)value);
            } else if (key.equals("purgeUndeliverableOutput")) {
                Boolean pOutput = (Boolean)value;
                interAttr.setPurgeUndeliverableOutput(pOutput);
            } else if (key.equals("rerouteUndeliverableOutput")) {
                Boolean pOutput = (Boolean)value;
                interAttr.setRerouteUndeliverableOutput(pOutput);
            } else if (key.equals("rerouteName")) {
                interAttr.setRerouteName((String)value);
            } else if (key.equals("resumeTpipeAlternateClientId")) {
                interAttr.setResumeTpipeAlternateClientId((String)value);
            } else if (key.equals("resumeTpipeProcessing")) {
                int rtpProc = (Integer)value;
                interAttr.setResumeTpipeProcessing(rtpProc);
            } else if (key.equals("calloutRequestNakProcessing")) {
                interAttr.setCalloutRequestNakProcessing((String)value);
            } else if (key.equals("calloutResponseMessageType")) {
                interAttr.setCalloutResponseMessageType((String)value);
            } else if (key.equals("resumeTPipeRetrievalType")) {
                Byte retType = (Byte)value;
                interAttr.setResumeTpipeRetrievalType(retType);
            } else if (key.equals("nakReasonCode")) {
                short nakRC = (Short)value;
                interAttr.setResumeTpipeProcessing(nakRC);
            } else if (!key.equals("inputModName")) {
                if (key.equals("correlatorTkn")) {
                    byte[] cTkn = (byte[])value;
                    interAttr.setCorrelatorToken(cTkn);
                } else if (key.equals("racfApplName")) {
                    interAttr.setRacfApplName((String)value);
                } else if (key.equals("racfGroupName")) {
                    interAttr.setRacfGroupName((String)value);
                } else if (key.equals("racfPassword")) {
                    interAttr.setRacfPassword((String)value);
                } else if (key.equals("racfUserId")) {
                    interAttr.setRacfUserId((String)value);
                } else if (key.equals("imsDatastoreName")) {
                    interAttr.setImsDatastoreName((String)value);
                } else if (key.equals("trancode")) {
                    interAttr.setTrancode((String)value);
                } else if (key.equals("interactionTimeout")) {
                    int iTimeout = (Integer)value;
                    interAttr.setInteractionTimeout(iTimeout);
                } else if (key.equals("imsConnectTimeout")) {
                    int cTimeout = (Integer)value;
                    interAttr.setImsConnectTimeout(cTimeout);
                } else if (key.equals("otmaTransactionExpiration")) {
                    Boolean tExp = (Boolean)value;
                    interAttr.setOtmaTransactionExpiration(tExp);
                } else if (!key.equals("useCM0AckNoWait") && key.equals("responseIncludesLlll")) {
                    Boolean iLlll = (Boolean)value;
                    interAttr.setResponseIncludesLlll(iLlll);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

