/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.connect;

import com.ibm.ims.connect.ApiProperties;
import com.ibm.ims.connect.ImsConnectApiException;
import com.ibm.ims.connect.ImsConnectErrorMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import java.util.logging.Logger;

public class ResponseProcessor {
    private static final String copyright = "Licensed Material - Property of IBM 5655-T62(C) Copyright IBM Corp. 2011  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private Properties myProperties = new Properties();
    InputStream is = null;
    String processedResponse = null;
    private Logger logger = Logger.getLogger("com.ibm.ims.connect");

    ResponseProcessor() {
    }

    protected Properties processProperties(String aResponse, String anEncoding) throws ImsConnectApiException {
        ImsConnectApiException e;
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> ResponseProcessor.processProperties(String aResponse, String anEncoding)");
        }
        this.processedResponse = "<?xml version=\"1.0\"?><!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\"><properties><entry key=\"" + aResponse;
        if (!this.processedResponse.endsWith(" ")) {
            this.processedResponse = String.valueOf(this.processedResponse) + " ";
        }
        this.processedResponse = this.processedResponse.replaceFirst("\\(", "\">");
        StringBuffer regexBuf2 = new StringBuffer();
        regexBuf2.append("\\");
        regexBuf2.append(") ");
        String regex2 = regexBuf2.toString();
        this.processedResponse = this.processedResponse.replaceFirst(regex2, "</entry>");
        int startLoc = this.processedResponse.lastIndexOf("</entry>");
        while (this.processedResponse.indexOf("(", startLoc) > 0) {
            int posNextRightParen;
            int posNextLeftParen = this.processedResponse.indexOf("(", startLoc);
            if (posNextLeftParen < (posNextRightParen = this.processedResponse.indexOf("(", startLoc)) && posNextLeftParen != -1) continue;
            String leftPartOfString = this.processedResponse.substring(0, startLoc);
            String restOfString = this.processedResponse.substring(startLoc);
            restOfString = restOfString.replaceFirst("</entry>", "</entry><entry key=\"");
            restOfString = restOfString.replaceFirst("\\(", "\">");
            restOfString = restOfString.replaceFirst("\\) ", "</entry>");
            this.processedResponse = String.valueOf(leftPartOfString) + restOfString;
            startLoc = this.processedResponse.lastIndexOf("</entry>");
        }
        this.processedResponse = String.valueOf(this.processedResponse) + "</properties>";
        this.processedResponse.replaceAll("< ", "<");
        this.processedResponse.replaceAll(" entry>", "entry>");
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            this.logger.finer("    processedResponse (a <rsp> element after removing unwanted spaces):\n    " + this.processedResponse);
        }
        try {
            byte[] bytesBuffer = this.processedResponse.getBytes(anEncoding);
            ByteArrayInputStream is = new ByteArrayInputStream(bytesBuffer);
            this.myProperties.clear();
            this.myProperties.loadFromXML(is);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"Type-2 command XML response", anEncoding});
            e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in ResponseProcessor.processProperties(String aResponse, String anEncoding): [" + e.toString() + "]");
            }
            throw e;
        }
        catch (InvalidPropertiesFormatException ipfe) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0044E", new Object[]{ipfe.toString()});
            e = new ImsConnectApiException("HWS0044E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in ResponseProcessor.processProperties(String aResponse, String anEncoding): [" + ipfe.toString() + "]");
            }
            throw e;
        }
        catch (IOException ioe) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0044E", new Object[]{ioe.toString()});
            e = new ImsConnectApiException("HWS0044E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in ResponseProcessor.processProperties(String aResponse, String anEncoding): [" + e.toString() + "]+");
            }
            throw e;
        }
        catch (Exception e2) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0044E", new Object[]{e2.toString()});
            ImsConnectApiException e1 = new ImsConnectApiException("HWS0044E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in ResponseProcessor.processProperties(String aResponse, String anEncoding): [" + e1.toString() + "]+");
            }
            throw e1;
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- ResponseProcessor.processProperties(String aResponse, String anEncoding)");
        }
        return this.myProperties;
    }

    public String getProcessedResponse() {
        return this.processedResponse;
    }

    protected static String formatBufferForTracing(byte[] buffer, String anImsConnectCodepage) {
        String imsConnectCodepage = anImsConnectCodepage;
        StringBuffer strbuf = new StringBuffer(buffer.length * 4 + buffer.length / 16 * 6);
        strbuf.append("    ");
        int rowByteCount = 0;
        int totalByteCount = 0;
        int numberOfBytesInRow = 32;
        int startOfData = 116;
        String str = "";
        int i = 0;
        while (i < buffer.length) {
            int hiByte = (buffer[i] & 0xF0) >> 4;
            int lowByte = buffer[i] & 0xF;
            strbuf.append(Integer.toString(hiByte, 16));
            strbuf.append(Integer.toString(lowByte, 16));
            ++totalByteCount;
            if (++rowByteCount % 4 == 0) {
                strbuf.append(" ");
            }
            if (rowByteCount % 16 == 0) {
                strbuf.append(" ");
            }
            if (rowByteCount == numberOfBytesInRow) {
                try {
                    int startOfRow = i - numberOfBytesInRow + 1;
                    byte[] rowBytes = new byte[numberOfBytesInRow];
                    System.arraycopy(buffer, i - numberOfBytesInRow + 1, rowBytes, 0, numberOfBytesInRow);
                    if (i < 116) {
                        str = new String(rowBytes, 0, rowByteCount, imsConnectCodepage);
                    } else if (startOfRow >= 116) {
                        str = new String(rowBytes, 0, rowByteCount, imsConnectCodepage);
                    } else {
                        int dataInRowLen1 = buffer.length - startOfData;
                        int startOfDataInRowString = startOfData - (i - numberOfBytesInRow);
                        int irmInRowLen = startOfDataInRowString;
                        int dataInRowLen = numberOfBytesInRow - irmInRowLen;
                        if (dataInRowLen1 < dataInRowLen) {
                            dataInRowLen = dataInRowLen1;
                        }
                        byte[] irmRowBytes = new byte[irmInRowLen];
                        byte[] dataRowBytes = new byte[dataInRowLen];
                        System.arraycopy(buffer, i - numberOfBytesInRow + 1, irmRowBytes, 0, irmInRowLen);
                        System.arraycopy(buffer, startOfData + 1, dataRowBytes, 0, dataInRowLen);
                        str = String.valueOf(new String(irmRowBytes, 0, irmInRowLen, imsConnectCodepage)) + new String(dataRowBytes, 0, dataInRowLen, imsConnectCodepage);
                    }
                    strbuf.append("|");
                    int m = 0;
                    while (m < rowByteCount) {
                        if (ResponseProcessor.isPrintableChar(str.charAt(m))) {
                            strbuf.append(str.charAt(m));
                        } else {
                            strbuf.append(".");
                        }
                        ++m;
                    }
                    strbuf.append("|");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                strbuf.append(" : ");
                strbuf.append(totalByteCount);
                strbuf.append("\n    ");
                rowByteCount = 0;
            }
            ++i;
        }
        if (rowByteCount != 0) {
            int l = rowByteCount;
            while (l < 32) {
                strbuf.append("  ");
                if ((l + 1) % 4 == 0) {
                    strbuf.append(" ");
                }
                if ((l + 1) % 16 == 0) {
                    strbuf.append(" ");
                }
                ++l;
            }
            try {
                str = new String(buffer, buffer.length - rowByteCount, rowByteCount, imsConnectCodepage);
                strbuf.append("|");
                int m = 0;
                while (m < rowByteCount) {
                    if (ResponseProcessor.isPrintableChar(str.charAt(m))) {
                        strbuf.append(str.charAt(m));
                    } else {
                        strbuf.append(".");
                    }
                    ++m;
                }
                while (m < 32) {
                    strbuf.append(" ");
                    ++m;
                }
                strbuf.append("|");
            }
            catch (Exception exception) {
                // empty catch block
            }
            strbuf.append(" : ");
            strbuf.append(totalByteCount);
        }
        return new String(strbuf);
    }

    private static boolean isPrintableChar(char ch) {
        if (Character.isISOControl(ch)) {
            return false;
        }
        return !Character.isIdentifierIgnorable(ch);
    }
}

