/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.connect;

import com.ibm.ims.connect.ApiProperties;
import com.ibm.ims.connect.ImsConnectApiException;
import com.ibm.ims.connect.ImsConnectErrorMessage;
import com.ibm.ims.connect.MyDefaultHandler;
import com.ibm.ims.connect.Type2CmdResponse;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser {
    private Logger logger = Logger.getLogger("com.ibm.ims.connect");

    public void parseXml(Type2CmdResponse aType2CmdRsp, byte[] aParsedOutDataByteArray, String anImsConnectCodepage) throws ImsConnectApiException {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> XmlParser.parseXml(Type2CmdResponse aType2CmdRsp, byte[] aParsedOutDataByteArray, String anImsConnectCodepage)");
        }
        ByteArrayInputStream inStrm = new ByteArrayInputStream(aParsedOutDataByteArray);
        SAXParser saxParser = null;
        try {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                saxParser = factory.newSAXParser();
                MyDefaultHandler handler = new MyDefaultHandler();
                InputSource inSrc = new InputSource(inStrm);
                inSrc.setSystemId(this.getClass().getClassLoader().getResource("imsout.dtd").toString());
                handler.setMyT2CmdRsp(aType2CmdRsp);
                saxParser.parse(inSrc, (DefaultHandler)handler);
            }
            catch (SAXParseException spe) {
                StringBuffer sb = new StringBuffer(spe.toString());
                sb.append("\n Line number: " + spe.getLineNumber());
                sb.append("\nColumn number: " + spe.getColumnNumber());
                sb.append("\n Public ID: " + spe.getPublicId());
                sb.append("\n System ID: " + spe.getSystemId() + "\n");
                String errMsg = ImsConnectErrorMessage.getString("HWS0044E", new Object[]{sb.toString()});
                ImsConnectApiException e = new ImsConnectApiException("HWS0044E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception caught in XmlParser.parseXml(Type2CmdResponse aType2CmdRsp, byte[] aParsedOutDataByteArray, String anImsConnectCodepage): [" + sb.toString() + "]");
                }
                throw e;
            }
            catch (Throwable e) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0001E", new Object[]{ImsConnectErrorMessage.getExceptionMessage(e)});
                ImsConnectApiException e1 = new ImsConnectApiException("HWS0001E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in parseXml(Type2CmdResponse aType2CmdRsp, byte[] aParsedOutDataByteArray, String anImsConnectCodepage). Exception thrown was: " + e1.toString());
                }
                throw e1;
            }
        }
        finally {
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
                this.logger.finer("<-- XmlParser.parseXml(Type2CmdResponse aType2CmdRsp, byte[] aParsedOutDataByteArray, String anImsConnectCodepage)");
            }
        }
    }

    private byte[] applyWorkaroundToResponseByteArray(byte[] aParsedOutDataByteArray, String anImsConnectCodepage) throws ImsConnectApiException {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> XmlParser.applyWorkaroundToResponseByteArray(byte[] aParsedOutDataByteArray, String aBadString, String aReplaceString, String anImsConnectCodepage)");
        }
        String responseString = null;
        String cleanedUpResponseString = null;
        byte[] cleanedUpResponseByteArray = null;
        List<String> badString = Arrays.asList("\"skipb=\"", "\"key=\"", "\"align=\"", "\"len=\"", "< ");
        List<String> replacementString = Arrays.asList("\" skipb=\"", "\" key=\"", "\" align=\"", "\" len=\"", "<");
        try {
            responseString = new String(aParsedOutDataByteArray, anImsConnectCodepage);
            int i = 0;
            while (i < badString.size()) {
                cleanedUpResponseString = null;
                cleanedUpResponseString = responseString.replaceAll(badString.get(i), replacementString.get(i));
                if (!responseString.equals(cleanedUpResponseString)) {
                    if (badString.get(i) == "< ") {
                        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                            this.logger.finer("    WORKAROUNDAPPLIED : One or more instances of \"" + badString.get(i) + "\" replaced with \"" + replacementString.get(i) + "\" in response message");
                        }
                    } else if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                        this.logger.finer("    WORKAROUNDAPPLIED: One or more instances of " + badString.get(i) + " replaced with " + replacementString.get(i) + " in response message");
                    }
                }
                ++i;
            }
            cleanedUpResponseByteArray = cleanedUpResponseString.getBytes(anImsConnectCodepage);
        }
        catch (Exception e) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0001E", new Object[]{ImsConnectErrorMessage.getExceptionMessage(e)});
            ImsConnectApiException e1 = new ImsConnectApiException("HWS0001E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in applyWorkaroundToResponseByteArray(byte[] aParsedOutDataByteArray, String aBadString, String aReplaceString, String anImsConnectCodepage). Exception thrown was: " + e1.toString());
            }
            throw e1;
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- XmlParser.applyWorkaroundToResponseByteArray(byte[] aParsedOutDataByteArray, String aBadString, String aReplaceString, String anImsConnectCodepage)");
        }
        return cleanedUpResponseByteArray;
    }
}

