/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.connect.impl;

import com.ibm.ims.connect.ApiProperties;
import com.ibm.ims.connect.Connection;
import com.ibm.ims.connect.ConnectionAttributes;
import com.ibm.ims.connect.ConnectionFactory;
import com.ibm.ims.connect.ImsConnectApiException;
import com.ibm.ims.connect.ImsConnectCommunicationException;
import com.ibm.ims.connect.ImsConnectErrorMessage;
import com.ibm.ims.connect.NumberConversion;
import com.ibm.ims.connect.PropertiesFileLoader;
import com.ibm.ims.connect.TmInteraction;
import com.ibm.ims.connect.TmInteractionAttributes;
import com.ibm.ims.connect.impl.TmInteractionImpl;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyStore;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public final class ConnectionImpl
implements Connection,
Runnable {
    private static final String copyright = "Licensed Material - Property of IBM 5655-TDA(C) Copyright IBM Corp. 2009,2013  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private TmInteraction myTmInteraction = null;
    Connection myConnection = null;
    private String hostName = "HOSTNAME";
    private int portNumber = 9999;
    private byte socketType = (byte)16;
    private String clientId = "        ";
    private byte sslEncryptionType = 1;
    private InputStream sslKeystoreInputStream = DEFAULT_SSL_KEYSTORE_INPUT_STREAM;
    private URL sslKeystoreUrl = DEFAULT_SSL_KEYSTORE_URL;
    private String sslKeystoreName = DEFAULT_SSL_KEYSTORE_NAME;
    private String sslKeystorePassword = "keystrPw";
    private InputStream sslTruststoreInputStream = DEFAULT_SSL_TRUSTSTORE_INPUT_STREAM;
    private URL sslTruststoreUrl = DEFAULT_SSL_TRUSTSTORE_URL;
    private String sslTruststoreName = DEFAULT_SSL_TRUSTSTORE_NAME;
    private String sslTruststorePassword = "trststPw";
    private boolean useSslConnection = false;
    private SSLContext sslContext = null;
    private String sslCertType = null;
    private SSLSocket sslSocket = null;
    private int interactionTimeout = -1;
    private boolean setSoTimeoutRequired = false;
    private int socketConnectTimeout = -1;
    private boolean isConnected = false;
    private static final String validChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-";
    private static final String validLetters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final int s = 0;
    private String imsConnectCodepage;
    private Socket socket = null;
    private Logger logger;
    Thread hook = null;
    protected boolean updateIrmClientId = false;
    protected boolean returnedClientID = false;

    protected ConnectionImpl() throws ImsConnectApiException {
        this.logger = Logger.getLogger("com.ibm.ims.connect");
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-> ConnectionImpl()...");
        }
    }

    public ConnectionImpl(ConnectionFactory aConnectionFactory) throws ImsConnectApiException {
        this.myConnection = this;
        this.logger = Logger.getLogger("com.ibm.ims.connect");
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> ConnectionImpl(ConnectionFactory)...");
        }
        if (aConnectionFactory != null) {
            this.setClientId(aConnectionFactory.getClientId());
            this.setHostName(aConnectionFactory.getHostName());
            this.setPortNumber(aConnectionFactory.getPortNumber());
            this.setInteractionTimeout(aConnectionFactory.getInteractionTimeout());
            this.setSocketConnectTimeout(aConnectionFactory.getSocketConnectTimeout());
            this.setSocketType(aConnectionFactory.getSocketType());
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                this.logger.finer("     Connection.clientID set to [" + this.getClientId() + "]");
                this.logger.finer("     Connection.hostName set to [" + this.getHostName() + "]");
                this.logger.finer("     Connection.portNumber set to [" + this.getPortNumber() + "]");
                this.logger.finer("     Connection.interactionTimeout set to [" + this.getInteractionTimeout() + "]");
                this.logger.finer("     Connection.socketConnectTimeout set to [" + this.getSocketConnectTimeout() + "]");
                this.logger.finer("     Connection.socketType set to [" + this.getSocketType() + "]");
            }
            if (aConnectionFactory.isUseSslConnection()) {
                this.setSslEncryptionType(aConnectionFactory.getSslEncryptionType());
                this.setSslKeystoreInputStream(aConnectionFactory.getSslKeystoreInputStream());
                this.setSslKeystoreUrl(aConnectionFactory.getSslKeystoreUrl());
                this.setSslKeystoreName(aConnectionFactory.getSslKeystoreName());
                this.setSslKeystorePassword(aConnectionFactory.getSslKeystorePassword());
                this.setSslTruststoreInputStream(aConnectionFactory.getSslTruststoreInputStream());
                this.setSslTruststoreUrl(aConnectionFactory.getSslTruststoreUrl());
                this.setSslTruststoreName(aConnectionFactory.getSslTruststoreName());
                this.setSslTruststorePassword(aConnectionFactory.getSslTruststorePassword());
                this.setUseSslConnection(aConnectionFactory.isUseSslConnection());
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                    this.logger.finer("     Connection.sslEncryptionType set to [" + this.getSslEncryptionType() + "]");
                    this.logger.finer("     Connection.sslKeystoreInputStream set to [" + this.getSslKeystoreInputStream() + "]");
                    this.logger.finer("     Connection.sslKeystoreUrl set to [" + this.getSslKeystoreUrl() + "]");
                    this.logger.finer("     Connection.sslKeystoreName set to [" + this.getSslKeystoreName() + "]");
                    this.logger.finer("     Connection.sslKeystorePassword set to [" + new String("********") + "]");
                    this.logger.finer("     Connection.sslTruststoreInputStream set to [" + this.getSslTruststoreInputStream() + "]");
                    this.logger.finer("     Connection.sslTruststoreUrl set to [" + this.getSslTruststoreUrl() + "]");
                    this.logger.finer("     Connection.sslTruststoreName set to [" + this.getSslTruststoreName() + "]");
                    this.logger.finer("     Connection.sslTruststorePassword set to [" + new String("********") + "]");
                    this.logger.finer("     Connection.useSslConnection set to [" + this.isUseSslConnection() + "]");
                }
            }
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- ConnectionImpl(Connection)...");
        }
    }

    public void close() {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> ConnectionImpl.close()...");
        }
        try {
            try {
                if (this.socket != null) {
                    String socketTypeString = new String("    Socket ");
                    if (this.socket.equals(this.sslSocket)) {
                        socketTypeString = new String("    SSL socket ");
                    }
                    this.socket.close();
                    if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                        this.logger.finer(String.valueOf(socketTypeString) + "connection with clientId [" + this.clientId + "] to hostname [" + this.hostName + "], portNumber [" + this.portNumber + "] now " + (this.socket.isClosed() ? "closed" : "not closed"));
                    }
                    this.socket = null;
                    if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                        this.logger.finer("    Socket object now set to null");
                    }
                }
                this.setSetSoTimeoutRequired(false);
            }
            catch (Exception e) {
                this.socket = null;
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                    this.logger.finer("    Socket object now set to null");
                }
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception caught in Connection.close().  Exception caught was: " + e.toString());
                }
                this.setIsConnected(false);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
                    this.logger.finer("<-- ConnectionImpl.close()...");
                }
            }
        }
        finally {
            this.setIsConnected(false);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
                this.logger.finer("<-- ConnectionImpl.close()...");
            }
        }
    }

    @Override
    public void connect() throws ImsConnectApiException, ImsConnectCommunicationException, SocketException {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> ConnectionImpl.connect()...");
        }
        if (this.isConnected()) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0034E", new Object[]{this.clientId});
            ImsConnectApiException e = new ImsConnectApiException("HWS0034E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.connect().  Exception thrown was: " + e.toString());
            }
            throw e;
        }
        if (!this.useSslConnection) {
            try {
                if (this.socket == null) {
                    this.socket = new Socket();
                }
                InetSocketAddress endpoint = new InetSocketAddress(this.hostName, this.portNumber);
                if (this.socketConnectTimeout == -1) {
                    this.socket.connect(endpoint);
                } else {
                    this.socket.connect(endpoint, this.socketConnectTimeout);
                }
            }
            catch (SocketTimeoutException e1) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0025E", new Object[]{"Socket connect", this.socketConnectTimeout, ImsConnectErrorMessage.getExceptionMessage(e1)});
                ImsConnectCommunicationException e2 = new ImsConnectCommunicationException("HWS0025E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception caught in Connection.connect().  Exception caught was: " + e1.toString());
                }
                throw e2;
            }
            catch (Exception e2) {
                this.setIsConnected(false);
                String errMsg = ImsConnectErrorMessage.getString("HWS0006E", new Object[]{this.hostName, String.valueOf(this.portNumber), ImsConnectErrorMessage.getExceptionMessage(e2)});
                ImsConnectCommunicationException e3 = new ImsConnectCommunicationException("HWS0006E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception caught in Connection.connect().  Exception caught was: " + e3.toString());
                }
                throw e3;
            }
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                this.logger.finest("    ConnectionImpl.connect() - Non-SSL connection for clientId [" + this.clientId + "] to hostname [" + this.hostName + "], portNumber [" + this.portNumber + "] " + (this.socket.isClosed() ? "not open" : "now open"));
            }
        } else {
            SSLSession sslSession = null;
            this.initContext(this.sslKeystoreInputStream, this.sslKeystoreUrl, this.sslKeystoreName, this.sslKeystorePassword, this.sslTruststoreInputStream, this.sslTruststoreUrl, this.sslTruststoreName, this.sslTruststorePassword);
            SSLSocketFactory factory = this.sslContext.getSocketFactory();
            try {
                this.sslSocket = (SSLSocket)factory.createSocket(this.validateHostName(this.hostName), this.validatePortNumber(this.portNumber));
                this.setSupportedCipherSuites(this.sslEncryptionType);
                sslSession = this.sslSocket.getSession();
                if (!sslSession.isValid()) {
                    String invalidSslSessionString = "";
                    try {
                        invalidSslSessionString = ImsConnectErrorMessage.getString("INVALID_SSLSESSION");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new Exception(invalidSslSessionString);
                }
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                    this.logger.finest("   ConnectionImpl.connect() - SSL connection for clientId [" + this.clientId + "] to hostname [" + this.hostName + "], portNumber [" + this.portNumber + "] " + (this.sslSocket.isClosed() ? "not open" : "now open"));
                    this.logger.finest("   ConnectionImpl.connect() - SSL Cipher Suite used is : " + sslSession.getCipherSuite());
                }
            }
            catch (Exception e4) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0010E", new Object[]{this.hostName, Integer.toString(this.portNumber).replaceAll("'", ""), ImsConnectErrorMessage.getExceptionMessage(e4)});
                ImsConnectCommunicationException e5 = new ImsConnectCommunicationException("HWS0010E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception caught in Connection.connect().  Exception caught was: " + e5.toString());
                }
                throw e5;
            }
            this.socket = this.sslSocket;
        }
        if (this.isSetSoTimeoutRequired()) {
            this.setSoTimeout();
            this.setSetSoTimeoutRequired(false);
        }
        this.setIsConnected(true);
        this.socket.setTcpNoDelay(true);
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- ConnectionImpl.connect()...");
        }
    }

    @Override
    public void disconnect() throws ImsConnectApiException {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> ConnectionImpl.disconnect()...");
        }
        Runtime.getRuntime().removeShutdownHook(this.hook);
        this.close();
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- ConnectionImpl.disconnect()...");
        }
    }

    @Override
    public TmInteraction createInteraction() throws ImsConnectApiException {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> ConnectionImpl.createInteraction()...");
        }
        this.myTmInteraction = new TmInteractionImpl();
        ((TmInteractionImpl)this.myTmInteraction).setConnection(this);
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- ConnectionImpl.createInteraction()...");
        }
        return this.myTmInteraction;
    }

    @Override
    public TmInteraction createInteraction(TmInteractionAttributes aTMInteractionAttributes) throws ImsConnectApiException {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> ConnectionImpl.createInteraction(TmInteractionAttributes)...");
        }
        this.myTmInteraction = new TmInteractionImpl(aTMInteractionAttributes);
        ((TmInteractionImpl)this.myTmInteraction).setConnection(this);
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- ConnectionImpl.createInteraction(TmInteractionAttributes)...");
        }
        return this.myTmInteraction;
    }

    private String hashKey() {
        if (this.hostName != null && this.portNumber != -1) {
            return String.valueOf(this.hostName) + String.valueOf(this.portNumber) + String.valueOf(this.useSslConnection) + this.sslEncryptionType;
        }
        return null;
    }

    private boolean hasValue(Object inObj) {
        if (inObj != null) {
            if (inObj.getClass().equals(String.class)) {
                return ((String)inObj).trim().length() > 0;
            }
            return true;
        }
        return false;
    }

    private void initContext(InputStream aKeystoreInputStream, URL aKeystoreUrl, String aKeystoreName, String aKeyStorePasswd, InputStream aTruststoreInputStream, URL aTruststoreUrl, String aTruststoreName, String aTrustStorePasswd) throws ImsConnectApiException {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> ConnectionImpl.initContext(String aKeyStoreName, String aKeyStorePasswd, String aTrustStoreName, String aTrustStorePasswd)...");
        }
        InputStream keystoreInputStream = null;
        InputStream truststoreInputStream = null;
        TrustManager[] tm = null;
        KeyManager[] km = null;
        this.sslCertType = !System.getProperty("java.vendor").equals("IBM Corporation") ? "SunX509" : "IbmX509";
        KeyStore ks = null;
        KeyStore ts = null;
        try {
            System.setProperty("javax.net.debug", "false");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.sslCertType);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.sslCertType);
            if (this.hasValue(aKeyStorePasswd)) {
                char[] ksPass = aKeyStorePasswd.toCharArray();
                ks = KeyStore.getInstance("JKS");
                keystoreInputStream = this.hasValue(aKeystoreInputStream) ? aKeystoreInputStream : (this.hasValue(aKeystoreUrl) ? aKeystoreUrl.openStream() : new FileInputStream(aKeystoreName));
                ks.load(keystoreInputStream, ksPass);
                if (!this.hasValue(aKeystoreInputStream)) {
                    keystoreInputStream.close();
                }
                kmf.init(ks, ksPass);
                km = kmf.getKeyManagers();
            }
            if (this.hasValue(aTrustStorePasswd)) {
                char[] tsPass = aTrustStorePasswd.toCharArray();
                ts = KeyStore.getInstance("JKS");
                truststoreInputStream = this.hasValue(aTruststoreInputStream) ? aTruststoreInputStream : (this.hasValue(aTruststoreUrl) ? aTruststoreUrl.openStream() : new FileInputStream(aTruststoreName));
                ts.load(truststoreInputStream, tsPass);
                if (!this.hasValue(aTruststoreInputStream)) {
                    truststoreInputStream.close();
                }
                tmf.init(ts);
                tm = tmf.getTrustManagers();
            }
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(km, tm, null);
        }
        catch (Exception e1) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0009E", new Object[]{ImsConnectErrorMessage.getExceptionMessage(e1)});
            ImsConnectApiException e2 = new ImsConnectApiException("HWS0009E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in Connection.initContext().  Exception caught was: " + e1.toString());
            }
            throw e2;
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- ConnectionImpl.initContext(String aKeyStoreName, String aKeyStorePasswd, String aTrustStoreName, String aTrustStorePasswd)...");
        }
    }

    @Override
    public void loadConnectionAttributesFromFile(String aConnectionAttributesFileName) throws Exception {
        PropertiesFileLoader myPropertiesFileLoader = new PropertiesFileLoader();
        myPropertiesFileLoader.loadPropertiesFile(this, aConnectionAttributesFileName);
    }

    @Override
    public void loadConnectionAttributesFromObject(ConnectionAttributes aConnectionAttributes) {
        this.clientId = aConnectionAttributes.getClientId();
        this.hostName = aConnectionAttributes.getHostName();
        this.portNumber = aConnectionAttributes.getPortNumber();
        this.interactionTimeout = aConnectionAttributes.getInteractionTimeout();
        this.socketType = aConnectionAttributes.getSocketType();
        this.useSslConnection = false;
        this.sslKeystoreName = aConnectionAttributes.getSslKeystoreName();
        this.sslKeystorePassword = aConnectionAttributes.getSslKeystorePassword();
        this.sslTruststoreName = aConnectionAttributes.getSslTruststoreName();
        this.sslTruststorePassword = aConnectionAttributes.getSslTruststorePassword();
        this.sslEncryptionType = aConnectionAttributes.getSslEncryptionType();
    }

    private void setSupportedCipherSuites(byte aEncrypType) {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> ConnectionImpl.setSupportedCipherSuites(byte aEncrypType)...");
        }
        String[] cipherSuites = this.sslContext.getSocketFactory().getSupportedCipherSuites();
        String[] tmpStrongCipherSuites = new String[cipherSuites.length];
        String[] tmpWeakCipherSuites = new String[cipherSuites.length];
        String[] tmpNullCipherSuites = new String[cipherSuites.length];
        String tempString = null;
        int i = 0;
        int s = 0;
        int w = 0;
        int n = 0;
        int ci_nonanon = 0;
        while (i < cipherSuites.length) {
            if (cipherSuites[i].indexOf("anon") < 0) {
                ++ci_nonanon;
                if (cipherSuites[i].indexOf("EXPORT") > 0) {
                    tempString = cipherSuites[i];
                    tmpWeakCipherSuites[w++] = tempString;
                } else if (cipherSuites[i].indexOf("NULL") > 0) {
                    tempString = cipherSuites[i];
                    tmpNullCipherSuites[n++] = cipherSuites[i];
                } else {
                    tempString = cipherSuites[i];
                    tmpStrongCipherSuites[s++] = cipherSuites[i];
                }
            }
            ++i;
        }
        String[] strongCipherSuites = new String[s];
        String[] weakCipherSuites = new String[w];
        String[] nullCipherSuites = new String[n];
        i = 0;
        if (aEncrypType >= 0 && aEncrypType <= 2) {
            this.sslEncryptionType = aEncrypType;
        }
        if (this.sslEncryptionType == 2) {
            System.arraycopy(tmpStrongCipherSuites, 0, strongCipherSuites, 0, s);
            this.sslSocket.setEnabledCipherSuites(strongCipherSuites);
        } else if (this.sslEncryptionType == 1) {
            System.arraycopy(tmpWeakCipherSuites, 0, weakCipherSuites, 0, w);
            this.sslSocket.setEnabledCipherSuites(weakCipherSuites);
        } else if (this.sslEncryptionType == 0) {
            System.arraycopy(tmpNullCipherSuites, 0, nullCipherSuites, 0, n);
            this.sslSocket.setEnabledCipherSuites(nullCipherSuites);
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- ConnectionImpl.setSupportedCipherSuites(byte aEncrypType)...");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public byte[] receive() throws Exception {
        block40: {
            len = 0;
            inBytes = null;
            tempBytes = null;
            llllBytes = new byte[4];
            llBytes = new byte[2];
            secondLlBytes = new byte[2];
            responseDataInputStream = null;
            bytesAsString = null;
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
                this.logger.finer("--> ConnectionImpl.receive()...");
            }
            this.imsConnectCodepage = this.myTmInteraction.getImsConnectCodepage();
            interactionTimeoutValue = this.getInteractionTimeout();
            interactionTimeoutWaitForever = interactionTimeoutValue == -1;
            interactionTimeoutTime = interactionTimeoutWaitForever != false ? 0L : System.currentTimeMillis() + (long)interactionTimeoutValue;
            exceptionCaught = false;
            try {
                if (!this.isConnected()) {
                    internalMsg = ImsConnectErrorMessage.getString("NO_CONN");
                    errMsg = ImsConnectErrorMessage.getString("HWS0008E", new Object[]{this.hostName, String.valueOf(this.portNumber), internalMsg});
                    e = new ImsConnectCommunicationException("HWS0008E", errMsg);
                    if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                        this.logger.severe("    Exception thrown in Connection.receive().  Exception thrown was: " + e.toString());
                    }
                    throw e;
                }
                responseDataInputStream = new DataInputStream(this.socket.getInputStream());
                if (this.myTmInteraction.isResponseIncludesLlll()) {
                    responseDataInputStream.readFully(llllBytes, 0, 4);
                    len = NumberConversion.parseByteArrayToInt(llllBytes, 0);
                    inBytes = new byte[len];
                    System.arraycopy(llllBytes, 0, inBytes, 0, 4);
                    responseDataInputStream.readFully(inBytes, 4, len - 4);
                } else {
                    sleepTime = 1;
                    numberOfCalloutRequestSegments = 0;
                    responseDataInputStream.readFully(llBytes);
                    len = NumberConversion.parseByteArrayToShort(llBytes, 0);
                    if (len > 3) {
                        inBytes = new byte[len];
                        System.arraycopy(llBytes, 0, inBytes, 0, 2);
                        responseDataInputStream.readFully(inBytes, 2, len - 2);
                        bytesAsString = new String(inBytes, this.imsConnectCodepage);
                    }
                    bytesAsStringLen = bytesAsString.length();
                    while (bytesAsStringLen < 12 || bytesAsString.substring(4, 12).indexOf("*REQSTS*") == -1 && bytesAsString.substring(bytesAsStringLen - 8).indexOf("*CSMOKY*") == -1) {
                        if (interactionTimeoutWaitForever == false & System.currentTimeMillis() >= interactionTimeoutTime) {
                            this.disconnect();
                            errMsg = ImsConnectErrorMessage.getString("HWS0025E", new Object[]{"Interaction", new Integer(this.interactionTimeout), ""});
                            e = new ImsConnectCommunicationException("HWS0025E", errMsg);
                            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                                this.logger.severe("    Exception thrown in Connection.receive().  Exception thrown was: " + e.toString());
                            }
                            throw e;
                        }
                        if (bytesAsStringLen > 12 && bytesAsString.substring(4, 12).indexOf("*CORTKN*") == 0 && numberOfCalloutRequestSegments == 0) {
                            if (this.myTmInteraction.isReturnMfsModname()) {
                                responseDataInputStream.readFully(llBytes);
                                len = NumberConversion.parseByteArrayToShort(llBytes, 0);
                                tempBytes = new byte[inBytes.length + len];
                                System.arraycopy(inBytes, 0, tempBytes, 0, inBytes.length);
                                System.arraycopy(llBytes, 0, tempBytes, inBytes.length, 2);
                                responseDataInputStream.readFully(tempBytes, inBytes.length + 2, len - 2);
                                inBytes = new byte[tempBytes.length];
                                System.arraycopy(tempBytes, 0, inBytes, 0, tempBytes.length);
                            }
                            if (this.myTmInteraction.isReturnClientId()) {
                                responseDataInputStream.readFully(llBytes);
                                len = NumberConversion.parseByteArrayToShort(llBytes, 0);
                                tempBytes = new byte[inBytes.length + len];
                                System.arraycopy(inBytes, 0, tempBytes, 0, inBytes.length);
                                System.arraycopy(llBytes, 0, tempBytes, inBytes.length, 2);
                                responseDataInputStream.readFully(tempBytes, inBytes.length + 2, len - 2);
                                inBytes = new byte[tempBytes.length];
                                System.arraycopy(tempBytes, 0, inBytes, 0, tempBytes.length);
                            }
                            responseDataInputStream.readFully(llllBytes);
                            len = NumberConversion.parseByteArrayToInt(llllBytes, 0);
                            tempBytes = new byte[inBytes.length + len];
                            System.arraycopy(inBytes, 0, tempBytes, 0, inBytes.length);
                            System.arraycopy(llllBytes, 0, tempBytes, inBytes.length, 4);
                            responseDataInputStream.readFully(tempBytes, inBytes.length + 4, len - 4);
                            inBytes = new byte[tempBytes.length];
                            System.arraycopy(tempBytes, 0, inBytes, 0, tempBytes.length);
                            bytesAsString = new String(inBytes, this.imsConnectCodepage);
                            ++numberOfCalloutRequestSegments;
                        } else if (bytesAsStringLen > 12 && bytesAsString.substring(4, 12).indexOf("*CORTKN*") == 0 && numberOfCalloutRequestSegments > 0) {
                            responseDataInputStream.readFully(llBytes);
                            if (llBytes[0] == 0 && llBytes[1] == 0) {
                                responseDataInputStream.readFully(secondLlBytes);
                                System.arraycopy(llBytes, 0, llllBytes, 0, 2);
                                System.arraycopy(secondLlBytes, 0, llllBytes, 2, 2);
                                len = NumberConversion.parseByteArrayToInt(llllBytes, 0);
                                tempBytes = new byte[inBytes.length + len];
                                System.arraycopy(inBytes, 0, tempBytes, 0, inBytes.length);
                                System.arraycopy(llllBytes, 0, tempBytes, inBytes.length, 4);
                                responseDataInputStream.readFully(tempBytes, inBytes.length + 4, len - 4);
                                inBytes = new byte[tempBytes.length];
                                System.arraycopy(tempBytes, 0, inBytes, 0, tempBytes.length);
                                bytesAsString = new String(inBytes, this.imsConnectCodepage);
                                ++numberOfCalloutRequestSegments;
                            } else {
                                len = NumberConversion.parseByteArrayToShort(llBytes, 0);
                                if (len == 12) {
                                    tempBytes = new byte[inBytes.length + len];
                                    System.arraycopy(inBytes, 0, tempBytes, 0, inBytes.length);
                                    System.arraycopy(llBytes, 0, tempBytes, inBytes.length, 2);
                                    responseDataInputStream.readFully(tempBytes, inBytes.length + 2, len - 2);
                                    inBytes = new byte[tempBytes.length];
                                    System.arraycopy(tempBytes, 0, inBytes, 0, tempBytes.length);
                                    bytesAsString = new String(inBytes, this.imsConnectCodepage);
                                    if (bytesAsString.indexOf("*CSMOKY*") > 0 && llBytes[0] == 0 && llBytes[1] == 12) break;
                                    System.arraycopy(inBytes, 0, llllBytes, 0, 4);
                                    len = NumberConversion.parseByteArrayToInt(llllBytes, 0) - 12;
                                    inBytes = new byte[len];
                                    responseDataInputStream.readFully(tempBytes, 0, len);
                                    inBytes = new byte[tempBytes.length];
                                    System.arraycopy(tempBytes, 0, inBytes, 0, tempBytes.length);
                                    bytesAsString = new String(inBytes, this.imsConnectCodepage);
                                    ++numberOfCalloutRequestSegments;
                                } else {
                                    System.arraycopy(llBytes, 0, llllBytes, 0, 2);
                                    responseDataInputStream.readFully(secondLlBytes);
                                    System.arraycopy(secondLlBytes, 0, llllBytes, 2, 2);
                                    len = NumberConversion.parseByteArrayToInt(llllBytes, 0);
                                    tempBytes = new byte[inBytes.length + len];
                                    System.arraycopy(inBytes, 0, tempBytes, 0, inBytes.length);
                                    System.arraycopy(llllBytes, 0, tempBytes, inBytes.length, 4);
                                    responseDataInputStream.readFully(tempBytes, inBytes.length + 4, len - 4);
                                    inBytes = new byte[tempBytes.length];
                                    System.arraycopy(tempBytes, 0, inBytes, 0, tempBytes.length);
                                    bytesAsString = new String(inBytes, this.imsConnectCodepage);
                                    ++numberOfCalloutRequestSegments;
                                }
                            }
                        } else {
                            responseDataInputStream.readFully(llBytes);
                            len = NumberConversion.parseByteArrayToShort(llBytes, 0);
                            tempBytes = new byte[inBytes.length + len];
                            System.arraycopy(inBytes, 0, tempBytes, 0, inBytes.length);
                            System.arraycopy(llBytes, 0, tempBytes, inBytes.length, 2);
                            responseDataInputStream.readFully(tempBytes, inBytes.length + 2, len - 2);
                            inBytes = new byte[tempBytes.length];
                            System.arraycopy(tempBytes, 0, inBytes, 0, tempBytes.length);
                            bytesAsString = new String(inBytes, this.imsConnectCodepage);
                        }
                        if (len != 0) continue;
                        Thread.sleep(sleepTime);
                        if (sleepTime < 10) {
                            ++sleepTime;
                            continue;
                        }
                        if (sleepTime < 50) {
                            sleepTime += 10;
                            continue;
                        }
                        if (sleepTime < 100) {
                            sleepTime += 25;
                            continue;
                        }
                        sleepTime += 100;
                    }
                }
                var20_34 = inBytes;
                return var20_34;
            }
            catch (SocketTimeoutException e1) {
                block39: {
                    exceptionCaught = true;
                    sockTimeoutStr = "";
                    try {
                        sockTimeout = this.socket.getSoTimeout();
                        sockTimeoutStr = String.valueOf(sockTimeout);
                    }
                    catch (SocketException e) {
                        if (!this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) break block39;
                        this.logger.severe("    Exception caught while processing SocketTimeoutException in Connection.receive()");
                        this.logger.severe("    Exception caught was: [" + e.toString() + "]");
                        this.logger.severe("    Original SocketExceptionTimeout was: [" + e1.toString() + "]");
                    }
                }
                errMsg = ImsConnectErrorMessage.getString("HWS0025E", new Object[]{"Interaction", sockTimeoutStr, ImsConnectErrorMessage.getExceptionMessage(e1)});
                e2 = new ImsConnectCommunicationException("HWS0025E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    SocketTimeoutException caught in Connection.receive().  Exception caught was: " + e2.toString());
                }
                throw e2;
            }
            catch (IOException e3) {
                exceptionCaught = true;
                errMsg = ImsConnectErrorMessage.getString("HWS0008E", new Object[]{this.hostName, String.valueOf(this.portNumber), ImsConnectErrorMessage.getExceptionMessage(e3)});
                e4 = new ImsConnectCommunicationException("HWS0008E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    IOException caught in Connection.receive().  Exception caught was: " + e4.toString());
                }
                throw e4;
            }
            catch (ImsConnectCommunicationException e5) {
                throw e5;
            }
            catch (Exception e6) {
                exceptionCaught = true;
                errMsg = ImsConnectErrorMessage.getString("HWS0001E", new Object[]{ImsConnectErrorMessage.getExceptionMessage(e6)});
                e7 = new ImsConnectCommunicationException("HWS0001E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception caught in Connection.receive().  Exception caught was: " + e7.toString());
                }
                throw e6;
            }
            finally {
                if (!this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL) || !exceptionCaught || bytesAsString == null || bytesAsString.length() <= 0) break block40;
                inBytesLength = inBytes.length;
                obfuscatePassword = true;
                bufferReceived = null;
                bufferReceivedStringArray = null;
                bufferReceived = ((TmInteractionImpl)this.myTmInteraction).formatBufferForTracing(inBytes, obfuscatePassword);
                bufferReceivedStringArray = ((TmInteractionImpl)this.myTmInteraction).stringToStringArray(bufferReceived);
                this.logger.finest("   Connection.receive() - Buffer received from stringbuffer: (may be corrupt or incomplete)");
                i = 0;
                ** while (i < bufferReceivedStringArray.length)
            }
lbl-1000:
            // 1 sources

            {
                this.logger.finest(bufferReceivedStringArray[i]);
                ++i;
                continue;
            }
lbl200:
            // 1 sources

            bufferReceived = null;
            bufferReceivedStringArray = null;
            if (inBytesLength > 0) {
                bufferReceived = ((TmInteractionImpl)this.myTmInteraction).formatBufferForTracing(inBytes, obfuscatePassword);
                bufferReceivedStringArray = ((TmInteractionImpl)this.myTmInteraction).stringToStringArray(bufferReceived);
                this.logger.finest("   Connection.receive() - Buffer received from receive byte array: (may be corrupt or incomplete)");
                i = 0;
                while (i < bufferReceivedStringArray.length) {
                    this.logger.finest(bufferReceivedStringArray[i]);
                    ++i;
                }
                bufferReceived = null;
                bufferReceivedStringArray = null;
            }
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- ConnectionImpl.receive()...");
        }
        throw var19_45;
    }

    @Override
    public void send(byte[] outBytes) throws ImsConnectApiException {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> ConnectionImpl.send(byte[])...");
        }
        try {
            try {
                if (!this.isConnected()) {
                    String internalMsg = ImsConnectErrorMessage.getString("NO_CONN");
                    String errMsg = ImsConnectErrorMessage.getString("HWS0008E", new Object[]{this.hostName, String.valueOf(this.portNumber), internalMsg});
                    ImsConnectCommunicationException e = new ImsConnectCommunicationException("HWS0008E", errMsg);
                    if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                        this.logger.severe("    Exception thrown in Connection.send(byte[]).  Exception thrown was: " + e.toString());
                    }
                    throw e;
                }
                OutputStream out = this.socket.getOutputStream();
                out.write(outBytes);
            }
            catch (IOException e1) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0008E", new Object[]{this.hostName, String.valueOf(this.portNumber), ImsConnectErrorMessage.getExceptionMessage(e1)});
                ImsConnectCommunicationException e2 = new ImsConnectCommunicationException("HWS0008E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    IOException caught in Connection.send(byte[]).  Exception caught was: " + e2.toString());
                }
                throw e2;
            }
        }
        finally {
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
                this.logger.finer("<-- ConnectionImpl.send(byte[])...");
            }
        }
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void setClientId(String aClientId) throws ImsConnectApiException {
        if (this.isConnected() && !this.returnedClientID) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0033E", new Object[]{"clientId", this.clientId});
            ImsConnectApiException e = new ImsConnectApiException("HWS0033E", errMsg);
            if (!this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) throw e;
            this.logger.severe("    Exception thrown in Connection.setClientId(String). Exception thrown was: " + e.toString());
            throw e;
        }
        if (aClientId.trim().equals("")) {
            if (this.clientId.equals("        ")) return;
            this.clientId = "        ";
            this.updateIrmClientId = true;
            return;
        }
        if (PropertiesFileLoader.isValidHostStyleName(aClientId.trim())) {
            if (aClientId.equals(this.clientId)) return;
            this.clientId = aClientId.toUpperCase();
            this.updateIrmClientId = true;
            return;
        }
        if (aClientId.length() > 8) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0026E", new Object[]{aClientId, "clientId", "8"});
            ImsConnectApiException e = new ImsConnectApiException("HWS0026E", errMsg);
            if (!this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) throw e;
            this.logger.severe("    Exception thrown in Connection.setClientId(String). Exception thrown was: " + e.toString());
            throw e;
        }
        String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"clientID", aClientId});
        ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
        if (!this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) throw e;
        this.logger.severe("    Exception thrown in Connection.setClientId(String). Exception thrown was: " + e.toString());
        throw e;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setHostName(String aHostName) throws ImsConnectApiException {
        if (!this.isConnected()) {
            String[] result = aHostName.split("\\.");
            boolean valid = true;
            boolean ipAddress = true;
            int numberOfNodes = result.length;
            int i = 0;
            while (i < numberOfNodes) {
                block22: {
                    try {
                        int octet = Integer.parseInt(result[i]);
                        if (octet < 0 || octet > 255) {
                            valid = false;
                        }
                        break block22;
                    }
                    catch (Exception e) {
                        valid = false;
                        ipAddress = false;
                    }
                    break;
                }
                ++i;
            }
            if (valid && ipAddress && numberOfNodes != 4 && numberOfNodes != 6) {
                valid = false;
            }
            if (!ipAddress) {
                if (aHostName.length() <= 255 && validLetters.indexOf(aHostName.charAt(0)) != -1) {
                    if (numberOfNodes <= 127) {
                        valid = true;
                        i = 0;
                        while (i < numberOfNodes) {
                            int strLen = result[i].length();
                            if (strLen > 63) {
                                valid = false;
                                i = numberOfNodes;
                            } else {
                                char[] charBuf = new char[strLen];
                                result[i].getChars(0, strLen, charBuf, 0);
                                int j = 0;
                                while (j < strLen) {
                                    if (validChars.indexOf(charBuf[j]) == -1) {
                                        valid = false;
                                        i = numberOfNodes;
                                        j = strLen;
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                    }
                } else {
                    valid = false;
                }
            }
            if (!valid) {
                String validHostnameString = "";
                try {
                    validHostnameString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_HOSTNAME");
                }
                catch (Exception strLen) {
                    // empty catch block
                }
                String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"hostName", aHostName, validHostnameString});
                ImsConnectApiException e1 = new ImsConnectApiException("HWS0030E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception caught in Connection.setHostName(String). Exception caught was: " + e1.toString());
                }
                throw e1;
            }
        } else {
            if (this.hostName.equalsIgnoreCase(aHostName)) {
                return;
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0033E", new Object[]{"hostName", this.clientId});
            ImsConnectApiException e1 = new ImsConnectApiException("HWS0033E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setHostName(String). Exception thrown was: " + e1.toString());
            }
            throw e1;
        }
        this.hostName = aHostName;
    }

    @Override
    public int getInteractionTimeout() {
        return this.interactionTimeout;
    }

    @Override
    public void setInteractionTimeout(int anInteractionTimeout) throws ImsConnectApiException {
        if (anInteractionTimeout <= 0 && anInteractionTimeout != -1) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0007E", new Object[]{"ConnectionImpl.setInteractionTimeout(int)", String.valueOf(anInteractionTimeout)});
            ImsConnectApiException e = new ImsConnectApiException("HWS0007E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setInteractionTimeout(int). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.interactionTimeout = anInteractionTimeout;
        if (this.isConnected()) {
            this.setSoTimeout();
        } else {
            this.setSetSoTimeoutRequired(true);
        }
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public void setPortNumber(int aPortNumber) throws ImsConnectApiException {
        if (aPortNumber > 0 && aPortNumber <= 65535) {
            if (this.getPortNumber() == aPortNumber) {
                return;
            }
            if (this.isConnected()) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0033E", new Object[]{"portNumber", this.clientId});
                ImsConnectApiException e = new ImsConnectApiException("HWS0033E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in Connection.setPortNumber(int). Exception thrown was: " + e.toString());
                }
                throw e;
            }
        } else {
            String validPortNumberString = "";
            try {
                validPortNumberString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_PORTNUMBER");
            }
            catch (Exception e) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"portNumber", String.valueOf(aPortNumber), validPortNumberString});
            ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setPortNumber(int).  Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.portNumber = aPortNumber;
    }

    protected Socket getSocket() {
        return this.socket;
    }

    protected void setSocket(Socket socket) {
        this.socket = socket;
    }

    @Override
    public int getSocketConnectTimeout() {
        return this.socketConnectTimeout;
    }

    @Override
    public void setSocketConnectTimeout(int aSocketConnectTimeout) throws ImsConnectApiException {
        if (aSocketConnectTimeout <= 0 && aSocketConnectTimeout != -1) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0007E", new Object[]{"ConnectionImpl.setSocketConnectTimeout(int)", aSocketConnectTimeout});
            ImsConnectApiException e = new ImsConnectApiException("HWS0007E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setSocketConnectTimeout(). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.socketConnectTimeout = aSocketConnectTimeout;
    }

    @Override
    public byte getSocketType() {
        return this.socketType;
    }

    @Override
    public void setSocketType(byte aSocketType) throws ImsConnectApiException {
        if (this.getSocketType() == aSocketType) {
            return;
        }
        if (this.isConnected()) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0033E", new Object[]{"socketType", this.clientId});
            ImsConnectApiException e = new ImsConnectApiException("HWS0033E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setSocketType(byte). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        if (aSocketType != 16 && aSocketType != 0) {
            String validSocketTypeString = "";
            try {
                validSocketTypeString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_SOCKETTYPE");
            }
            catch (Exception e) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"socketType", String.valueOf(aSocketType), validSocketTypeString});
            ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setSocketType(byte).  Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.socketType = aSocketType;
    }

    @Override
    public byte getSslEncryptionType() {
        return this.sslEncryptionType;
    }

    @Override
    public void setSslEncryptionType(byte anSslEncryptionType) throws ImsConnectApiException {
        if (this.getSslEncryptionType() == anSslEncryptionType) {
            return;
        }
        if (this.isConnected()) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0033E", new Object[]{"sslEncryptionType", this.clientId});
            ImsConnectApiException e = new ImsConnectApiException("HWS0033E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setSslEncryptionType(byte). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        if (anSslEncryptionType != 0 && anSslEncryptionType != 1 && anSslEncryptionType != 2) {
            String validSslEncryptionTypeString = "";
            try {
                validSslEncryptionTypeString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_SSLENCRYPTIONTYPE");
            }
            catch (Exception e) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"socketType", String.valueOf(anSslEncryptionType), validSslEncryptionTypeString});
            ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setSslEncryptionType(byte).  Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.sslEncryptionType = anSslEncryptionType;
    }

    @Override
    public InputStream getSslKeystoreInputStream() {
        return this.sslKeystoreInputStream;
    }

    @Override
    public void setSslKeystoreInputStream(InputStream anSslKeystoreInputStream) {
        this.sslKeystoreInputStream = anSslKeystoreInputStream;
    }

    @Override
    public URL getSslKeystoreUrl() {
        return this.sslKeystoreUrl;
    }

    @Override
    public void setSslKeystoreUrl(URL anSslKeystoreUrl) {
        this.sslKeystoreUrl = anSslKeystoreUrl;
    }

    @Override
    public String getSslKeystoreName() {
        return this.sslKeystoreName;
    }

    @Override
    public void setSslKeystoreName(String anSslKeystoreName) throws ImsConnectApiException {
        if (this.getSslKeystoreName() == anSslKeystoreName) {
            return;
        }
        if (this.isConnected()) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0033E", new Object[]{"anSslKeystoreName", this.clientId});
            ImsConnectApiException e = new ImsConnectApiException("HWS0033E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setPortNumber(int). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.sslKeystoreName = anSslKeystoreName;
    }

    @Override
    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    @Override
    public void setSslKeystorePassword(String anSslKeystorePassword) throws ImsConnectApiException {
        if (this.getSslKeystorePassword() == anSslKeystorePassword) {
            return;
        }
        if (this.isConnected()) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0033E", new Object[]{"anSslKeystorePassword", this.clientId});
            ImsConnectApiException e = new ImsConnectApiException("HWS0033E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setSslKeystorePassword(String). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.sslKeystorePassword = anSslKeystorePassword;
    }

    @Override
    public InputStream getSslTruststoreInputStream() {
        return this.sslTruststoreInputStream;
    }

    @Override
    public void setSslTruststoreInputStream(InputStream sslTruststoreInputStream) {
        this.sslTruststoreInputStream = sslTruststoreInputStream;
    }

    @Override
    public URL getSslTruststoreUrl() {
        return this.sslTruststoreUrl;
    }

    @Override
    public void setSslTruststoreUrl(URL anSslTruststoreUrl) {
        this.sslTruststoreUrl = anSslTruststoreUrl;
    }

    @Override
    public String getSslTruststoreName() {
        return this.sslTruststoreName;
    }

    @Override
    public void setSslTruststoreName(String anSslTruststoreName) throws ImsConnectApiException {
        if (this.getSslTruststoreName() == anSslTruststoreName) {
            return;
        }
        if (this.isConnected()) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0033E", new Object[]{"anSslTruststoreName", this.clientId});
            ImsConnectApiException e = new ImsConnectApiException("HWS0033E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setSslTruststoreName(String). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.sslTruststoreName = anSslTruststoreName;
    }

    @Override
    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    @Override
    public void setSslTruststorePassword(String anSslTruststorePassword) throws ImsConnectApiException {
        if (this.getSslTruststorePassword() == anSslTruststorePassword) {
            return;
        }
        if (this.isConnected()) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0033E", new Object[]{"anSslTruststoreName", this.clientId});
            ImsConnectApiException e = new ImsConnectApiException("HWS0033E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setSslTruststorePassword(String). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.sslTruststorePassword = anSslTruststorePassword;
    }

    protected boolean isSetSoTimeoutRequired() {
        return this.setSoTimeoutRequired;
    }

    private void setSetSoTimeoutRequired(boolean setSoTimeoutRequired) {
        this.setSoTimeoutRequired = setSoTimeoutRequired;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        if (this.sslSocket != null) {
            return this.sslSocket.getEnabledCipherSuites();
        }
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public boolean isUseSslConnection() {
        return this.useSslConnection;
    }

    @Override
    public void setUseSslConnection(boolean aUseSslConnection) throws ImsConnectApiException {
        if (this.isUseSslConnection() == aUseSslConnection) {
            return;
        }
        if (this.isConnected()) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0033E", new Object[]{"useSslConnection", this.clientId});
            ImsConnectApiException e = new ImsConnectApiException("HWS0033E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setUseSslConnection(String). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.useSslConnection = aUseSslConnection;
    }

    private void setIsConnected(boolean anIsConnected) {
        if (this.isConnected() != anIsConnected) {
            this.isConnected = anIsConnected;
        }
    }

    private void setSoTimeout() throws ImsConnectCommunicationException {
        try {
            if (this.interactionTimeout == -1) {
                this.socket.setSoTimeout(0);
            } else if (this.interactionTimeout >= 0) {
                this.socket.setSoTimeout(this.interactionTimeout);
            }
        }
        catch (SocketException e1) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0037E", new Object[]{"socket.setSoTimeout()", e1.toString()});
            ImsConnectCommunicationException e = new ImsConnectCommunicationException("HWS0037E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setSoTimeout(). Exception thrown was: " + e.toString());
            }
            throw e;
        }
    }

    @Override
    public void run() {
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.hostName);
        buf.append(",");
        buf.append(this.portNumber);
        buf.append(",");
        buf.append(this.interactionTimeout);
        buf.append(",");
        buf.append(this.sslEncryptionType);
        buf.append(",");
        buf.append(this.sslKeystoreName);
        buf.append(",");
        buf.append(this.sslTruststoreName);
        buf.append(",");
        buf.append(this.useSslConnection);
        return buf.toString();
    }

    public void finalize() {
        block4: {
            try {
                if (this.isUseSslConnection()) {
                    this.sslKeystoreInputStream.close();
                    this.sslTruststoreInputStream.close();
                }
                if (this.isConnected()) {
                    this.close();
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) break block4;
                this.logger.severe("    Exception thrown in Connection.finalize() while removing unused Connection instance. Exception thrown was: " + e.toString());
            }
        }
    }

    private String validateHostName(String host) throws ImsConnectApiException {
        String[] result = host.split("\\.");
        boolean valid = true;
        boolean ipAddress = true;
        int numberOfNodes = result.length;
        int i = 0;
        while (i < numberOfNodes) {
            block18: {
                try {
                    int octet = Integer.parseInt(result[i]);
                    if (octet < 0 || octet > 255) {
                        valid = false;
                    }
                    break block18;
                }
                catch (Exception e) {
                    valid = false;
                    ipAddress = false;
                }
                break;
            }
            ++i;
        }
        if (valid && ipAddress && numberOfNodes != 4 && numberOfNodes != 6) {
            valid = false;
        }
        if (!ipAddress) {
            if (host.length() <= 255 && validLetters.indexOf(host.charAt(0)) != -1) {
                if (numberOfNodes <= 127) {
                    valid = true;
                    i = 0;
                    while (i < numberOfNodes) {
                        int strLen = result[i].length();
                        if (strLen > 63) {
                            valid = false;
                            i = numberOfNodes;
                        } else {
                            char[] charBuf = new char[strLen];
                            result[i].getChars(0, strLen, charBuf, 0);
                            int j = 0;
                            while (j < strLen) {
                                if (validChars.indexOf(charBuf[j]) == -1) {
                                    valid = false;
                                    i = numberOfNodes;
                                    j = strLen;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            } else {
                valid = false;
            }
        }
        if (valid) {
            return host;
        }
        String validHostnameString = "";
        try {
            validHostnameString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_HOSTNAME");
        }
        catch (Exception strLen) {
            // empty catch block
        }
        String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"hostName", host, validHostnameString});
        ImsConnectApiException e1 = new ImsConnectApiException("HWS0030E", errMsg);
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
            this.logger.severe("    Exception caught in Connection.setHostName(String). Exception caught was: " + e1.toString());
        }
        throw e1;
    }

    private int validatePortNumber(int port) throws ImsConnectApiException {
        if (port > 0 && port <= 65535) {
            return port;
        }
        String validPortNumberString = "";
        try {
            validPortNumberString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_PORTNUMBER");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"portNumber", String.valueOf(port), validPortNumberString});
        ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
            this.logger.severe("    Exception thrown in Connection.setPortNumber(int).  Exception thrown was: " + e.toString());
        }
        throw e;
    }
}

