/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.connect.impl;

import com.ibm.ims.connect.ApiProperties;
import com.ibm.ims.connect.Hdr;
import com.ibm.ims.connect.ImsConnectApiException;
import com.ibm.ims.connect.ImsConnectErrorMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class HdrImpl
implements Hdr {
    private String elementText = null;
    private String uri = null;
    private Attributes attributes = null;
    private Properties myProperties = new Properties();
    private String slbl = null;
    private String llbl = null;
    private String scope = null;
    private String sort = null;
    private String key = null;
    private String scroll = null;
    private String len = null;
    private String dtype = null;
    private String skipb = null;
    private String align = null;
    private Logger logger = Logger.getLogger("com.ibm.ims.connect");

    public HdrImpl(String anElementText) {
        this.setElementText(anElementText);
    }

    @Override
    public String getHdrAttributesAsXmlString() {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> Hdr.getHdrAttributesAsXmlString()");
        }
        StringBuffer hdrAttributesAsXmlStringBuffer = new StringBuffer();
        hdrAttributesAsXmlStringBuffer.append("<?xml version=\"1.0\"?><!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\"><properties>");
        if (this.getSlbl() != null) {
            hdrAttributesAsXmlStringBuffer.append("<entry key=\"SLBL\">" + this.getSlbl() + "</entry>");
        }
        if (this.getLlbl() != null) {
            hdrAttributesAsXmlStringBuffer.append("<entry key=\"LLBL\">" + this.getLlbl() + "</entry>");
        }
        if (this.getScope() != null) {
            hdrAttributesAsXmlStringBuffer.append("<entry key=\"SCOPE\">" + this.getScope() + "</entry>");
        }
        if (this.getSort() != null) {
            hdrAttributesAsXmlStringBuffer.append("<entry key=\"SORT\">" + this.getSort() + "</entry>");
        }
        if (this.getKey() != null) {
            hdrAttributesAsXmlStringBuffer.append("<entry key=\"KEY\">" + this.getKey() + "</entry>");
        }
        if (this.getScroll() != null) {
            hdrAttributesAsXmlStringBuffer.append("<entry key=\"SCROLL\">" + this.getScroll() + "</entry>");
        }
        if (this.getLen() != null) {
            hdrAttributesAsXmlStringBuffer.append("<entry key=\"LEN\">" + this.getLen() + "</entry>");
        }
        if (this.getDtype() != null) {
            hdrAttributesAsXmlStringBuffer.append("<entry key=\"DTYPE\">" + this.getDtype() + "</entry>");
        }
        if (this.getSkipb() != null) {
            hdrAttributesAsXmlStringBuffer.append("<entry key=\"SKIPB\">" + this.getKey() + "</entry>");
        }
        if (this.getAlign() != null) {
            hdrAttributesAsXmlStringBuffer.append("<entry key=\"ALIGN\">" + this.getKey() + "</entry>");
        }
        hdrAttributesAsXmlStringBuffer.append("</properties>");
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- Hdr.getHdrAttributesAsXmlString()");
        }
        return hdrAttributesAsXmlStringBuffer.toString();
    }

    @Override
    public Properties getHdrElementAttributesAsPropertiesObject(String anEncoding) throws ImsConnectApiException {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> Hdr.getHdrAttributesAsPropertiesObject(String anEncoding)");
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(this.getHdrAttributesAsXmlString().getBytes(anEncoding));
            this.myProperties.clear();
            this.myProperties.loadFromXML(is);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"Type-2 command cmdrsphdr", anEncoding});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in Hdr.getHdrAttributesAsPropertiesObject(String anEncoding): [" + e.toString() + "]");
            }
            throw e;
        }
        catch (InvalidPropertiesFormatException ipfe) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0044E", new Object[]{ipfe.toString()});
            ImsConnectApiException e = new ImsConnectApiException("HWS0044E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in Hdr.getHdrAttributesAsPropertiesObject(String anEncoding): [" + ipfe.toString() + "]");
            }
            throw e;
        }
        catch (IOException ioe) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0044E", new Object[]{ioe.toString()});
            ImsConnectApiException e = new ImsConnectApiException("HWS0044E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in Hdr.getHdrAttributesAsPropertiesObject(String anEncoding): [" + e.toString() + "]+");
            }
            throw e;
        }
        catch (Exception e) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0044E", new Object[]{e.toString()});
            ImsConnectApiException e1 = new ImsConnectApiException("HWS0044E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in Hdr.getHdrAttributesAsPropertiesObject(String anEncoding): [" + e1.toString() + "]+");
            }
            throw e1;
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- Hdr.getHdrAttributesAsPropertiesObject(String anEncoding)");
        }
        return this.myProperties;
    }

    @Override
    public String getElementText() {
        return this.elementText;
    }

    public void setElementText(String anElementText) {
        this.elementText = anElementText;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public String getSlbl() {
        return this.slbl;
    }

    public void setSlbl(String slbl) {
        this.slbl = slbl;
    }

    @Override
    public String getLlbl() {
        return this.llbl;
    }

    public void setLlbl(String llbl) {
        this.llbl = llbl;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getScroll() {
        return this.scroll;
    }

    public void setScroll(String scroll) {
        this.scroll = scroll;
    }

    @Override
    public String getLen() {
        return this.len;
    }

    public void setLen(String len) {
        this.len = len;
    }

    @Override
    public String getDtype() {
        return this.dtype;
    }

    public void setDtype(String dtype) {
        this.dtype = dtype;
    }

    @Override
    public String getSkipb() {
        return this.skipb;
    }

    public void setSkipb(String skipb) {
        this.skipb = skipb;
    }

    @Override
    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }
}

