/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.connect.impl;

import com.ibm.ims.connect.ApiProperties;
import com.ibm.ims.connect.ImsConnectApiException;
import com.ibm.ims.connect.ImsConnectErrorMessage;
import com.ibm.ims.connect.InputMessage;
import com.ibm.ims.connect.InputMessageProperties;
import com.ibm.ims.connect.TmInteraction;
import com.ibm.ims.connect.impl.ConnectionImpl;
import com.ibm.ims.connect.impl.TmInteractionImpl;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.logging.Logger;

public class InputMessageImpl
implements InputMessage {
    private static final String copyright = "Licensed Material - Property of IBM 5655-T62(C) Copyright IBM Corp. 2009,2012  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private int llll = 0;
    private int irmLen = 0;
    private byte irmArch;
    private byte irmF0;
    private byte[] irmId;
    private short irmResWord;
    private int irmF5;
    private int irmTimer;
    private byte irmSocType;
    private byte irmEncodingSchema;
    private byte[] irmClientId;
    private byte irmF1;
    private byte irmF2;
    private byte irmF3;
    private char irmF4;
    private byte[] irmTrancode;
    private byte[] irmDestId;
    private byte[] irmLTerm;
    private byte[] irmRacfUserId;
    private byte[] irmRacfGroupName;
    private byte[] irmRacfPassword;
    private byte[] irmRacfApplName;
    private byte[] irmRerouteName;
    private byte[] irmTagAdapter;
    private byte[] irmTagMap;
    private short irmNakReasonCode = 0;
    private byte[] irmInputModname;
    private byte[] irmCorelatorToken;
    private byte[] trancodeInData;
    private int trancodeInDataLength = 0;
    private byte[] trancodeInDataToBeUsed;
    private byte[] data = null;
    private String imsConnectCodepage = "CP037";
    private boolean inputMessageDataSegmentsIncludeLlzzAndTrancode = false;
    private boolean connectionPropertiesAlreadySet = false;
    private boolean tmInteractionPropertiesAlreadySet = false;
    private int i = 0;
    private Logger logger;
    private TmInteractionImpl myTmInteractionImpl;
    private String aCodepage;
    private byte[] message = null;
    int messageLength = 0;
    private ArrayList<byte[]> inputData = new ArrayList();
    private int numberOfSegments;
    private int[] segmentLengths;
    private int bytesProcessed = 0;
    private int bytesCopied = 0;
    private boolean inConversation;
    private boolean rebuildData;
    private boolean tranRemoved = false;
    byte[] aBlankTrancodeByteArray = null;
    byte[] anEmptyTrancodeByteArray = new byte[0];

    public InputMessageImpl(TmInteraction myTMInteraction) throws ImsConnectApiException {
        this.logger = Logger.getLogger("com.ibm.ims.connect");
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> InputMessage(TmInteraction)");
        }
        this.myTmInteractionImpl = (TmInteractionImpl)myTMInteraction;
        this.reset();
        this.setImsConnectCodepage(this.myTmInteractionImpl.getImsConnectCodepage());
        try {
            this.aBlankTrancodeByteArray = new String("        ").getBytes(this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage constructor: [" + e.getMessage() + "]+");
            }
            throw e;
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- InputMessage(TmInteraction)");
        }
    }

    public void reset() throws ImsConnectApiException {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> InputMessage.reset()");
        }
        this.setLlll(0);
        this.setImsConnectCodepage("CP037");
        this.setIrmLen(0);
        this.setIrmArch((byte)3);
        this.setIrmF0((byte)0);
        this.setIrmId("        ");
        this.setIrmNakReasonCode((short)0);
        this.setIrmResWord((short)0);
        this.setIrmF5(0);
        this.setIrmTimer(0);
        this.setIrmSocType((byte)16);
        this.setIrmEncodingSchema((byte)0);
        this.setIrmClientId("        ");
        this.setIrmF1((byte)0);
        this.setIrmF2((byte)32);
        this.setIrmF3((byte)0);
        this.setIrmF4(' ');
        this.setIrmTrancode("        ");
        this.setIrmDestId("        ");
        this.setIrmLTerm("        ");
        this.setIrmRacfUserId("        ");
        this.setIrmRacfGroupName("        ");
        this.setIrmRacfPassword("        ");
        this.setIrmRacfApplName("        ");
        this.setIrmRerouteName("        ");
        this.setIrmTagAdapter("        ");
        this.setIrmTagMap("        ");
        this.setIrmInputModName("        ");
        this.setIrmCorelatorToken(ApiProperties.CORRELATOR_TOKEN_DEFAULT);
        this.setInputMessageDataSegmentsIncludeLlzzAndTrancode(false);
        this.setData(null);
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            this.logger.finer("     InputMessage.llll reset to 0");
            this.logger.finer("     InputMessage IRM properties reset to default values");
            this.logger.finer("     InputMessage.inputMessageDataSegmentsIncludeLlzzAndTrancode reset to false");
            this.logger.finer("     InputMessage.data reset to null");
        }
        this.setConnectionPropertiesAlreadySet(false);
        this.setTmInteractionPropertiesAlreadySet(false);
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- InputMessage.reset()");
        }
    }

    public void copyInputMessage(InputMessageImpl anInputMessage) throws UnsupportedEncodingException {
        this.setLlll(anInputMessage.getLlll());
        this.imsConnectCodepage = anInputMessage.getImsConnectCodepage();
        this.irmLen = anInputMessage.getIrmLen();
        this.irmArch = anInputMessage.getIrmArch();
        this.irmF0 = anInputMessage.getIrmF0();
        this.irmId = anInputMessage.getIrmId();
        this.irmNakReasonCode = anInputMessage.getIrmNakReasonCode();
        this.irmResWord = anInputMessage.getIrmResWord();
        this.irmF5 = anInputMessage.getIrmF5();
        this.irmTimer = anInputMessage.getIrmTimer();
        this.irmSocType = anInputMessage.getIrmSocType();
        this.irmEncodingSchema = anInputMessage.getIrmEncodingSchema();
        this.irmClientId = anInputMessage.getIrmClientId();
        this.irmF1 = anInputMessage.getIrmF1();
        this.irmF2 = anInputMessage.getIrmF2();
        this.irmF3 = anInputMessage.getIrmF3();
        this.irmF4 = anInputMessage.getIrmF4();
        this.irmTrancode = anInputMessage.getIrmTrancode();
        this.irmDestId = anInputMessage.getIrmDestId();
        this.irmLTerm = anInputMessage.getIrmLTerm();
        this.irmRacfUserId = anInputMessage.getIrmRacfUserId();
        this.irmRacfGroupName = anInputMessage.getIrmRacfGroupName();
        this.irmRacfPassword = anInputMessage.getIrmRacfPassword();
        this.irmRacfApplName = anInputMessage.getIrmRacfApplName();
        this.irmRerouteName = anInputMessage.getIrmRerouteName();
        this.irmTagAdapter = anInputMessage.getIrmTagAdapter();
        this.irmTagMap = anInputMessage.getIrmTagMap();
        this.irmInputModname = anInputMessage.getIrmInputModName();
        this.irmCorelatorToken = anInputMessage.getIrmCorelatorToken();
        this.setInputMessageDataSegmentsIncludeLlzzAndTrancode(anInputMessage.isInputMessageDataSegmentsIncludeLlzzAndTrancode());
        this.setData(anInputMessage.getData());
    }

    public void setConnectionProperties(ConnectionImpl aConnImpl) throws ImsConnectApiException {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> InputMessage.setConnectionProperties(ConnectionImpl)");
        }
        this.setIrmSocType(aConnImpl.getSocketType());
        if (aConnImpl.updateIrmClientId) {
            this.setIrmClientId(aConnImpl.getClientId());
            aConnImpl.updateIrmClientId = false;
        }
        this.connectionPropertiesAlreadySet = true;
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- InputMessage.setConnectionProperties(ConnectionImpl)");
        }
    }

    public void setTmInteractionProperties() throws ImsConnectApiException {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> InputMessage.setTMInteractionProperties()");
        }
        String interTypeDesc = this.myTmInteractionImpl.getInteractionTypeDescription().trim();
        String iconUserMessageExitId = this.myTmInteractionImpl.getImsConnectUserMessageExitIdentifier();
        this.setImsConnectCodepage(this.myTmInteractionImpl.getImsConnectCodepage());
        this.setIrmArch(this.myTmInteractionImpl.getArchitectureLevel());
        this.setIrmF0(this.myTmInteractionImpl.getXmlMessageType());
        if (this.myTmInteractionImpl.updateIrmId) {
            this.setIrmId(iconUserMessageExitId);
            this.myTmInteractionImpl.updateIrmId = false;
        }
        if (iconUserMessageExitId.equals("*SAMPLE*")) {
            this.myTmInteractionImpl.setResponseIncludesLlll(false);
        } else if (iconUserMessageExitId.equals("*SAMPL1*") || iconUserMessageExitId.equals("*HWSCSL*") || iconUserMessageExitId.equals("*HWSCS1*")) {
            this.myTmInteractionImpl.setResponseIncludesLlll(true);
        }
        this.setIrmNakReasonCode(this.myTmInteractionImpl.getNakReasonCode());
        this.setIrmResWord((short)0);
        this.irmF5 = 0;
        this.setIrmF5(this.myTmInteractionImpl.getInputMessageOptions());
        this.setIrmTimer(this.myTmInteractionImpl.getImsConnectTimeoutIndex());
        this.setIrmEncodingSchema(this.myTmInteractionImpl.getImsConnectUnicodeEncodingSchema());
        this.irmF1 = 0;
        this.setIrmF1(this.myTmInteractionImpl.isOtmaTransactionExpiration() ? (byte)1 : 0);
        this.setIrmF1(this.myTmInteractionImpl.getImsConnectUnicodeUsage());
        this.setIrmF1(this.myTmInteractionImpl.isReturnMfsModname() ? (byte)-128 : 0);
        this.setIrmF1(this.myTmInteractionImpl.isCM0AckNoWaitCanBeUsed() ? (byte)2 : 0);
        this.setIrmF1(this.myTmInteractionImpl.isReturnClientId() ? (byte)64 : 0);
        this.setIrmF2(this.myTmInteractionImpl.getCommitMode());
        if (this.myTmInteractionImpl.isGenerateClientIdWhenDuplicate()) {
            this.irmF2 = (byte)(this.irmF2 | 1);
        }
        this.irmF3 = this.myTmInteractionImpl.isCancelClientId() ? (byte)-128 : (byte)0;
        this.setIrmF3(this.myTmInteractionImpl.getSyncLevel());
        if (this.myTmInteractionImpl.isPurgeUndeliverableOutput()) {
            this.setIrmF3((byte)4);
        }
        if (this.myTmInteractionImpl.isRerouteUndeliverableOutput()) {
            this.setIrmF3((byte)8);
        }
        if (this.myTmInteractionImpl.isCm0IgnorePurge()) {
            this.setIrmF3((byte)32);
        }
        if (this.myTmInteractionImpl.isReturnDFS2082AfterCM0SendRecvNoResponse()) {
            this.setIrmF3((byte)64);
        }
        if (interTypeDesc.equals("ACK")) {
            if (this.myTmInteractionImpl.updateIrmInteractionType) {
                this.setIrmF4('A');
                this.myTmInteractionImpl.updateIrmInteractionType = false;
            }
        } else if (interTypeDesc.equals("CANCELTIMER")) {
            if (this.myTmInteractionImpl.updateIrmInteractionType) {
                this.setIrmF4('C');
                this.myTmInteractionImpl.updateIrmInteractionType = false;
            }
            this.irmF3 = (byte)(this.irmF3 & 0x7F);
        } else if (interTypeDesc.equals("ENDCONVERSATION")) {
            if (this.myTmInteractionImpl.updateIrmInteractionType) {
                this.setIrmF4('D');
                this.myTmInteractionImpl.updateIrmInteractionType = false;
            }
        } else if (!interTypeDesc.equals("RECEIVE")) {
            if (interTypeDesc.equals("SENDONLYACK")) {
                if (this.myTmInteractionImpl.updateIrmInteractionType) {
                    this.setIrmF4('K');
                    this.myTmInteractionImpl.updateIrmInteractionType = false;
                }
            } else if (interTypeDesc.equals("NAK")) {
                if (this.myTmInteractionImpl.updateIrmInteractionType) {
                    this.setIrmF4('N');
                    this.myTmInteractionImpl.updateIrmInteractionType = false;
                }
                if (this.myTmInteractionImpl.getCalloutRequestNakProcessing().equals("DISCARDREQUESTCONTINUERESUMETPIPE")) {
                    this.setIrmF3((byte)8);
                } else if (this.myTmInteractionImpl.getCalloutRequestNakProcessing().equals("REQUEUEREQUESTENDRESUMETPIPE")) {
                    this.setIrmF0((byte)32);
                }
                if ((this.myTmInteractionImpl.getCalloutRequestNakProcessing().equals("DISCARDREQUESTENDRESUMETPIPE") || this.myTmInteractionImpl.getCalloutRequestNakProcessing().equals("DISCARDREQUESTCONTINUERESUMETPIPE")) && this.myTmInteractionImpl.getNakReasonCode() != 0) {
                    this.setIrmF0((byte)16);
                }
            } else if (interTypeDesc.equals("RESUMETPIPE")) {
                if (this.myTmInteractionImpl.updateIrmInteractionType) {
                    this.setIrmF4('R');
                    this.myTmInteractionImpl.updateIrmInteractionType = false;
                }
                this.setIrmF5(this.myTmInteractionImpl.getResumeTpipeProcessing());
                this.setIrmF0(this.myTmInteractionImpl.getResumeTpipeRetrievalType());
            } else if (interTypeDesc.equals("SENDONLY")) {
                if (this.myTmInteractionImpl.updateIrmInteractionType) {
                    this.setIrmF4('S');
                    this.myTmInteractionImpl.updateIrmInteractionType = false;
                }
            } else if (interTypeDesc.equals("SENDONLYXCFORDDLV")) {
                if (this.myTmInteractionImpl.updateIrmInteractionType) {
                    this.setIrmF4('S');
                    this.myTmInteractionImpl.updateIrmInteractionType = false;
                }
                this.setIrmF3((byte)16);
            } else if (interTypeDesc.equals("SENDRECV") || interTypeDesc.equals("TYPE2CMD")) {
                if (this.myTmInteractionImpl.updateIrmInteractionType) {
                    this.setIrmF4(' ');
                    this.myTmInteractionImpl.updateIrmInteractionType = false;
                }
            } else if (interTypeDesc.equals("SENDONLYCALLOUTRESPONSE")) {
                this.irmF0 = 0;
                this.setIrmArch((byte)3);
                if (this.myTmInteractionImpl.updateIrmInteractionType) {
                    this.setIrmF4('M');
                    this.myTmInteractionImpl.updateIrmInteractionType = false;
                }
                if (this.myTmInteractionImpl.getCalloutResponseMessageType().equals("CALLOUTERRORMESSAGE")) {
                    if (this.myTmInteractionImpl.getNakReasonCode() != 0) {
                        this.setIrmF0((byte)16);
                    } else {
                        this.setIrmF0((byte)32);
                    }
                }
            } else if (interTypeDesc.equals("SENDONLYACKCALLOUTRESPONSE")) {
                this.irmF0 = 0;
                this.setIrmArch((byte)3);
                if (this.myTmInteractionImpl.updateIrmInteractionType) {
                    this.setIrmF4('L');
                    this.myTmInteractionImpl.updateIrmInteractionType = false;
                }
                if (this.myTmInteractionImpl.getCalloutResponseMessageType().equals("CALLOUTERRORMESSAGE")) {
                    if (this.myTmInteractionImpl.getNakReasonCode() != 0) {
                        this.setIrmF0((byte)16);
                    } else {
                        this.setIrmF0((byte)32);
                    }
                }
            } else {
                String validInteractionTypeDescription = "";
                try {
                    validInteractionTypeDescription = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_INTERACTIONTYPEDESCRIPTION");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"interactionTypeDescription", interTypeDesc, validInteractionTypeDescription});
                ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in InputMessage.setTMInteractionProperties(): [" + e.getMessage() + "]+");
                }
                throw e;
            }
        }
        if (this.myTmInteractionImpl.updateIrmTrancode) {
            if (interTypeDesc.equals("RESUMETPIPE") || interTypeDesc.equals("SENDONLYCALLOUTRESPONSE") || interTypeDesc.equals("SENDONLYACKCALLOUTRESPONSE") || interTypeDesc.equals("TYPE2CMD")) {
                this.setIrmTrancode("        ");
            } else {
                this.setIrmTrancode(this.myTmInteractionImpl.getTrancode());
            }
            this.myTmInteractionImpl.updateIrmTrancode = false;
        }
        if (this.myTmInteractionImpl.updateIrmDestId) {
            this.setIrmDestId(this.myTmInteractionImpl.getImsDatastoreName());
            this.myTmInteractionImpl.updateIrmDestId = false;
        }
        if (this.myTmInteractionImpl.updateIrmLTerm) {
            this.setIrmLTerm(this.myTmInteractionImpl.getLtermOverrideName());
            this.myTmInteractionImpl.updateIrmLTerm = false;
        }
        if (this.myTmInteractionImpl.updateIrmRacfUserId) {
            this.setIrmRacfUserId(this.myTmInteractionImpl.getRacfUserId());
            this.myTmInteractionImpl.updateIrmRacfUserId = false;
        }
        if (this.myTmInteractionImpl.updateIrmRacfGroupName) {
            this.setIrmRacfGroupName(this.myTmInteractionImpl.getRacfGroupName());
            this.myTmInteractionImpl.updateIrmRacfGroupName = false;
        }
        if (this.myTmInteractionImpl.updateIrmRacfPassword) {
            this.setIrmRacfPassword(this.myTmInteractionImpl.getRacfPassword());
            this.myTmInteractionImpl.updateIrmRacfPassword = false;
        }
        if (this.myTmInteractionImpl.updateIrmRacfApplName) {
            this.setIrmRacfApplName(this.myTmInteractionImpl.getRacfApplName());
            this.myTmInteractionImpl.updateIrmRacfApplName = false;
        }
        if (this.myTmInteractionImpl.updateIrmRerouteName) {
            if (!interTypeDesc.equals("RESUMETPIPE")) {
                this.setIrmRerouteName(this.myTmInteractionImpl.getRerouteName());
            } else {
                this.setIrmRerouteName(this.myTmInteractionImpl.getResumeTpipeAlternateClientId());
            }
            this.myTmInteractionImpl.updateIrmRerouteName = false;
        }
        if (this.myTmInteractionImpl.updateIrmTagAdapter) {
            this.setIrmTagAdapter("        ");
            this.myTmInteractionImpl.updateIrmTagAdapter = false;
        }
        if (this.myTmInteractionImpl.updateIrmTagMap) {
            this.setIrmTagMap("        ");
            this.myTmInteractionImpl.updateIrmTagMap = false;
        }
        if (this.myTmInteractionImpl.updateIrmInputModName) {
            this.setIrmInputModName(this.myTmInteractionImpl.getInputModName());
            this.myTmInteractionImpl.updateIrmInputModName = false;
        }
        this.setIrmCorelatorToken(this.myTmInteractionImpl.getCorrelatorToken());
        this.setInputMessageDataSegmentsIncludeLlzzAndTrancode(this.myTmInteractionImpl.isInputMessageDataSegmentsIncludeLlzzAndTrancode());
        if (interTypeDesc.equals("TYPE2CMD")) {
            this.setTrancodeInData("        ");
        } else if (this.myTmInteractionImpl.updateIrmTrancodeInData) {
            this.setTrancodeInData(this.myTmInteractionImpl.getTrancode());
            this.myTmInteractionImpl.updateIrmTrancodeInData = false;
        }
        this.setInConversation(this.myTmInteractionImpl.testInConversation());
        this.setTmInteractionPropertiesAlreadySet(true);
        this.rebuildData |= this.myTmInteractionImpl.isRebuildMessage();
        try {
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                if (this.getImsConnectCodepage() != null) {
                    this.logger.finer("     InputMessage.imsConnectCodepage set to [" + this.getImsConnectCodepage() + "]");
                }
                if (this.getIrmId() != null) {
                    this.logger.finer("     InputMessage.irmId set to [" + new String(this.getIrmId(), this.getImsConnectCodepage()) + "]");
                }
                this.logger.finer("     InputMessage.TmInteractionImpl.responseIncludesLlll internally set to [" + this.myTmInteractionImpl.isResponseIncludesLlll() + "]");
                this.logger.finer("     InputMessage.irmNakReasonCode set to [" + this.getIrmNakReasonCode() + "]");
                this.logger.finer("     InputMessage.irmResWord set to [" + this.getIrmResWord() + "]");
                this.logger.finer("     InputMessage.irmTimer set to [" + this.getIrmTimer() + "]");
                this.logger.finer("     InputMessage.irmEncodingSchema set to [" + this.getIrmEncodingSchema() + "]");
                this.logger.finer("     InputMessage.irmF0 set to [" + this.getIrmF0() + "]");
                this.logger.finer("     InputMessage.irmF1 set to [" + this.getIrmF1() + "]");
                this.logger.finer("     InputMessage.irmF2 set to [" + this.getIrmF2() + "]");
                this.logger.finer("     InputMessage.irmF3 set to [" + this.getIrmF3() + "]");
                byte[] tmpByteArray = new byte[1];
                String outStr = null;
                tmpByteArray[0] = (byte)this.getIrmF4();
                if (tmpByteArray != null) {
                    outStr = new String(tmpByteArray, this.imsConnectCodepage);
                }
                this.logger.finer("     InputMessage.irmF4 set to [" + outStr + "]");
                this.logger.finer("     InputMessage.irmF5 set to [" + this.getIrmF5() + "]");
                if (this.getIrmTrancode() != null) {
                    this.logger.finer("     InputMessage.irmTrancode set to [" + new String(this.getIrmTrancode(), this.getImsConnectCodepage()) + "]");
                }
                if (this.getIrmDestId() != null) {
                    this.logger.finer("     InputMessage.irmDestId set to [" + new String(this.getIrmDestId(), this.getImsConnectCodepage()) + "]");
                }
                if (this.getIrmLTerm() != null) {
                    this.logger.finer("     InputMessage.irmLTerm set to [" + new String(this.getIrmLTerm(), this.getImsConnectCodepage()) + "]");
                }
                if (this.getIrmRacfUserId() != null) {
                    this.logger.finer("     InputMessage.irmRacfUserId set to [" + new String(this.getIrmRacfUserId(), this.getImsConnectCodepage()) + "]");
                }
                if (this.getIrmRacfGroupName() != null) {
                    this.logger.finer("     InputMessage.irmRacfGroupName set to [" + new String(this.getIrmRacfGroupName(), this.getImsConnectCodepage()) + "]");
                }
                if (this.getIrmRacfPassword() != null) {
                    this.logger.finer("     InputMessage.irmRacfPassword set to [" + new String("********") + "]");
                }
                if (this.getIrmRacfApplName() != null) {
                    this.logger.finer("     InputMessage.irmRacfApplName set to [" + new String(this.getIrmRacfApplName(), this.getImsConnectCodepage()) + "]");
                }
                if (this.getIrmRerouteName() != null) {
                    this.logger.finer("     InputMessage.irmRerouteName set to [" + new String(this.getIrmRerouteName(), this.getImsConnectCodepage()) + "]");
                }
                if (this.getIrmTagAdapter() != null) {
                    this.logger.finer("     InputMessage.irmTagAdapter set to [" + new String(this.getIrmTagAdapter(), this.getImsConnectCodepage()) + "]");
                }
                if (this.getIrmTagMap() != null) {
                    this.logger.finer("     InputMessage.irmTagMap set to [" + new String(this.getIrmTagMap(), this.getImsConnectCodepage()) + "]");
                }
                if (this.getIrmInputModName() != null) {
                    this.logger.finer("     InputMessage.irmInputModName set to [" + new String(this.getIrmInputModName(), this.getImsConnectCodepage()) + "]");
                }
                if (this.getIrmCorelatorToken() != null) {
                    this.logger.finer("     InputMessage.irmCorelatorToken set to [" + InputMessageImpl.bytesToHexString(this.getIrmCorelatorToken()) + "] in Hex");
                }
                this.logger.finer("     InputMessage.inputMessageDataSegmentsIncludeLlzzAndTrancode set to [" + this.isInputMessageDataSegmentsIncludeLlzzAndTrancode() + "]");
                if (this.getTrancodeInData() != null) {
                    this.logger.finer("     InputMessage.trancodeInData set to [" + new String(this.getTrancodeInData(), this.getImsConnectCodepage()) + "]");
                }
                this.logger.finer("     InputMessage.inConversation set to [" + this.myTmInteractionImpl.testInConversation() + "]");
                this.logger.finer("     InputMessage.rebuildData set to [" + this.rebuildData + "]");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- InputMessage.setTMInteractionProperties()");
        }
    }

    public void setType2CommandInteractionProperties() throws ImsConnectApiException {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> InputMessage.setType2CommandInteractionProperties()");
        }
        this.setIrmTrancode("        ");
        this.setIrmRacfApplName("        ");
        this.setTrancodeInData("");
        this.setInConversation(false);
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            this.logger.finer("     InputMessage.irmTrancode set to [        ]");
            this.logger.finer("     InputMessage.irmRacfApplName set to [        ]");
            this.logger.finer("     InputMessage.trancodeInData set to []");
            this.logger.finer("     InputMessage.inConversation set to [false]");
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- InputMessage.setType2CommandInteractionProperties()");
        }
    }

    public void buildDataByteArray() {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> InputMessage.buildDataByteArray()");
        }
        if (this.rebuildData) {
            if (this.myTmInteractionImpl.getInteractionTypeDescription().equals("SENDRECV") || this.myTmInteractionImpl.getInteractionTypeDescription().equals("SENDONLY") || this.myTmInteractionImpl.getInteractionTypeDescription().equals("SENDONLYCALLOUTRESPONSE") || this.myTmInteractionImpl.getInteractionTypeDescription().equals("SENDONLYACKCALLOUTRESPONSE") || this.myTmInteractionImpl.getInteractionTypeDescription().equals("SENDONLYACK") || this.myTmInteractionImpl.getInteractionTypeDescription().equals("TYPE2CMD") || this.myTmInteractionImpl.getInteractionTypeDescription().equals("SENDONLYXCFORDDLV")) {
                this.i = 0;
                this.bytesCopied = 0;
                this.segmentLengths = new int[this.numberOfSegments];
                this.messageLength = 0;
                if (this.inputMessageDataSegmentsIncludeLlzzAndTrancode) {
                    while (this.i < this.numberOfSegments) {
                        this.segmentLengths[this.i] = this.inputData.get(this.i).length;
                        this.messageLength += this.segmentLengths[this.i++];
                    }
                    this.data = new byte[this.messageLength];
                    this.i = 0;
                    while (this.i < this.numberOfSegments) {
                        System.arraycopy(this.inputData.get(this.i), 0, this.data, this.bytesCopied, this.segmentLengths[this.i]);
                        this.bytesCopied += this.segmentLengths[this.i++];
                    }
                } else {
                    this.trancodeInDataLength = this.myTmInteractionImpl.testInConversation() ? 0 : this.trancodeInData.length;
                    while (this.i < this.numberOfSegments) {
                        this.segmentLengths[this.i] = 4 + this.inputData.get(this.i).length;
                        if (this.i == 0 && !this.myTmInteractionImpl.isInConversation()) {
                            int n = this.i;
                            this.segmentLengths[n] = this.segmentLengths[n] + this.trancodeInDataLength;
                        }
                        this.messageLength += this.segmentLengths[this.i++];
                    }
                    this.data = new byte[this.messageLength];
                    this.i = 0;
                    while (this.i < this.numberOfSegments) {
                        byte[] llzzBytes = this.createLlzzByteArrayFromLlValue(this.segmentLengths[this.i]);
                        System.arraycopy(llzzBytes, 0, this.data, this.bytesCopied, 4);
                        this.bytesCopied += 4;
                        if (this.i == 0) {
                            System.arraycopy(this.trancodeInData, 0, this.data, this.bytesCopied, this.trancodeInDataLength);
                            this.bytesCopied += this.trancodeInDataLength;
                            System.arraycopy(this.inputData.get(this.i), 0, this.data, this.bytesCopied, this.segmentLengths[this.i] - 4 - this.trancodeInDataLength);
                            this.bytesCopied += this.segmentLengths[this.i++] - 4 - this.trancodeInDataLength;
                            continue;
                        }
                        System.arraycopy(this.inputData.get(this.i), 0, this.data, this.bytesCopied, this.segmentLengths[this.i] - 4);
                        this.bytesCopied += this.segmentLengths[this.i++] - 4;
                    }
                }
                this.rebuildData = false;
            } else {
                this.data = null;
                this.rebuildData = true;
            }
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- InputMessage.buildDataByteArray()");
        }
    }

    public byte[] buildInputMessageByteArray(boolean aSuppressLogging) throws ImsConnectApiException {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> InputMessage.buildInputMessageByteArray(boolean)");
        }
        if (this.myTmInteractionImpl.testInConversation() && this.myTmInteractionImpl.getCommitMode() == 64) {
            this.myTmInteractionImpl.setCommitMode((byte)32);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                this.logger.finest("   TmInteractionImpl.execute() - Commit mode changed internally from CM0 to CM1 for conversational interaction");
                this.logger.finest("                                 Conversational interactions are only supported with Commit Mode 1");
            }
        } else if ((this.myTmInteractionImpl.getInteractionTypeDescription() == "RESUMETPIPE" || this.myTmInteractionImpl.getInteractionTypeDescription() == "SENDONLY" || this.myTmInteractionImpl.getInteractionTypeDescription() == "SENDONLYCALLOUTRESPONSE" || this.myTmInteractionImpl.getInteractionTypeDescription() == "SENDONLYACKCALLOUTRESPONSE" || this.myTmInteractionImpl.getInteractionTypeDescription() == "SENDONLYACK" || this.myTmInteractionImpl.getInteractionTypeDescription() == "SENDONLYXCFORDDLV") && this.myTmInteractionImpl.getCommitMode() == 32) {
            this.myTmInteractionImpl.setCommitMode((byte)64);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                this.logger.finest("   TmInteractionImpl.execute() - Commit mode changed internally from CM1 to CM0 for interaction type " + this.myTmInteractionImpl.getInteractionTypeDescription());
                this.logger.finest("                                 Interaction type " + this.myTmInteractionImpl.getInteractionTypeDescription() + " is only supported with Commit Mode 0");
            }
        }
        if (this.myTmInteractionImpl.getCommitMode() == 64 && this.myTmInteractionImpl.getSyncLevel() == 0) {
            this.myTmInteractionImpl.setSyncLevel((byte)1);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                this.logger.finest("   TmInteractionImpl.execute() - Sync Level changed internally from SYNC_LEVEL_NONE to SYNC_LEVEL_CONFIRM");
                this.logger.finest("                                 Commit Mode 0 is only supported with Sync Level CONFIRM");
            }
        }
        if (this.myTmInteractionImpl.rebuildMessage || this.rebuildData) {
            this.setConnectionProperties((ConnectionImpl)this.myTmInteractionImpl.getMyConnection());
            this.setTmInteractionProperties();
            if (this.getMyTmInteractionImpl().getInteractionTypeDescription().equals("TYPE2CMD")) {
                this.setType2CommandInteractionProperties();
            }
            boolean addDataToMessageBuilt = true;
            this.buildDataByteArray();
            if (this.data == null) {
                addDataToMessageBuilt = false;
            }
            this.irmLen = 160;
            this.setLlll(4 + this.irmLen + (addDataToMessageBuilt ? this.data.length : 0) + InputMessageProperties.MESSAGE_END.length);
            this.message = new byte[this.llll];
            ByteBuffer buf = ByteBuffer.wrap(this.message);
            this.trancodeInDataToBeUsed = this.myTmInteractionImpl.testInConversation() || this.myTmInteractionImpl.getInteractionTypeDescription().equals("RESUMETPIPE") || this.myTmInteractionImpl.getInteractionTypeDescription().equals("ACK") || this.myTmInteractionImpl.getInteractionTypeDescription().equals("TYPE2CMD") || this.myTmInteractionImpl.getInteractionTypeDescription().equals("NAK") || this.myTmInteractionImpl.getInteractionTypeDescription().equals("CANCELTIMER") || this.myTmInteractionImpl.getInteractionTypeDescription().equals("ENDCONVERSATION") ? this.anEmptyTrancodeByteArray : this.trancodeInData;
            try {
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL) && !aSuppressLogging) {
                    this.logger.finest("   InputMessage.buildInputMessageByteArray(boolean) - writing LLLL [" + this.getLlll() + "] to \"dout\" DataOutStream");
                }
                buf.putInt(this.llll);
                buf.putShort((short)this.irmLen);
                buf.put(this.irmArch);
                buf.put(this.irmF0);
                buf.put(this.irmId);
                buf.putShort(this.irmNakReasonCode);
                buf.putShort(this.irmResWord);
                buf.put((byte)this.irmF5);
                buf.put((byte)this.irmTimer);
                buf.put(this.irmSocType);
                buf.put(this.irmEncodingSchema);
                buf.put(this.irmClientId);
                buf.put(this.irmF1);
                buf.put(this.irmF2);
                buf.put(this.irmF3);
                buf.put((byte)this.irmF4);
                buf.put(this.irmTrancode);
                buf.put(this.irmDestId);
                buf.put(this.irmLTerm);
                buf.put(this.irmRacfUserId);
                buf.put(this.irmRacfGroupName);
                buf.put(this.irmRacfPassword);
                buf.put(this.irmRacfApplName);
                if (this.irmArch >= 1) {
                    buf.put(this.irmRerouteName);
                }
                if (this.irmArch >= 2) {
                    buf.put(this.irmTagAdapter);
                    buf.put(this.irmTagMap);
                }
                if (this.irmArch >= 3) {
                    buf.put(this.irmInputModname);
                    buf.put(this.irmCorelatorToken);
                }
            }
            catch (Exception e1) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0001E", new Object[]{ImsConnectErrorMessage.getString("MSG_BLD_ERR", new Object[]{ImsConnectErrorMessage.getExceptionMessage(e1)})});
                ImsConnectApiException e = new ImsConnectApiException("HWS0001E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception caught in InputMessage.buildInputMessageByteArray(boolean): [" + e.getMessage() + "]+");
                }
                throw e;
            }
            try {
                if (addDataToMessageBuilt || this.data != null) {
                    buf.put(this.data);
                }
                buf.put(InputMessageProperties.MESSAGE_END, 0, 4);
                this.myTmInteractionImpl.rebuildMessage = false;
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL) && !aSuppressLogging) {
                    boolean obfuscatePassword = true;
                    String bufferToSend = this.myTmInteractionImpl.formatBufferForTracing(this.message, obfuscatePassword);
                    String[] bufferToSendStringArray = this.myTmInteractionImpl.stringToStringArray(bufferToSend);
                    String[] interpretedIrm = this.myTmInteractionImpl.interpretIrm(this.message);
                    this.logger.finest("   InputMessage.buildInputMessageByteArray(boolean) - Buffer to be sent:");
                    int sendBufStringArrayLen = bufferToSendStringArray.length;
                    int i = 0;
                    while (i < sendBufStringArrayLen) {
                        this.logger.finest(bufferToSendStringArray[i]);
                        ++i;
                    }
                    i = 0;
                    while (i < interpretedIrm.length) {
                        this.logger.finest(interpretedIrm[i]);
                        ++i;
                    }
                }
            }
            catch (UnsupportedEncodingException usee) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
                ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception caught in InputMessage.buildInputMessageByteArray(boolean): [" + e.getMessage() + "]+");
                }
                throw e;
            }
            catch (Exception e1) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0001E", new Object[]{ImsConnectErrorMessage.getString("MSG_BLD_ERR", new Object[]{ImsConnectErrorMessage.getExceptionMessage(e1)})});
                ImsConnectApiException e = new ImsConnectApiException("HWS0001E", errMsg);
                if (this.logger.getLevel().intValue() <= ApiProperties.TRACE_LEVEL_EXCEPTION.intValue()) {
                    this.logger.severe("    Exception caught in InputMessage.buildInputMessageByteArray(boolean): [" + e.getMessage() + "]+");
                }
                throw e;
            }
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
                this.logger.finer("<-- InputMessage.buildInputMessageByteArray(boolean)");
            }
        }
        return this.message;
    }

    public String padAndConvertString(String str, char c, int len, String codepage) throws ImsConnectApiException {
        this.aCodepage = codepage;
        try {
            StringBuffer buf = new StringBuffer(str);
            if (str.length() < len) {
                int i = str.length();
                while (i < len) {
                    buf.append(c);
                    ++i;
                }
            }
            return new String(buf.toString().getBytes(codepage));
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.aCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.padAndConvertString(String, char, int, String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    @Override
    public String padString(String str, char c, int len) {
        int strLen = 0;
        if (str != null) {
            strLen = str.length();
        }
        if (strLen < len) {
            StringBuilder buf;
            if (str != null) {
                buf = new StringBuilder(len);
                buf.append(str);
            } else {
                buf = new StringBuilder();
            }
            int i = strLen;
            while (i < len) {
                buf.append(c);
                ++i;
            }
            return buf.toString();
        }
        return str;
    }

    @Override
    public int getNumberOfSegments() {
        return this.numberOfSegments;
    }

    @Override
    public byte[] getDataAsByteArray() {
        int copyPos;
        int i = 0;
        int dataLen = 0;
        int savedCopyPos = copyPos = this.isInputMessageDataSegmentsIncludeLlzzAndTrancode() ? 4 + (this.myTmInteractionImpl.testInConversation() ? 0 : this.myTmInteractionImpl.getTrancode().length()) : 0;
        int bytesCopied = 0;
        int bytesToCopy = 0;
        int numberOfSegments = this.inputData.size();
        short[] segmentLengths = new short[numberOfSegments];
        while (i < numberOfSegments) {
            segmentLengths[i] = (short)this.inputData.get(i).length;
            dataLen += segmentLengths[i++] - copyPos;
            copyPos = 4;
        }
        byte[] inputDataByteArray = new byte[dataLen];
        i = 0;
        copyPos = savedCopyPos;
        while (i < numberOfSegments) {
            bytesToCopy = segmentLengths[i] - copyPos;
            System.arraycopy(this.inputData.get(i++), copyPos, inputDataByteArray, bytesCopied, bytesToCopy);
            bytesCopied += bytesToCopy;
            copyPos = 4;
        }
        return inputDataByteArray;
    }

    @Override
    public byte[][] getDataAsArrayOfByteArrays() {
        int i = 0;
        int dataLen = 0;
        int copyPos = this.isInputMessageDataSegmentsIncludeLlzzAndTrancode() ? 4 + (this.myTmInteractionImpl.testInConversation() ? 0 : this.myTmInteractionImpl.getTrancode().length()) : 0;
        int numberOfSegments = this.inputData.size();
        byte[][] returnArrayOfByteArrays = new byte[numberOfSegments][];
        while (i < numberOfSegments) {
            dataLen = this.inputData.get(i).length;
            returnArrayOfByteArrays[i] = new byte[dataLen - copyPos];
            System.arraycopy(this.inputData.get(i), copyPos, returnArrayOfByteArrays[i], 0, dataLen - copyPos);
            copyPos = 4;
            ++i;
        }
        return returnArrayOfByteArrays;
    }

    @Override
    public String getDataAsString() throws ImsConnectApiException {
        try {
            return new String(this.getDataAsByteArray(), this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.getDataAsString(): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    @Override
    public String[] getDataAsArrayOfStrings() throws ImsConnectApiException {
        int i = 0;
        int numberOfSegments = this.inputData.size();
        String[] returnStringArray = new String[numberOfSegments];
        byte[][] tmpArrayOfByteArrays = this.getDataAsArrayOfByteArrays();
        try {
            while (i < numberOfSegments) {
                returnStringArray[i] = new String(tmpArrayOfByteArrays[i], this.imsConnectCodepage);
                ++i;
            }
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.getDataAsArrayOfStrings(): [" + e.getMessage() + "]+");
            }
            throw e;
        }
        return returnStringArray;
    }

    @Override
    public byte[] getSegmentAsByteArray(int aSegmentNumber) {
        return this.inputData.get(aSegmentNumber);
    }

    @Override
    public String getSegmentAsString(int aSegmentNumber) {
        return new String(this.inputData.get(aSegmentNumber));
    }

    @Override
    public void appendSegment(byte[] aSegmentData) {
        if (this.isInputMessageDataSegmentsIncludeLlzzAndTrancode()) {
            this.bytesProcessed = 0;
            int dataLen = aSegmentData.length;
            int numberOfSegments = 0;
            while (this.bytesProcessed < dataLen) {
                int ll = this.getLlValueFromLlzzBytes(aSegmentData, this.bytesProcessed);
                byte[] inputSegment = new byte[ll];
                System.arraycopy(aSegmentData, this.bytesProcessed, inputSegment, 0, ll);
                this.inputData.add(inputSegment);
                ++numberOfSegments;
                this.bytesProcessed += ll;
            }
        } else {
            this.inputData.add(aSegmentData);
        }
        this.setNumberOfSegments(this.inputData.size());
        this.rebuildData = true;
    }

    @Override
    public void appendSegment(String aSegmentData) throws ImsConnectApiException {
        byte[] inputSegment;
        this.imsConnectCodepage = this.myTmInteractionImpl.getImsConnectCodepage();
        if (this.myTmInteractionImpl.isInputMessageDataSegmentsIncludeLlzzAndTrancode()) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0035E");
            ImsConnectApiException e = new ImsConnectApiException("HWS0035E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.appendSegment(String). Exception caught was: " + e.getMessage());
            }
            throw e;
        }
        try {
            inputSegment = aSegmentData.getBytes(this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message segment", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.appendSegment(String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
        this.appendSegment(inputSegment);
    }

    @Override
    public void insertSegment(byte[] aSegmentData, int aLocation) {
        if (this.isInputMessageDataSegmentsIncludeLlzzAndTrancode()) {
            this.bytesProcessed = 0;
            int dataLen = aSegmentData.length;
            while (this.bytesProcessed < dataLen) {
                short ll = (short)this.getLlValueFromLlzzBytes(aSegmentData, this.bytesProcessed);
                byte[] inputSegment = new byte[ll];
                System.arraycopy(aSegmentData, this.bytesProcessed, inputSegment, 0, ll);
                this.inputData.add(aLocation++, aSegmentData);
                this.bytesProcessed += ll;
            }
        } else {
            this.inputData.add(aLocation++, aSegmentData);
        }
        this.setNumberOfSegments(this.inputData.size());
        this.rebuildData = true;
    }

    @Override
    public void insertSegment(String aSegmentData, int aLocation) throws ImsConnectApiException {
        this.imsConnectCodepage = this.myTmInteractionImpl.getImsConnectCodepage();
        if (this.myTmInteractionImpl.isInputMessageDataSegmentsIncludeLlzzAndTrancode()) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0035E");
            ImsConnectApiException e = new ImsConnectApiException("HWS0035E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.insertSegment(String, int). Exception caught was: " + e.getMessage());
            }
            throw e;
        }
        try {
            this.insertSegment(aSegmentData.getBytes(this.imsConnectCodepage), aLocation);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message segment", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.insertSegment(String, int): [" + usee.getMessage() + "]+");
            }
            throw e;
        }
    }

    @Override
    public void changeSegment(byte[] aSegmentData, int aLocation) {
        this.bytesProcessed = 0;
        int dataLen = aSegmentData.length;
        int numberOfSegments = 0;
        this.inputData.remove(aLocation);
        if (this.isInputMessageDataSegmentsIncludeLlzzAndTrancode()) {
            while (this.bytesProcessed < dataLen) {
                int ll = this.getLlValueFromLlzzBytes(aSegmentData, this.bytesProcessed);
                byte[] inputSegment = new byte[ll];
                System.arraycopy(aSegmentData, this.bytesProcessed, inputSegment, 0, ll);
                this.inputData.add(aLocation, inputSegment);
                ++numberOfSegments;
                this.bytesProcessed += ll;
            }
        } else {
            this.inputData.add(aSegmentData);
        }
        this.rebuildData = true;
    }

    @Override
    public void changeSegment(String aSegmentData, int aLocation) throws ImsConnectApiException {
        this.imsConnectCodepage = this.myTmInteractionImpl.getImsConnectCodepage();
        if (this.myTmInteractionImpl.isInputMessageDataSegmentsIncludeLlzzAndTrancode()) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0035E");
            ImsConnectApiException e = new ImsConnectApiException("HWS0035E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.changeSegment(String, int). Exception caught was: " + e.getMessage());
            }
            throw e;
        }
        try {
            this.changeSegment(aSegmentData.getBytes(this.imsConnectCodepage), aLocation);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message segment", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.changeSegment(String, int): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    @Override
    public void setInputMessageData(byte[] anInputDataByteArray) throws ImsConnectApiException {
        this.bytesProcessed = 0;
        int dataLen = 0;
        if (anInputDataByteArray != null) {
            dataLen = anInputDataByteArray.length;
            this.setInputMessageDataSegmentsIncludeLlzzAndTrancode(this.myTmInteractionImpl.isInputMessageDataSegmentsIncludeLlzzAndTrancode());
            this.inputData.clear();
            if (!this.isInputMessageDataSegmentsIncludeLlzzAndTrancode()) {
                this.inputData.add(anInputDataByteArray);
                this.numberOfSegments = 1;
            } else {
                this.numberOfSegments = 0;
                while (this.bytesProcessed < dataLen) {
                    int ll = this.getLlValueFromLlzzBytes(anInputDataByteArray, this.bytesProcessed);
                    if (ll < 4 || ll > Short.MAX_VALUE) {
                        String errMsg = ImsConnectErrorMessage.getString("HWS0036E", new Object[]{ll});
                        ImsConnectApiException e = new ImsConnectApiException("HWS0036E", errMsg);
                        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                            this.logger.severe("    Exception caught in InputMessageImpl.setInputMessageData(byte[]). Exception caught was: " + e.getMessage());
                        }
                        throw e;
                    }
                    byte[] tmpInputSegment = new byte[ll];
                    System.arraycopy(anInputDataByteArray, this.bytesProcessed, tmpInputSegment, 0, ll);
                    this.inputData.add(tmpInputSegment);
                    ++this.numberOfSegments;
                    this.bytesProcessed += ll;
                }
            }
            this.rebuildData = true;
        }
    }

    @Override
    public void setInputMessageData(byte[][] anInputData2DByteArray) throws ImsConnectApiException {
        int i = 0;
        int numberOfSegments = anInputData2DByteArray.length;
        int numberOfSegmentsProcessed = 0;
        int inputData2DByteArraySegmentLen = 0;
        this.setInputMessageDataSegmentsIncludeLlzzAndTrancode(this.myTmInteractionImpl.isInputMessageDataSegmentsIncludeLlzzAndTrancode());
        this.inputData.clear();
        while (i < numberOfSegments) {
            inputData2DByteArraySegmentLen = anInputData2DByteArray[i].length;
            if (inputData2DByteArraySegmentLen > 0) {
                short segLen = (short)anInputData2DByteArray[i].length;
                if (segLen < 4 || segLen > Short.MAX_VALUE) {
                    String errMsg = ImsConnectErrorMessage.getString("HWS0036E", new Object[]{segLen});
                    ImsConnectApiException e = new ImsConnectApiException("HWS0036E", errMsg);
                    if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                        this.logger.severe("    Exception caught in InputMessageImpl.setInputMessageData(byte[][]). Exception caught was: " + e.getMessage());
                    }
                    throw e;
                }
                this.inputData.add(anInputData2DByteArray[i]);
                ++numberOfSegmentsProcessed;
            }
            ++i;
        }
        this.setNumberOfSegments(numberOfSegmentsProcessed);
        this.rebuildData = true;
    }

    @Override
    public void setInputMessageData(String anInputDataString) throws ImsConnectApiException {
        this.imsConnectCodepage = this.myTmInteractionImpl.getImsConnectCodepage();
        try {
            if (this.myTmInteractionImpl.isInputMessageDataSegmentsIncludeLlzzAndTrancode()) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0035E");
                ImsConnectApiException e = new ImsConnectApiException("HWS0035E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception caught in InputMessage.setInputMessageData(String). Exception caught was: " + e.getMessage());
                }
                throw e;
            }
            this.setInputMessageData(anInputDataString.getBytes(this.imsConnectCodepage));
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setInputMessageData(String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setInputMessageData(String[] anInputDataStringArray) throws ImsConnectApiException {
        int i = 0;
        int numberOfSegments = anInputDataStringArray.length;
        byte[][] inData2DByteArray = new byte[numberOfSegments][];
        try {
            if (this.myTmInteractionImpl.isInputMessageDataSegmentsIncludeLlzzAndTrancode()) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0035E");
                ImsConnectApiException e = new ImsConnectApiException("HWS0035E", errMsg);
                if (!this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) throw e;
                this.logger.severe("    Exception caught in InputMessage.setInputMessageData(String[]). Exception caught was: " + e.getMessage());
                throw e;
            }
            while (true) {
                if (i >= numberOfSegments) {
                    this.setInputMessageData(inData2DByteArray);
                    return;
                }
                inData2DByteArray[i] = anInputDataStringArray[i].getBytes(this.imsConnectCodepage);
                ++i;
            }
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (!this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) throw e;
            this.logger.severe("    Exception caught in InputMessage.setInputMessageData(String[]): [" + e.getMessage() + "]+");
            throw e;
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] aByteArray) {
        if (aByteArray != null && this.myTmInteractionImpl.isInConversation() && !this.isTranRemoved() && (this.myTmInteractionImpl.getInteractionTypeDescription() == "SENDRECV" || this.myTmInteractionImpl.getInteractionTypeDescription() == "SENDONLY" || this.myTmInteractionImpl.getInteractionTypeDescription() == "SENDONLYACK" || this.myTmInteractionImpl.getInteractionTypeDescription() == "SENDONLYXCFORDDLV")) {
            int trancodeLen = 0;
            if (this.trancodeInData != null) {
                trancodeLen = this.trancodeInData.length;
            }
            int tmpByteArrayLen = aByteArray.length - trancodeLen;
            byte[] tmpByteArray = new byte[tmpByteArrayLen];
            System.arraycopy(this.createLlzzByteArrayFromLlValue(tmpByteArrayLen), 0, tmpByteArray, 0, 4);
            System.arraycopy(aByteArray, 4 + trancodeLen, tmpByteArray, 4, tmpByteArrayLen - 4);
            this.data = tmpByteArray;
            this.setTranRemoved(true);
        } else {
            this.data = aByteArray;
        }
        this.setTmInteractionPropertiesAlreadySet(false);
    }

    public String getImsConnectCodepage() {
        return this.imsConnectCodepage;
    }

    protected void setImsConnectCodepage(String anImsConnectCodepage) {
        if (this.imsConnectCodepage == anImsConnectCodepage || anImsConnectCodepage == null) {
            return;
        }
        this.imsConnectCodepage = anImsConnectCodepage;
        this.rebuildData = true;
    }

    protected boolean isInConversation() {
        return this.inConversation;
    }

    protected void setInConversation(boolean inConversation) {
        this.inConversation = inConversation;
    }

    @Override
    public boolean isInputMessageDataSegmentsIncludeLlzzAndTrancode() {
        return this.inputMessageDataSegmentsIncludeLlzzAndTrancode;
    }

    @Override
    public void setInputMessageDataSegmentsIncludeLlzzAndTrancode(boolean anInputMessageDataSegmentsIncludeLlzzAndTrancode) {
        this.inputMessageDataSegmentsIncludeLlzzAndTrancode = anInputMessageDataSegmentsIncludeLlzzAndTrancode;
    }

    private byte getIrmArch() {
        return this.irmArch;
    }

    private void setIrmArch(byte b) {
        this.irmArch = b;
    }

    private byte[] getIrmClientId() {
        return this.irmClientId;
    }

    private void setIrmClientId(String aClientId) throws ImsConnectApiException {
        try {
            String anIrmClientId = this.padString(aClientId, ' ', 8);
            this.irmClientId = anIrmClientId.getBytes(this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmClientId(String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    private byte[] getIrmDestId() {
        return this.irmDestId;
    }

    private void setIrmDestId(String aDestId) throws ImsConnectApiException {
        try {
            String anIrmDestId = this.padString(aDestId, ' ', 8);
            this.irmDestId = anIrmDestId.getBytes(this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmDestId(String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    private byte getIrmEncodingSchema() {
        return this.irmEncodingSchema;
    }

    private void setIrmEncodingSchema(byte b) {
        this.irmEncodingSchema = b;
    }

    private byte getIrmF0() {
        return this.irmF0;
    }

    private void setIrmF0(byte b) {
        this.irmF0 = (byte)(this.irmF0 | b);
    }

    private byte getIrmF1() {
        return this.irmF1;
    }

    private void setIrmF1(byte aByte) {
        this.irmF1 = (byte)(this.irmF1 | aByte);
    }

    private byte getIrmF2() {
        return this.irmF2;
    }

    private void setIrmF2(byte b) {
        this.irmF2 = b;
    }

    private byte getIrmF3() {
        return this.irmF3;
    }

    private void setIrmF3(byte b) {
        this.irmF3 = (byte)(this.irmF3 | b);
    }

    private char getIrmF4() {
        return this.irmF4;
    }

    private void setIrmF4(char c) throws ImsConnectApiException {
        try {
            this.irmF4 = (char)new StringBuffer().append(c).toString().getBytes(this.imsConnectCodepage)[0];
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmF4(char): [" + e.getMessage() + "]+");
            }
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getIrmF5() {
        return this.irmF5;
    }

    private void setIrmF5(int anInt) {
        this.irmF5 |= anInt;
    }

    private byte[] getIrmId() {
        return this.irmId;
    }

    private void setIrmId(String anIrmIdString) throws ImsConnectApiException {
        try {
            String anIrmId = null;
            anIrmId = this.padString(anIrmIdString, ' ', 8);
            this.irmId = anIrmId.getBytes(this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmId(String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    private int getIrmLen() {
        return this.irmLen;
    }

    private void setIrmLen(int anIrmLen) {
        this.irmLen = anIrmLen;
    }

    private byte[] getIrmLTerm() {
        return this.irmLTerm;
    }

    private void setIrmLTerm(String anIrmLTerm) throws ImsConnectApiException {
        try {
            String anIrmLTermName = this.padString(anIrmLTerm, ' ', 8);
            this.irmLTerm = anIrmLTermName.getBytes(this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmId(String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    private byte[] getIrmRacfApplName() {
        return this.irmRacfApplName;
    }

    private void setIrmRacfApplName(String anIrmRacfApplName) throws ImsConnectApiException {
        try {
            String aIrmRacfApplName = this.padString(anIrmRacfApplName, ' ', 8);
            this.irmRacfApplName = aIrmRacfApplName.getBytes(this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmRacfApplName(String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    private byte[] getIrmRacfGroupName() {
        return this.irmRacfGroupName;
    }

    private void setIrmRacfGroupName(String aRacfGroupName) throws ImsConnectApiException {
        try {
            String anIrmRacfGroupName = this.padString(aRacfGroupName, ' ', 8);
            this.irmRacfGroupName = anIrmRacfGroupName.getBytes(this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmRacfGroupName(String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    private byte[] getIrmRacfPassword() {
        return this.irmRacfPassword;
    }

    private void setIrmRacfPassword(String anIrmRacfPassword) throws ImsConnectApiException {
        try {
            String anIrmRacfPasswordString = this.padString(anIrmRacfPassword, ' ', 8);
            this.irmRacfPassword = anIrmRacfPasswordString.getBytes(this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmRacfPassword(String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    private byte[] getIrmRacfUserId() {
        return this.irmRacfUserId;
    }

    private void setIrmRacfUserId(String anIrmRacfUserId) throws ImsConnectApiException {
        try {
            String anIrmRacfUserIdString = this.padString(anIrmRacfUserId, ' ', 8);
            this.irmRacfUserId = anIrmRacfUserIdString.getBytes(this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmRacfUserId(String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    private byte[] getIrmRerouteName() {
        return this.irmRerouteName;
    }

    private void setIrmRerouteName(String anIrmRerouteName) throws ImsConnectApiException {
        try {
            String anIrmRerouteNameString = this.padString(anIrmRerouteName, ' ', 8);
            this.irmRerouteName = anIrmRerouteNameString.getBytes(this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmRerouteName(String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    private short getIrmResWord() {
        return this.irmResWord;
    }

    private void setIrmResWord(short i) {
        this.irmResWord = i;
    }

    private byte getIrmSocType() {
        return this.irmSocType;
    }

    private void setIrmSocType(byte b) {
        this.irmSocType = b;
    }

    private byte[] getIrmTagAdapter() {
        return this.irmTagAdapter;
    }

    private void setIrmTagAdapter(String anIrmTagAdapter) throws ImsConnectApiException {
        try {
            String anIrmTagAdapterString = this.padString(anIrmTagAdapter, ' ', 8);
            this.irmTagAdapter = anIrmTagAdapterString.getBytes(this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmTagAdapter(String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    private byte[] getIrmTagMap() {
        return this.irmTagMap;
    }

    private void setIrmTagMap(String anIrmTagMap) throws ImsConnectApiException {
        try {
            String anIrmTagMapString = this.padString(anIrmTagMap, ' ', 8);
            this.irmTagMap = anIrmTagMapString.getBytes(this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmTagMap(String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    private int getIrmTimer() {
        return this.irmTimer;
    }

    protected void setIrmTimer(int anInt) {
        this.irmTimer = anInt;
    }

    private byte[] getIrmTrancode() {
        return this.irmTrancode;
    }

    private void setIrmTrancode(String anIrmTrancode) throws ImsConnectApiException {
        try {
            int irmTrancodeLen = anIrmTrancode.length();
            String anIrmTrancodeString = irmTrancodeLen < 8 ? this.padString(anIrmTrancode, ' ', 8) : (irmTrancodeLen > 8 ? anIrmTrancode.substring(0, 8) : anIrmTrancode);
            this.irmTrancode = anIrmTrancodeString.getBytes(this.imsConnectCodepage);
        }
        catch (Exception e1) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmTrancode(String): [" + e1.toString() + "]+");
            }
            throw e;
        }
    }

    @Override
    public int getLlll() {
        return this.llll;
    }

    private void setLlll(int anLlll) {
        this.llll = anLlll;
    }

    @Override
    public byte[] getMessage() throws ImsConnectApiException {
        boolean suppressLogging = true;
        return this.buildInputMessageByteArray(suppressLogging);
    }

    private TmInteraction getMyTmInteractionImpl() {
        return this.myTmInteractionImpl;
    }

    protected void setMyTmInteractionImpl(TmInteractionImpl myTMInteractionImpl) {
        this.myTmInteractionImpl = myTMInteractionImpl;
    }

    protected boolean isConnectionPropertiesAlreadySet() {
        return this.connectionPropertiesAlreadySet;
    }

    protected void setConnectionPropertiesAlreadySet(boolean connectionPropertiesAlreadySet) {
        this.connectionPropertiesAlreadySet = connectionPropertiesAlreadySet;
    }

    protected boolean isTmInteractionPropertiesAlreadySet() {
        return this.tmInteractionPropertiesAlreadySet;
    }

    protected void setTmInteractionPropertiesAlreadySet(boolean tmInteractionPropertiesAlreadySet) {
        this.tmInteractionPropertiesAlreadySet = tmInteractionPropertiesAlreadySet;
    }

    private byte[] getTrancodeInData() {
        return this.trancodeInData;
    }

    protected void setTrancodeInData(String aTrancodeInData) throws ImsConnectApiException {
        try {
            this.trancodeInData = aTrancodeInData.getBytes(this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmTrancodeInData(String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    private void setNumberOfSegments(int numberOfSegments) {
        this.numberOfSegments = numberOfSegments;
    }

    protected boolean isTranRemoved() {
        return this.tranRemoved;
    }

    protected void setTranRemoved(boolean tranRemoved) {
        this.tranRemoved = tranRemoved;
    }

    public String toString() {
        String str = "";
        int dataBeginPos = 4;
        if (this.irmArch == 0) {
            dataBeginPos += 88;
        } else if (this.irmArch == 1) {
            dataBeginPos += 96;
        } else if (this.irmArch == 2) {
            dataBeginPos += 112;
        }
        if (!this.inputMessageDataSegmentsIncludeLlzzAndTrancode) {
            dataBeginPos += 4 + this.irmTrancode.length;
        }
        try {
            boolean logBuffer = false;
            byte[] bytes = this.buildInputMessageByteArray(logBuffer);
            boolean obfuscatePassword = true;
            str = this.myTmInteractionImpl.formatBufferForTracing(bytes, obfuscatePassword);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    private int getLlValueFromLlzzBytes(byte[] aSegmentData, int llPos) {
        int lowOrderLL;
        int highOrderLL = new Integer(aSegmentData[llPos]);
        highOrderLL += highOrderLL < 0 ? 256 : 0;
        return (lowOrderLL += (lowOrderLL = new Integer(aSegmentData[llPos + 1]).intValue()) < 0 ? 256 : 0) + (highOrderLL *= 256);
    }

    private byte[] createLlzzByteArrayFromLlValue(int anLlValue) {
        byte[] llzzByteArray = new byte[4];
        if (this.myTmInteractionImpl.getInteractionTypeDescription().equals("SENDONLYCALLOUTRESPONSE") || this.myTmInteractionImpl.getInteractionTypeDescription().equals("SENDONLYACKCALLOUTRESPONSE")) {
            llzzByteArray[0] = (byte)(anLlValue >> 24 & 0xFF);
            llzzByteArray[1] = (byte)(anLlValue >> 16 & 0xFF);
            llzzByteArray[2] = (byte)(anLlValue >> 8 & 0xFF);
            llzzByteArray[3] = (byte)(anLlValue & 0xFF);
        } else {
            llzzByteArray[0] = (byte)(anLlValue >> 8 & 0xFF);
            llzzByteArray[1] = (byte)(anLlValue & 0xFF);
            llzzByteArray[2] = 0;
            llzzByteArray[3] = 0;
        }
        return llzzByteArray;
    }

    private int getLlllValueFromBytes(byte[] aSegmentData) {
        return (aSegmentData[0] << 24) + ((aSegmentData[1] & 0xFF) << 16) + ((aSegmentData[2] & 0xFF) << 8) + (aSegmentData[3] & 0xFF);
    }

    private byte[] createLlllByteArrayFromLlllValue(int anLlllValue) {
        return new byte[]{(byte)(anLlllValue >>> 24), (byte)(anLlllValue >>> 16), (byte)(anLlllValue >>> 8), (byte)anLlllValue};
    }

    private void setIrmCorelatorToken(byte[] acorelatorToken) {
        this.irmCorelatorToken = acorelatorToken;
    }

    private byte[] getIrmCorelatorToken() {
        return this.irmCorelatorToken;
    }

    private void setIrmInputModName(String anInputModName) throws ImsConnectApiException {
        try {
            String anIrmInputModNameString = this.padString(anInputModName, ' ', 8);
            this.irmInputModname = anIrmInputModNameString.getBytes(this.imsConnectCodepage);
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"input request message", this.imsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmInputModName(String): [" + e.getMessage() + "]+");
            }
            throw e;
        }
    }

    private byte[] getIrmInputModName() {
        return this.irmInputModname;
    }

    private void setIrmNakReasonCode(short aNakReasonCode) throws ImsConnectApiException {
        if ((aNakReasonCode < 2001 || aNakReasonCode > 3000) && aNakReasonCode != 0) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0041E", new Object[]{aNakReasonCode, (short)2001, (short)3000});
            ImsConnectApiException e = new ImsConnectApiException("HWS0041E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in InputMessage.setIrmNakReasonCode(short): [" + e.getMessage() + "]+");
            }
            throw e;
        }
        this.irmNakReasonCode = aNakReasonCode;
    }

    private short getIrmNakReasonCode() {
        return this.irmNakReasonCode;
    }

    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        Formatter formatter = new Formatter(sb);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            formatter.format("%02x", b);
            ++n2;
        }
        int length = sb.length();
        boolean i = false;
        return sb.toString();
    }
}

