/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.connect.impl;

import com.ibm.ims.connect.ApiProperties;
import com.ibm.ims.connect.ImsConnectApiException;
import com.ibm.ims.connect.ImsConnectErrorMessage;
import com.ibm.ims.connect.ImsConnectExecutionException;
import com.ibm.ims.connect.OutputMessage;
import com.ibm.ims.connect.OutputMessageProperties;
import com.ibm.ims.connect.TmInteraction;
import com.ibm.ims.connect.Type2CmdResponse;
import com.ibm.ims.connect.XmlParser;
import com.ibm.ims.connect.impl.TmInteractionImpl;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OutputMessageImpl
implements OutputMessage {
    private static final String copyright = "Licensed Material - Property of IBM 5655-TDA(C) Copyright IBM Corp. 2009,2013  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private TmInteractionImpl myTmInteractionImpl;
    private Type2CmdResponse myType2CommandResponse = null;
    private XmlParser myXmlParser = new XmlParser();
    private int[] parsedOutLlllValIntArray;
    private byte[][] parsedOutLlllByteArray;
    private byte[][] parsedOutLlByteArray;
    private short[] parsedOutLlValShortArray;
    private byte[][] parsedOutZzByteArray;
    private byte[][] parsedOutDataByteArray;
    private byte[] llll;
    private byte[] ll;
    private byte[] zz;
    private int numberOfSegments;
    private byte[] responseMessage = null;
    private int messageLength = 0;
    private int msgType = -1;
    private Logger logger = Logger.getLogger("com.ibm.ims.connect");
    private byte csmFlag1 = 0;
    private byte csmFlag2 = 0;
    private String csmStr;
    private int rsmReturnCode;
    private int rsmReasonCode;
    private int rsmOtmaSenseCode;
    private byte rsmOtmaReasonCode;
    private int rsmRacfReturnCode;
    private String racfReturnCodeString;
    private boolean responseIncludesLlll;
    private boolean ackNakNeeded;
    private boolean asyncOutputAvailable;
    private boolean inConversation;
    private byte protocolLevel;
    private boolean protocolLevelAvailable;
    private String mfsModname;
    private String clientId;
    private boolean responsePropertiesUpdatedAfterResponse = false;
    private String myImsConnectCodepage = "CP037";
    private boolean includeLlzzInSegments;
    private boolean messageIsSingleSegment;
    private int rmmOffset = 0;
    private int gencidOffset = 0;
    private int corOffset = 0;
    private boolean isSyncCalloutReq = false;

    OutputMessageImpl(TmInteraction myTMInteraction) {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> OutputMessage(TmInteraction) constructor");
        }
        this.myTmInteractionImpl = (TmInteractionImpl)myTMInteraction;
        this.myImsConnectCodepage = this.myTmInteractionImpl.getImsConnectCodepage();
        this.setIncludeLlzzInSegments(myTMInteraction.isInputMessageDataSegmentsIncludeLlzzAndTrancode());
        this.setMessageIsSingleSegment(((TmInteractionImpl)myTMInteraction).getNumberOfSegmentsFromOutput() <= 2);
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- OutputMessage(TmInteraction)");
        }
    }

    public void reset(TmInteraction aTMInteraction) {
        this.responseMessage = null;
        this.messageLength = 0;
        this.msgType = -1;
        this.csmFlag1 = 0;
        this.csmStr = null;
        this.rsmReturnCode = 0;
        this.rsmReasonCode = 0;
        this.setIncludeLlzzInSegments(aTMInteraction.isInputMessageDataSegmentsIncludeLlzzAndTrancode());
        this.rsmOtmaSenseCode = 0;
        this.rsmOtmaReasonCode = 0;
        this.rsmRacfReturnCode = 0;
        this.racfReturnCodeString = "";
        this.responseIncludesLlll = true;
        this.ackNakNeeded = false;
        this.asyncOutputAvailable = false;
        this.inConversation = false;
        this.isSyncCalloutReq = false;
        this.protocolLevel = 0;
        this.protocolLevelAvailable = false;
        this.mfsModname = "        ";
        this.clientId = "";
        this.responsePropertiesUpdatedAfterResponse = false;
        if (this.myType2CommandResponse != null) {
            this.myType2CommandResponse = new Type2CmdResponse(this.myTmInteractionImpl.getImsConnectCodepage());
        }
    }

    public void copyOutputMessage(OutputMessageImpl anOutputMessage) {
        this.responseMessage = anOutputMessage.getResponseMessage();
        this.messageLength = anOutputMessage.getMessageLength();
        this.msgType = anOutputMessage.getMsgType();
        this.numberOfSegments = anOutputMessage.getNumberOfSegments();
        this.parsedOutLlllByteArray = anOutputMessage.getParsedOutLlllByteArray();
        this.parsedOutLlllValIntArray = anOutputMessage.getParsedOutLlllValIntArray();
        this.parsedOutLlByteArray = anOutputMessage.getParsedOutLlByteArray();
        this.parsedOutLlValShortArray = anOutputMessage.getParsedOutLlValShortArray();
        this.parsedOutZzByteArray = anOutputMessage.getParsedOutZzByteArray();
        this.parsedOutDataByteArray = anOutputMessage.getParsedOutDataByteArray();
        this.setImsConnectReturnCode(anOutputMessage.getImsConnectReturnCode());
        this.setImsConnectReasonCode(anOutputMessage.getImsConnectReasonCode());
        this.setOtmaSenseCode(anOutputMessage.getOtmaSenseCode());
        this.setOtmaReasonCode(anOutputMessage.getOtmaReasonCode());
        this.myImsConnectCodepage = anOutputMessage.getMyImsConnectCodepage();
        this.csmFlag1 = anOutputMessage.getCsmFlag1();
        this.csmStr = anOutputMessage.getCsmStr();
        this.includeLlzzInSegments = anOutputMessage.isIncludeLlzzInSegments();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(boolean aResponseIncludesLlll) throws Exception {
        this.msgType = 255;
        String checkStr = null;
        String checkRsmStr = "";
        String checkCsmStr = null;
        String checkT2CmdStr = null;
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> OutputMessage.parse(boolean)");
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            this.logger.finest("   OutputMessage.parse(boolean) - message length: [" + this.responseMessage.length + "]");
        }
        try {
            block62: {
                block63: {
                    block55: {
                        ByteBuffer buf;
                        block64: {
                            block54: {
                                block61: {
                                    block60: {
                                        block59: {
                                            block57: {
                                                block58: {
                                                    if (this.responseMessage.length < 12) {
                                                        String errMsg = ImsConnectErrorMessage.getString("HWS0019E");
                                                        ImsConnectExecutionException e = new ImsConnectExecutionException("HWS0019E", errMsg);
                                                        if (!this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) throw e;
                                                        this.logger.severe("    Exception thrown in OutputMessage.parse(boolean). Exception was: " + e.toString());
                                                        throw e;
                                                    }
                                                    checkStr = new String(this.responseMessage, this.myImsConnectCodepage);
                                                    if (this.myTmInteractionImpl.getInteractionTypeDescription().equals("TYPE2CMD")) {
                                                        String string = checkT2CmdStr = checkStr.toUpperCase().endsWith(OutputMessageProperties.T2C_ID) ? OutputMessageProperties.T2C_ID : null;
                                                        if (checkT2CmdStr == null) {
                                                            checkRsmStr = checkStr.substring(aResponseIncludesLlll ? 8 : 4, aResponseIncludesLlll ? 16 : 12);
                                                        }
                                                    } else {
                                                        String string = checkCsmStr = checkStr.endsWith("*CSMOKY*") ? "*CSMOKY*" : null;
                                                        if (checkCsmStr == null) {
                                                            checkRsmStr = checkStr.substring(aResponseIncludesLlll ? 8 : 4, aResponseIncludesLlll ? 16 : 12);
                                                        }
                                                    }
                                                    if (aResponseIncludesLlll) break block57;
                                                    this.llll = null;
                                                    if (this.responseMessage.length != 20) break block58;
                                                    if (checkRsmStr.equals(OutputMessageProperties.RSM_ID_REQSTS)) {
                                                        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                                                            this.logger.finest("   OutputMessage.parse(boolean) - message includes RSM (*REQSTS*)");
                                                        }
                                                        this.msgType = 2;
                                                        break block54;
                                                    } else if (checkRsmStr.equals(OutputMessageProperties.RSM_ID_CBLADP)) {
                                                        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                                                            this.logger.finest("   OutputMessage.parse(boolean) - message includes RSM (*XADPST*)");
                                                        }
                                                        this.msgType = 3;
                                                        break block54;
                                                    } else {
                                                        if (!checkCsmStr.equals("*CSMOKY*")) {
                                                            String errMsg = ImsConnectErrorMessage.getString("HWS0018E");
                                                            ImsConnectExecutionException e = new ImsConnectExecutionException("HWS0018E", errMsg);
                                                            if (!this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) throw e;
                                                            this.logger.severe("    Exception thrown in OutputMessage.parse(boolean). Exception was: " + e.toString());
                                                            throw e;
                                                        }
                                                        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                                                            this.logger.finest("   OutputMessage.parse(boolean) - message includes CSM (*CSMOKY*)");
                                                        }
                                                        this.msgType = 0;
                                                    }
                                                    break block54;
                                                }
                                                if (!checkCsmStr.equals("*CSMOKY*")) {
                                                    String errMsg = ImsConnectErrorMessage.getString("HWS0018E");
                                                    ImsConnectExecutionException e = new ImsConnectExecutionException("HWS0018E", errMsg);
                                                    if (!this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) throw e;
                                                    this.logger.severe("    Exception thrown in OutputMessage.parse(boolean). Exception was: " + e.toString());
                                                    throw e;
                                                }
                                                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                                                    this.logger.finest("   OutputMessage.parse(boolean) - message includes CSM (*CSMOKY*)");
                                                }
                                                this.msgType = 0;
                                                break block54;
                                            }
                                            this.llll = new byte[4];
                                            System.arraycopy(this.responseMessage, 0, this.llll, 0, 4);
                                            if (checkCsmStr == null || !checkCsmStr.equals("*CSMOKY*")) break block59;
                                            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                                                this.logger.finest("   OutputMessage.parse(boolean) - message includes CSM (*CSMOKY*)");
                                            }
                                            this.msgType = 0;
                                            break block54;
                                        }
                                        if (checkT2CmdStr == null || !checkT2CmdStr.equals(OutputMessageProperties.T2C_ID)) break block60;
                                        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                                            this.logger.finest("   OutputMessage.parse(boolean) - message includes XML Type-2 command response");
                                        }
                                        this.msgType = 4;
                                        break block54;
                                    }
                                    if (checkRsmStr == null || this.responseMessage.length != 24) break block61;
                                    if (checkRsmStr.equals(OutputMessageProperties.RSM_ID_REQSTS)) {
                                        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                                            this.logger.finest("   OutputMessage.parse(boolean) - message includes RSM (*REQSTS*)");
                                        }
                                        this.msgType = 2;
                                        break block54;
                                    } else if (checkRsmStr.equals(OutputMessageProperties.RSM_ID_CBLADP)) {
                                        if (this.logger.getLevel() == Level.INFO) {
                                            this.logger.finest("   OutputMessage.parse(boolean) - message includes RSM (*XADPST*)");
                                        }
                                        this.msgType = 3;
                                    }
                                    break block54;
                                }
                                String errMsg = ImsConnectErrorMessage.getString("HWS0018E");
                                ImsConnectExecutionException e = new ImsConnectExecutionException("HWS0018E", errMsg);
                                if (!this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) throw e;
                                this.logger.severe("    Exception thrown in OutputMessage.parse(boolean). Exception was: " + e.toString());
                                throw e;
                            }
                            if (checkStr == null) break block62;
                            this.csmFlag1 = 0;
                            buf = ByteBuffer.wrap(this.getResponseMessage());
                            if (this.msgType != 2 && this.msgType != 3) break block63;
                            if (aResponseIncludesLlll) break block64;
                            this.rsmReturnCode = buf.getInt(12);
                            if (this.rsmReturnCode == 16) {
                                this.setOtmaSenseCode(buf.getInt(16));
                                this.setOtmaReasonCode(this.responseMessage[3]);
                                break block55;
                            } else if (this.rsmReturnCode == 8 && (byte)buf.getInt(16) == 40) {
                                this.setImsConnectReasonCode(buf.getInt(16));
                                this.setRacfReturnCode(this.responseMessage[3]);
                                break block55;
                            } else {
                                this.setImsConnectReasonCode(buf.getInt(16));
                            }
                            break block55;
                        }
                        this.setImsConnectReturnCode(buf.getInt(16));
                        if (this.rsmReturnCode == 16) {
                            this.setOtmaSenseCode(buf.getInt(20));
                            this.setOtmaReasonCode(this.responseMessage[7]);
                        } else if (this.rsmReturnCode == 8 && (byte)buf.getInt(20) == 40) {
                            this.setImsConnectReasonCode(buf.getInt(20));
                            this.setRacfReturnCode(this.responseMessage[7]);
                        } else {
                            this.setImsConnectReasonCode(buf.getInt(20));
                        }
                    }
                    this.mfsModname = new String("        ");
                    break block62;
                }
                if (this.msgType == 0) {
                    this.csmStr = "*CSMOKY*";
                    this.csmFlag1 = this.responseMessage[this.responseMessage.length - 12 + 2];
                    this.csmFlag2 = this.responseMessage[this.responseMessage.length - 12 + 3];
                    checkCsmStr = null;
                    checkCsmStr = checkStr.substring(aResponseIncludesLlll ? 8 : 4, aResponseIncludesLlll ? 16 : 12);
                    if (checkCsmStr.equals("*CORTKN*")) {
                        byte[] correlatorTokenByteArray = new byte[40];
                        System.arraycopy(this.responseMessage, aResponseIncludesLlll ? 16 : 12, correlatorTokenByteArray, 0, 40);
                        this.myTmInteractionImpl.setCorrelatorToken(correlatorTokenByteArray);
                        this.corOffset = 52;
                        this.isSyncCalloutReq = true;
                        checkCsmStr = null;
                        int tempStPOS = 56;
                        int tempEndPOS = 64;
                        checkCsmStr = checkStr.substring(aResponseIncludesLlll ? 4 + tempStPOS : tempStPOS, aResponseIncludesLlll ? 4 + tempEndPOS : tempEndPOS);
                        if (checkCsmStr.equals("*REQMOD*")) {
                            byte[] mfsModnameByteArray = new byte[8];
                            tempStPOS = tempEndPOS;
                            System.arraycopy(this.responseMessage, aResponseIncludesLlll ? tempStPOS + 4 : tempStPOS, mfsModnameByteArray, 0, 8);
                            this.mfsModname = new String(mfsModnameByteArray, this.myImsConnectCodepage);
                            this.rmmOffset = 20;
                            tempStPOS = tempEndPOS + 4 + 8;
                            tempEndPOS = tempStPOS + 8;
                            checkCsmStr = checkStr.substring(aResponseIncludesLlll ? 4 + tempStPOS : tempStPOS, aResponseIncludesLlll ? 4 + tempEndPOS : tempEndPOS);
                        } else {
                            this.mfsModname = new String("        ");
                            this.rmmOffset = 0;
                        }
                        if (checkCsmStr.equals("*GENCID*")) {
                            byte[] clientIdByteArray = new byte[8];
                            tempStPOS = tempEndPOS;
                            System.arraycopy(this.responseMessage, aResponseIncludesLlll ? tempStPOS + 4 : tempStPOS, clientIdByteArray, 0, 8);
                            this.clientId = new String(clientIdByteArray, this.myImsConnectCodepage);
                            this.gencidOffset = 20;
                        } else {
                            this.clientId = new String("");
                            this.gencidOffset = 0;
                        }
                    } else {
                        int tempStPOS = 12;
                        int tempEndPOS = 0;
                        if (checkCsmStr.equals("*REQMOD*")) {
                            byte[] mfsModnameByteArray = new byte[8];
                            System.arraycopy(this.responseMessage, aResponseIncludesLlll ? tempStPOS + 4 : tempStPOS, mfsModnameByteArray, 0, 8);
                            this.mfsModname = new String(mfsModnameByteArray, this.myImsConnectCodepage);
                            this.rmmOffset = 20;
                            tempStPOS = tempStPOS + 8 + 4;
                            tempEndPOS = tempStPOS + 8;
                            checkCsmStr = checkStr.substring(aResponseIncludesLlll ? 4 + tempStPOS : tempStPOS, aResponseIncludesLlll ? 4 + tempEndPOS : tempEndPOS);
                        } else {
                            this.mfsModname = new String("        ");
                            this.rmmOffset = 0;
                        }
                        if (checkCsmStr.equals("*GENCID*")) {
                            if (tempStPOS != 12) {
                                tempStPOS = tempEndPOS;
                            }
                            byte[] clientIdByteArray = new byte[8];
                            System.arraycopy(this.responseMessage, aResponseIncludesLlll ? tempStPOS + 4 : tempStPOS, clientIdByteArray, 0, 8);
                            this.clientId = new String(clientIdByteArray, this.myImsConnectCodepage);
                            this.gencidOffset = 20;
                        } else {
                            this.clientId = new String("");
                            this.gencidOffset = 0;
                        }
                    }
                    this.myTmInteractionImpl.setMfsModname(this.mfsModname);
                    if (!this.clientId.equals("")) {
                        this.myTmInteractionImpl.getMyConnection().setClientId(this.clientId);
                    }
                } else {
                    if (this.msgType != 4) {
                        String errMsg = ImsConnectErrorMessage.getString("HWS0018E");
                        ImsConnectExecutionException e = new ImsConnectExecutionException("HWS0018E", errMsg);
                        if (!this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) throw e;
                        this.logger.severe("    Exception thrown in OutputMessage.parse(boolean). Exception was: " + e.toString());
                        throw e;
                    }
                    checkCsmStr = null;
                    checkCsmStr = checkStr.substring(aResponseIncludesLlll ? 8 : 4, aResponseIncludesLlll ? 16 : 12);
                    if (checkCsmStr.equals("*GENCID*")) {
                        byte[] clientIdByteArray = new byte[8];
                        System.arraycopy(this.responseMessage, aResponseIncludesLlll ? 16 : 12, clientIdByteArray, 0, 8);
                        this.clientId = new String(clientIdByteArray, this.myImsConnectCodepage);
                        this.gencidOffset = 20;
                    } else {
                        this.clientId = new String("");
                        this.gencidOffset = 0;
                    }
                    if (!this.clientId.equals("")) {
                        this.myTmInteractionImpl.getMyConnection().setClientId(this.clientId);
                    }
                }
            }
            this.parseOutMsgByteArray();
            return;
        }
        finally {
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
                this.logger.finer("<-- OutputMessage.parse(boolean)");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void parseOutMsgByteArray() throws ImsConnectApiException, ImsConnectExecutionException {
        block10: {
            block9: {
                i = 0;
                segmentLengths = new ArrayList<Number>();
                segmentLls = new ArrayList<byte[]>();
                segmentZzs = new ArrayList<byte[]>();
                segmentData = new ArrayList<byte[]>();
                dataLen = 0;
                startCpySrcPos = 0;
                this.setMessageLength();
                dataLen = this.getMessageLength();
                if (this.myTmInteractionImpl.getInteractionTypeDescription().equals("TYPE2CMD")) {
                    startCpySrcPos = 0;
                } else {
                    if (this.myTmInteractionImpl.isResponseIncludesLlll()) {
                        startCpySrcPos = 4;
                    }
                    startCpySrcPos += this.rmmOffset;
                    startCpySrcPos += this.gencidOffset;
                }
                if (!this.isSyncCalloutReq) break block9;
                startCpySrcPos += this.corOffset;
                while (startCpySrcPos < dataLen) {
                    if (startCpySrcPos == dataLen - 12) {
                        l0Nibble = 12;
                    } else {
                        l0Nibble = this.responseMessage[startCpySrcPos] & 255;
                        l0Nibble <<= 24;
                        l0Nibble &= -16777216;
                        l1Nibble = this.responseMessage[startCpySrcPos + 1] & 255;
                        l1Nibble <<= 16;
                        l2Nibble = this.responseMessage[startCpySrcPos + 2] & 255;
                        l2Nibble <<= 8;
                        l3Nibble = this.responseMessage[startCpySrcPos + 3] & 255;
                        l0Nibble = ((l3Nibble &= 255) | (l2Nibble &= 65280) | (l1Nibble &= 0xFF0000) | l0Nibble) & 0x7FFFFFFF;
                    }
                    segmentLengths.add(l0Nibble);
                    this.ll = new byte[4];
                    System.arraycopy(this.responseMessage, startCpySrcPos, this.ll, 0, 4);
                    segmentLls.add(this.ll);
                    inputSegment = new byte[l0Nibble -= 4];
                    System.arraycopy(this.responseMessage, startCpySrcPos + 4, inputSegment, 0, l0Nibble);
                    segmentData.add(inputSegment);
                    startCpySrcPos += 4 + l0Nibble;
                }
                this.numberOfSegments = segmentData.size();
                this.parsedOutLlllByteArray = new byte[this.numberOfSegments][];
                this.parsedOutLlllValIntArray = new int[this.numberOfSegments];
                this.parsedOutDataByteArray = new byte[this.numberOfSegments][];
                while (i < this.numberOfSegments) {
                    this.parsedOutLlllByteArray[i] = new byte[4];
                    System.arraycopy(segmentLls.get(i), 0, this.parsedOutLlllByteArray[i], 0, 4);
                    this.parsedOutLlllValIntArray[i] = i == this.numberOfSegments - 1 ? 12 : (Integer)segmentLengths.get(i);
                    this.parsedOutDataByteArray[i] = new byte[this.parsedOutLlllValIntArray[i] - 4];
                    System.arraycopy(segmentData.get(i), 0, this.parsedOutDataByteArray[i], 0, this.parsedOutLlllValIntArray[i] - 4);
                    ++i;
                }
                break block10;
            }
            if (!this.myTmInteractionImpl.getInteractionTypeDescription().equals("TYPE2CMD")) ** GOTO lbl108
            l0Nibble = this.responseMessage[startCpySrcPos] & 255;
            l0Nibble <<= 24;
            l0Nibble &= -16777216;
            l1Nibble = this.responseMessage[startCpySrcPos + 1] & 255;
            l1Nibble <<= 16;
            l2Nibble = this.responseMessage[startCpySrcPos + 2] & 255;
            l2Nibble <<= 8;
            l3Nibble = this.responseMessage[startCpySrcPos + 3] & 255;
            l0Nibble = ((l3Nibble &= 255) | (l2Nibble &= 65280) | (l1Nibble &= 0xFF0000) | l0Nibble) & 0x7FFFFFFF;
            segmentLengths.add(l0Nibble);
            inputSegment = new byte[l0Nibble - 4];
            System.arraycopy(this.responseMessage, startCpySrcPos + 4, inputSegment, 0, l0Nibble - 4);
            segmentData.add(inputSegment);
            startCpySrcPos += l0Nibble - 4;
            this.numberOfSegments = segmentData.size();
            this.parsedOutLlllByteArray = new byte[1][];
            this.parsedOutLlllValIntArray = new int[1];
            this.parsedOutDataByteArray = new byte[1][];
            this.parsedOutLlllByteArray[0] = new byte[4];
            this.parsedOutLlllValIntArray[0] = (Integer)segmentLengths.get(0);
            this.parsedOutDataByteArray[0] = new byte[this.parsedOutLlllValIntArray[0] - 4];
            System.arraycopy(segmentData.get(0), 0, this.parsedOutDataByteArray[0], 0, this.parsedOutLlllValIntArray[0] - 4);
            this.myType2CommandResponse.setType2CmdrspdataStale(true);
            break block10;
lbl-1000:
            // 1 sources

            {
                l0Nibble = (short)(this.responseMessage[startCpySrcPos] & 255);
                l0Nibble = (short)(l0Nibble << 8);
                l0Nibble = (short)(l0Nibble & 65280);
                l1Nibble = (short)(this.responseMessage[startCpySrcPos + 1] & 255);
                l1Nibble = (short)(l1Nibble & 255);
                l1Nibble = (short)(l1Nibble & 255);
                l0Nibble = (short)(l0Nibble | l1Nibble);
                segmentLengths.add(l0Nibble);
                l0Nibble = (short)(l0Nibble - 4);
                this.ll = new byte[2];
                System.arraycopy(this.responseMessage, startCpySrcPos, this.ll, 0, 2);
                segmentLls.add(this.ll);
                this.zz = new byte[2];
                System.arraycopy(this.responseMessage, startCpySrcPos + 2, this.zz, 0, 2);
                segmentZzs.add(this.zz);
                inputSegment = new byte[l0Nibble];
                System.arraycopy(this.responseMessage, startCpySrcPos + 4, inputSegment, 0, l0Nibble);
                segmentData.add(inputSegment);
                startCpySrcPos += 4 + l0Nibble;
lbl108:
                // 2 sources

                ** while (startCpySrcPos < dataLen)
            }
lbl109:
            // 1 sources

            this.numberOfSegments = segmentData.size();
            this.parsedOutLlByteArray = new byte[this.numberOfSegments][];
            this.parsedOutLlValShortArray = new short[this.numberOfSegments];
            this.parsedOutZzByteArray = new byte[this.numberOfSegments][];
            this.parsedOutDataByteArray = new byte[this.numberOfSegments][];
            while (i < this.numberOfSegments) {
                this.parsedOutLlByteArray[i] = new byte[2];
                System.arraycopy(segmentLls.get(i), 0, this.parsedOutLlByteArray[i], 0, 2);
                this.parsedOutLlValShortArray[i] = (Short)segmentLengths.get(i);
                this.parsedOutZzByteArray[i] = new byte[2];
                System.arraycopy(segmentZzs.get(i), 0, this.parsedOutZzByteArray[i], 0, 2);
                this.parsedOutDataByteArray[i] = new byte[this.parsedOutLlValShortArray[i] - 4];
                System.arraycopy(segmentData.get(i), 0, this.parsedOutDataByteArray[i], 0, this.parsedOutLlValShortArray[i] - 4);
                ++i;
            }
        }
    }

    void processType2CmdRsp(byte[] aParsedOutDataByteArray) throws ImsConnectApiException {
        this.myXmlParser.parseXml(this.myType2CommandResponse, aParsedOutDataByteArray, this.myImsConnectCodepage);
        this.myType2CommandResponse.setType2CmdrspdataStale(false);
    }

    public byte[] getDataBytes() {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> OutputMessage.getDataBytes()");
        }
        this.setMessageIsSingleSegment(this.getNumberOfSegments() <= 1);
        if (this.responseMessage != null && this.csmStr != null && this.csmStr.equalsIgnoreCase("*CSMOKY*")) {
            this.messageLength = this.responseMessage.length;
            if (this.messageLength > 0) {
                int dataBytesLen = this.messageLength - (!this.includeLlzzInSegments && this.messageIsSingleSegment ? this.myTmInteractionImpl.getNumberOfSegmentsFromOutput() * 4 : 0);
                byte[] dataBytes = new byte[dataBytesLen];
                if (this.myTmInteractionImpl.getIncludeLlllInOutputMessages()) {
                    System.arraycopy(this.responseMessage, 0, dataBytes, 0, 4);
                    if (!this.includeLlzzInSegments && this.messageIsSingleSegment) {
                        System.arraycopy(this.responseMessage, 8, dataBytes, 4, this.messageLength - 4 - 12);
                        System.arraycopy(this.responseMessage, this.messageLength - 8, dataBytes, dataBytesLen - 8, 8);
                    } else {
                        System.arraycopy(this.responseMessage, 4, dataBytes, 4, dataBytesLen - 4);
                    }
                } else if (!this.includeLlzzInSegments && this.messageIsSingleSegment) {
                    System.arraycopy(this.responseMessage, 4, dataBytes, 0, this.messageLength - 4 - 12);
                    System.arraycopy(this.responseMessage, this.messageLength - 8, dataBytes, dataBytesLen - 8, 8);
                } else {
                    System.arraycopy(this.responseMessage, 0, dataBytes, 0, this.messageLength);
                }
                return dataBytes;
            }
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- OutputMessage.getDataBytes()");
        }
        return null;
    }

    @Override
    public byte[] getDataAsByteArray() {
        int i = 0;
        byte[] returnByteArray = null;
        int returnByteArrayLen = 0;
        int copyPos = 0;
        while (i < this.numberOfSegments) {
            returnByteArrayLen += this.parsedOutDataByteArray[i++].length;
        }
        returnByteArray = new byte[returnByteArrayLen];
        i = 0;
        while (i < this.numberOfSegments) {
            int llVal = this.isSyncCalloutReq ? new Integer(this.parsedOutLlllValIntArray[i]) - 4 : new Short(this.parsedOutLlValShortArray[i]) - 4;
            System.arraycopy(this.parsedOutDataByteArray[i++], 0, returnByteArray, copyPos, llVal);
            copyPos += llVal;
        }
        return returnByteArray;
    }

    @Override
    public byte[][] getDataAsArrayOfByteArrays() {
        return this.parsedOutDataByteArray;
    }

    @Override
    public String getDataAsString() throws ImsConnectApiException {
        StringBuffer strBuf = new StringBuffer("");
        int i = 0;
        try {
            while (i < this.numberOfSegments) {
                strBuf.append(new String(this.parsedOutDataByteArray[i++], this.myImsConnectCodepage));
            }
            return strBuf.toString();
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"output response message", this.myImsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in OutputMessage.getDataAsString(). Exception was: " + e.toString());
            }
            throw e;
        }
    }

    @Override
    public String[] getDataAsArrayOfStrings() throws ImsConnectApiException {
        int i = 0;
        String[] msgAsStringArray = new String[this.numberOfSegments];
        try {
            while (i < this.numberOfSegments) {
                msgAsStringArray[i] = new String(this.parsedOutDataByteArray[i], this.myImsConnectCodepage);
                ++i;
            }
        }
        catch (UnsupportedEncodingException usee) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0017E", new Object[]{"output response message", this.myImsConnectCodepage});
            ImsConnectApiException e = new ImsConnectApiException("HWS0017E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in OutputMessage.getDataAsArrayOfStrings(). Exception was: " + e.toString());
            }
            throw e;
        }
        return msgAsStringArray;
    }

    @Override
    public byte[] getSegmentDataAsByteArray(int aSegmentNumber) {
        return this.parsedOutDataByteArray[aSegmentNumber];
    }

    @Override
    public String getSegmentDataAsString(int aSegmentNumber) {
        return new String(this.getSegmentDataAsByteArray(aSegmentNumber));
    }

    @Override
    public byte[] getLlll() {
        return this.llll;
    }

    @Override
    public String getLlllAsHexString() {
        byte[] llllByteArray = this.getLlll();
        if (llllByteArray != null) {
            int l0 = (llllByteArray[0] & 0xF0) >> 4;
            int l1 = llllByteArray[0] & 0xF;
            int l2 = (llllByteArray[1] & 0xF0) >> 4;
            int l3 = llllByteArray[1] & 0xF;
            int l4 = (llllByteArray[2] & 0xF0) >> 4;
            int l5 = llllByteArray[2] & 0xF;
            int l6 = (llllByteArray[3] & 0xF0) >> 4;
            int l7 = llllByteArray[3] & 0xF;
            StringBuffer strbuf = new StringBuffer("");
            strbuf.append(Integer.toString(l0, 16));
            strbuf.append(String.valueOf(Integer.toString(l1, 16)) + " ");
            strbuf.append(Integer.toString(l2, 16));
            strbuf.append(String.valueOf(Integer.toString(l3, 16)) + " ");
            strbuf.append(Integer.toString(l4, 16));
            strbuf.append(String.valueOf(Integer.toString(l5, 16)) + " ");
            strbuf.append(Integer.toString(l6, 16));
            strbuf.append(Integer.toString(l7, 16));
            return new String(strbuf);
        }
        return "00 00 00 00";
    }

    @Override
    public int getLlllValue() {
        byte[] llllByteArray = this.getLlll();
        if (llllByteArray != null) {
            int l0 = (llllByteArray[0] & 0xF0) >> 4;
            int l1 = llllByteArray[0] & 0xF;
            int l2 = (llllByteArray[1] & 0xF0) >> 4;
            int l3 = llllByteArray[1] & 0xF;
            int l4 = (llllByteArray[2] & 0xF0) >> 4;
            int l5 = llllByteArray[2] & 0xF;
            int l6 = (llllByteArray[3] & 0xF0) >> 4;
            int l7 = llllByteArray[3] & 0xF;
            int llllValue = l0 << 28 | l1 << 24 | l2 << 20 | l3 << 16 | l4 << 12 | l5 << 8 | l6 << 4 | l7;
            return llllValue;
        }
        return 0;
    }

    @Override
    public byte[] getSegmentLl(int aSegmentNumber) {
        return this.parsedOutLlByteArray[aSegmentNumber];
    }

    @Override
    public String getSegmentLlAsHexString(int aSegmentNumber) {
        byte[] segmentLlByteArray = this.parsedOutLlByteArray[aSegmentNumber];
        int l0 = (segmentLlByteArray[0] & 0xF0) >> 4;
        int l1 = segmentLlByteArray[0] & 0xF;
        int l2 = (segmentLlByteArray[1] & 0xF0) >> 4;
        int l3 = segmentLlByteArray[1] & 0xF;
        StringBuffer strbuf = new StringBuffer("");
        strbuf.append(Integer.toString(l0, 16));
        strbuf.append(String.valueOf(Integer.toString(l1, 16)) + " ");
        strbuf.append(Integer.toString(l2, 16));
        strbuf.append(Integer.toString(l3, 16));
        return new String(strbuf);
    }

    @Override
    public short getSegmentLlValue(int aSegmentNumber) {
        return this.parsedOutLlValShortArray[aSegmentNumber];
    }

    public byte[] getSegmentLlll(int aSegmentNumber) {
        return this.parsedOutLlllByteArray[aSegmentNumber];
    }

    public String getSegmentLlllAsHexString(int aSegmentNumber) {
        byte[] segmentLlllByteArray = this.parsedOutLlllByteArray[aSegmentNumber];
        int l0 = (segmentLlllByteArray[0] & 0xF0) >> 4;
        int l1 = segmentLlllByteArray[0] & 0xF;
        int l2 = (segmentLlllByteArray[1] & 0xF0) >> 4;
        int l3 = segmentLlllByteArray[1] & 0xF;
        int l4 = (segmentLlllByteArray[2] & 0xF0) >> 4;
        int l5 = segmentLlllByteArray[2] & 0xF;
        int l6 = (segmentLlllByteArray[3] & 0xF0) >> 4;
        int l7 = segmentLlllByteArray[3] & 0xF;
        StringBuffer strbuf = new StringBuffer("");
        strbuf.append(Integer.toString(l0, 16));
        strbuf.append(String.valueOf(Integer.toString(l1, 16)) + " ");
        strbuf.append(Integer.toString(l2, 16));
        strbuf.append(String.valueOf(Integer.toString(l3, 16)) + " ");
        strbuf.append(Integer.toString(l4, 16));
        strbuf.append(String.valueOf(Integer.toString(l5, 16)) + " ");
        strbuf.append(Integer.toString(l6, 16));
        strbuf.append(Integer.toString(l7, 16));
        return new String(strbuf);
    }

    public int getSegmentLlllValue(int aSegmentNumber) {
        return this.parsedOutLlllValIntArray[aSegmentNumber];
    }

    @Override
    public byte[] getSegmentZz(int aSegmentNumber) {
        return this.parsedOutZzByteArray[aSegmentNumber];
    }

    @Override
    public String getSegmentZzAsHexString(int aSegmentNumber) {
        byte[] segmentZzByteArray = this.parsedOutZzByteArray[aSegmentNumber];
        int z0 = (segmentZzByteArray[0] & 0xF0) >> 4;
        int z1 = segmentZzByteArray[0] & 0xF;
        int z2 = (segmentZzByteArray[1] & 0xF0) >> 4;
        int z3 = segmentZzByteArray[1] & 0xF;
        StringBuffer strbuf = new StringBuffer("");
        strbuf.append(Integer.toString(z0, 16));
        strbuf.append(String.valueOf(Integer.toString(z1, 16)) + " ");
        strbuf.append(Integer.toString(z2, 16));
        strbuf.append(Integer.toString(z3, 16));
        return new String(strbuf);
    }

    @Override
    public int getNumberOfSegments() {
        return this.numberOfSegments;
    }

    public String toString() {
        boolean obfuscatePassword = false;
        return this.myTmInteractionImpl.formatBufferForTracing(this.getResponseMessage(), obfuscatePassword);
    }

    protected byte getCsmFlag1() {
        return this.csmFlag1;
    }

    public byte getCsmFlag2() {
        return this.csmFlag2;
    }

    protected String getCsmStr() {
        return this.csmStr;
    }

    protected String getMyImsConnectCodepage() {
        return this.myImsConnectCodepage;
    }

    protected boolean isMessageIsSingleSegment() {
        return this.messageIsSingleSegment;
    }

    @Override
    public int getMessageLength() {
        return this.messageLength;
    }

    protected int getMsgType() {
        return this.msgType;
    }

    protected byte[][] getParsedOutDataByteArray() {
        return this.parsedOutDataByteArray;
    }

    protected byte[][] getParsedOutLlByteArray() {
        return this.parsedOutLlByteArray;
    }

    protected short[] getParsedOutLlValShortArray() {
        return this.parsedOutLlValShortArray;
    }

    protected byte[][] getParsedOutLlllByteArray() {
        return this.parsedOutLlllByteArray;
    }

    protected int[] getParsedOutLlllValIntArray() {
        return this.parsedOutLlllValIntArray;
    }

    protected byte[][] getParsedOutZzByteArray() {
        return this.parsedOutZzByteArray;
    }

    @Override
    public byte[] getResponseMessage() {
        return this.responseMessage;
    }

    public String getRSMErrorMsg() {
        String hwsrescode = "HWS_RESCODE_";
        String rsmErrMsg = ImsConnectErrorMessage.getString(String.valueOf(hwsrescode) + String.valueOf(this.rsmReasonCode));
        return rsmErrMsg;
    }

    @Override
    public int getImsConnectReturnCode() {
        return this.rsmReturnCode;
    }

    @Override
    public int getImsConnectReasonCode() {
        return this.rsmReasonCode;
    }

    @Override
    public String getMfsModname() {
        return this.mfsModname;
    }

    @Override
    public String getReturnedClientId() {
        return this.clientId;
    }

    @Override
    public int getOtmaSenseCode() {
        return this.rsmOtmaSenseCode;
    }

    @Override
    public byte getOtmaReasonCode() {
        return this.rsmOtmaReasonCode;
    }

    @Override
    public int getRacfReturnCode() {
        return this.rsmRacfReturnCode;
    }

    @Override
    public String getRacfReturnCodeString() {
        return this.racfReturnCodeString;
    }

    @Override
    public boolean isResponseIncludesLlll() {
        return this.responseIncludesLlll;
    }

    @Override
    public boolean isAckNakNeeded() {
        if (this.isResponsePropertiesUpdatedAfterResponse()) {
            return this.ackNakNeeded;
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            this.logger.finest("   isAckNakNeeded returned the default value, false, since no response has been yet from IMS Connect\n");
        }
        return false;
    }

    protected boolean isResponsePropertiesUpdatedAfterResponse() {
        return this.responsePropertiesUpdatedAfterResponse;
    }

    @Override
    public boolean isAsyncOutputAvailable() {
        if (this.isAsyncOutputAvailablePropertyUpdated()) {
            return this.asyncOutputAvailable;
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            this.logger.finest("   isAsyncOutputAvailable returned the default value, false, since no response has been yet from IMS Connect\n");
        }
        return false;
    }

    protected boolean isAsyncOutputAvailablePropertyUpdated() {
        return this.responsePropertiesUpdatedAfterResponse;
    }

    @Override
    public boolean isInConversation() {
        if (this.isResponsePropertiesUpdatedAfterResponse()) {
            return this.inConversation;
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            this.logger.finest("   isInConversation returned the default value, false, since no response has been received yet from IMS Connect\n");
        }
        return false;
    }

    public byte getProtocolLevel() {
        return this.protocolLevel;
    }

    public boolean isProtocolLevelAvailable() {
        return this.protocolLevelAvailable;
    }

    protected boolean isIncludeLlzzInSegments() {
        return this.includeLlzzInSegments;
    }

    protected void setCsmFlag1(byte csmFlag) {
        this.csmFlag1 = csmFlag;
    }

    public void setCsmFlag2(byte csmFlag2) {
        this.csmFlag2 = csmFlag2;
    }

    protected void setCsmStr(String aCsmStr) {
        this.csmStr = aCsmStr;
    }

    protected void setMyImsConnectCodepage(String string) {
        if (string == null) {
            return;
        }
        this.myImsConnectCodepage = string;
    }

    protected void setMessageLength() throws ImsConnectExecutionException {
        if (this.myTmInteractionImpl.isResponseIncludesLlll()) {
            byte[] messageAsByteArray = this.responseMessage;
            int l0Nibble = messageAsByteArray[0] & 0xFF;
            l0Nibble <<= 24;
            l0Nibble &= 0xFF000000;
            int l1Nibble = messageAsByteArray[1] & 0xFF;
            l1Nibble <<= 16;
            int l2Nibble = messageAsByteArray[2] & 0xFF;
            l2Nibble <<= 8;
            int l3Nibble = messageAsByteArray[3] & 0xFF;
            this.messageLength = ((l3Nibble &= 0xFF) | (l2Nibble &= 0xFF00) | (l1Nibble &= 0xFF0000) | l0Nibble) & Integer.MAX_VALUE;
            if (this.messageLength != this.responseMessage.length) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0020E", new Object[]{this.responseMessage.length, this.messageLength});
                ImsConnectExecutionException e = new ImsConnectExecutionException("HWS0020E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception caught in OutputMessage.setMessageLength(). Exception was: " + e.toString());
                }
                throw e;
            }
        } else {
            this.messageLength = this.responseMessage.length;
        }
    }

    protected void setMessageLength(int aMessageLength) {
        this.messageLength = aMessageLength;
    }

    protected void setResponseMessage(byte[] outMessage) {
        this.responseMessage = outMessage;
    }

    protected void setMessageIsSingleSegment(boolean messageIsSingleSegment) {
        this.messageIsSingleSegment = messageIsSingleSegment;
    }

    protected void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    protected void setNumberOfSegments(int numberOfSegments) {
        this.numberOfSegments = numberOfSegments;
    }

    protected void setImsConnectReasonCode(int anRsmReasonCode) {
        this.rsmReasonCode = anRsmReasonCode;
    }

    protected void setImsConnectReturnCode(int anRsmReturnCode) {
        this.rsmReturnCode = anRsmReturnCode;
    }

    protected void setOtmaSenseCode(int anRsmOtmaSenseCode) {
        this.rsmOtmaSenseCode = anRsmOtmaSenseCode;
    }

    protected void setOtmaReasonCode(byte anRsmOtmaReasonCode) {
        this.rsmOtmaReasonCode = anRsmOtmaReasonCode;
    }

    public void setRacfReturnCode(int rsmRacfReturnCode) {
        this.rsmRacfReturnCode = rsmRacfReturnCode;
    }

    public void setRacfReturnCodeString(String aRacfReturnCodeString) {
        this.racfReturnCodeString = aRacfReturnCodeString;
    }

    protected void setAckNakNeeded(boolean ackNakNeeded) {
        this.ackNakNeeded = ackNakNeeded;
    }

    protected void setResponsePropertiesUpdatedAfterResponse(boolean aResponsePropertiesUpdatedAfterResponse) {
        this.responsePropertiesUpdatedAfterResponse = aResponsePropertiesUpdatedAfterResponse;
    }

    protected void setAsyncOutputAvailable(boolean asyncOutputAvailable) {
        this.asyncOutputAvailable = asyncOutputAvailable;
    }

    protected void setInConversation(boolean inConversation) {
        this.inConversation = inConversation;
    }

    public void setProtocolLevel(byte protocolLevel) {
        this.protocolLevel = protocolLevel;
    }

    public void setProtocolLevelAvailable(boolean protocolLevelAvailable) {
        this.protocolLevelAvailable = protocolLevelAvailable;
    }

    protected void setIncludeLlzzInSegments(boolean aSegmentsIncludeLlzz) {
        this.includeLlzzInSegments = aSegmentsIncludeLlzz;
    }

    @Override
    public Type2CmdResponse getType2CommandResponse() throws ImsConnectApiException {
        if (this.myType2CommandResponse == null) {
            this.myType2CommandResponse = new Type2CmdResponse(this.myImsConnectCodepage);
        } else if (this.myType2CommandResponse.isType2CmdRspStale()) {
            this.processType2CmdRsp(this.parsedOutDataByteArray[0]);
        }
        return this.myType2CommandResponse;
    }

    private void setMyType2CommandResponse(Type2CmdResponse type2CommandResponse) {
        this.myType2CommandResponse = type2CommandResponse;
    }
}

