/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ims.connect.impl;

import com.ibm.ims.connect.ApiProperties;
import com.ibm.ims.connect.Connection;
import com.ibm.ims.connect.ImsConnectApiException;
import com.ibm.ims.connect.ImsConnectErrorMessage;
import com.ibm.ims.connect.ImsConnectExecutionException;
import com.ibm.ims.connect.ImsOtmaExecutionException;
import com.ibm.ims.connect.InputMessage;
import com.ibm.ims.connect.OutputMessage;
import com.ibm.ims.connect.PropertiesFileLoader;
import com.ibm.ims.connect.TmInteraction;
import com.ibm.ims.connect.TmInteractionAttributes;
import com.ibm.ims.connect.impl.ConnectionImpl;
import com.ibm.ims.connect.impl.InputMessageImpl;
import com.ibm.ims.connect.impl.OutputMessageImpl;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.util.logging.Logger;

public final class TmInteractionImpl
implements TmInteraction,
Cloneable {
    private static final String copyright = "Licensed Material - Property of IBM 5655-TDA(C) Copyright IBM Corp. 2009,2013  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private TmInteractionAttributes interAttr = null;
    private ConnectionImpl myConnection = null;
    private InputMessageImpl internalAckInputMessage;
    private InputMessage inputMsg = new InputMessageImpl(this);
    private OutputMessage outputMsg = new OutputMessageImpl(this);
    protected boolean updateIrmDestId = true;
    protected boolean updateIrmId = true;
    protected boolean updateIrmLTerm = true;
    protected boolean updateIrmRacfApplName = true;
    protected boolean updateIrmRacfGroupName = true;
    protected boolean updateIrmRacfPassword = true;
    protected boolean updateIrmRacfUserId = true;
    protected boolean updateIrmRerouteName = true;
    protected boolean updateIrmTagAdapter = false;
    protected boolean updateIrmTagMap = true;
    protected boolean updateIrmTrancode = true;
    protected boolean updateIrmTrancodeInData = true;
    protected boolean updateIrmInputModName = true;
    protected boolean updateIrmInteractionType = true;
    protected boolean copyInputMessageForInternalAck = true;
    private byte architectureLevel = (byte)3;
    private byte ackNakProvider = 0;
    private int clientType = 1;
    private byte commitMode = (byte)64;
    private boolean cm0IgnorePurge = false;
    private boolean cancelClientId = true;
    private boolean returnClientId = false;
    private boolean generateClientIdWhenDuplicate = false;
    private boolean inputMessageDataSegmentsIncludeLlzzAndTrancode = false;
    private String imsConnectUserMessageExitIdentifier = "*SAMPL1*";
    private int inputMessageOptions = 0;
    private String interactionTypeDescription = "SENDRECV";
    private String ltermOverrideName = "        ";
    private boolean returnMfsModname = false;
    private byte syncLevel = 1;
    private String xmlAdapterName = "HWSXMLA0";
    private String xmlConverterName = "HWSXCNV0";
    private byte xmlMessageType = 0;
    private String imsConnectCodepage = "CP037";
    private byte imsConnectUnicodeEncodingSchema = 0;
    private byte imsConnectUnicodeUsage = 0;
    private boolean purgeUndeliverableOutput = false;
    private boolean rerouteUndeliverableOutput = false;
    private String rerouteName = "        ";
    private String resumeTpipeAlternateClientId = "        ";
    private int resumeTpipeProcessing = 16;
    private String calloutRequestNakProcessing = "DISCARDREQUESTENDRESUMETPIPE";
    private String calloutResponseMessageType = "CALLOUTRESPONSEMESSAGE";
    private byte resumeTPipeRetrievalType = 0;
    private short nakReasonCode = 0;
    private String inputModName = "        ";
    private byte[] correlatorTkn = CORRELATOR_TOKEN_DEFAULT;
    private String racfApplName = "RACFAPNM";
    private String racfGroupName = "RACFGRUP";
    private String racfPassword = "RACFPSWD";
    private String racfUserId = "RACFUID";
    private String imsDatastoreName = "MYDSTRNM";
    private String trancode = "TRANCODE";
    private int interactionTimeout = -1;
    private int imsConnectTimeout = 0;
    private int imsConnectConvertedTimeout = 0;
    private int imsConnectTimeoutIndex = 0;
    private boolean otmaTransactionExpiration = false;
    private boolean useCM0AckNoWait = false;
    private boolean cM0AckNoWaitCanBeUsed = false;
    private boolean returnDFS2082AfterCM0SendRecvNoResponse = false;
    private boolean ackNakNeeded;
    private boolean asyncOutputAvailable;
    private boolean inConversation;
    private boolean protocolLevelAvailable;
    private byte protocolLevel;
    private int imsConnectReturnCode;
    private int imsConnectReasonCode;
    private String mfsModname;
    private int otmaSenseCode;
    private int otmaReasonCode;
    private int racfReturnCode;
    private String racfReturnCodeString;
    private boolean responseIncludesLlll;
    byte[] inputMsgBytes = null;
    byte[] outputMsgBytes = null;
    byte[] anEmptyByteArray = new byte[0];
    private Logger logger = Logger.getLogger("com.ibm.ims.connect");
    private byte csmFlag1;
    private byte csmFlag2;
    private SavedResponseValues mySavedResponseValues = null;
    private boolean recvAfterResumeTpipe = false;
    private boolean use2DimensionalByteArray;
    private int cursor;
    private int numberOfSegments;
    private boolean includeLlllInOutputMessages = true;
    private boolean includeLlzzInOutputMessages = true;
    private boolean ackNakNeededPropertyUpdated = false;
    private boolean responsePropertiesUpdatedAfterResponse = false;
    protected boolean rebuildMessage = true;
    private String allValidInteractionTypeDescriptionsString = " ACK CANCELTIMER ENDCONVERSATION RECEIVE SENDONLYACK NAK SENDONLYXCFORDDLV RESUMETPIPE SENDONLY SENDRECV SENDONLYCALLOUTRESPONSE SENDONLYACKCALLOUTRESPONSE TYPE2CMD";
    private String allValidCalloutRequestNakProcessingsString = " DISCARDREQUESTCONTINUERESUMETPIPE DISCARDREQUESTENDRESUMETPIPE REQUEUEREQUESTENDRESUMETPIPE";
    private String allValidCalloutResponseMessageTypesString = " CALLOUTRESPONSEMESSAGE CALLOUTERRORMESSAGE";

    public TmInteractionImpl() throws ImsConnectApiException {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-> TmInteractionImpl()");
        }
    }

    public TmInteractionImpl(TmInteractionAttributes tmInterAttr) throws ImsConnectApiException {
        new TmInteractionImpl();
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> TmInteractionImpl(TmInteractionAttributes)");
        }
        this.interAttr = tmInterAttr;
        this.ackNakProvider = tmInterAttr.getAckNakProvider();
        this.commitMode = tmInterAttr.getCommitMode();
        this.syncLevel = tmInterAttr.getSyncLevel();
        this.interactionTypeDescription = tmInterAttr.getInteractionTypeDescription();
        this.imsDatastoreName = tmInterAttr.getImsDatastoreName();
        this.racfUserId = tmInterAttr.getRacfUserId();
        this.racfPassword = tmInterAttr.getRacfPassword();
        this.racfGroupName = tmInterAttr.getRacfGroupName();
        this.racfApplName = tmInterAttr.getRacfApplName();
        this.ltermOverrideName = tmInterAttr.getLtermOverrideName();
        this.imsConnectUserMessageExitIdentifier = tmInterAttr.getImsConnectUserMessageExitIdentifier();
        this.inputMessageDataSegmentsIncludeLlzzAndTrancode = tmInterAttr.isInputMessageDataSegmentsIncludeLlzzAndTrancode();
        this.responseIncludesLlll = tmInterAttr.isResponseIncludesLlll();
        this.trancode = tmInterAttr.getTrancode();
        this.purgeUndeliverableOutput = tmInterAttr.isPurgeUndeliverableOutput();
        this.rerouteUndeliverableOutput = tmInterAttr.isRerouteUndeliverableOutput();
        this.rerouteName = tmInterAttr.getRerouteName();
        this.resumeTpipeAlternateClientId = tmInterAttr.getResumeTpipeAlternateClientId();
        this.imsConnectTimeout = tmInterAttr.getImsConnectTimeout();
        this.otmaTransactionExpiration = tmInterAttr.isOtmaTransactionExpiration();
        this.imsConnectCodepage = tmInterAttr.getImsConnectCodepage();
        this.resumeTpipeProcessing = tmInterAttr.getResumeTpipeProcessing();
        this.interactionTimeout = tmInterAttr.getInteractionTimeout();
        this.useCM0AckNoWait = tmInterAttr.isCm0IgnorePurge();
        this.cancelClientId = tmInterAttr.isCancelClientId();
        this.returnClientId = tmInterAttr.isReturnClientId();
        this.generateClientIdWhenDuplicate = tmInterAttr.isGenerateClientIdWhenDuplicate();
        this.calloutRequestNakProcessing = tmInterAttr.getCalloutRequestNakProcessing();
        this.calloutResponseMessageType = tmInterAttr.getCalloutResponseMessageType();
        this.resumeTPipeRetrievalType = tmInterAttr.getResumeTpipeRetrievalType();
        this.nakReasonCode = tmInterAttr.getNakReasonCode();
        this.returnMfsModname = tmInterAttr.isReturnMfsModname();
        this.correlatorTkn = tmInterAttr.getCorrelatorToken();
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- TmInteractionImpl(TmInteractionAttributes)");
        }
    }

    @Override
    public void execute() throws ImsConnectApiException, ImsConnectExecutionException, SocketException, Exception {
        boolean suppressLogging = false;
        byte[] inputData = null;
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> TmInteractionImpl.execute(byte[])");
        }
        ((OutputMessageImpl)this.outputMsg).reset(this);
        this.myConnection.setInteractionTimeout(this.interactionTimeout);
        if (!this.myConnection.isConnected()) {
            this.myConnection.connect();
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            this.logger.finest("   TmInteractionImpl.execute(byte[]) - processing " + this.interactionTypeDescription + " interaction");
        }
        if (this.getInteractionTypeDescription() == "RESUMETPIPE" && this.getAckNakProvider() == 0 && (this.getResumeTpipeProcessing() == 2 || this.getResumeTpipeProcessing() == 4)) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0015E");
            ImsConnectApiException e = new ImsConnectApiException("HWS0015E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in TmInteraction.execute(byte[]). Exception caught was: " + e.toString());
            }
            throw e;
        }
        if (this.inConversation && (this.interactionTypeDescription == "RESUMETPIPE" || this.interactionTypeDescription == "SENDONLY" || this.interactionTypeDescription == "SENDONLYACK" || this.interactionTypeDescription == "SENDONLYXCFORDDLV")) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0016E");
            ImsConnectApiException e = new ImsConnectApiException("HWS0016E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in TmInteraction.execute(byte[]). Exception caught was: " + e.toString());
            }
            throw e;
        }
        if (this.ackNakNeeded && this.ackNakProvider == 1 && this.interactionTypeDescription != "ACK" && this.interactionTypeDescription != "NAK") {
            String errMsg = ImsConnectErrorMessage.getString("HWS0045E", new Object[]{this.interactionTypeDescription});
            ImsConnectApiException e = new ImsConnectApiException("HWS0045E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception caught in TmInteraction.execute(byte[]). Exception caught was: " + e.toString());
            }
            throw e;
        }
        if (this.interactionTypeDescription == "SENDRECV" || this.interactionTypeDescription == "RESUMETPIPE" || this.interactionTypeDescription == "SENDONLYACKCALLOUTRESPONSE" || this.interactionTypeDescription == "TYPE2CMD" || this.interactionTypeDescription == "NAK" || this.interactionTypeDescription == "SENDONLYACK" || this.interactionTypeDescription == "CANCELTIMER") {
            if (this.interactionTypeDescription == "TYPE2CMD") {
                if (this.imsConnectUserMessageExitIdentifier != "*HWSCS1*" && this.imsConnectUserMessageExitIdentifier != "*HWSCSL*") {
                    this.imsConnectUserMessageExitIdentifier = "*HWSCS1*";
                }
                this.outputMsg.getType2CommandResponse().reset(this.imsConnectCodepage);
            }
            inputData = ((InputMessageImpl)this.inputMsg).buildInputMessageByteArray(suppressLogging);
            this.myConnection.send(inputData);
            this.outputMsgBytes = this.myConnection.receive();
            ((OutputMessageImpl)this.outputMsg).setResponseMessage(this.outputMsgBytes);
            this.processOutputMessage();
        } else if (this.interactionTypeDescription == "ACK" && this.inConversation || this.interactionTypeDescription == "SENDONLY" || this.interactionTypeDescription == "SENDONLYCALLOUTRESPONSE" || this.interactionTypeDescription == "SENDONLYXCFORDDLV" || this.interactionTypeDescription == "ENDCONVERSATION") {
            inputData = ((InputMessageImpl)this.inputMsg).buildInputMessageByteArray(suppressLogging);
            this.myConnection.send(inputData);
            this.imsConnectReturnCode = 0;
            this.imsConnectReasonCode = 0;
            this.otmaSenseCode = 0;
            this.setAckNakNeeded(false);
            if (this.interactionTypeDescription == "ENDCONVERSATION") {
                this.setInConversation(false);
            }
        } else if (this.interactionTypeDescription == "ACK") {
            if (this.cM0AckNoWaitCanBeUsed) {
                this.setImsConnectTimeout(-23);
                inputData = ((InputMessageImpl)this.inputMsg).buildInputMessageByteArray(suppressLogging);
                this.myConnection.send(inputData);
                this.imsConnectReturnCode = 0;
                this.imsConnectReasonCode = 0;
                this.otmaSenseCode = 0;
                this.setAckNakNeeded(false);
                if (this.interactionTypeDescription == "ENDCONVERSATION") {
                    this.setInConversation(false);
                }
            } else {
                if (this.useCM0AckNoWait && (!this.protocolLevelAvailable || this.protocolLevel != 2) && this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                    this.logger.finest("   The useCm0AckNoWait value of true was ignored because CM0 ACK nowait is not supported in the target IMS Connect.  The API will send in the ACK message using the configured imsConnectTimeout value and wait that length of time for the timeout response to be returned by IMS Connect.");
                }
                inputData = ((InputMessageImpl)this.inputMsg).buildInputMessageByteArray(suppressLogging);
                this.myConnection.send(inputData);
                this.outputMsgBytes = this.myConnection.receive();
                ((OutputMessageImpl)this.outputMsg).setResponseMessage(this.outputMsgBytes);
                this.processOutputMessage();
            }
        } else if (this.interactionTypeDescription.equals("RECEIVE")) {
            this.outputMsgBytes = this.myConnection.receive();
            ((OutputMessageImpl)this.outputMsg).setResponseMessage(this.outputMsgBytes);
            this.processOutputMessage();
        }
        if (this.myConnection.getSocketType() == 0 && !this.inConversation && !this.ackNakNeeded || this.getInteractionTypeDescription() == "CANCELTIMER") {
            this.myConnection.disconnect();
        }
        if (this.imsConnectReturnCode == 0 || this.commitMode == 32 && this.imsConnectReturnCode == 4 && this.imsConnectReasonCode == 97 || (this.imsConnectReturnCode == 32 || this.imsConnectReturnCode == 36 || this.imsConnectReturnCode == 40) && (this.getInteractionTypeDescription() == "ACK" || this.getInteractionTypeDescription() == "NAK" || this.recvAfterResumeTpipe)) {
            if (this.ackNakNeeded && this.ackNakProvider == 0) {
                this.mySavedResponseValues = new SavedResponseValues(this);
                this.sendInternalAck();
                this.restoreResponseValuesAfterInternalAck(this.mySavedResponseValues);
                if (this.myConnection.getSocketType() == 0 && !this.inConversation) {
                    this.myConnection.disconnect();
                }
            }
        } else {
            if (this.imsConnectReturnCode == 8 && this.imsConnectReasonCode == 40) {
                StringBuffer racfRetCodeBuf = new StringBuffer("RACF_RETCODE_");
                racfRetCodeBuf.append(this.racfReturnCode);
                String key = racfRetCodeBuf.toString();
                try {
                    this.setRacfReturnCodeString(ImsConnectErrorMessage.getString((String)ImsConnectErrorMessage.class.getField(key).get(null), new Object[0]));
                    ((OutputMessageImpl)this.outputMsg).setRacfReturnCodeString(this.getRacfReturnCodeString());
                }
                catch (Exception e) {
                    if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                        this.logger.severe("    Exception caught in TmInteraction.execute(byte[]) - unknown RACF return code. Exception caught was: " + e.toString());
                    }
                    this.racfReturnCodeString = "";
                    ((OutputMessageImpl)this.outputMsg).setRacfReturnCodeString("");
                }
                this.myConnection.disconnect();
                String errMsg = ImsConnectErrorMessage.getString("HWS0043E", new Object[]{new Integer(this.imsConnectReturnCode), new Integer(this.imsConnectReasonCode), new Integer(this.racfReturnCode), this.racfReturnCodeString});
                ImsConnectExecutionException e1 = new ImsConnectExecutionException("HWS0043E", errMsg, this.imsConnectReturnCode, this.imsConnectReasonCode, this.racfReturnCode, this.racfReturnCodeString);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.execute(byte[]). Exception thrown was: \n" + e1.toString());
                }
                throw e1;
            }
            if (this.imsConnectReturnCode == 8 && this.imsConnectReasonCode == 59 && this.getInteractionTypeDescription() == "CANCELTIMER") {
                this.myConnection.disconnect();
            } else {
                if (this.imsConnectReturnCode == 12) {
                    String errMsg = ImsConnectErrorMessage.getString("HWS0004E", new Object[]{new Integer(this.imsConnectReturnCode), new Integer(this.otmaSenseCode)});
                    ImsOtmaExecutionException e2 = new ImsOtmaExecutionException("HWS0004E", errMsg);
                    if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                        this.logger.severe("    Exception caught in TmInteraction.execute(byte[]). Exception caught was: " + e2.toString());
                    }
                    this.myConnection.disconnect();
                    throw e2;
                }
                if (this.imsConnectReturnCode == 16) {
                    ImsOtmaExecutionException e3;
                    if (this.otmaSenseCode != 26) {
                        String errMsg = ImsConnectErrorMessage.getString("HWS0004E", new Object[]{new Integer(this.imsConnectReturnCode), new Integer(this.otmaSenseCode)});
                        e3 = new ImsOtmaExecutionException("HWS0004E", errMsg);
                    } else {
                        StringBuffer rsBuf = new StringBuffer("OTMA_RESCODE_");
                        rsBuf.append(this.otmaReasonCode);
                        String key = rsBuf.toString();
                        String rsValue = "";
                        try {
                            rsValue = ImsConnectErrorMessage.getString((String)ImsConnectErrorMessage.class.getField(key).get(null));
                        }
                        catch (Exception e3a) {
                            rsValue = "";
                        }
                        String errMsg = ImsConnectErrorMessage.getString("HWS0005E", new Object[]{new Integer(this.imsConnectReturnCode), new Integer(this.otmaSenseCode), new Integer(this.otmaReasonCode), rsValue});
                        e3 = new ImsOtmaExecutionException("HWS0005E", errMsg);
                    }
                    if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                        this.logger.severe("    Exception caught in TmInteraction.execute(byte[]). Exception caught was: " + e3.toString());
                    }
                    this.myConnection.disconnect();
                    throw e3;
                }
                if ((this.imsConnectReturnCode == 32 || this.imsConnectReturnCode == 40) && this.imsConnectReasonCode != 0) {
                    int convertedImsConnectReasonCode = this.imsConnectReasonCode;
                    String convertedImsConnectReasonCodeString = "";
                    if (this.imsConnectReasonCode > 0 && this.imsConnectReasonCode <= 25) {
                        convertedImsConnectReasonCode = this.imsConnectReasonCode * 10;
                        convertedImsConnectReasonCodeString = String.valueOf(Integer.toString(convertedImsConnectReasonCode)) + " milliseconds";
                    } else if (this.imsConnectReasonCode > 25 && this.imsConnectReasonCode <= 39) {
                        convertedImsConnectReasonCode = (this.imsConnectReasonCode - 25) * 50 + 250;
                        convertedImsConnectReasonCodeString = String.valueOf(Integer.toString(convertedImsConnectReasonCode)) + " milliseconds";
                    } else if (this.imsConnectReasonCode > 39 && this.imsConnectReasonCode <= 99) {
                        convertedImsConnectReasonCode = (this.imsConnectReasonCode - 40) * 1000 + 1000;
                        convertedImsConnectReasonCodeString = String.valueOf(Integer.toString(convertedImsConnectReasonCode / 1000)) + " seconds";
                    } else if (this.imsConnectReasonCode > 99 && this.imsConnectReasonCode <= 158) {
                        convertedImsConnectReasonCode = (this.imsConnectReasonCode - 99) * 60000 + 60000;
                        convertedImsConnectReasonCodeString = String.valueOf(Integer.toString(convertedImsConnectReasonCode / 60000)) + " minutes";
                    }
                    String errMsg = ImsConnectErrorMessage.getString("HWS0011E", new Object[]{new Integer(this.imsConnectReturnCode), new Integer(this.imsConnectReasonCode), convertedImsConnectReasonCodeString});
                    ImsConnectExecutionException e4 = new ImsConnectExecutionException("HWS0011E", errMsg);
                    e4.setReturnCode(this.imsConnectReturnCode);
                    e4.setReasonCode(this.imsConnectReasonCode);
                    if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                        this.logger.severe("    Exception thrown in TmInteraction.execute(byte[]). Exception thrown was: " + e4.toString());
                    }
                    throw e4;
                }
                if (this.imsConnectReturnCode == 36 || (this.imsConnectReturnCode == 32 || this.imsConnectReturnCode == 40) && this.imsConnectReasonCode == 0) {
                    String errMsg = ImsConnectErrorMessage.getString("HWS0012E", new Object[]{new Integer(this.imsConnectReturnCode)});
                    ImsConnectExecutionException e5 = new ImsConnectExecutionException("HWS0012E", errMsg);
                    e5.setReturnCode(this.imsConnectReturnCode);
                    e5.setReasonCode(0);
                    if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                        this.logger.severe("    Exception thrown in TmInteraction.execute(byte[]). Exception thrown was: " + e5.toString());
                    }
                    throw e5;
                }
                StringBuffer rsBuf = new StringBuffer("HWS_RESCODE_");
                rsBuf.append(this.imsConnectReasonCode);
                String key = rsBuf.toString();
                String rsValue = null;
                try {
                    rsValue = this.imsConnectReasonCode == 14 ? ImsConnectErrorMessage.getString((String)ImsConnectErrorMessage.class.getField(key).get(null), new Object[]{this.xmlAdapterName}) : (this.imsConnectReasonCode == 40 ? ImsConnectErrorMessage.getString((String)ImsConnectErrorMessage.class.getField(key).get(null), new Object[]{this.racfUserId, this.racfGroupName}) : (this.imsConnectReasonCode == 56 ? ImsConnectErrorMessage.getString((String)ImsConnectErrorMessage.class.getField(key).get(null), new Object[]{this.myConnection.getClientId()}) : (this.imsConnectReasonCode == 72 || this.imsConnectReasonCode == 74 ? ImsConnectErrorMessage.getString((String)ImsConnectErrorMessage.class.getField(key).get(null), new Object[]{this.imsDatastoreName}) : ImsConnectErrorMessage.getString((String)ImsConnectErrorMessage.class.getField(key).get(null)))));
                }
                catch (Exception e6) {
                    if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                        this.logger.severe("    Exception caught in TmInteraction.execute(byte[]) - unknown IMS Connect reason code. Exception caught was: " + e6.toString());
                    }
                    rsValue = "";
                }
                String errMsg = ImsConnectErrorMessage.getString("HWS0003E", new Object[]{new Integer(this.imsConnectReturnCode), new Integer(this.imsConnectReasonCode), rsValue});
                ImsConnectExecutionException e6a = new ImsConnectExecutionException("HWS0003E", errMsg);
                e6a.setReturnCode(this.imsConnectReturnCode);
                e6a.setReasonCode(this.imsConnectReasonCode);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.execute(byte[]). Exception thrown was: " + e6a.toString());
                }
                this.myConnection.disconnect();
                throw e6a;
            }
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- TmInteraction.execute()");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendInternalAck() throws Exception {
        block14: {
            block13: {
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
                    this.logger.finer("--> TmInteractionImpl.sendInternalAck()");
                }
                byte[] internalAckInputMsgBytes = null;
                byte[] internalAckResponseMsg = null;
                if (this.internalAckInputMessage == null || this.copyInputMessageForInternalAck) {
                    this.internalAckInputMessage = null;
                    this.internalAckInputMessage = new InputMessageImpl(this);
                    this.internalAckInputMessage.copyInputMessage((InputMessageImpl)this.inputMsg);
                    this.internalAckInputMessage.setData(this.anEmptyByteArray);
                    this.internalAckInputMessage.setTrancodeInData("");
                }
                this.setInteractionTypeDescription("ACK");
                if (this.cM0AckNoWaitCanBeUsed) {
                    this.setImsConnectTimeout(-23);
                } else {
                    this.setImsConnectTimeout(10);
                }
                boolean aSuppressLogging = false;
                internalAckInputMsgBytes = this.internalAckInputMessage.buildInputMessageByteArray(aSuppressLogging);
                this.myConnection.send(internalAckInputMsgBytes);
                if (this.inConversation || this.cM0AckNoWaitCanBeUsed) break block13;
                internalAckResponseMsg = this.myConnection.receive();
                if (this.useCM0AckNoWait && !this.cM0AckNoWaitCanBeUsed && this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                    this.logger.finest("   The useCm0AckNoWait value of true was ignored because CM0 ACK nowait is not supported in the target IMS Connect.  The API will send in the ACK message using the configured imsConnectTimeout value and wait that length of time for the timeout response to be returned by IMS Connect.");
                }
                ((OutputMessageImpl)this.outputMsg).setResponseMessage(internalAckResponseMsg);
                this.outputMsgBytes = internalAckResponseMsg;
                this.processOutputMessage();
                if (this.commitMode == 32 && this.imsConnectReturnCode == 4 && this.imsConnectReasonCode == 97 || this.imsConnectReturnCode == 32 || this.imsConnectReturnCode == 36 || this.imsConnectReturnCode == 40) break block14;
                if (this.imsConnectReturnCode == 0) {
                    this.sendInternalNak();
                    break block14;
                } else {
                    StringBuffer rsBuf = new StringBuffer("HWS_RESCODE_");
                    rsBuf.append(this.imsConnectReasonCode);
                    String key = rsBuf.toString();
                    String rsValue = null;
                    try {
                        rsValue = this.imsConnectReasonCode == 14 ? ImsConnectErrorMessage.getString((String)ImsConnectErrorMessage.class.getField(key).get(null), new Object[]{this.xmlAdapterName}) : (this.imsConnectReasonCode == 40 ? ImsConnectErrorMessage.getString((String)ImsConnectErrorMessage.class.getField(key).get(null), new Object[]{this.racfUserId, this.racfGroupName}) : (this.imsConnectReasonCode == 72 || this.imsConnectReasonCode == 74 ? ImsConnectErrorMessage.getString((String)ImsConnectErrorMessage.class.getField(key).get(null), new Object[]{this.imsDatastoreName}) : ImsConnectErrorMessage.getString((String)ImsConnectErrorMessage.class.getField(key).get(null))));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String errMsg = ImsConnectErrorMessage.getString("HWS0003E", new Object[]{new Integer(this.imsConnectReturnCode), new Integer(this.imsConnectReasonCode), rsValue});
                    ImsConnectExecutionException e = new ImsConnectExecutionException("HWS0003E", errMsg);
                    e.setReturnCode(this.imsConnectReturnCode);
                    e.setReasonCode(this.imsConnectReasonCode);
                    if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                        this.logger.severe("    Exception thrown in TmInteraction.sendInternalAck(). Exception thrown was: " + e.toString());
                    }
                    this.myConnection.disconnect();
                    throw e;
                }
            }
            if (this.cM0AckNoWaitCanBeUsed && this.isUseCM0AckNoWait() && this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                this.logger.finest("   Receive call skipped because CM0 ACK no wait was used\n");
            }
            if (this.isInConversation() && this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                this.logger.finest("   Receive call skipped because current interaction was within the scope of an IMS Conversation\n");
            }
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- TmInteractionImpl.sendInternalAck()");
        }
    }

    public byte[] sendInternalNak() throws Exception {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> TmInteractionImpl.sendInternalNak()");
        }
        byte[] internalNakInputMsgBytes = null;
        byte[] internalNakResponseMsg = null;
        this.setInteractionTypeDescription("NAK");
        InputMessageImpl internalNakInputMessage = new InputMessageImpl(this);
        internalNakInputMessage.copyInputMessage((InputMessageImpl)this.inputMsg);
        internalNakInputMessage.setData(this.anEmptyByteArray);
        boolean aSuppressLogging = true;
        internalNakInputMsgBytes = internalNakInputMessage.buildInputMessageByteArray(aSuppressLogging);
        this.setImsConnectTimeout(0);
        this.setUseCM0AckNoWait(false);
        this.myConnection.send(internalNakInputMsgBytes);
        internalNakResponseMsg = this.myConnection.receive();
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL) && internalNakResponseMsg != null) {
            boolean obfuscatePassword = false;
            String bufferReceived = this.formatBufferForTracing(internalNakResponseMsg, obfuscatePassword);
            this.logger.finest("   TmInteraction.sendInternalNak() - Buffer received:");
            this.logger.finest(bufferReceived);
        }
        ((OutputMessageImpl)this.outputMsg).setResponseMessage(internalNakResponseMsg);
        this.processOutputMessage();
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- TmInteractionImpl.sendInternalNak()");
        }
        if (this.getCommitMode() == 64) {
            return null;
        }
        return internalNakResponseMsg;
    }

    public void restoreResponseValuesAfterInternalAck(SavedResponseValues aMySavedResponseValues) throws ImsConnectApiException, UnsupportedEncodingException {
        this.setInteractionTypeDescription(aMySavedResponseValues.getTmpIntTypeDesc());
        this.setImsConnectTimeout(aMySavedResponseValues.getTmpImsConnectTimeout());
        ((InputMessageImpl)this.inputMsg).copyInputMessage(aMySavedResponseValues.getTmpInputMsg());
        ((OutputMessageImpl)this.outputMsg).copyOutputMessage(aMySavedResponseValues.getTmpOutputMsg());
        this.outputMsgBytes = aMySavedResponseValues.tmpOutputMsgBytes;
        this.setImsConnectReturnCode(aMySavedResponseValues.getTmpImsConnectReturnCode());
        this.setImsConnectReasonCode(aMySavedResponseValues.getTmpImsConnectReasonCode());
        this.setOtmaSenseCode(aMySavedResponseValues.getTmpOtmaSenseCode());
        this.ackNakNeeded = false;
        this.setInConversation(aMySavedResponseValues.isTmpInConversation());
        this.setAsyncOutputAvailable(aMySavedResponseValues.isTmpAsyncOutputAvailable());
        this.setProtocolLevel(aMySavedResponseValues.getTmpProtocolLevel());
        this.setUseCM0AckNoWait(aMySavedResponseValues.isTmpUseCM0AckNoWait());
        this.setResponsePropertiesUpdatedAfterResponse(aMySavedResponseValues.isTmpResponsePropertiesSetAfterResponse());
    }

    @Override
    public void loadTmInteractionAttributesFromFile(String anInteractionAttributesFileName) throws Exception {
        PropertiesFileLoader myPropertiesFileLoader = new PropertiesFileLoader();
        myPropertiesFileLoader.loadPropertiesFile(this, anInteractionAttributesFileName);
    }

    public void processCsmFlag() {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> TmInteractionImpl.processCsmFlg()");
        }
        try {
            if (this.outputMsg != null) {
                this.csmFlag1 = ((OutputMessageImpl)this.outputMsg).getCsmFlag1();
                this.csmFlag2 = ((OutputMessageImpl)this.outputMsg).getCsmFlag2();
                this.setProtocolLevelAvailable((this.csmFlag1 & 0x10) == 16);
                ((OutputMessageImpl)this.outputMsg).setProtocolLevelAvailable(this.isProtocolLevelAvailable());
                if (this.isProtocolLevelAvailable()) {
                    this.setProtocolLevel((byte)(this.csmFlag2 & 3));
                    ((OutputMessageImpl)this.outputMsg).setProtocolLevel(this.getProtocolLevel());
                    if (this.getCommitMode() == 64) {
                        this.setCM0AckNoWaitCanBeUsed(this.isUseCM0AckNoWait());
                    }
                } else {
                    this.setProtocolLevel((byte)0);
                    ((OutputMessageImpl)this.outputMsg).setProtocolLevel((byte)0);
                    this.setCM0AckNoWaitCanBeUsed(false);
                }
                this.setAckNakNeeded((this.csmFlag1 & 0x20) == 32);
                ((OutputMessageImpl)this.outputMsg).setAckNakNeeded(this.isAckNakNeeded());
                this.setInConversation((this.csmFlag1 & 0x40) == 64);
                ((InputMessageImpl)this.inputMsg).setInConversation(this.testInConversation());
                ((OutputMessageImpl)this.outputMsg).setInConversation(this.testInConversation());
                this.setAsyncOutputAvailable((this.csmFlag1 & 0xFFFFFF80) == -128);
                ((OutputMessageImpl)this.outputMsg).setAsyncOutputAvailable(this.isAsyncOutputAvailable());
                this.setResponsePropertiesUpdatedAfterResponse(true);
                ((OutputMessageImpl)this.outputMsg).setResponsePropertiesUpdatedAfterResponse(true);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                    this.logger.finest("    protocolLevelAvailable = [" + this.protocolLevelAvailable + "]");
                    this.logger.finest("              ackNakNeeded = [" + this.ackNakNeeded + "]");
                    this.logger.finest("            inConversation = [" + this.inConversation + "]");
                    this.logger.finest("      asyncOutputAvailable = [" + this.asyncOutputAvailable + "]");
                    this.logger.finest("             protocolLevel = [" + this.protocolLevel + "]");
                }
            }
        }
        finally {
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
                this.logger.finer("<-- TmInteractionImpl.processCsmFlg()");
            }
        }
    }

    public void processOutputMessage() throws Exception {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> TmInteractionImpl.processOutputMessage()");
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            boolean obfuscatePassword = false;
            this.formatAndPrintReceiveBuffer(obfuscatePassword);
        }
        if (this.imsConnectUserMessageExitIdentifier == "*SAMPLE*") {
            this.setResponseIncludesLlll(false);
        } else if (this.imsConnectUserMessageExitIdentifier == "*SAMPL1*" || this.imsConnectUserMessageExitIdentifier == "*HWSDP1*" || this.imsConnectUserMessageExitIdentifier == "*HWSCS1*" || this.imsConnectUserMessageExitIdentifier == "*HWSCSL*") {
            this.setResponseIncludesLlll(true);
        }
        try {
            try {
                ((OutputMessageImpl)this.outputMsg).setMyImsConnectCodepage(this.getImsConnectCodepage());
                ((OutputMessageImpl)this.outputMsg).setIncludeLlzzInSegments(this.inputMessageDataSegmentsIncludeLlzzAndTrancode);
                ((OutputMessageImpl)this.outputMsg).parse(this.responseIncludesLlll);
                if (((OutputMessageImpl)this.outputMsg).getMsgType() == 0 || ((OutputMessageImpl)this.outputMsg).getMsgType() == 2) {
                    this.processCsmFlag();
                }
                this.processRtnRsnSnsCodes();
            }
            catch (Exception e) {
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception caught in TmInteractionImpl.processOutputMessage(). Exception caught was: " + e.toString());
                }
                throw e;
            }
        }
        finally {
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
                this.logger.finer("<-- TmInteractionImpl.processOutputMessage()");
            }
        }
    }

    public void processRtnRsnSnsCodes() {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> TmInteractionImpl.processRtnRsnSnsCodes()");
        }
        try {
            if (this.outputMsg != null) {
                this.setImsConnectReturnCode(this.outputMsg.getImsConnectReturnCode());
                this.setImsConnectReasonCode(this.outputMsg.getImsConnectReasonCode());
                this.setOtmaSenseCode(this.outputMsg.getOtmaSenseCode());
                this.setOtmaReasonCode(this.outputMsg.getOtmaReasonCode());
                this.setRacfReturnCode(this.outputMsg.getRacfReturnCode());
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
                    this.logger.finest("    IMS Connect Return Code = [" + this.getImsConnectReturnCode() + "]");
                    this.logger.finest("    IMS Connect Reason Code = [" + this.getImsConnectReasonCode() + "]");
                    if (this.getImsConnectReturnCode() == 16) {
                        this.logger.finest("        IMS OTMA Sense Code = [" + this.getOtmaSenseCode() + "]");
                        this.logger.finest("       IMS OTMA Reason Code = [" + this.getOtmaReasonCode() + "]");
                    } else if (this.getImsConnectReturnCode() == 8 && this.getImsConnectReasonCode() == 40) {
                        this.logger.finest("           RACF Return Code = [" + this.getRacfReturnCode() + "]");
                    }
                }
            }
        }
        finally {
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
                this.logger.finer("<-- TmInteractionImpl.processRtnRsnSnsCodes()");
            }
        }
    }

    @Override
    public byte getAckNakProvider() {
        return this.ackNakProvider;
    }

    @Override
    public void setAckNakProvider(byte anAckNakProvider) throws ImsConnectApiException {
        this.ackNakProvider = anAckNakProvider;
        if (anAckNakProvider != 0 && anAckNakProvider != 1) {
            String validAckNakProviderString = "";
            try {
                validAckNakProviderString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_ACKNAKPROVIDER");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"ackNakProvider", String.valueOf(anAckNakProvider), validAckNakProviderString});
            ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setAckNakProvider(byte).  Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.ackNakProvider = anAckNakProvider;
    }

    public Connection getMyConnection() {
        return this.myConnection;
    }

    public TmInteractionAttributes getInteractionAttributes() {
        return this.interAttr;
    }

    public boolean getIncludeLlllInOutputMessages() {
        return this.includeLlllInOutputMessages;
    }

    public boolean getIncludeLlzzInOutputMessages() {
        return this.includeLlzzInOutputMessages;
    }

    @Override
    public InputMessage getInputMessage() throws ImsConnectApiException {
        return this.inputMsg;
    }

    @Override
    public OutputMessage getOutputMessage() throws ImsConnectApiException {
        return this.outputMsg;
    }

    public boolean isResponseNeeded() {
        boolean result = false;
        if (this.outputMsg != null) {
            boolean bl = result = (this.csmFlag1 & 0x20) == 32;
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL) && result) {
            this.logger.finest("   TmInteractionImpl.isResponseNeeded()ACK or NACK response requested");
        }
        return result;
    }

    @Override
    public boolean isAckNakNeeded() {
        if (this.isAckNakNeededPropertyUpdated()) {
            return this.ackNakNeeded;
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            this.logger.finest("   isAckNakNeeded returned the default value, false, since no response has been yet from IMS Connect\n");
        }
        return false;
    }

    protected boolean isAckNakNeededPropertyUpdated() {
        return this.ackNakNeededPropertyUpdated;
    }

    private void setAckNakNeeded(boolean ackNakNeeded) {
        this.ackNakNeeded = ackNakNeeded;
        this.setAckNakNeededPropertyUpdated(true);
    }

    protected void setAckNakNeededPropertyUpdated(boolean anAckNakNeededPropertyUpdated) {
        this.ackNakNeededPropertyUpdated = anAckNakNeededPropertyUpdated;
    }

    @Override
    public boolean isAsyncOutputAvailable() {
        if (this.isResponsePropertiesUpdatedAfterResponse()) {
            return this.asyncOutputAvailable;
        }
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            this.logger.finest("   isAsyncOutputAvailable returned the default value, false, since no response has been received yet from IMS Connect\n");
        }
        return false;
    }

    private void setAsyncOutputAvailable(boolean asyncOutputAvailable) {
        this.asyncOutputAvailable = asyncOutputAvailable;
        this.setResponsePropertiesUpdatedAfterResponse(true);
    }

    @Override
    public byte getProtocolLevel() {
        return this.protocolLevel;
    }

    public void setProtocolLevel(byte aProtocolLevel) {
        this.protocolLevel = aProtocolLevel;
    }

    @Override
    public boolean isProtocolLevelAvailable() {
        return this.protocolLevelAvailable;
    }

    public void setProtocolLevelAvailable(boolean protocolLevelAvailable) {
        this.protocolLevelAvailable = protocolLevelAvailable;
    }

    @Override
    public boolean isInConversation() {
        if (this.responsePropertiesUpdatedAfterResponse) {
            return this.inConversation;
        }
        if (this.logger != null && this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            this.logger.finest("   isInConversation returned the default value, false, since no response has been received yet from IMS Connect\n");
        }
        return false;
    }

    protected boolean testInConversation() {
        return this.inConversation;
    }

    private void setInConversation(boolean anInConversation) {
        if (this.inConversation != anInConversation) {
            this.inConversation = anInConversation;
            this.setRebuildMessage(true);
        }
        this.setResponsePropertiesUpdatedAfterResponse(true);
    }

    protected boolean isRebuildMessage() {
        return this.rebuildMessage;
    }

    protected void setRebuildMessage(boolean rebuildMessage) {
        this.rebuildMessage = rebuildMessage;
    }

    @Override
    public boolean isResponseIncludesLlll() {
        return this.responseIncludesLlll;
    }

    @Override
    public void setResponseIncludesLlll(boolean aResponsetIncludesLlll) {
        this.responseIncludesLlll = aResponsetIncludesLlll;
    }

    protected boolean isResponsePropertiesUpdatedAfterResponse() {
        return this.responsePropertiesUpdatedAfterResponse;
    }

    protected void setResponsePropertiesUpdatedAfterResponse(boolean aResponsePropertiesUpdatedAfterResponse) {
        this.responsePropertiesUpdatedAfterResponse = aResponsePropertiesUpdatedAfterResponse;
    }

    @Override
    public int getImsConnectReasonCode() {
        return this.imsConnectReasonCode;
    }

    private void setImsConnectReasonCode(int imsConnectReasonCode) {
        this.imsConnectReasonCode = imsConnectReasonCode;
    }

    @Override
    public int getImsConnectReturnCode() {
        return this.imsConnectReturnCode;
    }

    private void setImsConnectReturnCode(int imsConnectReturnCode) {
        this.imsConnectReturnCode = imsConnectReturnCode;
    }

    @Override
    public String getMfsModname() {
        return this.mfsModname;
    }

    protected void setMfsModname(String mfsModname) {
        this.mfsModname = mfsModname;
    }

    @Override
    public int getOtmaReasonCode() {
        return this.otmaReasonCode;
    }

    private void setOtmaReasonCode(int anOtmaReasonCode) {
        this.otmaReasonCode = anOtmaReasonCode;
    }

    @Override
    public int getOtmaSenseCode() {
        return this.otmaSenseCode;
    }

    private void setOtmaSenseCode(int anOtmaSenseCode) {
        this.otmaSenseCode = anOtmaSenseCode;
    }

    @Override
    public int getRacfReturnCode() {
        return this.racfReturnCode;
    }

    private void setRacfReturnCode(int aRacfReturnCode) {
        this.racfReturnCode = aRacfReturnCode;
    }

    @Override
    public String getRacfReturnCodeString() {
        return this.racfReturnCodeString;
    }

    public void setRacfReturnCodeString(String racfRetCodeString) {
        this.racfReturnCodeString = racfRetCodeString;
    }

    protected void setNumberOfSegments() {
        int msgLen = this.outputMsgBytes.length;
        this.cursor = this.isResponseIncludesLlll() ? 4 : 0;
        int i = 0;
        while (this.cursor < msgLen) {
            int low = this.outputMsgBytes[this.cursor + 1] & 0xFF;
            int high = this.outputMsgBytes[this.cursor] & 0xFF;
            this.cursor += high << 8 | low;
            ++i;
        }
        this.numberOfSegments = i;
    }

    protected int getNumberOfSegmentsFromOutput() {
        return this.numberOfSegments;
    }

    public boolean isUse2DimensionalByteArray() {
        return this.use2DimensionalByteArray;
    }

    public void setConnection(ConnectionImpl conn) {
        this.myConnection = conn;
    }

    public void setInputMsg(InputMessageImpl inputMsg) {
        if (this.inputMsg != inputMsg) {
            this.inputMsg = inputMsg;
            this.setRebuildMessage(true);
        }
    }

    protected byte getArchitectureLevel() {
        return this.architectureLevel;
    }

    private void setArchitectureLevel(byte anArchLevel) throws ImsConnectApiException {
        if (anArchLevel < 0 || anArchLevel > 3) {
            String validArchLevelString = "";
            try {
                validArchLevelString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_ARCHLEVEL");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"architectureLevel" + ARCH_LEVEL_NAME[anArchLevel], Byte.toString(anArchLevel), validArchLevelString});
            ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in TmInteraction.setArchitectureLevel(byte). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        if (this.architectureLevel != anArchLevel) {
            this.architectureLevel = anArchLevel;
            this.setRebuildMessage(true);
        }
    }

    protected int getClientType() {
        return this.clientType;
    }

    private void setClientType(int aClientType) {
        this.clientType = aClientType;
    }

    @Override
    public boolean isCm0IgnorePurge() {
        return this.cm0IgnorePurge;
    }

    @Override
    public void setCm0IgnorePurge(boolean aCm0IgnorePurge) {
        if (this.cm0IgnorePurge != aCm0IgnorePurge) {
            this.cm0IgnorePurge = aCm0IgnorePurge;
            this.setRebuildMessage(true);
        }
    }

    @Override
    public void setCancelClientId(boolean aCancelClientId) {
        if (this.cancelClientId != aCancelClientId) {
            this.cancelClientId = aCancelClientId;
            this.setRebuildMessage(true);
        }
    }

    @Override
    public boolean isCancelClientId() {
        return this.cancelClientId;
    }

    @Override
    public void setReturnClientId(boolean aReturnClientIdValue) {
        if (this.returnClientId != aReturnClientIdValue) {
            this.returnClientId = aReturnClientIdValue;
            this.setRebuildMessage(true);
        }
        if (this.returnClientId) {
            this.myConnection.returnedClientID = true;
        }
    }

    @Override
    public boolean isReturnClientId() {
        return this.returnClientId;
    }

    @Override
    public void setGenerateClientIdWhenDuplicate(boolean aGenerateClientIdValue) {
        if (this.generateClientIdWhenDuplicate != aGenerateClientIdValue) {
            this.generateClientIdWhenDuplicate = aGenerateClientIdValue;
            this.setRebuildMessage(true);
        }
    }

    @Override
    public boolean isGenerateClientIdWhenDuplicate() {
        return this.generateClientIdWhenDuplicate;
    }

    @Override
    public byte getCommitMode() {
        return this.commitMode;
    }

    @Override
    public void setCommitMode(byte aCommitMode) throws ImsConnectApiException {
        if (aCommitMode == 64 || aCommitMode == 32) {
            if (this.commitMode != aCommitMode) {
                this.commitMode = aCommitMode;
                this.setRebuildMessage(true);
            }
        } else {
            String validCommitModeString = "";
            try {
                validCommitModeString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_COMMITMODE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"commitMode", String.valueOf(aCommitMode), validCommitModeString});
            ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setSocketType(byte).  Exception thrown was: " + e.toString());
            }
            throw e;
        }
    }

    @Override
    public String getImsConnectCodepage() {
        return this.imsConnectCodepage;
    }

    @Override
    public void setImsConnectCodepage(String aCodepage) {
        if (this.imsConnectCodepage != aCodepage) {
            this.imsConnectCodepage = aCodepage;
            ((InputMessageImpl)this.inputMsg).setImsConnectCodepage(aCodepage);
            this.rebuildMessage = true;
            this.updateIrmDestId = true;
            this.updateIrmId = true;
            this.updateIrmLTerm = true;
            this.updateIrmRacfApplName = true;
            this.updateIrmRacfGroupName = true;
            this.updateIrmRacfPassword = true;
            this.updateIrmRacfUserId = true;
            this.updateIrmRerouteName = true;
            this.updateIrmTagAdapter = true;
            this.updateIrmTagMap = true;
            this.updateIrmTrancode = true;
            this.updateIrmTrancodeInData = true;
            this.updateIrmInputModName = true;
            this.updateIrmInteractionType = true;
            this.copyInputMessageForInternalAck = true;
        }
    }

    public byte getImsConnectUnicodeEncodingSchema() {
        return this.imsConnectUnicodeEncodingSchema;
    }

    public byte getImsConnectUnicodeUsage() {
        return this.imsConnectUnicodeUsage;
    }

    public void setImsConnectUnicodeUsage(byte anImsConnectUnicodeUsage) throws ImsConnectApiException {
        if ((anImsConnectUnicodeUsage & 0x20) != 32 && (anImsConnectUnicodeUsage & 0x10) != 16) {
            String validImsConnectUnicodeUsageString = "";
            try {
                validImsConnectUnicodeUsageString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_IMSCONNECTUNICODEUSAGE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"imsConnectUnicodeUsage", String.valueOf(anImsConnectUnicodeUsage), validImsConnectUnicodeUsageString});
            ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setImsConnectUnicodeUsage(byte).  Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.imsConnectUnicodeUsage = anImsConnectUnicodeUsage;
    }

    @Override
    public int getImsConnectTimeout() {
        return this.imsConnectTimeout;
    }

    @Override
    public void setImsConnectTimeout(int anImsConnectTimeout) throws ImsConnectApiException {
        boolean isValid = true;
        if (this.imsConnectTimeout != anImsConnectTimeout) {
            if (anImsConnectTimeout < 0) {
                if (anImsConnectTimeout == -1) {
                    this.imsConnectConvertedTimeout = -1;
                    this.imsConnectTimeoutIndex = -1;
                } else if (anImsConnectTimeout == -23) {
                    this.imsConnectConvertedTimeout = -23;
                    this.imsConnectTimeoutIndex = -23;
                } else {
                    this.imsConnectConvertedTimeout = 0;
                    this.imsConnectTimeoutIndex = 0;
                    isValid = false;
                }
            } else if (anImsConnectTimeout == 0) {
                this.imsConnectConvertedTimeout = 0;
                this.imsConnectTimeoutIndex = 0;
            } else if (anImsConnectTimeout <= 10) {
                this.imsConnectConvertedTimeout = 10;
                this.imsConnectTimeoutIndex = 1;
            } else if (anImsConnectTimeout <= 250) {
                this.imsConnectConvertedTimeout = (int)Math.round((double)anImsConnectTimeout / 10.0) * 10;
                this.imsConnectTimeoutIndex = this.imsConnectConvertedTimeout / 10;
            } else if (anImsConnectTimeout <= 1000) {
                this.imsConnectConvertedTimeout = (int)Math.round((double)anImsConnectTimeout / 50.0) * 50;
                this.imsConnectTimeoutIndex = (this.imsConnectConvertedTimeout - 250) / 50 + 25;
            } else if (anImsConnectTimeout <= 60000) {
                this.imsConnectConvertedTimeout = (int)Math.round((double)anImsConnectTimeout / 1000.0) * 1000;
                this.imsConnectTimeoutIndex = (this.imsConnectConvertedTimeout - 1000) / 1000 + 40;
            } else if (anImsConnectTimeout <= 3600000) {
                this.imsConnectConvertedTimeout = (int)Math.round((double)anImsConnectTimeout / 60000.0) * 60000;
                this.imsConnectTimeoutIndex = (this.imsConnectConvertedTimeout - 60000) / 60000 + 99;
            } else {
                anImsConnectTimeout = 0;
                this.imsConnectConvertedTimeout = 0;
                this.imsConnectTimeoutIndex = 0;
                isValid = false;
            }
            if (!isValid) {
                String validImsConnectTimeoutString = "";
                try {
                    validImsConnectTimeoutString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_IMSCONNECTTIMEOUT");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"imsConnectTimeout", new Integer(anImsConnectTimeout), validImsConnectTimeoutString});
                ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setImsConnectTimeout(int). Exception thrown is: " + e.toString());
                }
                throw e;
            }
            this.imsConnectTimeout = anImsConnectTimeout;
            this.setRebuildMessage(true);
        }
    }

    public int getImsConnectConvertedTimeout() {
        return this.imsConnectConvertedTimeout;
    }

    public int getImsConnectTimeoutIndex() {
        return this.imsConnectTimeoutIndex;
    }

    @Override
    public String getImsConnectUserMessageExitIdentifier() {
        return this.imsConnectUserMessageExitIdentifier;
    }

    @Override
    public void setImsConnectUserMessageExitIdentifier(String anImsConnectUserMessageExitIdentifier) throws ImsConnectApiException {
        if (anImsConnectUserMessageExitIdentifier.length() > 8) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0026E", new Object[]{anImsConnectUserMessageExitIdentifier, String.valueOf(8)});
            ImsConnectApiException e = new ImsConnectApiException("HWS0026E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in TmInteraction.setImsConnectUserMessageExitIdentifier(String). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        if (anImsConnectUserMessageExitIdentifier.trim().equals("")) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"imsConnectUserMessageExitIdentifier", anImsConnectUserMessageExitIdentifier});
            ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in TmInteraction.setImsConnectUserMessageExitIdentifier(String). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        if (this.imsConnectUserMessageExitIdentifier != anImsConnectUserMessageExitIdentifier) {
            this.imsConnectUserMessageExitIdentifier = anImsConnectUserMessageExitIdentifier;
            this.setRebuildMessage(true);
            this.updateIrmId = true;
        }
        if (this.imsConnectUserMessageExitIdentifier == "*SAMPL1*" || this.imsConnectUserMessageExitIdentifier == "*HWSDP1*") {
            this.responseIncludesLlll = true;
        } else if (this.imsConnectUserMessageExitIdentifier == "*SAMPLE*") {
            this.responseIncludesLlll = false;
        }
    }

    @Override
    public String getImsDatastoreName() {
        return this.imsDatastoreName;
    }

    @Override
    public void setImsDatastoreName(String anImsDatastoreName) throws ImsConnectApiException {
        if (anImsDatastoreName.trim().equals("") || anImsDatastoreName == null) {
            anImsDatastoreName = "        ";
        } else {
            if (anImsDatastoreName.length() > 8) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0026E", new Object[]{anImsDatastoreName, "imsDatastoreName", String.valueOf(8)});
                ImsConnectApiException e = new ImsConnectApiException("HWS0026E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setImsDatastoreName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
            if (!PropertiesFileLoader.isValidHostStyleName(anImsDatastoreName)) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"imsDatastoreName", anImsDatastoreName});
                ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setImsDatastoreName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
        }
        if (this.imsDatastoreName != anImsDatastoreName) {
            this.imsDatastoreName = anImsDatastoreName;
            this.setRebuildMessage(true);
            this.updateIrmDestId = true;
        }
    }

    @Override
    public boolean isInputMessageDataSegmentsIncludeLlzzAndTrancode() {
        return this.inputMessageDataSegmentsIncludeLlzzAndTrancode;
    }

    @Override
    public void setInputMessageDataSegmentsIncludeLlzzAndTrancode(boolean anInputMessageDataSegmentsIncludeLlzzAndTrancode) {
        if (this.inputMessageDataSegmentsIncludeLlzzAndTrancode != anInputMessageDataSegmentsIncludeLlzzAndTrancode) {
            this.inputMessageDataSegmentsIncludeLlzzAndTrancode = anInputMessageDataSegmentsIncludeLlzzAndTrancode;
            this.inputMsg.setInputMessageDataSegmentsIncludeLlzzAndTrancode(anInputMessageDataSegmentsIncludeLlzzAndTrancode);
            this.rebuildMessage = true;
        }
    }

    @Override
    public int getInputMessageOptions() {
        return this.inputMessageOptions;
    }

    @Override
    public void setInputMessageOptions(int anInputMessageOptions) throws ImsConnectApiException {
        if (false && (anInputMessageOptions & 0x40) != 64 || (anInputMessageOptions & 0xFFFFFFBF) != 0) {
            String validInputMessageOptionsString = "";
            try {
                validInputMessageOptionsString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_INPUTMESSAGEOPTIONS");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"inputMessageOptions", String.valueOf(anInputMessageOptions), validInputMessageOptionsString});
            ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setSocketType(byte).  Exception thrown was: " + e.toString());
            }
            throw e;
        }
        this.inputMessageOptions = anInputMessageOptions;
        this.setRebuildMessage(true);
    }

    @Override
    public int getInteractionTimeout() {
        return this.interactionTimeout;
    }

    @Override
    public void setInteractionTimeout(int anInteractionTimeout) throws ImsConnectApiException {
        if (this.interactionTimeout != anInteractionTimeout) {
            if (anInteractionTimeout > 0 || anInteractionTimeout == -1) {
                this.interactionTimeout = anInteractionTimeout;
                this.setRebuildMessage(true);
            } else {
                String errMsg = ImsConnectErrorMessage.getString("HWS0007E", new Object[]{"TmInteractionImpl.setInteractionTimeout(int)", anInteractionTimeout});
                ImsConnectApiException e = new ImsConnectApiException("HWS0007E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setInteractionTimeout(). Exception thrown was: " + e.toString());
                }
                throw e;
            }
        }
    }

    @Override
    public String getInteractionTypeDescription() {
        return this.interactionTypeDescription;
    }

    @Override
    public void setInteractionTypeDescription(String anInterTypeDesc) throws ImsConnectApiException {
        if (this.allValidInteractionTypeDescriptionsString.indexOf(anInterTypeDesc) == -1) {
            String validInteractionTypeDescription = "";
            try {
                validInteractionTypeDescription = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_INTERACTIONTYPEDESCRIPTION");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"interactionTypeDescription", anInterTypeDesc, validInteractionTypeDescription});
            ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in TmInteraction.setInteractionTypeDescription(): [" + e.toString() + "]");
            }
            throw e;
        }
        if (!this.interactionTypeDescription.equalsIgnoreCase(anInterTypeDesc)) {
            this.interactionTypeDescription = anInterTypeDesc;
            this.setRebuildMessage(true);
            this.updateIrmInteractionType = true;
            this.recvAfterResumeTpipe = anInterTypeDesc == "RESUMETPIPE";
        }
    }

    @Override
    public String getLtermOverrideName() {
        return this.ltermOverrideName;
    }

    @Override
    public void setLtermOverrideName(String anLtermOverrideName) throws ImsConnectApiException {
        if (anLtermOverrideName.trim().equals("") || anLtermOverrideName == null) {
            anLtermOverrideName = "        ";
        } else {
            if (anLtermOverrideName.length() > 8) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0026E", new Object[]{anLtermOverrideName, String.valueOf(8)});
                ImsConnectApiException e = new ImsConnectApiException("HWS0026E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setLtermOverrideName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
            if (!PropertiesFileLoader.isValidHostStyleName(anLtermOverrideName)) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"ltermOverrideName", anLtermOverrideName});
                ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setLtermOverrideName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
        }
        if (this.ltermOverrideName != anLtermOverrideName) {
            this.ltermOverrideName = anLtermOverrideName;
            this.setRebuildMessage(true);
            this.updateIrmLTerm = true;
        }
    }

    @Override
    public boolean isOtmaTransactionExpiration() {
        return this.otmaTransactionExpiration;
    }

    @Override
    public void setOtmaTransactionExpiration(boolean otmaTransactionExpiration) {
        this.otmaTransactionExpiration = otmaTransactionExpiration;
        this.setRebuildMessage(true);
    }

    @Override
    public boolean isUseCM0AckNoWait() {
        return this.useCM0AckNoWait;
    }

    @Override
    public void setUseCM0AckNoWait(boolean aUseCM0AckNoWait) {
        this.useCM0AckNoWait = aUseCM0AckNoWait;
        this.setRebuildMessage(true);
    }

    public boolean isCM0AckNoWaitCanBeUsed() {
        return this.cM0AckNoWaitCanBeUsed;
    }

    protected void setCM0AckNoWaitCanBeUsed(boolean aCM0AckNoWaitCanBeUsed) {
        this.cM0AckNoWaitCanBeUsed = aCM0AckNoWaitCanBeUsed;
        this.setRebuildMessage(true);
    }

    @Override
    public boolean isReturnDFS2082AfterCM0SendRecvNoResponse() {
        return this.returnDFS2082AfterCM0SendRecvNoResponse;
    }

    @Override
    public void setReturnDFS2082AfterCM0SendRecvNoResponse(boolean aReturnDFS2082AfterCM0NoResponse) {
        this.returnDFS2082AfterCM0SendRecvNoResponse = aReturnDFS2082AfterCM0NoResponse;
        this.setRebuildMessage(true);
    }

    @Override
    public void setPurgeUndeliverableOutput(boolean aPurgeUndeliverableOutput) throws ImsConnectApiException {
        if (this.rerouteUndeliverableOutput && aPurgeUndeliverableOutput) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0027E", new Object[]{"purgeUndeliverableOutput"});
            ImsConnectApiException e = new ImsConnectApiException("HWS0027E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in TmInteraction.setPurgeUndeliverableOutput(boolean). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        if (this.purgeUndeliverableOutput != aPurgeUndeliverableOutput) {
            this.purgeUndeliverableOutput = aPurgeUndeliverableOutput;
            this.setRebuildMessage(true);
        }
    }

    @Override
    public String getRacfApplName() {
        return this.racfApplName;
    }

    @Override
    public void setRacfApplName(String aRacfApplName) throws ImsConnectApiException {
        if (aRacfApplName.trim().equals("") || aRacfApplName == null) {
            aRacfApplName = "        ";
        } else {
            if (aRacfApplName.length() > 8) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0026E", new Object[]{aRacfApplName, "racfApplName", String.valueOf(8)});
                ImsConnectApiException e = new ImsConnectApiException("HWS0026E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setRacfApplName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
            if (!PropertiesFileLoader.isValidHostStyleName(aRacfApplName)) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"racfApplName", aRacfApplName});
                ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setRacfApplName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
        }
        if (this.racfApplName != aRacfApplName) {
            this.racfApplName = aRacfApplName;
            this.setRebuildMessage(true);
            this.updateIrmRacfApplName = true;
        }
    }

    @Override
    public String getRacfGroupName() {
        return this.racfGroupName;
    }

    @Override
    public void setRacfGroupName(String aRacfGroupName) throws ImsConnectApiException {
        if (aRacfGroupName.trim().equals("") || aRacfGroupName == null) {
            aRacfGroupName = "        ";
        } else {
            if (aRacfGroupName.length() > 8) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0026E", new Object[]{aRacfGroupName, "racfGroupName", String.valueOf(8)});
                ImsConnectApiException e = new ImsConnectApiException("HWS0026E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setRacfGroupName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
            if (!PropertiesFileLoader.isValidHostStyleName(aRacfGroupName)) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"racfGroupName", aRacfGroupName});
                ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setRacfGroupName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
        }
        if (this.racfGroupName != aRacfGroupName) {
            this.racfGroupName = aRacfGroupName;
            this.setRebuildMessage(true);
            this.updateIrmRacfGroupName = true;
        }
    }

    @Override
    public String getRacfPassword() {
        return this.racfPassword;
    }

    @Override
    public void setRacfPassword(String aRacfPassword) throws ImsConnectApiException {
        if (aRacfPassword.trim().equals("") || aRacfPassword == null) {
            aRacfPassword = "        ";
        } else {
            if (aRacfPassword.length() > 8) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0026E", new Object[]{aRacfPassword.replaceAll(".", "*"), "racfPassword", String.valueOf(8)});
                ImsConnectApiException e = new ImsConnectApiException("HWS0026E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setRacfPassword(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
            if (!TmInteractionImpl.isValidRacfPassword(aRacfPassword)) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"racfPassword", aRacfPassword.replaceAll(".", "*")});
                ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setRacfPassword(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
        }
        if (this.racfPassword != aRacfPassword) {
            this.racfPassword = aRacfPassword;
            this.setRebuildMessage(true);
            this.updateIrmRacfPassword = true;
        }
    }

    @Override
    public String getRacfUserId() {
        return this.racfUserId;
    }

    @Override
    public void setRacfUserId(String aRacfUserId) throws ImsConnectApiException {
        if (aRacfUserId.trim().equals("") || aRacfUserId == null) {
            aRacfUserId = "        ";
        } else {
            if (aRacfUserId.length() > 8) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0026E", new Object[]{aRacfUserId, "racfUserId", String.valueOf(8)});
                ImsConnectApiException e = new ImsConnectApiException("HWS0026E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setRacfUserId(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
            if (!PropertiesFileLoader.isValidHostStyleName(aRacfUserId)) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"racfUserId", aRacfUserId});
                ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setRacfUserId(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
        }
        if (this.racfUserId != aRacfUserId) {
            this.racfUserId = aRacfUserId;
            this.setRebuildMessage(true);
            this.updateIrmRacfUserId = true;
        }
    }

    @Override
    public boolean isPurgeUndeliverableOutput() {
        return this.purgeUndeliverableOutput;
    }

    @Override
    public String getRerouteName() {
        return this.rerouteName;
    }

    @Override
    public void setRerouteName(String aRerouteName) throws ImsConnectApiException {
        if (aRerouteName.trim().equals("") || aRerouteName == null) {
            aRerouteName = "        ";
        } else {
            if (aRerouteName.length() > 8) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0026E", new Object[]{aRerouteName, "rerouteName", String.valueOf(8)});
                ImsConnectApiException e = new ImsConnectApiException("HWS0026E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setRerouteName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
            if (!PropertiesFileLoader.isValidHostStyleName(aRerouteName)) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"rerouteName", new String(this.rerouteName)});
                ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setRerouteName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
        }
        if (this.rerouteName != aRerouteName) {
            this.rerouteName = aRerouteName;
            this.setRebuildMessage(true);
            this.updateIrmRerouteName = true;
        }
    }

    @Override
    public boolean isRerouteUndeliverableOutput() {
        return this.rerouteUndeliverableOutput;
    }

    @Override
    public void setRerouteUndeliverableOutput(boolean aRerouteUndeliverableOutput) throws ImsConnectApiException {
        if (this.purgeUndeliverableOutput && aRerouteUndeliverableOutput) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0027E", new Object[]{"rerouteUndeliverableOutput"});
            ImsConnectApiException e = new ImsConnectApiException("HWS0027E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in TmInteraction.setRerouteUndeliverableOutput(boolean). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        if (this.rerouteUndeliverableOutput != aRerouteUndeliverableOutput) {
            this.rerouteUndeliverableOutput = aRerouteUndeliverableOutput;
            this.setRebuildMessage(true);
        }
    }

    @Override
    public String getResumeTpipeAlternateClientId() {
        return this.resumeTpipeAlternateClientId;
    }

    @Override
    public void setResumeTpipeAlternateClientId(String aResumeTpipeAlternateClientId) throws ImsConnectApiException {
        if (aResumeTpipeAlternateClientId.trim().equals("") || aResumeTpipeAlternateClientId == null) {
            if (this.resumeTpipeAlternateClientId != "        ") {
                this.resumeTpipeAlternateClientId = "        ";
                this.setRebuildMessage(true);
            }
            return;
        }
        if (aResumeTpipeAlternateClientId.length() > 8) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0026E", new Object[]{aResumeTpipeAlternateClientId, "resumeTpipeAlternateClientId", String.valueOf(8)});
            ImsConnectApiException e = new ImsConnectApiException("HWS0026E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in TmInteraction.setResumeTpipeAlternateClientId(String). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        if (!PropertiesFileLoader.isValidHostStyleName(aResumeTpipeAlternateClientId.trim())) {
            String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"resumeTpipeAlternateClientId", new String(this.resumeTpipeAlternateClientId)});
            ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in TmInteraction.setResumeTpipeAlternateClientId(String). Exception thrown was: " + e.toString());
            }
            throw e;
        }
        if (this.resumeTpipeAlternateClientId != aResumeTpipeAlternateClientId) {
            this.resumeTpipeAlternateClientId = aResumeTpipeAlternateClientId;
            this.setRebuildMessage(true);
            this.updateIrmRerouteName = true;
        }
    }

    @Override
    public int getResumeTpipeProcessing() {
        return this.resumeTpipeProcessing;
    }

    @Override
    public void setResumeTpipeProcessing(int aResumeTpipeProcessing) throws ImsConnectApiException {
        if ((aResumeTpipeProcessing & 1) == 1 || (aResumeTpipeProcessing & 2) == 2 || (aResumeTpipeProcessing & 4) == 4 || (aResumeTpipeProcessing & 0x10) == 16) {
            if (this.resumeTpipeProcessing != aResumeTpipeProcessing) {
                this.resumeTpipeProcessing = aResumeTpipeProcessing;
                this.setRebuildMessage(true);
            }
        } else {
            String validResumeTpipeProcessingString = "";
            try {
                validResumeTpipeProcessingString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_RESUMETPIPEPROCESSING");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"resumeTpipeProcessing", String.valueOf(aResumeTpipeProcessing), validResumeTpipeProcessingString});
            ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in Connection.setResumeTpipeProcessing(byte).  Exception thrown was: " + e.toString());
            }
            throw e;
        }
    }

    @Override
    public boolean isReturnMfsModname() {
        return this.returnMfsModname;
    }

    @Override
    public void setReturnMfsModname(boolean aReturnMfsModname) {
        if (this.returnMfsModname != aReturnMfsModname) {
            this.returnMfsModname = aReturnMfsModname;
            this.setRebuildMessage(true);
        }
    }

    @Override
    public byte getSyncLevel() {
        return this.syncLevel;
    }

    @Override
    public void setSyncLevel(byte aSyncLevel) throws ImsConnectApiException {
        if ((aSyncLevel & 0) == 0 || aSyncLevel == 1) {
            if (this.syncLevel != aSyncLevel) {
                this.syncLevel = aSyncLevel;
                this.setRebuildMessage(true);
            }
        } else {
            String validSyncLevelString = "";
            try {
                validSyncLevelString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_SYNCLEVEL");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"syncLevel", String.valueOf(aSyncLevel), validSyncLevelString});
            ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in TmInteraction.setSyncLevel(byte). Exception thrown was: " + e.toString());
            }
            throw e;
        }
    }

    @Override
    public String getTrancode() {
        return this.trancode;
    }

    @Override
    public void setTrancode(String aTrancode) throws ImsConnectApiException {
        if (aTrancode == "" || aTrancode == null) {
            if (this.trancode != "") {
                this.trancode = "";
                ((InputMessageImpl)this.inputMsg).setTrancodeInData("");
                this.setRebuildMessage(true);
                this.updateIrmTrancode = true;
                this.updateIrmTrancodeInData = true;
            }
        } else {
            int len = aTrancode.length();
            if (len >= 2 && aTrancode.charAt(0) == '\"' && this.trancode.charAt(len - 1) == '\"') {
                aTrancode = aTrancode.substring(1, len - 1);
            }
            if (aTrancode.trim().length() > 8) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0026E", new Object[]{aTrancode, "trancode", String.valueOf(8)});
                ImsConnectApiException e = new ImsConnectApiException("HWS0026E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setTrancode(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
            int trailingBlankStart = aTrancode.indexOf(32, 1);
            String testTrancode = aTrancode.substring(0, trailingBlankStart == -1 ? 8 : trailingBlankStart);
            if (!PropertiesFileLoader.isValidHostStyleName(testTrancode)) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"trancode", aTrancode});
                ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setTrancode(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
            if (this.trancode != aTrancode) {
                this.trancode = aTrancode;
            }
            ((InputMessageImpl)this.inputMsg).setTrancodeInData(aTrancode);
            this.setRebuildMessage(true);
            this.updateIrmTrancode = true;
            this.updateIrmTrancodeInData = true;
        }
    }

    public String getXmlAdapterName() {
        return this.xmlAdapterName;
    }

    public void setXmlAdapterName(String anXmlAdapterName) throws ImsConnectApiException {
        if (anXmlAdapterName.trim().equals("") || anXmlAdapterName == null) {
            anXmlAdapterName = "        ";
        } else {
            if (anXmlAdapterName.length() > 8) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"xmlAdapterName", anXmlAdapterName});
                ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setXmlAdapterName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
            if (!PropertiesFileLoader.isValidHostStyleName(anXmlAdapterName)) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"xmlAdapterName", new String(anXmlAdapterName)});
                ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setRerouteName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
        }
        if (this.xmlAdapterName != anXmlAdapterName) {
            this.xmlAdapterName = anXmlAdapterName;
            this.setRebuildMessage(true);
        }
    }

    public String getXmlConverterName() {
        return this.xmlConverterName;
    }

    public void setXmlConverterName(String anXmlConverterName) throws ImsConnectApiException {
        if (anXmlConverterName.trim().equals("") || anXmlConverterName == null) {
            anXmlConverterName = "        ";
        } else {
            if (anXmlConverterName.length() > 8) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"xmlAdapterName", anXmlConverterName});
                ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setXmlAdapterName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
            if (!PropertiesFileLoader.isValidHostStyleName(anXmlConverterName)) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"xmlConverterName", new String(anXmlConverterName)});
                ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setRerouteName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
        }
        if (this.xmlConverterName != anXmlConverterName) {
            this.xmlConverterName = anXmlConverterName;
            this.setRebuildMessage(true);
        }
    }

    public byte getXmlMessageType() {
        return this.xmlMessageType;
    }

    public String toString() {
        String str = String.valueOf(this.architectureLevel) + "," + this.ackNakProvider + "," + this.commitMode + "," + this.inputMessageDataSegmentsIncludeLlzzAndTrancode + "," + this.imsDatastoreName + "," + this.imsConnectUserMessageExitIdentifier + "," + this.inputMessageOptions + "," + this.interactionTypeDescription + "," + this.ltermOverrideName + "," + this.resumeTpipeProcessing + "," + this.returnMfsModname + "," + this.syncLevel + "," + this.imsDatastoreName + "," + this.trancode + "," + this.rerouteUndeliverableOutput + "," + this.rerouteName + "," + this.resumeTpipeAlternateClientId + "," + this.racfUserId + "," + this.racfPassword + "," + this.racfGroupName + "," + this.racfApplName + "," + this.interactionTimeout + "," + this.imsConnectTimeout + "," + this.imsConnectConvertedTimeout + "," + this.imsConnectTimeoutIndex + "," + this.otmaTransactionExpiration + "," + this.useCM0AckNoWait + "," + this.cM0AckNoWaitCanBeUsed + "," + this.imsConnectCodepage;
        return str;
    }

    protected String formatBufferForTracing(byte[] buffer, boolean obfuscatePassword) {
        StringBuffer strbuf = new StringBuffer(buffer.length * 4 + buffer.length / 16 * 6);
        strbuf.append("    ");
        String passwordObfuscationChar = "*";
        byte passwordObfuscationByte = 0;
        int rowByteCount = 0;
        int totalByteCount = 0;
        int numberOfBytesInRow = 32;
        int startOfData = 116;
        int positionOfPasswordBegin = 76;
        int positionOfPasswordEnd = 83;
        String str = "";
        try {
            passwordObfuscationByte = passwordObfuscationChar.getBytes(this.imsConnectCodepage)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int i = 0;
        while (i < buffer.length) {
            int lowByte;
            int hiByte;
            if (i >= positionOfPasswordBegin && i <= positionOfPasswordEnd && obfuscatePassword) {
                hiByte = (passwordObfuscationByte & 0xF0) >> 4;
                lowByte = passwordObfuscationByte & 0xF;
            } else {
                hiByte = (buffer[i] & 0xF0) >> 4;
                lowByte = buffer[i] & 0xF;
            }
            strbuf.append(Integer.toString(hiByte, 16));
            strbuf.append(Integer.toString(lowByte, 16));
            ++totalByteCount;
            if (++rowByteCount % 4 == 0) {
                strbuf.append(" ");
            }
            if (rowByteCount % 16 == 0) {
                strbuf.append(" ");
            }
            if (rowByteCount == numberOfBytesInRow) {
                try {
                    int startOfRow = i - numberOfBytesInRow + 1;
                    byte[] rowBytes = new byte[numberOfBytesInRow];
                    System.arraycopy(buffer, i - numberOfBytesInRow + 1, rowBytes, 0, numberOfBytesInRow);
                    if (i < 116) {
                        if (positionOfPasswordBegin >= i - numberOfBytesInRow && positionOfPasswordEnd <= i && obfuscatePassword) {
                            int startOfPasswordInRowBytes = positionOfPasswordBegin - (i - numberOfBytesInRow + 1);
                            byte[] obfuscatedPasswordBytes = new String("********").getBytes(this.imsConnectCodepage);
                            str = String.valueOf(new String(rowBytes, 0, startOfPasswordInRowBytes, this.imsConnectCodepage)) + new String(obfuscatedPasswordBytes, 0, 8, this.imsConnectCodepage) + new String(rowBytes, startOfPasswordInRowBytes + 8, rowByteCount - (startOfPasswordInRowBytes + 8), this.imsConnectCodepage);
                        } else {
                            str = new String(rowBytes, 0, rowByteCount, this.imsConnectCodepage);
                        }
                    } else if (startOfRow >= 116) {
                        str = new String(rowBytes, 0, rowByteCount, this.imsConnectCodepage);
                    } else {
                        int dataInRowLen1 = buffer.length - startOfData;
                        int startOfDataInRowString = startOfData - (i - numberOfBytesInRow);
                        int irmInRowLen = startOfDataInRowString;
                        int dataInRowLen = numberOfBytesInRow - irmInRowLen;
                        if (dataInRowLen1 < dataInRowLen) {
                            dataInRowLen = dataInRowLen1;
                        }
                        byte[] irmRowBytes = new byte[irmInRowLen];
                        byte[] dataRowBytes = new byte[dataInRowLen];
                        System.arraycopy(buffer, i - numberOfBytesInRow + 1, irmRowBytes, 0, irmInRowLen);
                        System.arraycopy(buffer, startOfData + 1, dataRowBytes, 0, dataInRowLen);
                        str = String.valueOf(new String(irmRowBytes, 0, irmInRowLen, this.imsConnectCodepage)) + new String(dataRowBytes, 0, dataInRowLen, this.imsConnectCodepage);
                    }
                    strbuf.append("|");
                    int m = 0;
                    while (m < rowByteCount) {
                        if (TmInteractionImpl.isPrintableChar(str.charAt(m))) {
                            strbuf.append(str.charAt(m));
                        } else {
                            strbuf.append(".");
                        }
                        ++m;
                    }
                    strbuf.append("|");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                strbuf.append(" : ");
                strbuf.append(totalByteCount);
                strbuf.append("\n    ");
                rowByteCount = 0;
            }
            ++i;
        }
        if (rowByteCount != 0) {
            int l = rowByteCount;
            while (l < 32) {
                strbuf.append("  ");
                if ((l + 1) % 4 == 0) {
                    strbuf.append(" ");
                }
                if ((l + 1) % 16 == 0) {
                    strbuf.append(" ");
                }
                ++l;
            }
            try {
                str = new String(buffer, buffer.length - rowByteCount, rowByteCount, this.imsConnectCodepage);
                strbuf.append("|");
                int m = 0;
                while (m < rowByteCount) {
                    if (TmInteractionImpl.isPrintableChar(str.charAt(m))) {
                        strbuf.append(str.charAt(m));
                    } else {
                        strbuf.append(".");
                    }
                    ++m;
                }
                while (m < 32) {
                    strbuf.append(" ");
                    ++m;
                }
                strbuf.append("|");
            }
            catch (Exception exception) {
                // empty catch block
            }
            strbuf.append(" : ");
            strbuf.append(totalByteCount);
        }
        return new String(strbuf);
    }

    protected String[] interpretIrm(byte[] anInputByteArray) throws UnsupportedEncodingException {
        String[] returnStringArray = new String[44];
        String inputByteArrayAsString = new String(anInputByteArray, 0, anInputByteArray.length, this.imsConnectCodepage);
        long llll = (anInputByteArray[0] & 0xFF) << 24 | (anInputByteArray[1] & 0xFF) << 16 | (anInputByteArray[2] & 0xFF) << 8 | anInputByteArray[3] & 0xFF;
        short irm_ll = (short)((anInputByteArray[4] & 0xFF) << 8 | anInputByteArray[5] & 0xFF);
        byte archLvl = anInputByteArray[6];
        byte f0 = anInputByteArray[7];
        String irmId = new String(anInputByteArray, 8, 8, this.imsConnectCodepage);
        short irmNakReasonCode = (short)((anInputByteArray[16] & 0xFF) << 8 | anInputByteArray[17] & 0xFF);
        short resWrd = (short)((anInputByteArray[18] & 0xFF) << 8 | anInputByteArray[19] & 0xFF);
        byte f5 = anInputByteArray[20];
        byte irmTimer = anInputByteArray[21];
        byte sockType = anInputByteArray[22];
        byte encSchema = anInputByteArray[23];
        String clientId = new String(anInputByteArray, 24, 8, this.imsConnectCodepage);
        byte f1 = anInputByteArray[32];
        byte f2 = anInputByteArray[33];
        byte f3 = anInputByteArray[34];
        byte f4 = anInputByteArray[35];
        String irmTrancode = new String(anInputByteArray, 36, 8, this.imsConnectCodepage);
        String datastoreId = new String(anInputByteArray, 44, 8, this.imsConnectCodepage);
        String ltermOvrd = new String(anInputByteArray, 52, 8, this.imsConnectCodepage);
        String racfUserId = new String(anInputByteArray, 60, 8, this.imsConnectCodepage);
        String racfGroup = new String(anInputByteArray, 68, 8, this.imsConnectCodepage);
        String racfPassword = new String("********");
        String racfApplNm = new String(anInputByteArray, 84, 8, this.imsConnectCodepage);
        String rerouteName = new String(anInputByteArray, 92, 8, this.imsConnectCodepage);
        String xmlAdapterNm = new String(anInputByteArray, 100, 8, this.imsConnectCodepage);
        String xmlConvrtrNm = new String(anInputByteArray, 108, 8, this.imsConnectCodepage);
        String irmModNm = new String(anInputByteArray, 116, 8, this.imsConnectCodepage);
        StringBuffer correlatorTokenStringBuffer = new StringBuffer("");
        String correlatorTokenString = "00000000000000000000000000000000000000000000000000000000000000000000000000000000";
        if (f4 == 77 || f4 == -44 || f4 == 76 || f4 == -45) {
            int i = 0;
            while (i <= 40) {
                correlatorTokenStringBuffer.append(TmInteractionImpl.convertByteValueTo2CharacterString(anInputByteArray[124 + i]));
                ++i;
            }
            correlatorTokenString = correlatorTokenStringBuffer.toString();
        }
        returnStringArray[0] = "\n          Message length (llll) = 0x" + TmInteractionImpl.convertByteValueTo2CharacterString((byte)((llll & 0xFFFFFFFFFF000000L) >> 24)).toUpperCase() + TmInteractionImpl.convertByteValueTo2CharacterString((byte)((llll & 0xFF0000L) >> 16)).toUpperCase() + TmInteractionImpl.convertByteValueTo2CharacterString((byte)((llll & 0xFF00L) >> 8)).toUpperCase() + TmInteractionImpl.convertByteValueTo2CharacterString((byte)(llll & 0xFFL)).toUpperCase() + " (decimal " + String.valueOf(llll) + ")";
        returnStringArray[1] = "\n                IRM length (ll) = 0x" + TmInteractionImpl.convertByteValueTo2CharacterString((byte)((irm_ll & 0xFF00) >> 8)).toUpperCase() + TmInteractionImpl.convertByteValueTo2CharacterString((byte)(irm_ll & 0xFF)).toUpperCase() + " (decimal " + String.valueOf(irm_ll) + ")";
        returnStringArray[2] = "\n            Archictecture Level = 0x" + TmInteractionImpl.convertByteValueTo2CharacterString(archLvl);
        returnStringArray[3] = "\n                         Flag 0 = 0x" + TmInteractionImpl.convertByteValueTo2CharacterString(f0) + " (decimal " + String.valueOf(f0) + ")";
        returnStringArray[4] = f4 == 82 || f4 == -39 ? ((f0 & 0xFFFFFF80) == -128 ? "                                    resumeTPipeRetrievalType is RETRIEVE_SYNC_MESSAGE_ONLY" : ((f0 & 0x40) == 64 ? "                                    resumeTPipeRetrievalType is RETRIEVE_SYNC_OR_ASYNC_MESSAGE" : "                                    resumeTPipeRetrievalType is RETRIEVE_ASYNC_MESSAGE_ONLY")) : (f4 == 78 || f4 == -43 ? ((f0 & 0x20) == 32 ? "                                    If NAK is NAKing callout request from callout resumetpipe, OTMA will requeue callout request message on Tpipe queue; resumeTpipe will get timeout response" : ((f3 & 8) == 8 ? "                                    If NAK is NAKing callout request from callout resumetpipe, OTMA will discard callout request message; resumeTpipe will continue" : "                                    If NAK is NAKing callout request from callout resumetpipe, OTMA will discard callout request message; resumeTpipe will get timeout response")) : "                                    " + (String.valueOf(f0).equals("0") ? "No XML transformation" : (String.valueOf(f0).equals("1") ? "XML transformation of trancode and data" : (String.valueOf(f0).equals("2") ? "XML transformation of data only)" : ""))));
        returnStringArray[5] = "\n                 IRM identifier = [" + irmId + "]";
        returnStringArray[6] = "\n                NAK reason code = 0x" + TmInteractionImpl.convertByteValueTo2CharacterString((byte)((irmNakReasonCode & 0xFF00) >> 8)).toUpperCase() + TmInteractionImpl.convertByteValueTo2CharacterString((byte)(irmNakReasonCode & 0xFF)).toUpperCase() + " (decimal " + String.valueOf(irmNakReasonCode) + "]";
        returnStringArray[7] = "\n                  Reserved word = 0x" + TmInteractionImpl.convertByteValueTo2CharacterString((byte)((resWrd & 0xFF00) >> 8)).toUpperCase() + TmInteractionImpl.convertByteValueTo2CharacterString((byte)(resWrd & 0xFF)).toUpperCase() + " (decimal " + String.valueOf(resWrd) + "]";
        returnStringArray[8] = "\n                         Flag 5 = 0x" + TmInteractionImpl.convertByteValueTo2CharacterString(f5) + " (decimal " + String.valueOf(f5) + "]";
        returnStringArray[9] = (f5 & 0x40) == 64 ? "                                    EBCDIC translation done by client" : "                                    EBCDIC translation not done by client";
        if ((f5 & 0x10) == 16) {
            returnStringArray[10] = "                                    resumeTpipe option is SINGLE_WAIT";
        } else if ((f5 & 1) == 1) {
            returnStringArray[10] = "                                    resumeTpipe option is SINGLE_NOWAIT";
        } else if ((f5 & 2) == 2) {
            returnStringArray[10] = "                                    resumeTpipe option is AUTO";
        } else if ((f5 & 4) == 4) {
            returnStringArray[10] = "                                    resumeTpipe option is NOAUTO";
        } else if ((f5 & 0) == 0) {
            returnStringArray[10] = "                                    resumeTpipe option is NOOPTION (same as NOAUTO)";
        }
        returnStringArray[11] = "\n            IMS Connect timeout = 0x" + TmInteractionImpl.convertByteValueTo2CharacterString(irmTimer) + " (decimal " + String.valueOf(irmTimer) + ")";
        returnStringArray[12] = "\n                    Socket type = 0x" + TmInteractionImpl.convertByteValueTo2CharacterString(sockType) + " (decimal " + String.valueOf(sockType) + ")";
        if ((sockType & 0x10) == 0) {
            returnStringArray[13] = "                                    Transaction socket";
        } else if ((sockType & 0x10) == 16) {
            returnStringArray[13] = "                                    Persistent socket";
        }
        returnStringArray[14] = "\n        Unicode encoding schema = 0x" + TmInteractionImpl.convertByteValueTo2CharacterString(encSchema) + " (decimal " + encSchema + ")";
        returnStringArray[15] = "\n                       clientId = [" + clientId + "]\n";
        returnStringArray[16] = "\n                         Flag 1 = 0x" + TmInteractionImpl.convertByteValueTo2CharacterString(f1) + " (decimal " + String.valueOf(f1) + ")";
        returnStringArray[17] = (f1 & 1) == 1 ? "                                    OTMA Transaction Expiration is true" : "                                    OTMA Transaction Expiration is false";
        returnStringArray[18] = (f1 & 2) == 2 ? "\n                                    CM0 ACK/NAK No Wait requested" : "\n                                    CM0 ACK/NAK No Wait not requested";
        if ((f1 & 0x30) == 0) {
            returnStringArray[19] = "\n                                    Neither trancode nor data are Unicode";
        } else if ((f1 & 0x10) == 16) {
            returnStringArray[19] = "\n                                    Trancode is Unicode";
        } else if ((f1 & 0x20) == 32) {
            returnStringArray[19] = "\n                                    Data is Unicode";
        } else if ((f1 & 0x30) == 48) {
            returnStringArray[19] = "\n                                    Trancode and data are both Unicode";
        }
        returnStringArray[20] = (f1 & 0xFFFFFF80) == -128 ? "\n                                    Return MFS modname requested" : "\n                                    Return MFS modname not requested";
        returnStringArray[21] = (f1 & 0x40) == 64 ? "\n                                    Return ClientId requested" : "\n                                    Return ClientId not requested";
        returnStringArray[22] = "\n                         Flag 2 = 0x" + TmInteractionImpl.convertByteValueTo2CharacterString(f2) + " (decimal " + String.valueOf(f2) + ")";
        if ((f2 & 0x20) == 32) {
            returnStringArray[23] = "                                    Commit mode 1";
        } else if ((f2 & 0x40) == 64) {
            returnStringArray[23] = "                                    Commit mode 0";
        }
        returnStringArray[24] = (f2 & 1) == 1 ? "\n                                    Generate clientId when Duplicate requested" : "\n                                    Generate clientId when Duplicate not requested";
        returnStringArray[25] = "\n                         Flag 3 = 0x" + TmInteractionImpl.convertByteValueTo2CharacterString(f3) + " (decimal " + String.valueOf(f3) + ")";
        if ((f3 & 3) == 0) {
            returnStringArray[26] = "                                    Sync Level is NONE (0)";
        } else if ((f3 & 3) == 1) {
            returnStringArray[26] = "                                    Sync Level is CONFIRM (1)";
        } else if ((f3 & 3) == 2) {
            returnStringArray[26] = "                                    Sync Level is SYNCPT (2)";
        }
        returnStringArray[27] = (f3 & 4) == 4 ? "                                    Purge undeliverable output is true" : "                                    Purge undeliverable output is false";
        returnStringArray[28] = (f3 & 8) == 8 ? "                                    Reroute undeliverable output is true" : "                                    Reroute undeliverable output is false";
        returnStringArray[29] = (f3 & 0x40) == 64 ? "                                    Return DFS2082 after CM0 SendRecv timeout with no response is true" : "                                    Return DFS2082 after CM0 SendRecv timeout with no response is false";
        returnStringArray[30] = "\n                         Flag 4 = 0x" + TmInteractionImpl.convertByteValueTo2CharacterString(f4) + " (decimal " + String.valueOf(f4) + ", chararcter [" + (char)f4 + "])";
        if (f4 == 32 || f4 == 64) {
            returnStringArray[31] = "                                    SENDRECV interaction";
        } else if (f4 == 65 || f4 == -63) {
            returnStringArray[31] = "                                    ACK interaction";
        } else if (f4 == 78 || f4 == -43) {
            returnStringArray[31] = "                                    NAK interaction";
        } else if (f4 == 68 || f4 == -60) {
            returnStringArray[31] = "                                    DEALLOCATE interaction";
        } else if (f4 == 82 || f4 == -39) {
            returnStringArray[31] = "                                    RESUMETPIPE interaction";
        } else if (f4 == 83 || f4 == -30) {
            returnStringArray[31] = (f3 & 0x10) != 16 ? "                                    SENDONLY interaction" : "                                    SENDONLYXCFORDDEL interaction";
        } else if (f4 == 77 || f4 == -44) {
            returnStringArray[31] = "                                    SENDONLYCALLOUTRESPONSE interaction";
        } else if (f4 == 76 || f4 == -45) {
            returnStringArray[31] = "                                    SENDONLYACKCALLOUTRESPONSE interaction";
        } else if (f4 == 67 || f4 == -61) {
            returnStringArray[31] = "                                    CANCELTIMER interaction";
        } else if (f4 == 75 || f4 == -46) {
            returnStringArray[31] = "                                    SENDONLYACK interaction";
        }
        returnStringArray[32] = "\n                       Trancode = [" + irmTrancode + "]";
        returnStringArray[33] = "\n                   Datastore ID = [" + datastoreId + "]";
        returnStringArray[34] = "\n                 LTERM override = [" + ltermOvrd + "]";
        returnStringArray[35] = "\n                    RACF userId = [" + racfUserId + "]";
        returnStringArray[36] = "\n                RACF group name = [" + racfGroup + "]";
        returnStringArray[37] = "\n                  RACF password = [" + racfPassword + "]";
        returnStringArray[38] = "\n                 RACF appl name = [" + racfApplNm + "]";
        returnStringArray[39] = f4 == 82 || f4 == -39 ? "\n ResumeTpipe alternate clientId = [" + this.resumeTpipeAlternateClientId + "]" : "\n                   Reroute name = [" + rerouteName + "]";
        returnStringArray[40] = "\n               XML adapter name = [" + xmlAdapterNm + "] (not supported in API)";
        returnStringArray[41] = "\n             XML converter name = [" + xmlConvrtrNm + "] (not supported in API)";
        returnStringArray[42] = "\n             Input MFS MOD name = [" + irmModNm + "]";
        returnStringArray[43] = "\n               Correlator token = [" + correlatorTokenString + "]";
        return returnStringArray;
    }

    private static boolean isPrintableChar(char ch) {
        if (Character.isISOControl(ch)) {
            return false;
        }
        return !Character.isIdentifierIgnorable(ch);
    }

    private static String convertByteValueTo2CharacterString(byte aByte) {
        StringBuffer hexCharStringBuf = new StringBuffer("");
        int b = (aByte & 0xF0) >> 4;
        hexCharStringBuf.append(Integer.toHexString(b));
        b = aByte & 0xF;
        hexCharStringBuf.append(Integer.toHexString(b));
        return hexCharStringBuf.toString().toUpperCase();
    }

    protected String[] stringToStringArray(String aMultiLineString) {
        int rows = 1;
        String tempstr = aMultiLineString.toString();
        int bol = 0;
        int eol = tempstr.indexOf(10);
        int tempstrlen = tempstr.length() - 1;
        while (eol != -1 && eol < tempstrlen) {
            bol = eol + 1;
            eol = tempstr.indexOf(10, bol);
            ++rows;
        }
        String[] formattedBuffer = new String[rows];
        bol = 0;
        eol = tempstr.indexOf(10);
        int i = 0;
        while (i < rows) {
            formattedBuffer[i] = eol > -1 ? new String(tempstr.substring(bol, eol)) : new String(tempstr.substring(bol));
            bol = eol + 1;
            eol = tempstr.indexOf(10, bol);
            ++i;
        }
        return formattedBuffer;
    }

    @Override
    public String getCalloutRequestNakProcessing() {
        return this.calloutRequestNakProcessing;
    }

    @Override
    public String getCalloutResponseMessageType() {
        return this.calloutResponseMessageType;
    }

    @Override
    public byte getResumeTpipeRetrievalType() {
        return this.resumeTPipeRetrievalType;
    }

    @Override
    public void setCalloutRequestNakProcessing(String aCalloutNakProcessing) throws ImsConnectApiException {
        String tempaCalloutNakProcessing = aCalloutNakProcessing.toUpperCase();
        if (this.allValidCalloutRequestNakProcessingsString.indexOf(tempaCalloutNakProcessing) == -1) {
            String validCalloutRequestNakProcessing = "";
            try {
                validCalloutRequestNakProcessing = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_CALLOUTREQUESTNAKPROCESSING");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"calloutRequestNakProcessing", aCalloutNakProcessing, validCalloutRequestNakProcessing});
            ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in TmInteraction.setCalloutRequestNakProcessing(): [" + e.toString() + "]");
            }
            throw e;
        }
        if (this.calloutRequestNakProcessing != tempaCalloutNakProcessing) {
            this.calloutRequestNakProcessing = tempaCalloutNakProcessing;
            this.setRebuildMessage(true);
        }
    }

    @Override
    public void setCalloutResponseMessageType(String aCalloutResponseMsgType) throws ImsConnectApiException {
        String tempaCalloutResponseMsgType = aCalloutResponseMsgType.toUpperCase();
        if (this.allValidCalloutResponseMessageTypesString.indexOf(tempaCalloutResponseMsgType) == -1) {
            String validCalloutResponseMsgTypes = "";
            try {
                validCalloutResponseMsgTypes = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_RESPONSEMESSAGETYPE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"calloutResponseMessageType", aCalloutResponseMsgType, validCalloutResponseMsgTypes});
            ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in TmInteraction.setCalloutResponseMessageType(): [" + e.toString() + "]");
            }
            throw e;
        }
        if (this.calloutResponseMessageType != tempaCalloutResponseMsgType) {
            this.calloutResponseMessageType = tempaCalloutResponseMsgType;
            this.setRebuildMessage(true);
        }
    }

    @Override
    public void setResumeTpipeRetrievalType(byte aRetrievalType) throws ImsConnectApiException {
        if (aRetrievalType == -128 || aRetrievalType == 64 || aRetrievalType == 0) {
            if (this.resumeTPipeRetrievalType != aRetrievalType) {
                this.resumeTPipeRetrievalType = aRetrievalType;
                this.setRebuildMessage(true);
            }
        } else {
            String validResumeTpipeRetrievalTypeString = "";
            try {
                validResumeTpipeRetrievalTypeString = ImsConnectErrorMessage.getString("VALID_PROPERTY_VALUE_RESUMETPIPERETRIEVALTYPE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errMsg = ImsConnectErrorMessage.getString("HWS0030E", new Object[]{"ResumeTpipeRetrievalType", String.valueOf(aRetrievalType), validResumeTpipeRetrievalTypeString});
            ImsConnectApiException e = new ImsConnectApiException("HWS0030E", errMsg);
            if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                this.logger.severe("    Exception thrown in TmInteraction.setResumeTpipeRetrievalType(byte). Exception thrown was: " + e.toString());
            }
            throw e;
        }
    }

    @Override
    public void setCorrelatorToken(byte[] aCorrelatorToken) throws ImsConnectApiException {
        this.correlatorTkn = aCorrelatorToken;
        this.setRebuildMessage(true);
    }

    @Override
    public byte[] getCorrelatorToken() {
        return this.correlatorTkn;
    }

    @Override
    public void setNakReasonCode(short aNakReasonCode) {
        this.nakReasonCode = aNakReasonCode;
        this.setRebuildMessage(true);
    }

    @Override
    public short getNakReasonCode() {
        return this.nakReasonCode;
    }

    public void setInputModName(String anInputModName) throws ImsConnectApiException {
        if (anInputModName.trim().equals("") || anInputModName == null) {
            anInputModName = "        ";
        } else {
            if (anInputModName.length() > 8) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0026E", new Object[]{anInputModName, "inputModName", String.valueOf(8)});
                ImsConnectApiException e = new ImsConnectApiException("HWS0026E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setInputModName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
            if (!PropertiesFileLoader.isValidHostStyleName(anInputModName)) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0029E", new Object[]{"inputModName", anInputModName});
                ImsConnectApiException e = new ImsConnectApiException("HWS0029E", errMsg);
                if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    this.logger.severe("    Exception thrown in TmInteraction.setInputModName(String). Exception thrown was: " + e.toString());
                }
                throw e;
            }
        }
        if (this.inputModName != anInputModName) {
            this.inputModName = anInputModName;
            this.setRebuildMessage(true);
            this.updateIrmInputModName = true;
        }
    }

    public String getInputModName() {
        return this.inputModName;
    }

    protected void formatAndPrintReceiveBuffer(boolean obfuscatePassword) {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_INTERNAL)) {
            String bufferReceived = this.formatBufferForTracing(this.outputMsgBytes, obfuscatePassword);
            String[] bufferReceivedStringArray = this.stringToStringArray(bufferReceived);
            int bufferRecvLen = bufferReceivedStringArray.length;
            this.logger.finest("   TmInteraction.execute() - Buffer received:");
            int i = 0;
            while (i < bufferRecvLen) {
                this.logger.finest(bufferReceivedStringArray[i]);
                ++i;
            }
        }
    }

    @Override
    public CorrelatorToken getCorrelatorTokenDetails() {
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("--> TmInteractionImpl.getCorrelatorTokenDetails()...");
        }
        CorrelatorToken tkn = new CorrelatorToken();
        if (this.logger.isLoggable(ApiProperties.TRACE_LEVEL_ENTRY_EXIT)) {
            this.logger.finer("<-- TmInteractionImpl.getCorrelatorTokenDetails()...");
        }
        return tkn;
    }

    private static boolean isValidRacfPassword(String aName) {
        String validSpecialCharacters = "@#$.<+|&!*-%_>?:=";
        if (aName != null && aName.length() > 0) {
            int i = 0;
            while (i < aName.length()) {
                char c = aName.charAt(i);
                if (!Character.isLetterOrDigit(c) && "@#$.<+|&!*-%_>?:=".indexOf(c) == -1) {
                    i = 9;
                }
                ++i;
            }
            if (i < 9) {
                return true;
            }
        }
        return false;
    }

    public final class CorrelatorToken {
        private short IRM_CT_LEN;
        private short IRM_CT_RESV1;
        private String IRM_CT_IMSID;
        private String IRM_CT_MEMTK;
        private String IRM_CT_AWETK;
        private String IRM_CT_TPIPE;
        private String IRM_CT_USERID;

        public short getCorrelatorLength() throws ImsConnectApiException {
            try {
                byte[] tkn = TmInteractionImpl.this.getCorrelatorToken();
                this.IRM_CT_LEN = (short)((tkn[0] & 0xFF) << 8 | tkn[1] & 0xFF);
            }
            catch (Exception e1) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0001E", new Object[]{ImsConnectErrorMessage.getString("MSG_BLD_ERR", new Object[]{ImsConnectErrorMessage.getExceptionMessage(e1)})});
                ImsConnectApiException e = new ImsConnectApiException("HWS0001E", errMsg);
                if (TmInteractionImpl.this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    TmInteractionImpl.this.logger.severe("    Exception caught in getCorrelatorLength(): [" + e.toString() + "]+");
                }
                throw e;
            }
            return this.IRM_CT_LEN;
        }

        private short getCorrelatorTokenResv1() throws ImsConnectApiException {
            try {
                int i = 2;
                byte[] tkn = TmInteractionImpl.this.getCorrelatorToken();
                this.IRM_CT_RESV1 = (short)((tkn[i] & 0xFF) << 8 | tkn[i + 1] & 0xFF);
            }
            catch (Exception e1) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0001E", new Object[]{ImsConnectErrorMessage.getString("MSG_BLD_ERR", new Object[]{ImsConnectErrorMessage.getExceptionMessage(e1)})});
                ImsConnectApiException e = new ImsConnectApiException("HWS0001E", errMsg);
                if (TmInteractionImpl.this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    TmInteractionImpl.this.logger.severe("    Exception caught in getCorrelatorTokenResv1(): [" + e.toString() + "]+");
                }
                throw e;
            }
            return this.IRM_CT_RESV1;
        }

        public String getCorrelatorIMSID() throws ImsConnectApiException {
            try {
                int i = 4;
                byte[] tkn = TmInteractionImpl.this.getCorrelatorToken();
                this.IRM_CT_IMSID = new String(tkn, i, 4, TmInteractionImpl.this.imsConnectCodepage);
            }
            catch (Exception e1) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0001E", new Object[]{ImsConnectErrorMessage.getString("MSG_BLD_ERR", new Object[]{ImsConnectErrorMessage.getExceptionMessage(e1)})});
                ImsConnectApiException e = new ImsConnectApiException("HWS0001E", errMsg);
                if (TmInteractionImpl.this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    TmInteractionImpl.this.logger.severe("    Exception caught in getCorrelatorIMSID(): [" + e.toString() + "]+");
                }
                throw e;
            }
            return this.IRM_CT_IMSID;
        }

        public String getCorrelatorIOTMATMember() throws ImsConnectApiException {
            try {
                int i = 8;
                byte[] tkn = TmInteractionImpl.this.getCorrelatorToken();
                this.IRM_CT_MEMTK = new String(tkn, i, 8, TmInteractionImpl.this.imsConnectCodepage);
            }
            catch (Exception e1) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0001E", new Object[]{ImsConnectErrorMessage.getString("MSG_BLD_ERR", new Object[]{ImsConnectErrorMessage.getExceptionMessage(e1)})});
                ImsConnectApiException e = new ImsConnectApiException("HWS0001E", errMsg);
                if (TmInteractionImpl.this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    TmInteractionImpl.this.logger.severe("    Exception caught in getCorrelatorIOTMATMember(): [" + e.toString() + "]+");
                }
                throw e;
            }
            return this.IRM_CT_MEMTK;
        }

        public String getCorrelatorOTMAMessageToken() throws ImsConnectApiException {
            try {
                int i = 16;
                byte[] tkn = TmInteractionImpl.this.getCorrelatorToken();
                this.IRM_CT_AWETK = new String(tkn, i, 8, TmInteractionImpl.this.imsConnectCodepage);
            }
            catch (Exception e1) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0001E", new Object[]{ImsConnectErrorMessage.getString("MSG_BLD_ERR", new Object[]{ImsConnectErrorMessage.getExceptionMessage(e1)})});
                ImsConnectApiException e = new ImsConnectApiException("HWS0001E", errMsg);
                if (TmInteractionImpl.this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    TmInteractionImpl.this.logger.severe("    Exception caught in getCorrelatorOTMAMessageToken: [" + e.toString() + "]+");
                }
                throw e;
            }
            return this.IRM_CT_AWETK;
        }

        public String getCorrelatorOTMATPipeName() throws ImsConnectApiException {
            try {
                int i = 24;
                byte[] tkn = TmInteractionImpl.this.getCorrelatorToken();
                this.IRM_CT_TPIPE = new String(tkn, i, 8, TmInteractionImpl.this.imsConnectCodepage);
            }
            catch (Exception e1) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0001E", new Object[]{ImsConnectErrorMessage.getString("MSG_BLD_ERR", new Object[]{ImsConnectErrorMessage.getExceptionMessage(e1)})});
                ImsConnectApiException e = new ImsConnectApiException("HWS0001E", errMsg);
                if (TmInteractionImpl.this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    TmInteractionImpl.this.logger.severe("    Exception caught in getCorrelatorOTMATPipeName(): [" + e.toString() + "]+");
                }
                throw e;
            }
            return this.IRM_CT_TPIPE;
        }

        public String getCorrelatorICALUserId() throws ImsConnectApiException {
            try {
                int i = 32;
                byte[] tkn = TmInteractionImpl.this.getCorrelatorToken();
                this.IRM_CT_USERID = new String(tkn, i, 8, TmInteractionImpl.this.imsConnectCodepage);
            }
            catch (Exception e1) {
                String errMsg = ImsConnectErrorMessage.getString("HWS0001E", new Object[]{ImsConnectErrorMessage.getString("MSG_BLD_ERR", new Object[]{ImsConnectErrorMessage.getExceptionMessage(e1)})});
                ImsConnectApiException e = new ImsConnectApiException("HWS0001E", errMsg);
                if (TmInteractionImpl.this.logger.isLoggable(ApiProperties.TRACE_LEVEL_EXCEPTION)) {
                    TmInteractionImpl.this.logger.severe("    Exception caught in getCorrelatorICALUserId(): [" + e.toString() + "]+");
                }
                throw e;
            }
            return this.IRM_CT_USERID;
        }
    }

    private class SavedResponseValues {
        String tmpIntTypeDesc;
        int tmpImsConnectTimeout;
        InputMessageImpl tmpInputMsg;
        OutputMessageImpl tmpOutputMsg;
        byte[] tmpOutputMsgBytes;
        int tmpImsConnectReturnCode;
        int tmpImsConnectReasonCode;
        int tmpOtmaSenseCode;
        boolean tmpAsyncOutputAvailable;
        boolean tmpInConversation;
        byte tmpProtocolLevel;
        boolean tmpUseCM0AckNoWait;
        boolean tmpResponsePropertiesSetAfterResponse;

        SavedResponseValues(TmInteractionImpl aTMInteractionImpl) throws ImsConnectApiException, UnsupportedEncodingException, CloneNotSupportedException {
            this.setTmpIntTypeDesc(aTMInteractionImpl.getInteractionTypeDescription());
            this.tmpImsConnectTimeout = aTMInteractionImpl.getImsConnectTimeout();
            InputMessageImpl myTmpInMsg = new InputMessageImpl(aTMInteractionImpl);
            myTmpInMsg.copyInputMessage((InputMessageImpl)aTMInteractionImpl.getInputMessage());
            this.setTmpInputMsg(myTmpInMsg);
            OutputMessageImpl myTmpOutMsg = new OutputMessageImpl(aTMInteractionImpl);
            myTmpOutMsg.copyOutputMessage((OutputMessageImpl)aTMInteractionImpl.getOutputMessage());
            this.setTmpOutputMsg(myTmpOutMsg);
            this.setTmpOutputMsgBytes(aTMInteractionImpl.outputMsgBytes);
            this.setTmpImsConnectReturnCode(aTMInteractionImpl.getImsConnectReturnCode());
            this.setTmpImsConnectReasonCode(aTMInteractionImpl.getImsConnectReasonCode());
            this.setTmpOtmaSenseCode(aTMInteractionImpl.getOtmaSenseCode());
            this.setTmpAsyncOutputAvailable(aTMInteractionImpl.isAsyncOutputAvailable());
            this.setTmpInConversation(aTMInteractionImpl.inConversation);
            this.setTmpProtocolLevel(aTMInteractionImpl.protocolLevel);
            this.setTmpUseCM0AckNoWait(aTMInteractionImpl.useCM0AckNoWait);
            this.setTmpResponsePropertiesSetAfterResponse(aTMInteractionImpl.responsePropertiesUpdatedAfterResponse);
        }

        protected int getTmpImsConnectTimeout() {
            return this.tmpImsConnectTimeout;
        }

        protected void setTmpImsConnectTimeout(int tmpImsConnectTimeout) {
            this.tmpImsConnectTimeout = tmpImsConnectTimeout;
        }

        protected int getTmpImsConnectReasonCode() {
            return this.tmpImsConnectReasonCode;
        }

        protected int getTmpImsConnectReturnCode() {
            return this.tmpImsConnectReturnCode;
        }

        protected String getTmpIntTypeDesc() {
            return this.tmpIntTypeDesc;
        }

        protected int getTmpOtmaSenseCode() {
            return this.tmpOtmaSenseCode;
        }

        protected InputMessageImpl getTmpInputMsg() {
            return this.tmpInputMsg;
        }

        protected OutputMessageImpl getTmpOutputMsg() {
            return this.tmpOutputMsg;
        }

        protected boolean isTmpAsyncOutputAvailable() {
            return this.tmpAsyncOutputAvailable;
        }

        protected boolean isTmpInConversation() {
            return this.tmpInConversation;
        }

        public byte getTmpProtocolLevel() {
            return this.tmpProtocolLevel;
        }

        public boolean isTmpUseCM0AckNoWait() {
            return this.tmpUseCM0AckNoWait;
        }

        protected boolean isTmpResponsePropertiesSetAfterResponse() {
            return this.tmpResponsePropertiesSetAfterResponse;
        }

        protected byte[] getTmpOutputMsgBytes() {
            return this.tmpOutputMsgBytes;
        }

        public void setTmpProtocolLevel(byte aTmpProtocolLevel) {
            this.tmpProtocolLevel = aTmpProtocolLevel;
        }

        public void setTmpUseCM0AckNoWait(boolean aTmpUseCM0AckNoWait) {
            this.tmpUseCM0AckNoWait = aTmpUseCM0AckNoWait;
        }

        protected void setTmpAsyncOutputAvailable(boolean aTmpAsyncOutputAvailable) {
            this.tmpAsyncOutputAvailable = aTmpAsyncOutputAvailable;
        }

        protected void setTmpImsConnectReasonCode(int aTmpImsConnectReasonCode) {
            this.tmpImsConnectReasonCode = aTmpImsConnectReasonCode;
        }

        protected void setTmpImsConnectReturnCode(int aTmpImsConnectReturnCode) {
            this.tmpImsConnectReturnCode = aTmpImsConnectReturnCode;
        }

        protected void setTmpInConversation(boolean aTmpInConversation) {
            this.tmpInConversation = aTmpInConversation;
        }

        protected void setTmpResponsePropertiesSetAfterResponse(boolean aTmpInConversationPropertiesUpdated) {
            this.tmpResponsePropertiesSetAfterResponse = aTmpInConversationPropertiesUpdated;
        }

        protected void setTmpIntTypeDesc(String aTmpIntTypeDesc) {
            this.tmpIntTypeDesc = aTmpIntTypeDesc;
        }

        protected void setTmpOtmaSenseCode(int aTmpOtmaSenseCode) {
            this.tmpOtmaSenseCode = aTmpOtmaSenseCode;
        }

        protected void setTmpInputMsg(InputMessageImpl aTmpInputMsg) {
            this.tmpInputMsg = aTmpInputMsg;
        }

        protected void setTmpOutputMsg(OutputMessageImpl aTmpOutputMsg) {
            this.tmpOutputMsg = aTmpOutputMsg;
        }

        protected void setTmpOutputMsgBytes(byte[] aTmpOutputMsgBytes) {
            this.tmpOutputMsgBytes = aTmpOutputMsgBytes;
        }
    }
}

