/**
 * File: Cmdrspdata.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2011, 2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;

import java.util.ArrayList;

/**
 * A Cmdrspdata object represents the <code>Cmdrspdata</code> element of a type-2 command response
 * message. This element contains the detailed response information in the message. The strings
 * returned within child <code>Rsp</code> elements are intended to be formatted according to the
 * information in the <code>Cmdrsphdr</code> element returned in the response message.
 *
 *@since Enterprise Suite 2.1
 */
public interface Cmdrspdata
{
    /**
     * Gets any plain text encapsulated by the element.
     * @return the elementText
     */
    public String getElementText();
    
    /**
     * Gets all of the response text strings from the response message.
     * @return the rsp
     */
    public ArrayList<String> getRsp();
    
    /**
     * Gets a specific response text string from the response message list.
     * @return the rsp
     */
    public String getRspElement(int anIndex);
}