/**
 * File: Cmdsecerr.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2011, 2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;

/**
 * A Cmdsecerr object represents the <code>Cmdsecerr</code> element of a type-2 command
 * response message. This element contains details about a security error that prevented the
 * type-2 command from being executed, if such an error occurred. The element is only included in
 * the response message for type-2 commands that failed due to a security error.
 * <p>This element only contains information about security errors caused by either the OM security exit routine or
 * RACF (or an equivalent SAF) rejecting the authentication details that were included with the command.
 * 
 * @see <a href="http://www-01.ibm.com/support/knowledgecenter/search/CSL%20OM%20Security%20user%20exit%20routine?scope=SSEPH2" target="_blank">CSL OM Security exit routine</a> 
 *
 *@since Enterprise Suite 2.1
 */
public interface Cmdsecerr
{
    /**
     * Gets any plain text encapsulated by the element.
     * @return the elementText
     */
    public String getElementText();
    
    /**
     * Gets the Exit object from the element.
     * @return the exit
     */
    public Exit getExit();
    
    /**
     * Gets the Saf object from the element.
     * @return the saf
     */
    public Saf getSaf();
}
