/**
 * File: Exit.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2011, 2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;

/**
 * Represents the <code>exit</code> element of a type-2 command response message. This element is returned for
 * a command security error response. It contains the return code and user response data from the OM command security
 * exit routine.
 *
 *@since Enterprise Suite 2.1
 */
public interface Exit
{
    /**
     * Gets any plain text encapsulated by the element.
     * @return the elementText
     */
    public String getElementText();
    
    /**
     * Gets the reason code from the OM command security exit routine.
     * @return the rc
     */
    public String getRc();
    
    /**
     * Gets the user data from the OM command security exit routine. This data is specified by a
     * customized exit routine module that uses the field OSCX_USERDATA. Unprintable characters are
     * converted to periods (.) in the output.
     * @return the userdata
     */
    public String getUserdata();
}