/**
 * File: Msgdata.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-T62
 * 
 * (C) Copyright IBM Corp. 2011 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;

import java.util.ArrayList;

/**
 * A Msgdata object represents the <code>msgdata</code> element in a type-2 command response message.
 * This element contains any IMS or IMS component messages issued in response to the type-2 command by
 * each command processing client that the message was routed to. These messages can be informational,
 * warning, or error messages. Messages are returned in the standard IMS or IMS component format. For example,
 * IMS informational messages are given in the format <code>DFS<i>nnnn</i>I</code>.
 * 
 * @see <a href="http://www-01.ibm.com/support/knowledgecenter/search/IMS%20messages%20and%20codes?scope=SSEPH2" target="_blank">IMS messages and codes</a>
 * @since Enterprise Suite 2.1
 */
public interface Msgdata
{
    /**
     * Gets an array of Mbr objects, one for each command processing client that returned one or more IMS messages in
     * response to the type-2 command.
     * @return the mbr
     */
    public ArrayList<Mbr> getMbr();
    
    /**
     * Gets any plain text in the <code>msgdata</code> element.
     * @return the elementText
     */
    public String getElementText();
}