/**
 * File: Cmdclients.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2011,2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;

import java.util.ArrayList;

/**
 * A Cmdclients object represents the <code>Cmdclients</code> element of a type-2 command response message.
 * This element contains details about the OM command processing client that was the end-point of the
 * type-2 command. This element can contain information about more than one command processing client
 * if the type-2 command was routed to more than one end-point.
 * <p>
 * This element is populated in the response message to a QUERY(CMDCLIENTS) request.
 *
 *@since Enterprise Suite 2.1
 */
public interface Cmdclients
{
    /**
     * Gets any plain text encapsulated by the <code>cmdclients</code> element.
     * @return the cmdclientsElementText
     */
    public String getCmdclientsElementText();
    
    /**
     * Gets Mbr objects for all of the type-2 command processing clients that are registered with Operations Manager.
     * @return the mbr
     */
    public ArrayList<Mbr> getMbr();
}
