/**
 * File: Ctl.java                                               
 * ==========================================================================
 * Licensed Material - Property of IBM
 *  
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5655-TDA
 * 
 * (C) Copyright IBM Corp. 2011, 2013 All Rights Reserved. 
 * 
 * The source code for this program is not published or  
 * otherwise divested of its trade secrets, irrespective 
 * of what has been deposited with the U.S. Copyright 
 * Office.
 * 
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
 * =========================================================================== 
 */
package com.ibm.ims.connect;


/**
 * A Ctl object represents the <code>Ctl</code> element of a type-2 command response message. This
 * element is returned with every type-2 command response and contains processing details from the Operations Manager 
 * (OM) that received the command and routed it to a command processing client. 
 * <p>Use the provided methods to get the values of individual fields in the <code>Ctl</code> element.
 *
 *@since Enterprise Suite 2.1
 */
public interface Ctl
{
    /**
     * Gets any plain text encapsulated by the element.
     * @return the ctlElementText
     */
    public String getCtlElementText();
    
    /**
     * Gets the name of the OM instance that processed the type-2 command.
     * @return the omname
     */
    public String getOmname();
    
    /**
     * Gets the version number of the OM that processed the type-2 command.
     * @return the omvsn
     */
    public String getOmvsn();
    
    /**
     * Gets the OM return code for the type-2 command.
     * @return the rc
     */
    public String getRc();
    
    /**
     * Gets the user-specified RQSTTKN1 value for the type-2 command.
     * <p>Unprintable characters are converted to periods (.) in the output.
     * @return the rqsttkn1
     */
    public byte[] getRqsttkn1();
    
    /**
     * Gets the user-specified RQSTTKN2 value for the type-2 command.
     * <p>Unprintable characters are converted to periods (.) in the output.
     * @return the rqsttkn2
     */
    public byte[] getRqsttkn2();
    
    /**
     * Gets the OM reason code for the type-2 command.
     * @return the rsn
     */
    public String getRsn();
    
    /**
     * Gets the message associated with the OM reason code, if any.
     * @return the rsnmsg
     */
    public String getRsnmsg();
    
    /**
     * Gets the text associated with the OM reason code, if any.
     * @return the rsntxt
     */
    public String getRsntxt();
    
    /**
     * Gets the sequence value when OM started processing the request. 
     * The vaue is in printable EBCDIC hexadecimal format.
     * @return the staseq
     */
    public String getStaseq();
    
    /**
     * Gets the time that OM started processing the command. The timestamp is given in the following format:
     * <p>yyyy.ddd hh:mm:ss.th
     * @return the statime
     */
    public String getStatime();
    
    /**
     * Gets the OM sequence value when OM finished processing the command. 
     * The value is in printable EBCDIC hexadecimal format.
     * @return the stoseq
     */
    public String getStoseq();
    
    /**
     * Gets the time that OM finished processing the command. The timestamp is given in the following format:
     * <p>yyyy.ddd hh:mm:ss.th
     * @return the stotime
     */
    public String getStotime();
    
    /**
     * Indicates if this response message is an unsolicited output message.
     * @return the uom
     */
    public String getUom();
    
    /**
     * Gets the XML version number for the response message.
     * @return the xmlvsn
     */
    public String getXmlvsn();
}